(ns buckshot.test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool :max-active -1
                                :max-idle -1))

(def spec (redis/make-conn-spec :host "10.0.36.177"))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

(-> (wredis (redis/client-list))
    (clojure.string/split #"\n")
    count
    clojure.pprint/pprint)

;;(wredis (redis/flushall))

(def results (atom nil))

(def q (let [b (backend/make-redis {:host "10.0.36.177"})]
         (queue/make {:backend b})))

(def specs (for [i (range 1000)]
             {:id (str i)
              :fn :non-sense}))

(doseq [s specs]
  (future (swap! results conj (queue/add-spec! q s))))

(count @results)
