(ns buckshot.test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool :max-active -1
                                :max-idle -1))

(def spec (redis/make-conn-spec :host "10.0.36.177"))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

(-> (wredis (redis/client-list))
    (clojure.string/split #"\n")
    count
    clojure.pprint/pprint)

;;(wredis (redis/flushall))

(def results (atom nil))

(def q (let [b (backend/make-redis {:host "10.0.36.177"})]
         (queue/make {:backend b})))

(def specs (for [i (range 2000)]
             {:id (str i)
              :fn :adder
              :args [1]}))

(doseq [{:keys [id args]} specs]
  (queue/subscribe! q
                    id
                    (fn [result]
                      (swap! results conj id))))

(time
 (pmap #(queue/add-spec! q %) specs)
 nil)

(count @results)
