(ns buckshot.demo
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool :max-active -1
                                :max-idle -1))

(def spec (redis/make-conn-spec :host "10.0.36.177"))

(defmacro wredis [& body] `(redis/with-conn pool spec ~@body))

(clojure.pprint/pprint (clojure.string/split (wredis (redis/client-list)) #"\n"))

(def right (atom 0))

(def wrong (atom 0))

(defn queue []
  (let [b (backend/make {:type :redis
                         :spec {:host "10.0.36.177"}})]
    (queue/make {:backend b})))

(def q (queue))

(doseq [i (range 5)]
  (future
    (println i)
    (let [test-id (str i)
          xs (repeat 50 1)
          answer (str (apply + xs))]
      (queue/subscribe! q
                        test-id
                        (fn [result]
                          (if (= answer result)
                            (swap! right inc)
                            (swap! wrong inc))))
      (comment
        (queue/add-spec! q {:id test-id
                            :fn :stress-test
                            :args xs})))))

(defn f [& options]
  (println (apply hash-map options)))