(ns buckshot.util
  (:require [clj-time.coerce :as ctc]
            [clj-time.core :as ct]))

(defn ->period [[x unit]]
  (case unit
    ;; not supported because they don't have a standard duration
    ;; :year   (ct/years x)
    ;; :month  (ct/months x)
    :week   (ct/weeks x)
    :day    (ct/days x)
    :hour   (ct/hours x)
    :minute (ct/minutes x)
    :second (ct/seconds x)
    :milli  (ct/millis x)))

(defn ->millis [[x unit]]
  (-> [x unit] ->period (.toStandardDuration) (.getMillis)))

(defn make-id []
  (str (java.util.UUID/randomUUID)))

(defn make-job [now fn & [opts]]
  {:args (:args opts)
   :created now
   :fn fn
   :from (.getHostName (java.net.InetAddress/getLocalHost))
   :id (or (:id opts) (make-id))
   :period (:period opts)
   :queue (or (:queue opts) :default)
   ;; use later of now and :start (if present)
   :start (max now (-> opts :start (or 0) ctc/to-long))})
