(ns buckshot.demo
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]))

;; init
(def backend (backend/make {:type :in-memory}))

(def queue (queue/make {:backend backend}))

(buckshot/add-log-handler! queue println)

(def worker (worker/make {:id "worker 1"
                          :fns {:add (fn [w & args] (apply + args))
                                :bad (fn [w & args] (throw (Exception. "no bueno")))
                                :schedule-jobs tasks/schedule-jobs!}
                          :queue queue}))

(defn status-check []
  (println "specs:" (queue/get-specs queue))
  (println "scheduled:" (queue/get-scheduled queue))
  (println "processing:" (queue/get-processing queue)))

;; one-time task
(queue/subscribe! queue "good" #(println "got" %))

(queue/add-spec! queue {:id "good"
                        :fn :add
                        :args [1 1]})

;; task exception
(queue/add-spec! queue {:id "bad"
                        :fn :bad})

(->> (queue/get-processing queue)
     first
     (queue/finish-job! queue))

;; recurring task
(queue/add-spec! queue {:id "schedule jobs"
                        :fn :schedule-jobs
                        :period :second})

(worker/stop! worker)

(->> (queue/get-specs queue)
     first
     (queue/remove-spec! queue))

(worker/start! worker)

;; unknown job should not block everything
(queue/add-spec! queue {:id "ugly"
                        :fn :unknown})

(queue/add-spec! queue {:id "good"
                        :fn :add
                        :args [2 2]})

(->> (queue/get-specs queue)
     first
     (queue/remove-spec! queue))

(status-check)
