(ns buckshot.backend)

(defprotocol IBackend
  (get-colls [this])
  (get-all [this coll])
  (get-min [this coll])
  (has-score? [this coll score])
  (has-item? [this coll item])
  (atomically [this f])
  (add! [this coll score item])
  (remove! [this coll item])
  (delete! [this coll])
  (publish! [this channel message])
  (subscribe! [this channel f]))

(load "backend_in_memory")
(load "backend_redis")

(defn make [params]
  (case (:type params)
    :in-memory (make-in-memory params)
    :redis (make-redis params)))
