;; owner: marshall@readyforzero.com
;; Virtual transport for testing.

(ns borg.transport.virtual
  (:require [borg.transport.interface :refer :all]
            [cheshire.core :as json]))

(def exec-fn (atom nil))

(defrecord Virtual []
  ITransport
  (start-server [_ executer port]
    (reset! exec-fn executer)
    {})

  (stop-server [_ server]
    nil)

  (create-client [_ host port]
    "client")

  (close-client [_ client]
    nil)

  (send-command [_ client handler-spec]
    (-> (json/generate-string handler-spec)
        (json/parse-string true)
        (@exec-fn true)
        (json/generate-string)
        (json/parse-string true))))

(defn init
  "Takes no options."
  [opt]
  (Virtual.))