(ns borg.state.types.packages.core
  (:require [borg.state.types.packages.protocol :refer :all]
            [clojure.java.shell :as sh])
  (:use [borg.state.types.core :only [defop sh-result]]))

(defn- pkg-installed [sh-args]
  (let [{:keys [out err exit]} (apply sh/sh sh-args)]
    (if (== exit 0)
      out
      nil)))

(defop install [sh-args]
  (sh-result (apply sh/sh sh-args)))

(def aptget (reify
              PackageManager
              (installed? [self] (on-path? "apt-get"))
              (get-installed-version [self package-name]
                (pkg-installed ["dpkg-query" "-W" "-f=${Version}" package-name]))
              (install! [self package-name version]
                (install ["apt-get" "install" (str package-name "=" version)
                          "--assume-yes" "--dry-run"]))))

(def yum (reify
           PackageManager
           (installed? [self] (on-path? "yum"))
           (get-installed-version [self package-name]
             (pkg-installed ["rpm" "-q" "--queryformat" "%{VERSION}" package-name]))
           (install! [self package-name version]
             (install ["yum" "install" (str package-name "-" version) "--assumeyes"]))))

(def managers [yum aptget])

(def manager (delay (first (filter installed? managers))))
