(ns borg.borglet.users.s3
  (:refer-clojure :exclude [sync])
  (:require [aws.sdk.s3 :as s3]
            [borg.aws.core :as aws]
            [borg.borglet.users.interface :refer :all]
            [clojure.string :as string]))

(defn load-users
  "Load user roles from s3 and store them in the users atom."
  [bucket users]
  (->> (s3/list-objects (aws/get-credentials) bucket)
       (:objects)
       (map :key)
       (filter #(not= \/ (last %)))
       (map #(string/split % #"/"))
       (map reverse)
       (flatten)
       (map #(% %2) (cycle [identity keyword]))
       (apply hash-map)
       (reset! users)))

(defrecord S3 [bucket users]
  IUsers
  (sync [_]
    (load-users (:bucket _) (:users _)))

  (level [_ username]
    (get @(:users _) username))

  (get-all [_]
    @(:users _))

  (can-run? [_ order username level]
    (<= (.indexOf order level)
        (.indexOf order (level _ username)))))

(defn init [bucket]
  (S3. bucket (atom nil)))
