(ns borg.transport.http
  (:require [borg.transport.interface :refer :all]
            [cheshire.core :as json]
            [clj-http.client :as http]
            [clojure.tools.logging :as lg]
            [ring.adapter.jetty :as jetty]))

(defn make-request [handler-spec]
  {:body (json/generate-string handler-spec)
   :content-type :json
   :socket-timeout 30000
   :conn-timeout 30000
   :accept :json})

(defn request-handler [handle-exec]
  (fn [req]
    {:body (-> (:body req)
               (slurp)
               (json/parse-string true)
               (handle-exec true) ;; for now all requests are authed
               (json/generate-string))
     :headers {"Content-Type" "text/json"}
     :status 200}))

(defn configurator [server]
  (.setGracefulShutdown server 1000))

(defrecord HTTP []
  ITransport
  (start-server [_ exec-fn port]
    (let [server (jetty/run-jetty (request-handler exec-fn)
                                  {:configurator configurator
                                   :port port
                                  :join? false})]
      (lg/info "Listening on port" port)
      server))
  
  (stop-server [_ server]
    (lg/info "stoping" server)
    (.stop server)
    (lg/info "Server shutting down"))
  
  (create-client [_ host port]
    (str "http://" host ":" port))
  
  (close-client [_ client]
    nil)
  
  (send-command [_ client handler-spec]
    (-> (http/post client (make-request handler-spec))
        (:body)
        (json/parse-string true))))