(ns clj.new.lib
  "Generate a library project."
  (:require [clj.new.templates :refer [renderer year date project-name
                                       ->files sanitize-ns name-to-path
                                       multi-segment]]))

(defn lib
  "A general project template for Reaction Commerce libraries.

  Accepts a group id in the project name: `clj -A:new lib foo.bar/baz`"
  [name & args]
  (let [render (renderer "lib")
        main-ns (multi-segment (sanitize-ns name))
        data {:raw-name name
              :name (project-name name)
              :namespace main-ns
              :nested-dirs (name-to-path main-ns)
              :year (year)
              :date (date)}]
    (println "Generating a project called"
             (project-name name)
             "based on the Reaction Commerce 'lib' template.")
    (println "The lib template is intended for library projects, not applications.")
    (println (str "Args: " args))
    (println (str "Data: " data))
    (->files
      data
      [".gitignore" (render "gitignore" data)]
      [".metav.edn" (render "metav.edn" data)]
      ["Makefile" (render "Makefile" data)]
      ["README.md" (render "README.md" data)]
      ["bin/build" (render "bin/build" data)]
      ["bin/deploy" (render "bin/deploy" data)]
      ["bin/dev" (render "bin/dev" data)]
      ["bin/release" (render "bin/release" data)]
      ["bin/test" (render "bin/test" data)]
      ["deps.edn" (render "deps.edn" data)]
      ["dev/src/dev.clj" (render "dev/src/dev.clj" data)]
      ["dev/src/user.clj" (render "dev/src/user.clj" data)]
      ["resources/{{nested-dirs}}/.keep" ""]
      ["src/{{nested-dirs}}.clj" (render "src/core.clj" data)]
      ["test/{{nested-dirs}}_test.clj" (render "test/core_test.clj" data)])))
