(ns {{ns-name}}.routes.index.db
  (:require [clojure.spec.alpha :as s]))

;; = Functions =================================================================
(defn valid-hex-color? [hex]
  (re-matches #"\#[A-F0-9]{0,6}" hex))

;; = Specs =====================================================================
(s/def ::hex-color (s/and string? valid-hex-color?))
(s/def ::index-route (s/keys :req-un [::hex-color]))

;; = Default Index Route DB Map ================================================
(defonce default-db {:hex-color "#3E3E3E"})
