(defproject {{ns-name}} "0.1.0-SNAPSHOT"
  :dependencies [[org.clojure/clojure       "1.9.0"]
                 [org.clojure/clojurescript "1.9.946"]
                 [reagent                   "0.8.0-alpha2"]
                 [re-frame                  "0.10.5"]
                 [day8.re-frame/http-fx     "0.1.5"]
                 [cljs-ajax                 "0.7.3"]
                 [com.rpl/specter           "1.1.0"]
                 [secretary                 "1.2.3"]]


  {{#java9?}};; This Figwheel project was generated with Java 9
  ;; and ClojureScript currently needs this flag added to the compiler
  ;; under Java 9
  :jvm-opts ["--add-modules" "java.xml.bind"]{{/java9?}}

  :plugins [[lein-cljsbuild "1.1.5"]
            [yogthos/lein-sass "0.1.1"]]

  :sass {:source "sass"
         :target "resources/public/css"}

  :source-paths ["src"]

  :clean-targets ^{:protect false} ["resources/public/js/compiled"
                                    "resources/public/test"
                                    "target"]

  :npm {:devDependencies [[karma "2.0.0"]
                          [karma-cli "1.0.1"]
                          [karma-cljs-test "0.1.0"]
                          [karma-chrome-launcher "2.2.0"]]}

  :cljsbuild {:builds
              [{:id           "min"
                :source-paths ["src"]
                :compiler     {:main {{ns-name}}.core
                               :output-to "resources/public/js/compiled/app.js"
                               :optimizations :advanced
                               :closure-defines {goog.DEBUG false}
                               :pretty-print false}}
               {:id           "dev"
                :source-paths ["src" "dev"]
                :figwheel     {:on-jsload "{{ns-name}}.core/mount-app"}
                :compiler     {:main {{ns-name}}.core
                               :optimizations :none
                               :output-to "resources/public/js/compiled/app.js"
                               :output-dir "resources/public/js/compiled/out"
                               :asset-path "js/compiled/out"
                               :source-map-timestamp true
                               :preloads [devtools.preload day8.re-frame.trace.preload]
                               :closure-defines {"re_frame.trace.trace_enabled_QMARK_" true}
                               :external-config {:devtools/config {:features-to-install :all}}}}
               {:id           "test"
                :source-paths ["src" "test"]
                :compiler     {:main {{ns-name}}.runner
                               :optimizations :none
                               :asset-path "base/resources/public/js/compiled/test/out"
                               :output-to "resources/public/js/compiled/test.js"
                               :output-dir "resources/public/js/compiled/test/out"
                               :closure-defines {"{{sanitized}}.config.alert_timeout_ms" 10}
                               :source-map true}}]}

  :figwheel {:css-dirs ["resources/public/css"]}

  :profiles {:dev {:dependencies [[binaryage/devtools "0.9.9"]
                                  [figwheel-sidecar "0.5.14"]
                                  [com.cemerick/piggieback "0.2.2"]
                                  [day8.re-frame/test "0.1.5"]
                                  [day8.re-frame/trace "0.1.21-react16"]]
                   :repl-options {:init-ns user}
                   :source-paths ["src" "dev"]
                   :plugins      [[lein-figwheel "0.5.14"]
                                  [cider/cider-nrepl "0.16.0"]
                                  [lein-doo "0.1.8"]
                                  [lein-npm "0.6.2"]]}})
