(ns {{ns-name}}.other-test
  (:require [cljs.test :refer-macros [deftest testing is]]
            [day8.re-frame.test :as rf-test]
            [{{ns-name}}.shared-events :as shared-events]
            [{{ns-name}}.shared-subs :as shared-subs]
            [{{ns-name}}.routes.other.events :as sut-events]
            [re-frame.core :as rf]))

(deftest properly-display-an-alert-when-button-is-pressed
  (rf-test/run-test-async
    (rf/dispatch-sync [::shared-events/initialize-db])
    (let [alerts (rf/subscribe [::shared-subs/alerts])]
      (is (empty? @alerts))
      (rf/dispatch [::sut-events/sound-alert])
      (rf-test/wait-for [::shared-events/add-alert]
                        (is (not-empty @alerts))
                        (rf-test/wait-for [::shared-events/remove-alert]
                                          (is (empty? @alerts)))))))
