(ns {{ns-name}}.routes.index.view
  (:require [re-frame.core :as rf]
            [{{ns-name}}.routes.index.subs :as route-subs]
            [{{ns-name}}.routes.index.events :as route-events]))

; = Components =================================================================
(defn color-display []
  (let [rgb @(rf/subscribe [::route-subs/get-color])]
    [:h1 "The color is now: " [:span {:style {:color rgb}} rgb]]))

(defn color-input []
  [:div.color-input
   "Color: "
   [:input {:type "text"
            :value @(rf/subscribe [::route-subs/get-color])
            :on-change #(rf/dispatch [::route-events/set-color (-> % .-target .-value)])}]])

; = Template ===================================================================
(defn template []
  [:div
   [:h2 "Color Input"]
   [color-display]
   [color-input]])
