(ns {{ns-name}}.db
  (:require [clojure.spec.alpha :as s]
            [{{ns-name}}.routes.index.db :as index]))

{{! Change mustache delimiter to <% and %> }}
{{=<% %>=}}

;; = Specs =====================================================================
(s/def ::active-route keyword?)
(s/def ::uuid uuid?)
;; -- Alerts -------------------------------------------------------------------
(s/def ::message string?)
(s/def ::type string?)
(s/def ::alert (s/keys :req-un [::uuid ::message ::type]))
(s/def ::alerts (s/* ::alert))

;; = DB Spec ===================================================================
(s/def ::db (s/keys :req-un [::active-route
                             ::alerts
                             ::index/index-route]))

(defonce default-db {;; = Top Level ============================================
                     :active-route          :index-route
                     :alerts                '()
                     ;; = index Route ==========================================
                     :index-route index/default-db})

<%! Reset mustache delimiter %>
<%={{ }}=%>
