(defproject {{ns-name}} "0.1.0"
  :dependencies [[org.clojure/clojure "1.10.3"]
                 [org.clojure/clojurescript "1.10.879"
                  :exclusions
                  [com.google.javascript/closure-compiler-unshaded
                   org.clojure/google-closure-library
                   org.clojure/google-closure-library-third-party
                   com.cognitect/transit-clj]]

                 [re-frame "1.2.0"]
                 [com.7theta/via "9.1.2"]{{#auth?}}
                 [com.7theta/via-auth "0.5.2"]{{/auth?}}
                 [com.7theta/tailwind "0.3.0"]

                 [metosin/reitit-frontend "0.5.15"]
                 [metosin/reitit-ring "0.5.15"]

                 [integrant "0.8.0"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[binaryage/devtools "1.0.4"]
                                  [thheller/shadow-cljs "2.15.12"]
                                  [com.7theta/structor "0.2.2"]
                                  [integrant/repl "0.3.2"]]}
             :uberjar {:source-paths ["prod"]
                       :resource-paths ["resources/public/js/compiled"]{{#graal?}}
                       :global-vars {*assert* false}
                       :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                                  "-Dclojure.spec.skip-macros=true"
                                  "-Dorg.slf4j.simpleLogger.defaultLogLevel=warn"]{{/graal?}}
                       :dependencies [[yogthos/config "1.1.8"]{{#graal?}}
                                      [org.slf4j/slf4j-simple "2.0.0-alpha5"]{{/graal?}}]
                       :main {{name}}.main
                       :aot :all
                       :uberjar-name "{{name}}.jar"}}
  :prep-tasks ["compile"])
