(ns {{name}}.main
    (:require [{{name}}.config :refer [config]]
              [config.core :refer [env]]
              [integrant.core :as ig])
    (:gen-class))

(defn -main [& args]
  (let [port (env :port)
        app (-> config
                (assoc-in [:via/http-server :host] "0.0.0.0")
                (assoc-in [:via/http-server :port] port)
                ig/init)]
    (println (str "URL: http://0.0.0.0:" port))))
