/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IPersistentVector;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.PersistentVector;
import clojure.lang.RT;

public class LazilyPersistentVector {
    public static IPersistentVector createOwning(Object ... items) {
        if (items.length == 0) {
            return PersistentVector.EMPTY;
        }
        if (items.length <= 32) {
            return new PersistentVector(items.length, 5, PersistentVector.EMPTY_NODE, items);
        }
        return PersistentVector.create(items);
    }

    public static IPersistentVector create(Object obj) {
        if (obj instanceof IReduceInit) {
            return PersistentVector.create((IReduceInit)obj);
        }
        if (obj instanceof ISeq) {
            return PersistentVector.create(RT.seq(obj));
        }
        if (obj instanceof Iterable) {
            return PersistentVector.create((Iterable)obj);
        }
        return LazilyPersistentVector.createOwning(RT.toArray(obj));
    }
}

