(ns racehub.couchdb
  "CouchDB integration."
                                       
  (:require [racehub.schema :as ps]
            [schema.core :as s :include-macros true])
       
                                       
                                     
                                               
                                                    
                                          
                                      
                                        
                                             )

;; ## Schemas

(s/defschema Stub
  "CouchDB attachment stub."
  {s/Any s/Any})

(def ID s/Str)

(s/defn id [schema-name :- s/Str]
  s/Str)

(def CouchFields
  {:_id ID
   :_rev s/Str
   (s/optional-key :created-at) ps/Timestamp
   (s/optional-key :updated-at) ps/Timestamp
   (s/optional-key :*) (s/named s/Str "Kill this!")
   (s/optional-key :_conflicts) (s/named [s/Str] "Array of revision IDs")
   (s/optional-key :_deleted_conflicts) (s/named [s/Str] "Array of revision IDs")
   (s/optional-key :_attachments) {s/Keyword Stub}})

(defn couchify [m type]
  (-> (merge CouchFields m)
      (assoc :type (s/eq type))))

(defn uncouchify
  [m]
  (dissoc m :_id :_rev :created-at :updated-at :* :_conflicts :_deleted_conflicts
          :_attachments :type))

(def CouchDoc
  (-> CouchFields
      (assoc (s/either s/Keyword s/Str) s/Any)
      (s/named "CouchDB Document.")))

(def UpdateFailure
  {:id ID
   :error s/Str
   :reason s/Str})

(def UpdateSuccess
  {(s/optional-key :ok) (s/named boolean "Doesn't show up on Cloudant, only locally.")
   :id ID
   :rev s/Str})

(def UpdateResult
  (s/either UpdateFailure UpdateSuccess))

(def ViewName
  (s/named s/Str "Name of a view in a CouchDB design doc."))

(def ViewEntry
  {(s/optional-key :id) ID
   :key s/Any
   :value s/Any
   :doc CouchDoc})

(def DesignDoc
  (s/named s/Str "Design document name."))

(def SlimView
  "Schema for a CouchDB view result with :include-docs set to false."
  [(dissoc ViewEntry :doc)])

(def FatView
  "Schema for a CouchDB view result with :include-docs set to true."
  [ViewEntry])

(def View
  (s/either SlimView FatView))

(def CasedViewName
  (s/both s/Str (s/pred (fn [^String s] (.startsWith s "downcased-")))))

     
   
                            

                                

                                                                  
                   
                   
                                                                               
                                                                               
                                                                      
                 
                                        
                                                     
                       
                       
                                
                                                                                     
                                                      
                  

                          
                        
                                                                       
                                       

                      
                      

                    
           
                               
                   
                           
                                 

                                    
                                                     
                           
                                                                

                                                        

                      
                              
      
                                                       
                                        
                                 

                      
                                          
           
                                         
                                                    

                                                    
                          
                             
                         
                                        
                                                                       
               
                                                      
                                                            
                                                          
                                                                               

               
                                   
                            
                                 
              
                                                                  

                                
                                   
                  
                
           

                                   
                                         
              
                                               
                               

                       
                                                                       
                                                                  
                                                                      
                       

                                                                     
                                                                    
                                        
                     
                 
                                      
                     
                
                                                  
                                
                                     
                      
                                       
                                   
                          

                                         
                             
                               
                
                                       
                                     
                                                       
                                                  
                                 

                                                    
                                        
                               
                
                                                                    

                                                  
                                      
                               
                                                  

                          
                                                                  
                                                                     
         
                    
                                                      
                 

               
                                                                
                                            
                
                             
                                
                                     
                     
                                           
                                 

               
                                                        
              
                                        

               
                                                  

                      
                                                

                                                                    
            
                     
                                     
                                                                     

               

                      
                                                    
                   
                                            

                       
                                                                    
                                     
                     
                                                            
                                                          
                          
                                        
                                                         

                          
                                                                                       
                     
                                        
                   
                                                                   
                                  

                           
                
                                                                       
                           
         
                                             
                       
                             
                                           
                                         
          

                                       
                                                                     
                                                      
          
                                       
                                       
                                                   
                                                   
                                    
                                             

                                       
                     
                               

                    
                                                                
                                                                
          
          
                                                        

                       

                           
                                                    
                                  
                                 
                              
                                     
                        
                                          
                    

                              
    
                                                                  

                                               
                                           
                        
                                                  

                                                    
      
               
                                   

                                  
      
                                  
                                           

;;;;;;;;;;;; This file autogenerated from src/cljx/racehub/couchdb.cljx
