(ns racehub.util.aws
  "AWS Helpers for image uploading and friends."
       
                                              
                                       
                                      
                                            
  (:require [racehub.schema :as ps]
            [schema.core :as s :include-macros true])
                                 
                                                           
                                                                     
                                                                  )

;; This is required to register the proper runtime reflection
;; coercions.
                                 

;; Map of content type, so we can recover a proper uri.
(def content-types
  "Map of content-type to image extension."
  {"image/jpeg" "jpg"
   "image/bmp" "bmp"
   "image/gif" "gif"
   "image/png" "png"})

(def crazy-map
  "Map of IE-style, annoying prefixes over to proper image types."
  {"image/pjpeg" "image/jpeg"
   "image/x-png" "image/png"})

(def CrazyInput
  (apply s/enum (keys crazy-map)))

(def ImageContent
  (s/enum "image/jpeg" "image/png" "image/bmp" "image/gif"))

(def AWSKey
  (s/named s/Str "AWS bucket key"))

(def Bucket
  "Supported buckets. We only have one for now."
  (s/enum :photos))

(def BucketConf
  {:bucket-name s/Str
   :cloudfront s/Str})

(def ImageName
  (-> (s/either s/Keyword s/Str)
      (s/named "image name")))

(def CloudFrontURL
  (s/named s/Str "URL representing a path to a blob served by CloudFront."))

(def Credentials
  {:access-key s/Str
   :secret-key s/Str
   (s/optional-key :region) s/Str})

(s/defschema AWSConfig
  {:credentials Credentials
   :buckets {Bucket BucketConf}})

;; ## Methods

(s/defn massage-content-type :- ImageContent
  "Fixes up some of the crazier input types that IE responds to."
  [t :- (s/either ImageContent CrazyInput)]
  (or (crazy-map t) t))

     
   
            
                                                                        
                               
                                                                   
                                                     
                                                                       
                                                     
                                                                              

                                
                                                          
                                             
                                                                      
                
                             
               

                                            
                                                 
                         
                                                      

                                     
                                                        
                                        
                             

                  
                                      

                      
                                     

                                  
                                                                        
                                                                 
                                                               
                 
                                                                                                        
                       
                            
                      
                   
                         
                       
                                              
                    
                                   
                       
                            
                      
                   
                          
                              
                                
                                                      
                                
                                  
                                                                          
                                    

                                    
                                                                     
         

                                                                     
                                                                  
                                      
             
                                                        
                           
                                                   
                                              
                                          

                                  
                                   
                                        
              
                                          

                                    
                                                                        
                                                                     
                                                            

                                                               
                                
                            
                     
                            
                                                   
                                          
                          
                                                        
                                           
                                 
                          
                             
                              
                                           
                                            
                                                                         
                                                             
                                                        
                                      

              

                                     
                         
                     
                            
                        
                                                           

                                                   
                                                                 
                                                          
                      
                      
                         
                         
                             
                                                                
                                                            
                                       

;;;;;;;;;;;; This file autogenerated from src/cljx/racehub/util/aws.cljx
