(ns paddleguru.algebra
  "Shared algebras for cljs and clj.")

(defprotocol Semigroup
  (plus [l r]))

;; Shared extensions
(extend-protocol Semigroup
  nil
  (plus [l r] r))

      
(extend-protocol Semigroup
  string
  (plus [l r] (str l r))

  number
  (plus [l r] (+ l r))

  cljs.core/PersistentVector
  (plus [l r] (into l r))

  cljs.core/List
  (plus [l r] (concat l r))

  cljs.core/LazySeq
  (plus [l r]
    (lazy-cat l r))

  cljs.core/PersistentArrayMap
  (plus [l r] (merge-with plus l r))

  cljs.core/PersistentHashMap
  (plus [l r] (merge-with plus l r)))

;; Clojure-specific extension
     
                          
        
                        

                   
                      

                  
                      

                 
                      

                
                      

                    
                      

                                
                           

                              
                           

                             
             
                          

                      
             
                    

(defn monoid [zero]
  (fn
    ([] zero)
    ([l r] (plus l r))))

(defn sum [mon coll]
  (if (empty? coll)
    (mon)
    (reduce mon coll)))

(def numeric-monoid
  (monoid 0))

(def map-monoid
  (monoid {}))

(def vector-monoid
  (monoid []))

;;;;;;;;;;;; This file autogenerated from src/cljx/paddleguru/algebra.cljx
