/*
 * Decompiled with CFR 0.152.
 */
package processing.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PStyle;
import processing.core.PSurface;
import processing.core.PSurfaceNone;

public class PGraphicsPDF
extends PGraphicsJava2D {
    protected File file;
    protected OutputStream output;
    protected Document document;
    protected PdfWriter writer;
    protected PdfContentByte content;
    protected static DefaultFontMapper mapper;
    protected static String[] fontList;

    public void setPath(String string) {
        this.path = string;
        if (string != null) {
            this.file = new File(string);
            if (!this.file.isAbsolute()) {
                this.file = null;
            }
        }
        if (this.file == null) {
            throw new RuntimeException("PGraphicsPDF requires an absolute path for the location of the output file.");
        }
    }

    public void setOutput(OutputStream outputStream) {
        this.output = outputStream;
    }

    public PSurface createSurface() {
        this.surface = new PSurfaceNone((PGraphics)this);
        return this.surface;
    }

    protected void defaultSettings() {
        super.defaultSettings();
        this.textMode = 5;
    }

    public void beginDraw() {
        if (this.document == null) {
            this.document = new Document(new Rectangle((float)this.width, (float)this.height));
            boolean bl = false;
            try {
                if (this.file != null) {
                    this.output = new BufferedOutputStream(new FileOutputStream(this.file), 16384);
                } else if (this.output == null) {
                    bl = true;
                    throw new RuntimeException("PGraphicsPDF requires a path for the location of the output file.");
                }
                this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.output);
                this.document.open();
                this.content = this.writer.getDirectContent();
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    throw runtimeException;
                }
                throw new RuntimeException("Problem saving the PDF file.", runtimeException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("Can't save the PDF file to " + this.path, fileNotFoundException);
            }
            catch (DocumentException documentException) {
                throw new RuntimeException("Error inside the PDF library.", documentException);
            }
            this.g2 = this.content.createGraphicsShapes((float)this.width, (float)this.height);
        }
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
        this.pushMatrix();
    }

    protected static DefaultFontMapper getMapper() {
        if (mapper == null) {
            mapper = new DefaultFontMapper();
            if (PApplet.platform == 2) {
                try {
                    String string = String.valueOf(System.getProperty("user.home")) + "/Library/Fonts";
                    mapper.insertDirectory(string);
                }
                catch (Exception exception) {}
                mapper.insertDirectory("/System/Library/Fonts");
                mapper.insertDirectory("/Library/Fonts");
            } else if (PApplet.platform == 1) {
                File[] fileArray = File.listRoots();
                int n = 0;
                while (n < fileArray.length) {
                    if (!fileArray[n].toString().startsWith("A:")) {
                        File file = new File(fileArray[n], "WINDOWS/Fonts");
                        if (file.exists()) {
                            mapper.insertDirectory(file.getAbsolutePath());
                            break;
                        }
                        file = new File(fileArray[n], "WINNT/Fonts");
                        if (file.exists()) {
                            mapper.insertDirectory(file.getAbsolutePath());
                            break;
                        }
                    }
                    ++n;
                }
            } else if (PApplet.platform == 3) {
                PGraphicsPDF.checkDir("/usr/share/fonts/", mapper);
                PGraphicsPDF.checkDir("/usr/local/share/fonts/", mapper);
                PGraphicsPDF.checkDir(String.valueOf(System.getProperty("user.home")) + "/.fonts", mapper);
            }
        }
        return mapper;
    }

    protected static void checkDir(String string, DefaultFontMapper defaultFontMapper) {
        File file = new File(string);
        if (file.exists()) {
            defaultFontMapper.insertDirectory(string);
            PGraphicsPDF.traverseDir(file, defaultFontMapper);
        }
    }

    protected static void traverseDir(File file, DefaultFontMapper defaultFontMapper) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                defaultFontMapper.insertDirectory(fileArray[n].getPath());
                PGraphicsPDF.traverseDir(new File(fileArray[n].getPath()), defaultFontMapper);
            }
            ++n;
        }
    }

    public void endDraw() {
        this.popMatrix();
    }

    protected static boolean fileExists(File file) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "dir", file.getAbsolutePath()});
            boolean bl = false;
            int n = -1;
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            while (!bl) {
                while (inputStream.read() >= 0) {
                }
                while (inputStream2.read() >= 0) {
                }
                try {
                    n = process.exitValue();
                    bl = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.sleep(100L);
                }
            }
            return n == 0;
        }
        catch (IOException iOException) {
            System.out.println("Unable to check for file: " + file + " : " + iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Unable to check for file.  Interrupted: " + file + " : " + interruptedException);
            return false;
        }
    }

    public void nextPage() {
        PStyle pStyle = this.getStyle();
        this.endDraw();
        this.g2.dispose();
        try {
            this.document.newPage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.g2 = this.createGraphics();
        this.beginDraw();
        this.style(pStyle);
    }

    protected Graphics2D createGraphics() {
        if (this.textMode == 5) {
            return this.content.createGraphicsShapes((float)this.width, (float)this.height);
        }
        if (this.textMode == 4) {
            return this.content.createGraphics((float)this.width, (float)this.height, (FontMapper)PGraphicsPDF.getMapper());
        }
        throw new RuntimeException("Invalid textMode() selected for PDF.");
    }

    public void dispose() {
        if (this.document != null) {
            this.g2.dispose();
            this.document.close();
            this.document = null;
        }
    }

    public boolean displayable() {
        return false;
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        this.pushMatrix();
        this.translate(f, f2);
        int n5 = pImage.width;
        int n6 = pImage.height;
        this.scale((f3 - f) / (float)n5, (f4 - f2) / (float)n6);
        if (n3 - n == n5 && n4 - n2 == n6) {
            this.g2.drawImage(pImage.getImage(), 0, 0, null);
        } else {
            PImage pImage2 = pImage.get(n, n2, n3 - n, n4 - n2);
            this.g2.drawImage((Image)pImage2.getNative(), 0, 0, null);
        }
        this.popMatrix();
    }

    public void textFont(PFont pFont) {
        super.textFont(pFont);
        this.checkFont();
    }

    public void textMode(int n) {
        if (this.textMode != n) {
            if (n == 5) {
                this.textMode = 5;
                this.g2.dispose();
                this.g2 = this.createGraphics();
            } else if (n == 4) {
                this.textMode = 4;
                this.g2.dispose();
                this.g2 = this.createGraphics();
            } else {
                if (n == 256) {
                    throw new RuntimeException("textMode(SCREEN) not supported with PDF");
                }
                throw new RuntimeException("That textMode() does not exist");
            }
        }
    }

    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        this.checkFont();
        super.textLineImpl(cArray, n, n2, f, f2);
    }

    public void loadPixels() {
        this.nope("loadPixels");
    }

    public void updatePixels() {
        this.nope("updatePixels");
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        this.nope("updatePixels");
    }

    public int get(int n, int n2) {
        this.nope("get");
        return 0;
    }

    public PImage get(int n, int n2, int n3, int n4) {
        this.nope("get");
        return null;
    }

    public PImage get() {
        this.nope("get");
        return null;
    }

    public void set(int n, int n2, int n3) {
        this.nope("set");
    }

    public void set(int n, int n2, PImage pImage) {
        this.nope("set");
    }

    public void mask(int[] nArray) {
        this.nope("mask");
    }

    public void mask(PImage pImage) {
        this.nope("mask");
    }

    public void filter(int n) {
        this.nope("filter");
    }

    public void filter(int n, float f) {
        this.nope("filter");
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nope("copy");
    }

    public void blend(int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        this.nope("blend");
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.nope("blend");
    }

    public boolean save(String string) {
        this.nope("save");
        return false;
    }

    public void addFonts(String string) {
        mapper.insertDirectory(string);
    }

    protected void checkFont() {
        Font font = (Font)this.textFont.getNative();
        if (font == null) {
            throw new RuntimeException("Use createFont() instead of loadFont() when drawing text using the PDF library.");
        }
        if (this.textMode != 5) {
            if (this.textFont.isStream()) {
                throw new RuntimeException("Use textMode(SHAPE) with PDF when loading .ttf and .otf files with createFont().");
            }
            if (mapper.getAliases().get(this.textFont.getName()) == null) {
                if (this.textFont.getName().equals("Lucida Sans")) {
                    throw new RuntimeException("Use textMode(SHAPE) with the default font when exporting to PDF.");
                }
                throw new RuntimeException("Use textMode(SHAPE) with \u201c" + this.textFont.getName() + "\u201d " + "when exporting to PDF.");
            }
        }
    }

    public static String[] listFonts() {
        if (fontList == null) {
            HashMap hashMap = PGraphicsPDF.getMapper().getAliases();
            fontList = new String[hashMap.size()];
            int n = 0;
            for (Object k : hashMap.keySet()) {
                PGraphicsPDF.fontList[n++] = (String)k;
            }
            fontList = PApplet.sort((String[])fontList);
        }
        return fontList;
    }

    protected void nope(String string) {
        throw new RuntimeException("No " + string + "() for " + ((Object)((Object)this)).getClass().getSimpleName());
    }
}

