/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import processing.awt.ShimAWT;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;

public class PImage
implements PConstants,
Cloneable {
    public int format;
    public int[] pixels;
    public int pixelDensity = 1;
    public int pixelWidth;
    public int pixelHeight;
    public int width;
    public int height;
    public PApplet parent;
    protected boolean modified;
    protected int mx1;
    protected int my1;
    protected int mx2;
    protected int my2;
    public boolean loaded = false;
    private int ifV;
    private int sX;
    private int v1;
    private int v2;
    private int iw;
    private int iw1;
    private int ih1;
    private int srcXOffset;
    private int srcYOffset;
    private int[] srcBuffer;
    static final int PRECISIONB = 15;
    static final int PRECISIONF = 32768;
    static final int PREC_MAXVAL = Short.MAX_VALUE;
    static final int PREC_ALPHA_SHIFT = 9;
    static final int PREC_RED_SHIFT = 1;
    private int blurRadius;
    private int blurKernelSize;
    private int[] blurKernel;
    private int[][] blurMult;
    public static final int ALPHA_MASK = -16777216;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    private static final int RB_MASK = 0xFF00FF;
    private static final int GN_MASK = 65280;

    public PImage() {
        this.format = 2;
    }

    public PImage(int width, int height) {
        this.init(width, height, 1, 1);
    }

    public PImage(int width, int height, int format) {
        this.init(width, height, format, 1);
    }

    public PImage(int width, int height, int format, int factor) {
        this.init(width, height, format, factor);
    }

    public void init(int width, int height, int format) {
        this.init(width, height, format, 1);
    }

    public void init(int width, int height, int format, int factor) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.pixelDensity = factor;
        this.pixelWidth = width * this.pixelDensity;
        this.pixelHeight = height * this.pixelDensity;
        this.pixels = new int[this.pixelWidth * this.pixelHeight];
        if (format == 1) {
            Arrays.fill(this.pixels, -16777216);
        }
    }

    private void init(int width, int height, int format, int factor, int[] pixels) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.pixelDensity = factor;
        this.pixelWidth = width * this.pixelDensity;
        this.pixelHeight = height * this.pixelDensity;
        this.pixels = pixels;
    }

    public void checkAlpha() {
        if (this.pixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            if ((this.pixels[i] & 0xFF000000) == -16777216) continue;
            this.format = 2;
            break;
        }
    }

    public PImage(int width, int height, int[] pixels, boolean requiresCheckAlpha, PApplet parent) {
        this.init(width, height, 1, 1, pixels);
        this.parent = parent;
        if (requiresCheckAlpha) {
            this.checkAlpha();
        }
    }

    public PImage(int width, int height, int[] pixels, boolean requiresCheckAlpha, PApplet parent, int format, int factor) {
        this.init(width, height, format, factor, pixels);
        this.parent = parent;
        if (requiresCheckAlpha) {
            this.checkAlpha();
        }
    }

    @Deprecated
    public PImage(Image img) {
        ShimAWT.fromNativeImage(img, this);
    }

    @Deprecated
    public Image getImage() {
        return (Image)this.getNative();
    }

    public Object getNative() {
        return ShimAWT.getNativeImage(this);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
        this.mx1 = 0;
        this.my1 = 0;
        this.mx2 = this.pixelWidth;
        this.my2 = this.pixelHeight;
    }

    public void setModified(boolean m) {
        this.modified = m;
    }

    public int getModifiedX1() {
        return this.mx1;
    }

    public int getModifiedX2() {
        return this.mx2;
    }

    public int getModifiedY1() {
        return this.my1;
    }

    public int getModifiedY2() {
        return this.my2;
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.pixelWidth * this.pixelHeight) {
            this.pixels = new int[this.pixelWidth * this.pixelHeight];
        }
        this.setLoaded();
    }

    public void updatePixels() {
        this.updatePixels(0, 0, this.pixelWidth, this.pixelHeight);
    }

    public void updatePixels(int x, int y, int w, int h) {
        int x2 = x + w;
        int y2 = y + h;
        if (!this.modified) {
            this.mx1 = PApplet.max(0, x);
            this.mx2 = PApplet.min(this.pixelWidth, x2);
            this.my1 = PApplet.max(0, y);
            this.my2 = PApplet.min(this.pixelHeight, y2);
            this.modified = true;
        } else {
            if (x < this.mx1) {
                this.mx1 = PApplet.max(0, x);
            }
            if (x > this.mx2) {
                this.mx2 = PApplet.min(this.pixelWidth, x);
            }
            if (y < this.my1) {
                this.my1 = PApplet.max(0, y);
            }
            if (y > this.my2) {
                this.my2 = PApplet.min(this.pixelHeight, y);
            }
            if (x2 < this.mx1) {
                this.mx1 = PApplet.max(0, x2);
            }
            if (x2 > this.mx2) {
                this.mx2 = PApplet.min(this.pixelWidth, x2);
            }
            if (y2 < this.my1) {
                this.my1 = PApplet.max(0, y2);
            }
            if (y2 > this.my2) {
                this.my2 = PApplet.min(this.pixelHeight, y2);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return this.get();
    }

    public void resize(int w, int h) {
        ShimAWT.resizeImage(this, w, h);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded() {
        this.loaded = true;
    }

    public void setLoaded(boolean l) {
        this.loaded = l;
    }

    public int get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.pixelWidth || y >= this.pixelHeight) {
            return 0;
        }
        return switch (this.format) {
            case 1 -> this.pixels[y * this.pixelWidth + x] | 0xFF000000;
            case 2 -> this.pixels[y * this.pixelWidth + x];
            case 4 -> this.pixels[y * this.pixelWidth + x] << 24 | 0xFFFFFF;
            default -> 0;
        };
    }

    public PImage get(int x, int y, int w, int h) {
        int targetX = 0;
        int targetY = 0;
        int targetWidth = w;
        int targetHeight = h;
        boolean cropped = false;
        if (x < 0) {
            w += x;
            targetX = -x;
            cropped = true;
            x = 0;
        }
        if (y < 0) {
            h += y;
            targetY = -y;
            cropped = true;
            y = 0;
        }
        if (x + w > this.pixelWidth) {
            w = this.pixelWidth - x;
            cropped = true;
        }
        if (y + h > this.pixelHeight) {
            h = this.pixelHeight - y;
            cropped = true;
        }
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        int targetFormat = this.format;
        if (cropped && this.format == 1) {
            targetFormat = 2;
        }
        PImage target = new PImage(targetWidth / this.pixelDensity, targetHeight / this.pixelDensity, targetFormat, this.pixelDensity);
        target.parent = this.parent;
        if (w > 0 && h > 0) {
            this.getImpl(x, y, w, h, target, targetX, targetY);
        }
        return target;
    }

    public PImage get() {
        return this.get(0, 0, this.pixelWidth, this.pixelHeight);
    }

    public PImage copy() {
        return this.get(0, 0, this.pixelWidth, this.pixelHeight);
    }

    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        int sourceIndex = sourceY * this.pixelWidth + sourceX;
        int targetIndex = targetY * target.pixelWidth + targetX;
        for (int row = 0; row < sourceHeight; ++row) {
            System.arraycopy(this.pixels, sourceIndex, target.pixels, targetIndex, sourceWidth);
            sourceIndex += this.pixelWidth;
            targetIndex += target.pixelWidth;
        }
    }

    public void set(int x, int y, int c) {
        if (x < 0 || y < 0 || x >= this.pixelWidth || y >= this.pixelHeight) {
            return;
        }
        switch (this.format) {
            case 1: {
                this.pixels[y * this.pixelWidth + x] = 0xFF000000 | c;
                break;
            }
            case 2: {
                this.pixels[y * this.pixelWidth + x] = c;
                break;
            }
            case 4: {
                this.pixels[y * this.pixelWidth + x] = (c & 0xFF) << 24 | 0xFFFFFF;
            }
        }
        this.updatePixels(x, y, 1, 1);
    }

    public void set(int x, int y, PImage img) {
        int sx = 0;
        int sy = 0;
        int sw = img.pixelWidth;
        int sh = img.pixelHeight;
        if (x < 0) {
            sx -= x;
            sw += x;
            x = 0;
        }
        if (y < 0) {
            sy -= y;
            sh += y;
            y = 0;
        }
        if (x + sw > this.pixelWidth) {
            sw = this.pixelWidth - x;
        }
        if (y + sh > this.pixelHeight) {
            sh = this.pixelHeight - y;
        }
        if (sw <= 0 || sh <= 0) {
            return;
        }
        this.setImpl(img, sx, sy, sw, sh, x, y);
    }

    protected void setImpl(PImage sourceImage, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int targetX, int targetY) {
        int sourceOffset = sourceY * sourceImage.pixelWidth + sourceX;
        int targetOffset = targetY * this.pixelWidth + targetX;
        for (int y = sourceY; y < sourceY + sourceHeight; ++y) {
            System.arraycopy(sourceImage.pixels, sourceOffset, this.pixels, targetOffset, sourceWidth);
            sourceOffset += sourceImage.pixelWidth;
            targetOffset += this.pixelWidth;
        }
        this.updatePixels(targetX, targetY, sourceWidth, sourceHeight);
    }

    public void mask(int[] maskArray) {
        this.loadPixels();
        if (maskArray.length != this.pixels.length) {
            throw new IllegalArgumentException("mask() can only be used with an image that's the same size.");
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = (maskArray[i] & 0xFF) << 24 | this.pixels[i] & 0xFFFFFF;
        }
        this.format = 2;
        this.updatePixels();
    }

    public void mask(PImage img) {
        img.loadPixels();
        this.mask(img.pixels);
    }

    public void filter(int kind) {
        this.loadPixels();
        switch (kind) {
            case 11: {
                this.filter(11, 1.0f);
                break;
            }
            case 12: {
                if (this.format == 4) {
                    for (int i = 0; i < this.pixels.length; ++i) {
                        int col = 255 - this.pixels[i];
                        this.pixels[i] = 0xFF000000 | col << 16 | col << 8 | col;
                    }
                    this.format = 1;
                    break;
                }
                for (int i = 0; i < this.pixels.length; ++i) {
                    int col = this.pixels[i];
                    int lum = 77 * (col >> 16 & 0xFF) + 151 * (col >> 8 & 0xFF) + 28 * (col & 0xFF) >> 8;
                    this.pixels[i] = col & 0xFF000000 | lum << 16 | lum << 8 | lum;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.pixels.length) {
                    int n = i++;
                    this.pixels[n] = this.pixels[n] ^ 0xFFFFFF;
                }
                break;
            }
            case 15: {
                throw new RuntimeException("Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)");
            }
            case 14: {
                int i = 0;
                while (i < this.pixels.length) {
                    int n = i++;
                    this.pixels[n] = this.pixels[n] | 0xFF000000;
                }
                this.format = 1;
                break;
            }
            case 16: {
                this.filter(16, 0.5f);
                break;
            }
            case 17: {
                this.erode();
                break;
            }
            case 18: {
                this.dilate();
            }
        }
        this.updatePixels();
    }

    public void filter(int kind, float param) {
        this.loadPixels();
        switch (kind) {
            case 11: {
                if (this.format == 4) {
                    this.blurAlpha(param);
                    break;
                }
                if (this.format == 2) {
                    this.blurARGB(param);
                    break;
                }
                this.blurRGB(param);
                break;
            }
            case 12: {
                throw new RuntimeException("Use filter(GRAY) instead of filter(GRAY, param)");
            }
            case 13: {
                throw new RuntimeException("Use filter(INVERT) instead of filter(INVERT, param)");
            }
            case 14: {
                throw new RuntimeException("Use filter(OPAQUE) instead of filter(OPAQUE, param)");
            }
            case 15: {
                int levels = (int)param;
                if (levels < 2 || levels > 255) {
                    throw new RuntimeException("Levels must be between 2 and 255 for filter(POSTERIZE, levels)");
                }
                int levels1 = levels - 1;
                for (int i = 0; i < this.pixels.length; ++i) {
                    int rlevel = this.pixels[i] >> 16 & 0xFF;
                    int glevel = this.pixels[i] >> 8 & 0xFF;
                    int blevel = this.pixels[i] & 0xFF;
                    rlevel = (rlevel * levels >> 8) * 255 / levels1;
                    glevel = (glevel * levels >> 8) * 255 / levels1;
                    blevel = (blevel * levels >> 8) * 255 / levels1;
                    this.pixels[i] = 0xFF000000 & this.pixels[i] | rlevel << 16 | glevel << 8 | blevel;
                }
                break;
            }
            case 16: {
                int thresh = (int)(param * 255.0f);
                for (int i = 0; i < this.pixels.length; ++i) {
                    int max = Math.max((this.pixels[i] & 0xFF0000) >> 16, Math.max((this.pixels[i] & 0xFF00) >> 8, this.pixels[i] & 0xFF));
                    this.pixels[i] = this.pixels[i] & 0xFF000000 | (max < thresh ? 0 : 0xFFFFFF);
                }
                break;
            }
            case 17: {
                throw new RuntimeException("Use filter(ERODE) instead of filter(ERODE, param)");
            }
            case 18: {
                throw new RuntimeException("Use filter(DILATE) instead of filter(DILATE, param)");
            }
        }
        this.updatePixels();
    }

    protected void buildBlurKernel(float r) {
        int radius = (int)(r * 3.5f);
        if (radius < 1) {
            radius = 1;
        }
        if (radius > 248) {
            radius = 248;
        }
        if (this.blurRadius != radius) {
            int[] bm;
            this.blurRadius = radius;
            this.blurKernelSize = 1 + this.blurRadius << 1;
            this.blurKernel = new int[this.blurKernelSize];
            this.blurMult = new int[this.blurKernelSize][256];
            int radiusi = radius - 1;
            for (int i = 1; i < radius; ++i) {
                int bki;
                this.blurKernel[radiusi] = bki = radiusi * radiusi;
                this.blurKernel[radius + i] = bki;
                bm = this.blurMult[radius + i];
                int[] bmi = this.blurMult[radiusi--];
                for (int j = 0; j < 256; ++j) {
                    bm[j] = bmi[j] = bki * j;
                }
            }
            int bk = this.blurKernel[radius] = radius * radius;
            bm = this.blurMult[radius];
            for (int j = 0; j < 256; ++j) {
                bm[j] = bk * j;
            }
        }
    }

    protected void blurAlpha(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int sum;
        int x;
        int y;
        int[] b2 = new int[this.pixels.length];
        int yi = 0;
        this.buildBlurKernel(r);
        for (y = 0; y < this.pixelHeight; ++y) {
            for (x = 0; x < this.pixelWidth; ++x) {
                sum = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.pixelWidth) break;
                    bk0 = 0;
                }
                for (i = bk0; i < this.blurKernelSize && read < this.pixelWidth; ++read, ++i) {
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                }
                ri = yi + x;
                b2[ri] = cb / sum;
            }
            yi += this.pixelWidth;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.pixelWidth;
        for (y = 0; y < this.pixelHeight; ++y) {
            for (x = 0; x < this.pixelWidth; ++x) {
                sum = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.pixelHeight) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                for (i = bk0; i < this.blurKernelSize && ri < this.pixelHeight; ++i) {
                    int[] bm = this.blurMult[i];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.pixelWidth;
                }
                this.pixels[x + yi] = cb / sum;
            }
            yi += this.pixelWidth;
            ymi += this.pixelWidth;
            ++ym;
        }
    }

    protected void blurRGB(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int cg;
        int cr;
        int sum;
        int x;
        int y;
        int[] r2 = new int[this.pixels.length];
        int[] g2 = new int[this.pixels.length];
        int[] b2 = new int[this.pixels.length];
        int yi = 0;
        this.buildBlurKernel(r);
        for (y = 0; y < this.pixelHeight; ++y) {
            for (x = 0; x < this.pixelWidth; ++x) {
                sum = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.pixelWidth) break;
                    bk0 = 0;
                }
                for (i = bk0; i < this.blurKernelSize && read < this.pixelWidth; ++read, ++i) {
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    cr += bm[(c & 0xFF0000) >> 16];
                    cg += bm[(c & 0xFF00) >> 8];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                }
                ri = yi + x;
                r2[ri] = cr / sum;
                g2[ri] = cg / sum;
                b2[ri] = cb / sum;
            }
            yi += this.pixelWidth;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.pixelWidth;
        for (y = 0; y < this.pixelHeight; ++y) {
            for (x = 0; x < this.pixelWidth; ++x) {
                sum = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.pixelHeight) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                for (i = bk0; i < this.blurKernelSize && ri < this.pixelHeight; ++i) {
                    int[] bm = this.blurMult[i];
                    cr += bm[r2[read]];
                    cg += bm[g2[read]];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.pixelWidth;
                }
                this.pixels[x + yi] = 0xFF000000 | cr / sum << 16 | cg / sum << 8 | cb / sum;
            }
            yi += this.pixelWidth;
            ymi += this.pixelWidth;
            ++ym;
        }
    }

    protected void blurARGB(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int cg;
        int cr;
        int ca;
        int sum;
        int x;
        int y;
        int wh = this.pixels.length;
        int[] r2 = new int[wh];
        int[] g2 = new int[wh];
        int[] b2 = new int[wh];
        int[] a2 = new int[wh];
        int yi = 0;
        this.buildBlurKernel(r);
        for (y = 0; y < this.pixelHeight; ++y) {
            for (x = 0; x < this.pixelWidth; ++x) {
                sum = 0;
                ca = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.pixelWidth) break;
                    bk0 = 0;
                }
                for (i = bk0; i < this.blurKernelSize && read < this.pixelWidth; ++read, ++i) {
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    ca += bm[(c & 0xFF000000) >>> 24];
                    cr += bm[(c & 0xFF0000) >> 16];
                    cg += bm[(c & 0xFF00) >> 8];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                }
                ri = yi + x;
                a2[ri] = ca / sum;
                r2[ri] = cr / sum;
                g2[ri] = cg / sum;
                b2[ri] = cb / sum;
            }
            yi += this.pixelWidth;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.pixelWidth;
        for (y = 0; y < this.pixelHeight; ++y) {
            for (x = 0; x < this.pixelWidth; ++x) {
                sum = 0;
                ca = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.pixelHeight) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                for (i = bk0; i < this.blurKernelSize && ri < this.pixelHeight; ++i) {
                    int[] bm = this.blurMult[i];
                    ca += bm[a2[read]];
                    cr += bm[r2[read]];
                    cg += bm[g2[read]];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.pixelWidth;
                }
                this.pixels[x + yi] = ca / sum << 24 | cr / sum << 16 | cg / sum << 8 | cb / sum;
            }
            yi += this.pixelWidth;
            ymi += this.pixelWidth;
            ++ym;
        }
    }

    protected void dilate() {
        int index = 0;
        int maxIndex = this.pixels.length;
        int[] outgoing = new int[maxIndex];
        while (index < maxIndex) {
            int curRowIndex = index;
            int maxRowIndex = index + this.pixelWidth;
            while (index < maxRowIndex) {
                int orig;
                int result = orig = this.pixels[index];
                int idxLeft = index - 1;
                int idxRight = index + 1;
                int idxUp = index - this.pixelWidth;
                int idxDown = index + this.pixelWidth;
                if (idxLeft < curRowIndex) {
                    idxLeft = index;
                }
                if (idxRight >= maxRowIndex) {
                    idxRight = index;
                }
                if (idxUp < 0) {
                    idxUp = index;
                }
                if (idxDown >= maxIndex) {
                    idxDown = index;
                }
                int colUp = this.pixels[idxUp];
                int colLeft = this.pixels[idxLeft];
                int colDown = this.pixels[idxDown];
                int colRight = this.pixels[idxRight];
                int currLum = 77 * (orig >> 16 & 0xFF) + 151 * (orig >> 8 & 0xFF) + 28 * (orig & 0xFF);
                int lumLeft = 77 * (colLeft >> 16 & 0xFF) + 151 * (colLeft >> 8 & 0xFF) + 28 * (colLeft & 0xFF);
                int lumRight = 77 * (colRight >> 16 & 0xFF) + 151 * (colRight >> 8 & 0xFF) + 28 * (colRight & 0xFF);
                int lumUp = 77 * (colUp >> 16 & 0xFF) + 151 * (colUp >> 8 & 0xFF) + 28 * (colUp & 0xFF);
                int lumDown = 77 * (colDown >> 16 & 0xFF) + 151 * (colDown >> 8 & 0xFF) + 28 * (colDown & 0xFF);
                if (lumLeft > currLum) {
                    result = colLeft;
                    currLum = lumLeft;
                }
                if (lumRight > currLum) {
                    result = colRight;
                    currLum = lumRight;
                }
                if (lumUp > currLum) {
                    result = colUp;
                    currLum = lumUp;
                }
                if (lumDown > currLum) {
                    result = colDown;
                }
                outgoing[index++] = result;
            }
        }
        System.arraycopy(outgoing, 0, this.pixels, 0, maxIndex);
    }

    protected void erode() {
        int index = 0;
        int maxIndex = this.pixels.length;
        int[] outgoing = new int[maxIndex];
        while (index < maxIndex) {
            int curRowIndex = index;
            int maxRowIndex = index + this.pixelWidth;
            while (index < maxRowIndex) {
                int orig;
                int result = orig = this.pixels[index];
                int idxLeft = index - 1;
                int idxRight = index + 1;
                int idxUp = index - this.pixelWidth;
                int idxDown = index + this.pixelWidth;
                if (idxLeft < curRowIndex) {
                    idxLeft = index;
                }
                if (idxRight >= maxRowIndex) {
                    idxRight = index;
                }
                if (idxUp < 0) {
                    idxUp = index;
                }
                if (idxDown >= maxIndex) {
                    idxDown = index;
                }
                int colUp = this.pixels[idxUp];
                int colLeft = this.pixels[idxLeft];
                int colDown = this.pixels[idxDown];
                int colRight = this.pixels[idxRight];
                int currLum = 77 * (orig >> 16 & 0xFF) + 151 * (orig >> 8 & 0xFF) + 28 * (orig & 0xFF);
                int lumLeft = 77 * (colLeft >> 16 & 0xFF) + 151 * (colLeft >> 8 & 0xFF) + 28 * (colLeft & 0xFF);
                int lumRight = 77 * (colRight >> 16 & 0xFF) + 151 * (colRight >> 8 & 0xFF) + 28 * (colRight & 0xFF);
                int lumUp = 77 * (colUp >> 16 & 0xFF) + 151 * (colUp >> 8 & 0xFF) + 28 * (colUp & 0xFF);
                int lumDown = 77 * (colDown >> 16 & 0xFF) + 151 * (colDown >> 8 & 0xFF) + 28 * (colDown & 0xFF);
                if (lumLeft < currLum) {
                    result = colLeft;
                    currLum = lumLeft;
                }
                if (lumRight < currLum) {
                    result = colRight;
                    currLum = lumRight;
                }
                if (lumUp < currLum) {
                    result = colUp;
                    currLum = lumUp;
                }
                if (lumDown < currLum) {
                    result = colDown;
                }
                outgoing[index++] = result;
            }
        }
        System.arraycopy(outgoing, 0, this.pixels, 0, maxIndex);
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.blend(this, sx, sy, sw, sh, dx, dy, dw, dh, 0);
    }

    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, 0);
    }

    public static int blendColor(int c1, int c2, int mode) {
        return switch (mode) {
            case 0 -> c2;
            case 1 -> PImage.blend_blend(c1, c2);
            case 2 -> PImage.blend_add_pin(c1, c2);
            case 4 -> PImage.blend_sub_pin(c1, c2);
            case 8 -> PImage.blend_lightest(c1, c2);
            case 16 -> PImage.blend_darkest(c1, c2);
            case 32 -> PImage.blend_difference(c1, c2);
            case 64 -> PImage.blend_exclusion(c1, c2);
            case 128 -> PImage.blend_multiply(c1, c2);
            case 256 -> PImage.blend_screen(c1, c2);
            case 1024 -> PImage.blend_hard_light(c1, c2);
            case 2048 -> PImage.blend_soft_light(c1, c2);
            case 512 -> PImage.blend_overlay(c1, c2);
            case 4096 -> PImage.blend_dodge(c1, c2);
            case 8192 -> PImage.blend_burn(c1, c2);
            default -> 0;
        };
    }

    public void blend(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        this.blend(this, sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    public void blend(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        int sx2 = sx + sw;
        int sy2 = sy + sh;
        int dx2 = dx + dw;
        int dy2 = dy + dh;
        this.loadPixels();
        if (src == this) {
            if (this.intersect(sx, sy, sx2, sy2, dx, dy, dx2, dy2)) {
                this.blitResize(this.get(sx, sy, sw, sh), 0, 0, sw, sh, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode, true);
            } else {
                this.blitResize(src, sx, sy, sx2, sy2, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode, true);
            }
        } else {
            src.loadPixels();
            this.blitResize(src, sx, sy, sx2, sy2, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode, true);
        }
        this.updatePixels();
    }

    private boolean intersect(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        int sw = sx2 - sx1 + 1;
        int sh = sy2 - sy1 + 1;
        int dw = dx2 - dx1 + 1;
        int dh = dy2 - dy1 + 1;
        if (dx1 < sx1) {
            if ((dw += dx1 - sx1) > sw) {
                dw = sw;
            }
        } else {
            int w = sw + sx1 - dx1;
            if (dw > w) {
                dw = w;
            }
        }
        if (dy1 < sy1) {
            if ((dh += dy1 - sy1) > sh) {
                dh = sh;
            }
        } else {
            int h = sh + sy1 - dy1;
            if (dh > h) {
                dh = h;
            }
        }
        return dw > 0 && dh > 0;
    }

    private void blitResize(PImage img, int srcX1, int srcY1, int srcX2, int srcY2, int[] destPixels, int screenW, int screenH, int destX1, int destY1, int destX2, int destY2, int mode, boolean smooth) {
        if (srcX1 < 0) {
            srcX1 = 0;
        }
        if (srcY1 < 0) {
            srcY1 = 0;
        }
        if (srcX2 > img.pixelWidth) {
            srcX2 = img.pixelWidth;
        }
        if (srcY2 > img.pixelHeight) {
            srcY2 = img.pixelHeight;
        }
        int srcW = srcX2 - srcX1;
        int srcH = srcY2 - srcY1;
        int destW = destX2 - destX1;
        int destH = destY2 - destY1;
        if (!smooth) {
            ++srcW;
            ++srcH;
        }
        if (destW <= 0 || destH <= 0 || srcW <= 0 || srcH <= 0 || destX1 >= screenW || destY1 >= screenH || srcX1 >= img.pixelWidth || srcY1 >= img.pixelHeight) {
            return;
        }
        int dx = (int)((float)srcW / (float)destW * 32768.0f);
        int dy = (int)((float)srcH / (float)destH * 32768.0f);
        this.srcXOffset = destX1 < 0 ? -destX1 * dx : srcX1 * 32768;
        int n = this.srcYOffset = destY1 < 0 ? -destY1 * dy : srcY1 * 32768;
        if (destX1 < 0) {
            destW += destX1;
            destX1 = 0;
        }
        if (destY1 < 0) {
            destH += destY1;
            destY1 = 0;
        }
        destW = PImage.min(destW, screenW - destX1);
        destH = PImage.min(destH, screenH - destY1);
        int destOffset = destY1 * screenW + destX1;
        this.srcBuffer = img.pixels;
        if (smooth) {
            this.blitResizeBilinear(img, destPixels, destOffset, screenW, destW, destH, dx, dy, mode);
        } else {
            this.blitResizeNearest(img, destPixels, destOffset, screenW, destW, destH, dx, dy, mode);
        }
    }

    private void blitResizeBilinear(PImage img, int[] destPixels, int destOffset, int screenW, int destW, int destH, int dx, int dy, int mode) {
        this.iw = img.pixelWidth;
        this.iw1 = img.pixelWidth - 1;
        this.ih1 = img.pixelHeight - 1;
        switch (mode) {
            case 1: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_blend(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_add_pin(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_sub_pin(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 8: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_lightest(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 16: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_darkest(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 0: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = this.filter_bilinear();
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 32: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_difference(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 64: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_exclusion(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 128: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_multiply(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 256: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_screen(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 512: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_overlay(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 1024: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_hard_light(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 2048: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_soft_light(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 4096: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_dodge(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 8192: {
                for (int y = 0; y < destH; ++y) {
                    this.filter_new_scanline();
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_burn(destPixels[destOffset + x], this.filter_bilinear());
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
        }
    }

    private void blitResizeNearest(PImage img, int[] destPixels, int destOffset, int screenW, int destW, int destH, int dx, int dy, int mode) {
        switch (mode) {
            case 1: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_blend(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_add_pin(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_sub_pin(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 8: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_lightest(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 16: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_darkest(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 0: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = this.srcBuffer[sY + (this.sX >> 15)];
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 32: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_difference(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 64: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_exclusion(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 128: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_multiply(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 256: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_screen(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 512: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_overlay(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 1024: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_hard_light(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 2048: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_soft_light(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 4096: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_dodge(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
            case 8192: {
                for (int y = 0; y < destH; ++y) {
                    this.sX = this.srcXOffset;
                    int sY = (this.srcYOffset >> 15) * img.pixelWidth;
                    for (int x = 0; x < destW; ++x) {
                        destPixels[destOffset + x] = PImage.blend_burn(destPixels[destOffset + x], this.srcBuffer[sY + (this.sX >> 15)]);
                        this.sX += dx;
                    }
                    destOffset += screenW;
                    this.srcYOffset += dy;
                }
                break;
            }
        }
    }

    private void filter_new_scanline() {
        this.sX = this.srcXOffset;
        int fracV = this.srcYOffset & Short.MAX_VALUE;
        this.ifV = Short.MAX_VALUE - fracV + 1;
        this.v1 = (this.srcYOffset >> 15) * this.iw;
        this.v2 = PImage.min((this.srcYOffset >> 15) + 1, this.ih1) * this.iw;
    }

    private int filter_bilinear() {
        int fracU = this.sX & Short.MAX_VALUE;
        int ifU = Short.MAX_VALUE - fracU + 1;
        int ul = ifU * this.ifV >> 15;
        int ll = ifU - ul;
        int ur = this.ifV - ul;
        int lr = 32768 - ul - ll - ur;
        int u1 = this.sX >> 15;
        int u2 = PImage.min(u1 + 1, this.iw1);
        int cUL = this.srcBuffer[this.v1 + u1];
        int cUR = this.srcBuffer[this.v1 + u2];
        int cLL = this.srcBuffer[this.v2 + u1];
        int cLR = this.srcBuffer[this.v2 + u2];
        int r = ul * ((cUL & 0xFF0000) >> 16) + ll * ((cLL & 0xFF0000) >> 16) + ur * ((cUR & 0xFF0000) >> 16) + lr * ((cLR & 0xFF0000) >> 16) << 1 & 0xFF0000;
        int g = ul * (cUL & 0xFF00) + ll * (cLL & 0xFF00) + ur * (cUR & 0xFF00) + lr * (cLR & 0xFF00) >>> 15 & 0xFF00;
        int b = ul * (cUL & 0xFF) + ll * (cLL & 0xFF) + ur * (cUR & 0xFF) + lr * (cLR & 0xFF) >>> 15;
        int a = ul * ((cUL & 0xFF000000) >>> 24) + ll * ((cLL & 0xFF000000) >>> 24) + ur * ((cUR & 0xFF000000) >>> 24) + lr * ((cLR & 0xFF000000) >>> 24) << 9 & 0xFF000000;
        return a | r | g | b;
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    private static int blend_blend(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + (src & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (src & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_add_pin(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int rb = (dst & 0xFF00FF) + ((src & 0xFF00FF) * s_a >>> 8 & 0xFF00FF);
        int gn = (dst & 0xFF00) + ((src & 0xFF00) * s_a >>> 8);
        return PImage.min((dst >>> 24) + a, 255) << 24 | PImage.min(rb & 0xFFFF0000, 0xFF0000) | PImage.min(gn & 0xFFFF00, 65280) | PImage.min(rb & 0xFFFF, 255);
    }

    private static int blend_sub_pin(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int rb = (src & 0xFF00FF) * s_a >>> 8;
        int gn = (src & 0xFF00) * s_a >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | PImage.max((dst & 0xFF0000) - (rb & 0xFF0000), 0) | PImage.max((dst & 0xFF00) - (gn & 0xFF00), 0) | PImage.max((dst & 0xFF) - (rb & 0xFF), 0);
    }

    private static int blend_lightest(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int rb = PImage.max(src & 0xFF0000, dst & 0xFF0000) | PImage.max(src & 0xFF, dst & 0xFF);
        int gn = PImage.max(src & 0xFF00, dst & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_darkest(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int rb = PImage.min(src & 0xFF0000, dst & 0xFF0000) | PImage.min(src & 0xFF, dst & 0xFF);
        int gn = PImage.min(src & 0xFF00, dst & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_difference(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (dst & 0xFF0000) - (src & 0xFF0000);
        int b = (dst & 0xFF) - (src & 0xFF);
        int g = (dst & 0xFF00) - (src & 0xFF00);
        int rb = (r < 0 ? -r : r) | (b < 0 ? -b : b);
        int gn = g < 0 ? -g : g;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_exclusion(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_rb = dst & 0xFF00FF;
        int d_gn = dst & 0xFF00;
        int s_gn = src & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb_sub = ((src & 0xFF0000) * (f_r + (f_r >= 127 ? 1 : 0)) | (src & 0xFF) * (f_b + (f_b >= 127 ? 1 : 0))) >>> 7 & 0x1FF01FF;
        int gn_sub = s_gn * (d_gn + (d_gn >= 32512 ? 256 : 0)) >>> 15 & 0x1FF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | d_rb * d_a + (d_rb + (src & 0xFF00FF) - rb_sub) * s_a >>> 8 & 0xFF00FF | d_gn * d_a + (d_gn + s_gn - gn_sub) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_multiply(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_gn = dst & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb = ((src & 0xFF0000) * (f_r + 1) | (src & 0xFF) * (f_b + 1)) >>> 8 & 0xFF00FF;
        int gn = (src & 0xFF00) * (d_gn + 256) >>> 16 & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | d_gn * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_screen(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_rb = dst & 0xFF00FF;
        int d_gn = dst & 0xFF00;
        int s_gn = src & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb_sub = ((src & 0xFF0000) * (f_r + 1) | (src & 0xFF) * (f_b + 1)) >>> 8 & 0xFF00FF;
        int gn_sub = s_gn * (d_gn + 256) >>> 16 & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | d_rb * d_a + (d_rb + (src & 0xFF00FF) - rb_sub) * s_a >>> 8 & 0xFF00FF | d_gn * d_a + (d_gn + s_gn - gn_sub) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_overlay(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r = src & 0xFF0000;
        int s_g = src & 0xFF00;
        int s_b = src & 0xFF;
        int r = d_r < 0x800000 ? d_r * ((s_r >>> 16) + 1) >>> 7 : 0xFF0000 - ((256 - (s_r >>> 16)) * (0xFF0000 - d_r) >>> 7);
        int g = d_g < 32768 ? d_g * (s_g + 256) >>> 15 : 65280 - ((65536 - s_g) * (65280 - d_g) >>> 15);
        int b = d_b < 128 ? d_b * (s_b + 1) >>> 7 : 65280 - ((256 - s_b) * (255 - d_b) << 1) >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + ((r | b) & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (g & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_hard_light(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r = src & 0xFF0000;
        int s_g = src & 0xFF00;
        int s_b = src & 0xFF;
        int r = s_r < 0x800000 ? s_r * ((d_r >>> 16) + 1) >>> 7 : 0xFF0000 - ((256 - (d_r >>> 16)) * (0xFF0000 - s_r) >>> 7);
        int g = s_g < 32768 ? s_g * (d_g + 256) >>> 15 : 65280 - ((65536 - d_g) * (65280 - s_g) >>> 15);
        int b = s_b < 128 ? s_b * (d_b + 1) >>> 7 : 65280 - ((256 - d_b) * (255 - s_b) << 1) >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + ((r | b) & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (g & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_soft_light(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r1 = src & 0xFF;
        int s_g1 = src & 0xFF;
        int s_b1 = src & 0xFF;
        int d_r1 = (d_r >> 16) + ((float)s_r1 < 7.0f ? 1 : 0);
        int d_g1 = (d_g >> 8) + ((float)s_g1 < 7.0f ? 1 : 0);
        int d_b1 = d_b + ((float)s_b1 < 7.0f ? 1 : 0);
        int r = (s_r1 * d_r >> 7) + 255 * d_r1 * (d_r1 + 1) - (s_r1 * d_r1 * d_r1 << 1) & 0xFF0000;
        int g = (s_g1 * d_g << 1) + 255 * d_g1 * (d_g1 + 1) - (s_g1 * d_g1 * d_g1 << 1) >>> 8 & 0xFF00;
        int b = (s_b1 * d_b << 9) + 255 * d_b1 * (d_b1 + 1) - (s_b1 * d_b1 * d_b1 << 1) >>> 16;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + (r | b) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + g * s_a >>> 8 & 0xFF00;
    }

    private static int blend_dodge(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (dst & 0xFF0000) / (256 - ((src & 0xFF0000) >> 16));
        int g = ((dst & 0xFF00) << 8) / (256 - ((src & 0xFF00) >> 8));
        int b = ((dst & 0xFF) << 8) / (256 - (src & 0xFF));
        int rb = (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) | (b > 255 ? 255 : b);
        int gn = g > 65280 ? 65280 : g & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_burn(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (0xFF0000 - (dst & 0xFF0000)) / (1 + (src & 0xFF));
        int g = (65280 - (dst & 0xFF00) << 8) / (1 + (src & 0xFF));
        int b = (255 - (dst & 0xFF) << 8) / (1 + (src & 0xFF));
        int rb = 0xFF00FF - (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) - (b > 255 ? 255 : b);
        int gn = 65280 - (g > 65280 ? 65280 : g & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    public static PImage loadTGA(InputStream input) throws IOException {
        PImage outgoing;
        block46: {
            boolean reversed;
            int h;
            int w;
            int format;
            block44: {
                block45: {
                    int count;
                    byte[] header = new byte[18];
                    int offset = 0;
                    do {
                        if ((count = input.read(header, offset, header.length - offset)) != -1) continue;
                        return null;
                    } while ((offset += count) < 18);
                    format = 0;
                    if (!(header[2] != 3 && header[2] != 11 || header[16] != 8 || header[17] != 8 && header[17] != 40)) {
                        format = 4;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 24 || header[17] != 32 && header[17] != 0)) {
                        format = 1;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 32 || header[17] != 8 && header[17] != 40)) {
                        format = 2;
                    }
                    if (format == 0) {
                        System.err.println("Unknown .tga file format");
                        return null;
                    }
                    w = ((header[13] & 0xFF) << 8) + (header[12] & 0xFF);
                    h = ((header[15] & 0xFF) << 8) + (header[14] & 0xFF);
                    outgoing = new PImage(w, h, format);
                    boolean bl = reversed = (header[17] & 0x20) == 0;
                    if (header[2] != 2 && header[2] != 3) break block44;
                    if (!reversed) break block45;
                    int index = (h - 1) * w;
                    switch (format) {
                        case 4: {
                            for (int y = h - 1; y >= 0; --y) {
                                for (int x = 0; x < w; ++x) {
                                    outgoing.pixels[index + x] = input.read();
                                }
                                index -= w;
                            }
                            break block46;
                        }
                        case 1: {
                            for (int y = h - 1; y >= 0; --y) {
                                for (int x = 0; x < w; ++x) {
                                    outgoing.pixels[index + x] = input.read() | input.read() << 8 | input.read() << 16 | 0xFF000000;
                                }
                                index -= w;
                            }
                            break block46;
                        }
                        case 2: {
                            for (int y = h - 1; y >= 0; --y) {
                                for (int x = 0; x < w; ++x) {
                                    outgoing.pixels[index + x] = input.read() | input.read() << 8 | input.read() << 16 | input.read() << 24;
                                }
                                index -= w;
                            }
                            break;
                        }
                    }
                    break block46;
                }
                int count = w * h;
                switch (format) {
                    case 4: {
                        for (int i = 0; i < count; ++i) {
                            outgoing.pixels[i] = input.read();
                        }
                        break block46;
                    }
                    case 1: {
                        for (int i = 0; i < count; ++i) {
                            outgoing.pixels[i] = input.read() | input.read() << 8 | input.read() << 16 | 0xFF000000;
                        }
                        break block46;
                    }
                    case 2: {
                        for (int i = 0; i < count; ++i) {
                            outgoing.pixels[i] = input.read() | input.read() << 8 | input.read() << 16 | input.read() << 24;
                        }
                        break;
                    }
                }
                break block46;
            }
            int index = 0;
            int[] px = outgoing.pixels;
            block30: while (index < px.length) {
                boolean isRLE;
                int num = input.read();
                boolean bl = isRLE = (num & 0x80) != 0;
                if (isRLE) {
                    num -= 127;
                    int pixel = switch (format) {
                        case 4 -> input.read();
                        case 1 -> 0xFF000000 | input.read() | input.read() << 8 | input.read() << 16;
                        case 2 -> input.read() | input.read() << 8 | input.read() << 16 | input.read() << 24;
                        default -> 0;
                    };
                    for (int i = 0; i < num; ++i) {
                        px[index++] = pixel;
                        if (index == px.length) continue block30;
                    }
                    continue;
                }
                ++num;
                switch (format) {
                    case 4: {
                        int i;
                        for (i = 0; i < num; ++i) {
                            px[index++] = input.read();
                        }
                        continue block30;
                    }
                    case 1: {
                        int i;
                        for (i = 0; i < num; ++i) {
                            px[index++] = 0xFF000000 | input.read() | input.read() << 8 | input.read() << 16;
                        }
                        continue block30;
                    }
                    case 2: {
                        int i;
                        for (i = 0; i < num; ++i) {
                            px[index++] = input.read() | input.read() << 8 | input.read() << 16 | input.read() << 24;
                        }
                        break;
                    }
                }
            }
            if (!reversed) {
                int[] temp = new int[w];
                for (int y = 0; y < h / 2; ++y) {
                    int z = h - 1 - y;
                    System.arraycopy(px, y * w, temp, 0, w);
                    System.arraycopy(px, z * w, px, y * w, w);
                    System.arraycopy(temp, 0, px, z * w, w);
                }
            }
        }
        input.close();
        return outgoing;
    }

    protected boolean saveTGA(OutputStream output) {
        byte[] header = new byte[18];
        if (this.format == 4) {
            header[2] = 11;
            header[16] = 8;
            header[17] = 40;
        } else if (this.format == 1) {
            header[2] = 10;
            header[16] = 24;
            header[17] = 32;
        } else if (this.format == 2) {
            header[2] = 10;
            header[16] = 32;
            header[17] = 40;
        } else {
            throw new RuntimeException("Image format not recognized inside save()");
        }
        header[12] = (byte)(this.pixelWidth & 0xFF);
        header[13] = (byte)(this.pixelWidth >> 8);
        header[14] = (byte)(this.pixelHeight & 0xFF);
        header[15] = (byte)(this.pixelHeight >> 8);
        try {
            output.write(header);
            int maxLen = this.pixelHeight * this.pixelWidth;
            int[] currChunk = new int[128];
            if (this.format == 4) {
                int rle;
                for (index = 0; index < maxLen; index += rle) {
                    int col;
                    boolean isRLE = false;
                    rle = 1;
                    currChunk[0] = col = this.pixels[index] & 0xFF;
                    while (index + rle < maxLen) {
                        if (col != (this.pixels[index + rle] & 0xFF) || rle == 128) {
                            isRLE = rle > 1;
                            break;
                        }
                        ++rle;
                    }
                    if (isRLE) {
                        output.write(0x80 | rle - 1);
                        output.write(col);
                        continue;
                    }
                    rle = 1;
                    while (index + rle < maxLen) {
                        int cscan = this.pixels[index + rle] & 0xFF;
                        if ((col == cscan || rle >= 128) && rle >= 3) {
                            if (col != cscan) break;
                            rle -= 2;
                            break;
                        }
                        currChunk[rle] = col = cscan;
                        ++rle;
                    }
                    output.write(rle - 1);
                    for (int i = 0; i < rle; ++i) {
                        output.write(currChunk[i]);
                    }
                }
            } else {
                while (index < maxLen) {
                    int col;
                    boolean isRLE = false;
                    currChunk[0] = col = this.pixels[index];
                    int rle = 1;
                    while (index + rle < maxLen) {
                        if (col != this.pixels[index + rle] || rle == 128) {
                            isRLE = rle > 1;
                            break;
                        }
                        ++rle;
                    }
                    if (isRLE) {
                        output.write(0x80 | rle - 1);
                        output.write(col & 0xFF);
                        output.write(col >> 8 & 0xFF);
                        output.write(col >> 16 & 0xFF);
                        if (this.format == 2) {
                            output.write(col >>> 24 & 0xFF);
                        }
                    } else {
                        rle = 1;
                        while (index + rle < maxLen) {
                            if ((col == this.pixels[index + rle] || rle >= 128) && rle >= 3) {
                                if (col != this.pixels[index + rle]) break;
                                rle -= 2;
                                break;
                            }
                            currChunk[rle] = col = this.pixels[index + rle];
                            ++rle;
                        }
                        output.write(rle - 1);
                        if (this.format == 2) {
                            for (i = 0; i < rle; ++i) {
                                col = currChunk[i];
                                output.write(col & 0xFF);
                                output.write(col >> 8 & 0xFF);
                                output.write(col >> 16 & 0xFF);
                                output.write(col >>> 24 & 0xFF);
                            }
                        } else {
                            for (i = 0; i < rle; ++i) {
                                col = currChunk[i];
                                output.write(col & 0xFF);
                                output.write(col >> 8 & 0xFF);
                                output.write(col >> 16 & 0xFF);
                            }
                        }
                    }
                    index += rle;
                }
            }
            output.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean save(String filename) {
        String path;
        if (this.parent != null) {
            path = this.parent.savePath(filename);
        } else {
            File file = new File(filename);
            if (file.isAbsolute()) {
                PApplet.createPath(file);
                path = file.getAbsolutePath();
            } else {
                String msg = "PImage.save() requires an absolute path. Use createImage(), or pass savePath() to save().";
                PGraphics.showException(msg);
                return false;
            }
        }
        return this.saveImpl(path);
    }

    protected boolean saveImpl(String path) {
        boolean success;
        this.loadPixels();
        try {
            String lower = path.toLowerCase();
            if (lower.endsWith(".tga")) {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path), 32768);
                success = this.saveTGA(os);
                ((OutputStream)os).close();
            } else {
                success = ShimAWT.saveImage(this, path, new String[0]);
            }
        }
        catch (IOException e) {
            System.err.println("Error while saving " + path);
            e.printStackTrace();
            success = false;
        }
        return success;
    }
}

