/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.Taskbar;
import processing.core.PApplet;

public class ThinkDifferent {
    private static Desktop desktop;
    private static Taskbar taskbar;
    static boolean attemptedQuit;

    public static void init(PApplet sketch) {
        ThinkDifferent.getDesktop().setQuitHandler((event, quitResponse) -> {
            boolean noKnownCrash;
            sketch.exit();
            boolean bl = noKnownCrash = PApplet.uncaughtThrowable == null;
            if (noKnownCrash && !attemptedQuit) {
                quitResponse.cancelQuit();
                attemptedQuit = true;
            } else {
                quitResponse.performQuit();
            }
        });
    }

    public static void cleanup() {
        ThinkDifferent.getDesktop().setQuitHandler(null);
    }

    public static void setIconImage(Image image) {
        ThinkDifferent.getTaskbar().setIconImage(image);
    }

    private static Taskbar getTaskbar() {
        if (taskbar == null) {
            taskbar = Taskbar.getTaskbar();
        }
        return taskbar;
    }

    private static Desktop getDesktop() {
        if (desktop == null) {
            desktop = Desktop.getDesktop();
        }
        return desktop;
    }
}

