/*
 * Decompiled with CFR 0.152.
 */
package processing.awt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PShapeSVG;
import processing.data.XML;

public class PShapeJava2D
extends PShapeSVG {
    Paint strokeGradientPaint;
    Paint fillGradientPaint;

    public PShapeJava2D(XML svg) {
        super(svg);
    }

    public PShapeJava2D(PShapeSVG parent, XML properties, boolean parseKids) {
        super(parent, properties, parseKids);
    }

    @Override
    protected void setParent(PShapeSVG parent) {
        super.setParent(parent);
        if (parent instanceof PShapeJava2D) {
            PShapeJava2D pj = (PShapeJava2D)parent;
            this.fillGradientPaint = pj.fillGradientPaint;
            this.strokeGradientPaint = pj.strokeGradientPaint;
        } else {
            this.fillGradientPaint = null;
            this.strokeGradientPaint = null;
        }
    }

    @Override
    protected PShapeSVG createShape(PShapeSVG parent, XML properties, boolean parseKids) {
        return new PShapeJava2D(parent, properties, parseKids);
    }

    protected Paint calcGradientPaint(PShapeSVG.Gradient gradient) {
        if (gradient instanceof PShapeSVG.LinearGradient) {
            PShapeSVG.LinearGradient grad = (PShapeSVG.LinearGradient)gradient;
            return new LinearGradientPaint(grad.x1, grad.y1, grad.x2, grad.y2, grad.offset, grad.color, grad.count, this.opacity);
        }
        if (gradient instanceof PShapeSVG.RadialGradient) {
            PShapeSVG.RadialGradient grad = (PShapeSVG.RadialGradient)gradient;
            return new RadialGradientPaint(grad.cx, grad.cy, grad.r, grad.offset, grad.color, grad.count, this.opacity);
        }
        return null;
    }

    @Override
    protected void styles(PGraphics g) {
        super.styles(g);
        PGraphicsJava2D p2d = (PGraphicsJava2D)g;
        if (this.strokeGradient != null) {
            p2d.strokeGradient = true;
            if (this.strokeGradientPaint == null) {
                this.strokeGradientPaint = this.calcGradientPaint(this.strokeGradient);
            }
            p2d.strokeGradientObject = this.strokeGradientPaint;
        }
        if (this.fillGradient != null) {
            p2d.fillGradient = true;
            if (this.fillGradientPaint == null) {
                this.fillGradientPaint = this.calcGradientPaint(this.fillGradient);
            }
            p2d.fillGradientObject = this.fillGradientPaint;
        }
    }

    static class RadialGradientPaint
    implements Paint {
        float cx;
        float cy;
        float radius;
        float[] offset;
        int[] color;
        int count;
        float opacity;

        public RadialGradientPaint(float cx, float cy, float radius, float[] offset, int[] color, int count, float opacity) {
            this.cx = cx;
            this.cy = cy;
            this.radius = radius;
            this.offset = offset;
            this.color = color;
            this.count = count;
            this.opacity = opacity;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            return new RadialGradientContext();
        }

        @Override
        public int getTransparency() {
            return 3;
        }

        public class RadialGradientContext
        implements PaintContext {
            int ACCURACY = 5;

            @Override
            public void dispose() {
            }

            @Override
            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            @Override
            public Raster getRaster(int x, int y, int w, int h) {
                WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
                int span = (int)RadialGradientPaint.this.radius * this.ACCURACY;
                int[][] interp = new int[span][4];
                int prev = 0;
                for (int i = 1; i < RadialGradientPaint.this.count; ++i) {
                    int c0 = RadialGradientPaint.this.color[i - 1];
                    int c1 = RadialGradientPaint.this.color[i];
                    int last = (int)(RadialGradientPaint.this.offset[i] * (float)(span - 1));
                    for (int j = prev; j <= last; ++j) {
                        float btwn = PApplet.norm(j, prev, last);
                        interp[j][0] = (int)PApplet.lerp(c0 >> 16 & 0xFF, c1 >> 16 & 0xFF, btwn);
                        interp[j][1] = (int)PApplet.lerp(c0 >> 8 & 0xFF, c1 >> 8 & 0xFF, btwn);
                        interp[j][2] = (int)PApplet.lerp(c0 & 0xFF, c1 & 0xFF, btwn);
                        interp[j][3] = (int)(PApplet.lerp(c0 >> 24 & 0xFF, c1 >> 24 & 0xFF, btwn) * RadialGradientPaint.this.opacity);
                    }
                    prev = last;
                }
                int[] data = new int[w * h * 4];
                int index = 0;
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        float distance = PApplet.dist(RadialGradientPaint.this.cx, RadialGradientPaint.this.cy, x + i, y + j);
                        int which = PApplet.min((int)(distance * (float)this.ACCURACY), interp.length - 1);
                        data[index++] = interp[which][0];
                        data[index++] = interp[which][1];
                        data[index++] = interp[which][2];
                        data[index++] = interp[which][3];
                    }
                }
                raster.setPixels(0, 0, w, h, data);
                return raster;
            }
        }
    }

    static class LinearGradientPaint
    implements Paint {
        float x1;
        float y1;
        float x2;
        float y2;
        float[] offset;
        int[] color;
        int count;
        float opacity;

        public LinearGradientPaint(float x1, float y1, float x2, float y2, float[] offset, int[] color, int count, float opacity) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.offset = offset;
            this.color = color;
            this.count = count;
            this.opacity = opacity;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            Point2D t1 = xform.transform(new Point2D.Float(this.x1, this.y1), null);
            Point2D t2 = xform.transform(new Point2D.Float(this.x2, this.y2), null);
            return new LinearGradientContext((float)t1.getX(), (float)t1.getY(), (float)t2.getX(), (float)t2.getY());
        }

        @Override
        public int getTransparency() {
            return 3;
        }

        public class LinearGradientContext
        implements PaintContext {
            int ACCURACY = 2;
            float tx1;
            float ty1;
            float tx2;
            float ty2;

            public LinearGradientContext(float tx1, float ty1, float tx2, float ty2) {
                this.tx1 = tx1;
                this.ty1 = ty1;
                this.tx2 = tx2;
                this.ty2 = ty2;
            }

            @Override
            public void dispose() {
            }

            @Override
            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            @Override
            public Raster getRaster(int x, int y, int w, int h) {
                int span;
                WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
                int[] data = new int[w * h * 4];
                float nx = this.tx2 - this.tx1;
                float ny = this.ty2 - this.ty1;
                float len = (float)Math.sqrt(nx * nx + ny * ny);
                if (len != 0.0f) {
                    nx /= len;
                    ny /= len;
                }
                if ((span = (int)PApplet.dist(this.tx1, this.ty1, this.tx2, this.ty2) * this.ACCURACY) <= 0) {
                    int index = 0;
                    for (int j = 0; j < h; ++j) {
                        for (int i = 0; i < w; ++i) {
                            data[index++] = 0;
                            data[index++] = 0;
                            data[index++] = 0;
                            data[index++] = 255;
                        }
                    }
                } else {
                    int[][] interp = new int[span][4];
                    int prev = 0;
                    for (int i = 1; i < LinearGradientPaint.this.count; ++i) {
                        int c0 = LinearGradientPaint.this.color[i - 1];
                        int c1 = LinearGradientPaint.this.color[i];
                        int last = (int)(LinearGradientPaint.this.offset[i] * (float)(span - 1));
                        for (int j = prev; j <= last; ++j) {
                            float btwn = PApplet.norm(j, prev, last);
                            interp[j][0] = (int)PApplet.lerp(c0 >> 16 & 0xFF, c1 >> 16 & 0xFF, btwn);
                            interp[j][1] = (int)PApplet.lerp(c0 >> 8 & 0xFF, c1 >> 8 & 0xFF, btwn);
                            interp[j][2] = (int)PApplet.lerp(c0 & 0xFF, c1 & 0xFF, btwn);
                            interp[j][3] = (int)(PApplet.lerp(c0 >> 24 & 0xFF, c1 >> 24 & 0xFF, btwn) * LinearGradientPaint.this.opacity);
                        }
                        prev = last;
                    }
                    int index = 0;
                    for (int j = 0; j < h; ++j) {
                        for (int i = 0; i < w; ++i) {
                            float px = (float)(x + i) - this.tx1;
                            float py = (float)(y + j) - this.ty1;
                            int which = (int)((px * nx + py * ny) * (float)this.ACCURACY);
                            if (which < 0) {
                                which = 0;
                            }
                            if (which > interp.length - 1) {
                                which = interp.length - 1;
                            }
                            data[index++] = interp[which][0];
                            data[index++] = interp[which][1];
                            data[index++] = interp[which][2];
                            data[index++] = interp[which][3];
                        }
                    }
                }
                raster.setPixels(0, 0, w, h, data);
                return raster;
            }
        }
    }
}

