/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.JSONObject;
import processing.data.Sort;
import processing.data.StringList;

public class StringDict {
    protected int count;
    protected String[] keys;
    protected String[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public StringDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new String[10];
    }

    public StringDict(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new String[length];
    }

    public StringDict(BufferedReader reader) {
        String[] lines = PApplet.loadStrings(reader);
        this.keys = new String[lines.length];
        this.values = new String[lines.length];
        int i = 0;
        while (i < lines.length) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length == 2) {
                this.keys[this.count] = pieces[0];
                this.values[this.count] = pieces[1];
                this.indices.put(this.keys[this.count], this.count);
                ++this.count;
            }
            ++i;
        }
    }

    public StringDict(String[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = keys;
        this.values = values;
        this.count = keys.length;
        int i = 0;
        while (i < this.count) {
            this.indices.put(keys[i], i);
            ++i;
        }
    }

    public StringDict(String[][] pairs) {
        this.count = pairs.length;
        this.keys = new String[this.count];
        this.values = new String[this.count];
        int i = 0;
        while (i < this.count) {
            this.keys[i] = pairs[i][0];
            this.values[i] = pairs[i][1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return StringDict.this.entryIterator();
            }
        };
    }

    public Iterator<Entry> entryIterator() {
        return new Iterator<Entry>(){
            int index = -1;

            @Override
            public void remove() {
                StringDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Entry next() {
                Entry e = new Entry(StringDict.this.keys[this.index], StringDict.this.values[this.index]);
                ++this.index;
                return e;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringDict.this.size();
            }
        };
    }

    public String key(int index) {
        return this.keys[index];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return StringDict.this.keyIterator();
            }
        };
    }

    public Iterator<String> keyIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                StringDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return StringDict.this.key(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringDict.this.size();
            }
        };
    }

    public String[] keyArray() {
        this.crop();
        return this.keyArray(null);
    }

    public String[] keyArray(String[] outgoing) {
        if (outgoing == null || outgoing.length != this.count) {
            outgoing = new String[this.count];
        }
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public String value(int index) {
        return this.values[index];
    }

    public Iterable<String> values() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return StringDict.this.valueIterator();
            }
        };
    }

    public Iterator<String> valueIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                StringDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return StringDict.this.value(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringDict.this.size();
            }
        };
    }

    public String[] valueArray() {
        this.crop();
        return this.valueArray(null);
    }

    public String[] valueArray(String[] array) {
        if (array == null || array.length != this.size()) {
            array = new String[this.count];
        }
        System.arraycopy(this.values, 0, array, 0, this.count);
        return array;
    }

    public String get(String key) {
        int index = this.index(key);
        if (index == -1) {
            return null;
        }
        return this.values[index];
    }

    public String get(String key, String alternate) {
        int index = this.index(key);
        if (index == -1) {
            return alternate;
        }
        return this.values[index];
    }

    public void set(String key, String value) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, value);
        } else {
            this.values[index] = value;
        }
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    public boolean hasKey(String key) {
        return this.index(key) != -1;
    }

    protected void create(String key, String value) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(key, this.count);
        this.keys[this.count] = key;
        this.values[this.count] = value;
        ++this.count;
    }

    public int remove(String key) {
        int index = this.index(key);
        if (index != -1) {
            this.removeIndex(index);
        }
        return index;
    }

    public String removeIndex(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String key = this.keys[index];
        this.indices.remove(key);
        int i = index;
        while (i < this.count - 1) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = null;
        return key;
    }

    public void swap(int a, int b) {
        String tkey = this.keys[a];
        String tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
    }

    public void sortKeys() {
        this.sortImpl(true, false);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true);
    }

    public void sortValues() {
        this.sortImpl(false, false);
    }

    public void sortValuesReverse() {
        this.sortImpl(false, true);
    }

    protected void sortImpl(final boolean useKeys, final boolean reverse) {
        Sort s = new Sort(){

            @Override
            public int size() {
                return StringDict.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int diff = 0;
                if (useKeys) {
                    diff = StringDict.this.keys[a].compareToIgnoreCase(StringDict.this.keys[b]);
                    if (diff == 0) {
                        diff = StringDict.this.values[a].compareToIgnoreCase(StringDict.this.values[b]);
                    }
                } else {
                    diff = StringDict.this.values[a].compareToIgnoreCase(StringDict.this.values[b]);
                    if (diff == 0) {
                        diff = StringDict.this.keys[a].compareToIgnoreCase(StringDict.this.keys[b]);
                    }
                }
                return reverse ? -diff : diff;
            }

            @Override
            public void swap(int a, int b) {
                StringDict.this.swap(a, b);
            }
        };
        s.run();
        this.indices = new HashMap();
        int i = 0;
        while (i < this.count) {
            this.indices.put(this.keys[i], i);
            ++i;
        }
    }

    public StringDict copy() {
        StringDict outgoing = new StringDict(this.count);
        System.arraycopy(this.keys, 0, outgoing.keys, 0, this.count);
        System.arraycopy(this.values, 0, outgoing.values, 0, this.count);
        int i = 0;
        while (i < this.count) {
            outgoing.indices.put(this.keys[i], i);
            ++i;
        }
        outgoing.count = this.count;
        return outgoing;
    }

    public void print() {
        int i = 0;
        while (i < this.size()) {
            System.out.println(String.valueOf(this.keys[i]) + " = " + this.values[i]);
            ++i;
        }
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(String.valueOf(this.keys[i]) + "\t" + this.values[i]);
            ++i;
        }
        writer.flush();
    }

    public String toJSON() {
        StringList items = new StringList();
        int i = 0;
        while (i < this.count) {
            items.append(String.valueOf(JSONObject.quote(this.keys[i])) + ": " + JSONObject.quote(this.values[i]));
            ++i;
        }
        return "{ " + items.join(", ") + " }";
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " " + this.toJSON();
    }

    public class Entry {
        public String key;
        public String value;

        Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

