/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.FloatList;
import processing.data.Sort;

public class IntList
implements Iterable<Integer> {
    protected int count;
    protected int[] data;

    public IntList() {
        this.data = new int[10];
    }

    public IntList(int length) {
        this.data = new int[length];
    }

    public IntList(int[] source) {
        this.count = source.length;
        this.data = new int[this.count];
        System.arraycopy(source, 0, this.data, 0, this.count);
    }

    public IntList(Iterable<Object> iter) {
        this(10);
        for (Object o : iter) {
            if (o == null) {
                this.append(0);
                continue;
            }
            if (o instanceof Number) {
                this.append(((Number)o).intValue());
                continue;
            }
            this.append(PApplet.parseInt(o.toString().trim()));
        }
        this.crop();
    }

    public IntList(Object ... items) {
        this.count = items.length;
        this.data = new int[this.count];
        int index = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int value = 0;
            if (o != null) {
                value = o instanceof Number ? ((Number)o).intValue() : PApplet.parseInt(o.toString().trim(), 0);
            }
            this.data[index++] = value;
            ++n2;
        }
    }

    public static IntList fromRange(int stop) {
        return IntList.fromRange(0, stop);
    }

    public static IntList fromRange(int start, int stop) {
        int count = stop - start;
        IntList newbie = new IntList(count);
        int i = 0;
        while (i < count) {
            newbie.set(i, start + i);
            ++i;
        }
        return newbie;
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            int[] temp = new int[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public int get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void set(int index, int what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            int i = this.count;
            while (i < index) {
                this.data[i] = 0;
                ++i;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public void push(int value) {
        this.append(value);
    }

    public int pop() {
        if (this.count == 0) {
            throw new RuntimeException("Can't call pop() on an empty list");
        }
        int value = this.get(this.count - 1);
        --this.count;
        return value;
    }

    public int remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int entry = this.data[index];
        int i = index;
        while (i < this.count - 1) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        --this.count;
        return entry;
    }

    public int removeValue(int value) {
        int index = this.index(value);
        if (index != -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public int removeValues(int value) {
        int ii = 0;
        int i = 0;
        while (i < this.count) {
            if (this.data[i] != value) {
                this.data[ii++] = this.data[i];
            }
            ++i;
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public void append(int value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(int[] values) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void append(IntList list) {
        int[] nArray = list.values();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void appendUnique(int value) {
        if (!this.hasValue(value)) {
            this.append(value);
        }
    }

    public void insert(int index, int value) {
        this.insert(index, new int[]{value});
    }

    public void insert(int index, int[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        int[] temp = new int[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, IntList list) {
        this.insert(index, list.values());
    }

    public int index(int what) {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == what) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasValue(int value) {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void increment(int index) {
        if (this.count <= index) {
            this.resize(index + 1);
        }
        int n = index;
        this.data[n] = this.data[n] + 1;
    }

    private void boundsProblem(int index, String method) {
        String msg = String.format("The list size is %d. You cannot %s() to element %d.", this.count, method, index);
        throw new ArrayIndexOutOfBoundsException(msg);
    }

    public void add(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] + amount;
        } else {
            this.boundsProblem(index, "add");
        }
    }

    public void sub(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] - amount;
        } else {
            this.boundsProblem(index, "sub");
        }
    }

    public void mult(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] * amount;
        } else {
            this.boundsProblem(index, "mult");
        }
    }

    public void div(int index, int amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] / amount;
        } else {
            this.boundsProblem(index, "div");
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public int min() {
        this.checkMinMax("min");
        int outgoing = this.data[0];
        int i = 1;
        while (i < this.count) {
            if (this.data[i] < outgoing) {
                outgoing = this.data[i];
            }
            ++i;
        }
        return outgoing;
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        int value = this.data[0];
        int index = 0;
        int i = 1;
        while (i < this.count) {
            if (this.data[i] < value) {
                value = this.data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int max() {
        this.checkMinMax("max");
        int outgoing = this.data[0];
        int i = 1;
        while (i < this.count) {
            if (this.data[i] > outgoing) {
                outgoing = this.data[i];
            }
            ++i;
        }
        return outgoing;
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        int value = this.data[0];
        int index = 0;
        int i = 1;
        while (i < this.count) {
            if (this.data[i] > value) {
                value = this.data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int sum() {
        int outgoing = 0;
        int i = 0;
        while (i < this.count) {
            outgoing += this.data[i];
            ++i;
        }
        return outgoing;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                return IntList.this.count;
            }

            @Override
            public float compare(int a, int b) {
                return IntList.this.data[b] - IntList.this.data[a];
            }

            @Override
            public void swap(int a, int b) {
                int temp = IntList.this.data[a];
                IntList.this.data[a] = IntList.this.data[b];
                IntList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        int i = 0;
        while (i < this.count / 2) {
            int t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
            ++i;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            int temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            int temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public IntList copy() {
        IntList outgoing = new IntList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public int[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int index = -1;

            @Override
            public void remove() {
                IntList.this.remove(this.index);
                --this.index;
            }

            @Override
            public Integer next() {
                return IntList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntList.this.count;
            }
        };
    }

    public int[] array() {
        return this.array(null);
    }

    public int[] array(int[] array) {
        if (array == null || array.length != this.count) {
            array = new int[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public FloatList getPercent() {
        double sum = 0.0;
        int[] nArray = this.array();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            float value = nArray[n2];
            sum += (double)value;
            ++n2;
        }
        FloatList outgoing = new FloatList(this.count);
        int i = 0;
        while (i < this.count) {
            double percent = (double)this.data[i] / sum;
            outgoing.set(i, (float)percent);
            ++i;
        }
        return outgoing;
    }

    public IntList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public IntList getSubset(int start, int num) {
        int[] subset = new int[num];
        System.arraycopy(this.data, start, subset, 0, num);
        return new IntList(subset);
    }

    public String join(String separator) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.data[0]);
        int i = 1;
        while (i < this.count) {
            sb.append(separator);
            sb.append(this.data[i]);
            ++i;
        }
        return sb.toString();
    }

    public void print() {
        int i = 0;
        while (i < this.size()) {
            System.out.format("[%d] %d%n", i, this.data[i]);
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " [ ");
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(i) + ": " + this.data[i]);
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }
}

