/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.DefaultGraphicsConfiguration;
import com.jogamp.nativewindow.DefaultGraphicsDevice;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.OffscreenLayerOption;
import com.jogamp.nativewindow.OffscreenLayerSurface;
import com.jogamp.nativewindow.ToolkitLock;
import com.jogamp.nativewindow.UpstreamWindowHookMutableSizePos;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.nativewindow.ios.IOSGraphicsDevice;
import com.jogamp.nativewindow.macosx.MacOSXGraphicsDevice;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.io.File;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.BcmVCArtifacts;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NativeWindowFactoryImpl;
import jogamp.nativewindow.ResourceToolkitLock;
import jogamp.nativewindow.WrappedWindow;
import jogamp.nativewindow.ios.IOSUtil;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public abstract class NativeWindowFactory {
    protected static final boolean DEBUG;
    public static final String TYPE_WAYLAND = ".wayland";
    public static final String TYPE_DRM_GBM = ".egl.gbm";
    public static final String TYPE_EGL = ".egl";
    public static final String TYPE_WINDOWS = ".windows";
    public static final String TYPE_X11 = ".x11";
    public static final String TYPE_BCM_VC_IV = ".bcm.vc.iv";
    public static final String TYPE_ANDROID = ".android";
    public static final String TYPE_MACOSX = ".macosx";
    public static final String TYPE_IOS = ".ios";
    public static final String TYPE_AWT = ".awt";
    public static final String TYPE_DEFAULT = ".default";
    private static final String nativeWindowingTypeNative;
    private static final String nativeWindowingTypeCustom;
    private static NativeWindowFactory defaultFactory;
    private static Map<Class<?>, NativeWindowFactory> registeredFactories;
    private static Class<?> nativeWindowClass;
    private static boolean isAWTAvailable;
    private static final String JAWTUtilClassName = "jogamp.nativewindow.jawt.JAWTUtil";
    private static final String X11UtilClassName = "jogamp.nativewindow.x11.X11Util";
    private static final String DRMUtilClassName = "jogamp.nativewindow.drm.DRMUtil";
    private static final String OSXUtilClassName = "jogamp.nativewindow.macosx.OSXUtil";
    private static final String IOSUtilClassName = "jogamp.nativewindow.ios.IOSUtil";
    private static final String GDIClassName = "jogamp.nativewindow.windows.GDIUtil";
    private static ToolkitLock jawtUtilJAWTToolkitLock;
    private static boolean requiresToolkitLock;
    private static boolean desktopHasThreadingIssues;
    private static volatile boolean isJVMShuttingDown;
    private static final List<Runnable> customShutdownHooks;
    private static boolean initialized;

    protected NativeWindowFactory() {
    }

    private static String _getNativeWindowingType(boolean bl) {
        switch (PlatformPropsImpl.OS_TYPE) {
            case ANDROID: {
                return TYPE_ANDROID;
            }
            case MACOS: {
                return TYPE_MACOSX;
            }
            case IOS: {
                return TYPE_IOS;
            }
            case WINDOWS: {
                return TYPE_WINDOWS;
            }
            case OPENKODE: {
                return TYPE_EGL;
            }
        }
        if (bl) {
            NativeWindowFactory.guessX(true);
            NativeWindowFactory.guessWayland(true);
            NativeWindowFactory.guessGBM(true);
            BcmVCArtifacts.guessVCIVUsed(true);
        }
        if (BcmVCArtifacts.guessVCIVUsed(false)) {
            return TYPE_BCM_VC_IV;
        }
        if (NativeWindowFactory.guessX(false)) {
            return TYPE_X11;
        }
        if (NativeWindowFactory.guessWayland(false)) {
            return TYPE_WAYLAND;
        }
        if (NativeWindowFactory.guessGBM(false)) {
            return TYPE_DRM_GBM;
        }
        return TYPE_X11;
    }

    private static boolean guessX(boolean bl) {
        String string = System.getenv("DISPLAY");
        if (bl) {
            System.err.println("guessX: <" + string + "> isSet " + (null != string));
        }
        return null != string;
    }

    private static boolean guessWayland(boolean bl) {
        String string = System.getenv("WAYLAND_DISPLAY");
        if (bl) {
            System.err.println("guessWayland: <" + string + "> isSet " + (null != string));
        }
        return null != string;
    }

    private static boolean guessGBM(boolean bl) {
        File file = new File("/dev/dri/card0");
        if (bl) {
            System.err.println("guessGBM: <" + file.toString() + "> exists " + file.exists());
        }
        return file.exists();
    }

    private static String getNativeWindowingTypeClassName() {
        String string;
        switch (nativeWindowingTypeNative) {
            case ".x11": {
                string = X11UtilClassName;
                break;
            }
            case ".egl.gbm": {
                string = DRMUtilClassName;
                break;
            }
            case ".windows": {
                string = GDIClassName;
                break;
            }
            case ".macosx": {
                string = OSXUtilClassName;
                break;
            }
            case ".ios": {
                string = IOSUtilClassName;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private static void initSingletonNativeImpl(ClassLoader classLoader) {
        String string = NativeWindowFactory.getNativeWindowingTypeClassName();
        if (null != string) {
            ReflectionUtil.callStaticMethod((String)string, (String)"initSingleton", null, null, (ClassLoader)classLoader);
            Boolean bl = (Boolean)ReflectionUtil.callStaticMethod((String)string, (String)"requiresToolkitLock", null, null, (ClassLoader)classLoader);
            requiresToolkitLock = bl;
            Boolean bl2 = (Boolean)ReflectionUtil.callStaticMethod((String)string, (String)"hasThreadingIssues", null, null, (ClassLoader)classLoader);
            desktopHasThreadingIssues = bl2;
        } else {
            requiresToolkitLock = false;
            desktopHasThreadingIssues = false;
        }
    }

    public static final boolean isJVMShuttingDown() {
        return isJVMShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCustomShutdownHook(boolean bl, Runnable runnable) {
        List<Runnable> list = customShutdownHooks;
        synchronized (list) {
            if (!customShutdownHooks.contains(runnable)) {
                if (bl) {
                    customShutdownHooks.add(0, runnable);
                } else {
                    customShutdownHooks.add(runnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown(boolean bl) {
        isJVMShuttingDown = bl;
        if (DEBUG) {
            System.err.println("NativeWindowFactory.shutdown() START: JVM Shutdown " + isJVMShuttingDown + ", on thread " + Thread.currentThread().getName());
        }
        List<Runnable> list = customShutdownHooks;
        synchronized (list) {
            int n = customShutdownHooks.size();
            for (int i = 0; i < n; ++i) {
                try {
                    if (DEBUG) {
                        System.err.println("NativeWindowFactory.shutdown - customShutdownHook #" + (i + 1) + "/" + n);
                    }
                    customShutdownHooks.get(i).run();
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("NativeWindowFactory.shutdown: Caught " + throwable.getClass().getName() + " during customShutdownHook #" + (i + 1) + "/" + n);
                    if (!DEBUG) continue;
                    throwable.printStackTrace();
                }
            }
            customShutdownHooks.clear();
        }
        if (DEBUG) {
            System.err.println("NativeWindowFactory.shutdown(): Post customShutdownHook");
        }
        if (initialized) {
            initialized = false;
            if (null != registeredFactories) {
                registeredFactories.clear();
                registeredFactories = null;
            }
            GraphicsConfigurationFactory.shutdown();
        }
        NativeWindowFactory.shutdownNativeImpl(NativeWindowFactory.class.getClassLoader());
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.shutdown() END JVM Shutdown " + isJVMShuttingDown);
        }
    }

    private static void shutdownNativeImpl(ClassLoader classLoader) {
        String string = NativeWindowFactory.getNativeWindowingTypeClassName();
        if (null != string) {
            ReflectionUtil.callStaticMethod((String)string, (String)"shutdown", null, null, (ClassLoader)classLoader);
        }
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static synchronized void initSingleton() {
        if (!initialized) {
            Object object;
            initialized = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.initSingleton()");
            }
            ClassLoader classLoader = NativeWindowFactory.class.getClassLoader();
            isAWTAvailable = false;
            if (Platform.AWT_AVAILABLE && ReflectionUtil.isClassAvailable((String)"com.jogamp.nativewindow.awt.AWTGraphicsDevice", (ClassLoader)classLoader) && null != (object = (Method[])SecurityUtil.doPrivileged((PrivilegedAction)new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    try {
                        Class<?> clazz = Class.forName(NativeWindowFactory.JAWTUtilClassName, true, NativeWindowFactory.class.getClassLoader());
                        Method method = clazz.getDeclaredMethod("isHeadlessMode", null);
                        method.setAccessible(true);
                        Method method2 = clazz.getDeclaredMethod("initSingleton", null);
                        method2.setAccessible(true);
                        Method method3 = clazz.getDeclaredMethod("getJAWTToolkitLock", new Class[0]);
                        method3.setAccessible(true);
                        return new Method[]{method2, method, method3};
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            exception.printStackTrace();
                        }
                        return null;
                    }
                }
            }))) {
                Method method = object[0];
                Method method2 = object[1];
                Method method3 = object[2];
                ReflectionUtil.callMethod(null, (Method)method, (Object[])new Object[0]);
                Object object2 = ReflectionUtil.callMethod(null, (Method)method2, (Object[])new Object[0]);
                if (!(object2 instanceof Boolean)) {
                    throw new RuntimeException("JAWTUtil.isHeadlessMode() didn't return a Boolean");
                }
                isAWTAvailable = ((Boolean)object2).equals(Boolean.FALSE);
                object2 = ReflectionUtil.callMethod(null, (Method)method3, (Object[])new Object[0]);
                if (object2 instanceof ToolkitLock) {
                    jawtUtilJAWTToolkitLock = (ToolkitLock)object2;
                } else {
                    throw new RuntimeException("JAWTUtil.getJAWTToolkitLock() didn't return a ToolkitLock");
                }
            }
            NativeWindowFactory.initSingletonNativeImpl(classLoader);
            registeredFactories = Collections.synchronizedMap(new HashMap());
            object = new NativeWindowFactoryImpl();
            nativeWindowClass = NativeWindow.class;
            NativeWindowFactory.registerFactory(nativeWindowClass, (NativeWindowFactory)object);
            defaultFactory = object;
            if (isAWTAvailable) {
                NativeWindowFactory.registerFactory(ReflectionUtil.getClass((String)"java.awt.Component", (boolean)false, (ClassLoader)classLoader), (NativeWindowFactory)object);
            }
            if (DEBUG) {
                System.err.println("NativeWindowFactory requiresToolkitLock " + requiresToolkitLock + ", desktopHasThreadingIssues " + desktopHasThreadingIssues);
                System.err.println("NativeWindowFactory isAWTAvailable " + isAWTAvailable + ", defaultFactory " + object);
            }
            GraphicsConfigurationFactory.initSingleton();
        }
    }

    public static boolean requiresToolkitLock() {
        return requiresToolkitLock;
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getNativeWindowType(boolean bl) {
        return bl ? nativeWindowingTypeCustom : nativeWindowingTypeNative;
    }

    public static void setDefaultFactory(NativeWindowFactory nativeWindowFactory) {
        defaultFactory = nativeWindowFactory;
    }

    public static NativeWindowFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static ToolkitLock getAWTToolkitLock() {
        return jawtUtilJAWTToolkitLock;
    }

    public static ToolkitLock getNullToolkitLock() {
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock getDefaultToolkitLock() {
        return NativeWindowFactory.getDefaultToolkitLock(nativeWindowingTypeNative);
    }

    public static ToolkitLock getDefaultToolkitLock(String string) {
        if (requiresToolkitLock) {
            if (TYPE_AWT == string && NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.getAWTToolkitLock();
            }
            return ResourceToolkitLock.create();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock getDefaultToolkitLock(String string, long l) {
        if (requiresToolkitLock) {
            if (TYPE_AWT == string && NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.getAWTToolkitLock();
            }
            return ResourceToolkitLock.create();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static AbstractGraphicsScreen createScreen(AbstractGraphicsDevice abstractGraphicsDevice, int n) {
        String string = abstractGraphicsDevice.getType();
        if (TYPE_X11 == string) {
            X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)abstractGraphicsDevice;
            if (0 > n) {
                n = x11GraphicsDevice.getDefaultScreen();
            }
            return new X11GraphicsScreen(x11GraphicsDevice, n);
        }
        if (0 > n) {
            n = 0;
        }
        if (TYPE_AWT == string) {
            AWTGraphicsDevice aWTGraphicsDevice = (AWTGraphicsDevice)abstractGraphicsDevice;
            return new AWTGraphicsScreen(aWTGraphicsDevice);
        }
        return new DefaultGraphicsScreen(abstractGraphicsDevice, n);
    }

    public static NativeWindowFactory getFactory(Class<?> clazz) throws IllegalArgumentException {
        if (nativeWindowClass.isAssignableFrom(clazz)) {
            return registeredFactories.get(nativeWindowClass);
        }
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            NativeWindowFactory nativeWindowFactory = registeredFactories.get(clazz2);
            if (nativeWindowFactory == null) continue;
            return nativeWindowFactory;
        }
        throw new IllegalArgumentException("No registered NativeWindowFactory for class " + clazz.getName());
    }

    protected static void registerFactory(Class<?> clazz, NativeWindowFactory nativeWindowFactory) {
        if (DEBUG) {
            System.err.println("NativeWindowFactory.registerFactory() " + clazz + " -> " + nativeWindowFactory);
        }
        registeredFactories.put(clazz, nativeWindowFactory);
    }

    public static NativeWindow getNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException, NativeWindowException {
        if (object == null) {
            throw new IllegalArgumentException("Null window object");
        }
        return NativeWindowFactory.getFactory(object.getClass()).getNativeWindowImpl(object, abstractGraphicsConfiguration);
    }

    protected abstract NativeWindow getNativeWindowImpl(Object var1, AbstractGraphicsConfiguration var2) throws IllegalArgumentException;

    public static OffscreenLayerSurface getOffscreenLayerSurface(NativeSurface nativeSurface, boolean bl) {
        if (nativeSurface instanceof OffscreenLayerSurface && (!bl || nativeSurface instanceof OffscreenLayerOption)) {
            OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeSurface);
            return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
        }
        if (nativeSurface instanceof NativeWindow) {
            for (NativeWindow nativeWindow = ((NativeWindow)nativeSurface).getParent(); null != nativeWindow; nativeWindow = nativeWindow.getParent()) {
                if (!(nativeWindow instanceof OffscreenLayerSurface) || bl && !(nativeWindow instanceof OffscreenLayerOption)) continue;
                OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeWindow);
                return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
            }
        }
        return null;
    }

    public static boolean isNativeVisualIDValidForProcessing(int n) {
        return TYPE_X11 != NativeWindowFactory.getNativeWindowType(false) || 0 != n;
    }

    public static String getDefaultDisplayConnection() {
        return NativeWindowFactory.getDefaultDisplayConnection(NativeWindowFactory.getNativeWindowType(true));
    }

    public static String getDefaultDisplayConnection(String string) {
        if (TYPE_X11 == string) {
            return X11Util.getNullDisplayName();
        }
        return "decon";
    }

    public static AbstractGraphicsDevice createDevice(String string, boolean bl) {
        return NativeWindowFactory.createDevice(NativeWindowFactory.getNativeWindowType(true), string, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractGraphicsDevice createDevice(String string, String string2, boolean bl) {
        if (TYPE_X11 == string) {
            if (!bl) return new X11GraphicsDevice(string2, 0);
            return new X11GraphicsDevice(string2, 0, null);
        }
        if (TYPE_WINDOWS == string) {
            return new WindowsGraphicsDevice(0);
        }
        if (TYPE_MACOSX == string) {
            return new MacOSXGraphicsDevice(0);
        }
        if (TYPE_IOS == string) {
            return new IOSGraphicsDevice(0);
        }
        if (TYPE_EGL == string) {
            if (!bl) return new EGLGraphicsDevice(0L, 0L, string2, 0, null);
            Object object = null;
            try {
                object = ReflectionUtil.callStaticMethod((String)"jogamp.opengl.egl.EGLDisplayUtil", (String)"eglCreateEGLGraphicsDevice", (Class[])new Class[]{Long.class, String.class, Integer.class}, (Object[])new Object[]{0L, DefaultGraphicsDevice.getDefaultDisplayConnection(string), 0}, (ClassLoader)NativeWindowFactory.class.getClassLoader());
            }
            catch (Exception exception) {
                throw new NativeWindowException("EGLDisplayUtil.eglCreateEGLGraphicsDevice failed", exception);
            }
            if (!(object instanceof EGLGraphicsDevice)) throw new NativeWindowException("EGLDisplayUtil.eglCreateEGLGraphicsDevice failed");
            EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)object;
            eGLGraphicsDevice.open();
            return eGLGraphicsDevice;
        }
        if (TYPE_AWT != string) return new DefaultGraphicsDevice(string, string2, 0);
        throw new UnsupportedOperationException("n/a for windowing system: " + string);
    }

    public static NativeWindow createWrappedWindow(AbstractGraphicsScreen abstractGraphicsScreen, long l, long l2, UpstreamWindowHookMutableSizePos upstreamWindowHookMutableSizePos) {
        Capabilities capabilities = new Capabilities();
        DefaultGraphicsConfiguration defaultGraphicsConfiguration = new DefaultGraphicsConfiguration(abstractGraphicsScreen, capabilities, capabilities);
        return new WrappedWindow((AbstractGraphicsConfiguration)defaultGraphicsConfiguration, l, upstreamWindowHookMutableSizePos, true, l2);
    }

    public static Point getLocationOnScreen(NativeWindow nativeWindow) {
        String string = NativeWindowFactory.getNativeWindowType(true);
        if (TYPE_X11 == string) {
            return X11Lib.GetRelativeLocation(nativeWindow.getDisplayHandle(), nativeWindow.getScreenIndex(), nativeWindow.getWindowHandle(), 0L, 0, 0);
        }
        if (TYPE_WINDOWS == string) {
            return GDIUtil.GetRelativeLocation(nativeWindow.getWindowHandle(), 0L, 0, 0);
        }
        if (TYPE_MACOSX == string) {
            return OSXUtil.GetLocationOnScreen(nativeWindow.getWindowHandle(), 0, 0);
        }
        if (TYPE_IOS == string) {
            return IOSUtil.GetLocationOnScreen(nativeWindow.getWindowHandle(), 0, 0);
        }
        throw new UnsupportedOperationException("n/a for windowing system: " + string);
    }

    static {
        isJVMShuttingDown = false;
        customShutdownHooks = new ArrayList<Runnable>();
        final boolean[] blArray = new boolean[]{false};
        final String[] stringArray = new String[]{null};
        final String[] stringArray2 = new String[]{null};
        SecurityUtil.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Platform.initSingleton();
                blArray[0] = Debug.debug("NativeWindow");
                stringArray[0] = PropertyAccess.getProperty((String)"nativewindow.ws.name", (boolean)true);
                stringArray2[0] = NativeWindowFactory._getNativeWindowingType(blArray[0]);
                Runtime.getRuntime().addShutdownHook((Thread)new InterruptSource.Thread(null, new Runnable(){

                    @Override
                    public void run() {
                        NativeWindowFactory.shutdown(true);
                    }
                }, "NativeWindowFactory_ShutdownHook"));
                return null;
            }
        });
        DEBUG = blArray[0];
        nativeWindowingTypeNative = stringArray2[0];
        nativeWindowingTypeCustom = null == stringArray[0] || stringArray[0].length() == 0 ? nativeWindowingTypeNative : stringArray[0].intern();
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: NativeWindowFactory.<init>: Type " + nativeWindowingTypeCustom + " custom / " + nativeWindowingTypeNative + " native");
        }
        initialized = false;
    }
}

