/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo.hadoop.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.anarres.lzo.hadoop.codec.LzoCompressor;
import org.anarres.lzo.hadoop.codec.LzoDecompressor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LzoCodec
extends Configured
implements CompressionCodec {
    private static final Log LOG = LogFactory.getLog((String)LzoCodec.class.getName());
    public static final String LZO_COMPRESSOR_KEY = "io.compression.codec.lzo.compressor";
    public static final String LZO_DECOMPRESSOR_KEY = "io.compression.codec.lzo.decompressor";
    public static final String LZO_COMPRESSION_LEVEL_KEY = "io.compression.codec.lzo.compression.level";
    public static final String LZO_BUFFER_SIZE_KEY = "io.compression.codec.lzo.buffersize";
    public static final int DEFAULT_LZO_BUFFER_SIZE = 262144;
    public static final int MAX_BLOCK_SIZE = 0x4000000;
    public static final int UNDEFINED_COMPRESSION_LEVEL = -999;

    static LzoCompressor.CompressionStrategy getCompressionStrategy(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return LzoCompressor.CompressionStrategy.valueOf(conf.get(LZO_COMPRESSOR_KEY, LzoCompressor.CompressionStrategy.LZO1X_1.name()));
    }

    static LzoDecompressor.CompressionStrategy getDecompressionStrategy(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return LzoDecompressor.CompressionStrategy.valueOf(conf.get(LZO_DECOMPRESSOR_KEY, LzoDecompressor.CompressionStrategy.LZO1X.name()));
    }

    static int getCompressionLevel(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return conf.getInt(LZO_COMPRESSION_LEVEL_KEY, -999);
    }

    static int getBufferSize(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return conf.getInt(LZO_BUFFER_SIZE_KEY, 262144);
    }

    public static void setCompressionStrategy(Configuration conf, LzoCompressor.CompressionStrategy strategy) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.set(LZO_COMPRESSOR_KEY, strategy.name());
    }

    public static void setDecompressionStrategy(Configuration conf, LzoDecompressor.CompressionStrategy strategy) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.set(LZO_DECOMPRESSOR_KEY, strategy.name());
    }

    public static void setCompressionLevel(Configuration conf, int compressionLevel) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.setInt(LZO_COMPRESSION_LEVEL_KEY, compressionLevel);
    }

    public static void setBufferSize(Configuration conf, int bufferSize) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.setInt(LZO_BUFFER_SIZE_KEY, bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        Configuration conf = this.getConf();
        LzoCompressor.CompressionStrategy strategy = LzoCodec.getCompressionStrategy(conf);
        int bufferSize = LzoCodec.getBufferSize(conf);
        int compressionOverhead = strategy.name().contains("LZO1") ? (bufferSize >> 4) + 64 + 3 : (bufferSize >> 3) + 128 + 3;
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    public Class<? extends Compressor> getCompressorType() {
        return LzoCompressor.class;
    }

    public Compressor createCompressor() {
        Configuration conf = this.getConf();
        LzoCompressor.CompressionStrategy strategy = LzoCodec.getCompressionStrategy(conf);
        int bufferSize = LzoCodec.getBufferSize(conf);
        return new LzoCompressor(strategy, bufferSize);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        Configuration conf = this.getConf();
        return new BlockDecompressorStream(in, decompressor, LzoCodec.getBufferSize(conf));
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return LzoDecompressor.class;
    }

    public Decompressor createDecompressor() {
        Configuration conf = this.getConf();
        LzoDecompressor.CompressionStrategy strategy = LzoCodec.getDecompressionStrategy(conf);
        int bufferSize = LzoCodec.getBufferSize(conf);
        return new LzoDecompressor(strategy, bufferSize);
    }

    public String getDefaultExtension() {
        return ".lzo_deflate";
    }
}

