/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoOutputStream;
import org.anarres.lzo.LzopConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.DataOutputBuffer;

public class LzopOutputStream
extends LzoOutputStream {
    private static final Log LOG = LogFactory.getLog(LzopOutputStream.class);
    private final long flags;
    private final CRC32 c_crc32_c;
    private final CRC32 c_crc32_d;
    private final Adler32 c_adler32_c;
    private final Adler32 c_adler32_d;
    private boolean closed = false;

    public LzopOutputStream(OutputStream out, LzoCompressor compressor, int inputBufferSize, long flags) throws IOException {
        super(out, compressor, inputBufferSize);
        this.flags = flags;
        this.c_crc32_c = (flags & 0x200L) == 0L ? null : new CRC32();
        this.c_crc32_d = (flags & 0x100L) == 0L ? null : new CRC32();
        this.c_adler32_c = (flags & 2L) == 0L ? null : new Adler32();
        this.c_adler32_d = (flags & 1L) == 0L ? null : new Adler32();
        this.writeLzopHeader();
    }

    public LzopOutputStream(OutputStream out, LzoCompressor compressor, int inputBufferSize) throws IOException {
        this(out, compressor, inputBufferSize, 0L);
    }

    public LzopOutputStream(OutputStream out, LzoCompressor compressor) throws IOException {
        this(out, compressor, 262144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLzopHeader() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        try {
            dob.writeShort(4112);
            dob.writeShort(8272);
            dob.writeShort(2368);
            switch (this.getAlgorithm()) {
                case LZO1X: {
                    dob.writeByte(1);
                    dob.writeByte(5);
                    break;
                }
                default: {
                    throw new IOException("Incompatible lzop algorithm " + (Object)((Object)this.getAlgorithm()));
                }
            }
            long mask = 3L;
            mask = mask | 0x200L | 0x100L;
            dob.writeInt((int)(this.flags & mask & 0xFFFFFFFFFFFFFFFFL));
            dob.writeInt(33188);
            dob.writeInt((int)(System.currentTimeMillis() / 1000L));
            dob.writeInt(0);
            dob.writeByte(0);
            Adler32 headerChecksum = new Adler32();
            headerChecksum.update(dob.getData(), 0, dob.getLength());
            int hc = (int)headerChecksum.getValue();
            dob.writeInt(hc);
            this.out.write(LzopConstants.LZOP_MAGIC);
            this.out.write(dob.getData(), 0, dob.getLength());
        }
        finally {
            dob.close();
        }
    }

    private void writeChecksum(Checksum csum, byte[] data, int off, int len) throws IOException {
        if (csum == null) {
            return;
        }
        csum.reset();
        csum.update(data, off, len);
        long value = csum.getValue();
        this.writeInt((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void writeBlock(byte[] inputData, int inputPos, int inputLen, byte[] outputData, int outputPos, int outputLen) throws IOException {
        this.writeInt(inputLen);
        if (outputLen < inputLen) {
            this.writeInt(outputLen);
        } else {
            this.writeInt(inputLen);
        }
        this.writeChecksum(this.c_adler32_d, inputData, inputPos, inputLen);
        this.writeChecksum(this.c_crc32_d, inputData, inputPos, inputLen);
        if (outputLen < inputLen) {
            this.writeChecksum(this.c_adler32_c, outputData, outputPos, outputLen);
            this.writeChecksum(this.c_crc32_c, outputData, outputPos, outputLen);
        }
        if (outputLen < inputLen) {
            this.out.write(outputData, outputPos, outputLen);
        } else {
            this.out.write(inputData, inputPos, inputLen);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.out.write(new byte[]{0, 0, 0, 0});
            super.close();
            this.closed = true;
        }
    }
}

