/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoCompressor1x_1;
import org.anarres.lzo.LzoCompressor1y_1;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoDecompressor;
import org.anarres.lzo.LzoDecompressor1x;
import org.anarres.lzo.LzoDecompressor1x_safe;
import org.anarres.lzo.LzoDecompressor1y;
import org.anarres.lzo.LzoDecompressor1y_safe;
import org.anarres.lzo.LzoDecompressor1z;
import org.anarres.lzo.LzoDecompressor1z_safe;

public class LzoLibrary {
    public static LzoLibrary getInstance() {
        return Inner.INSTANCE;
    }

    public LzoCompressor newCompressor(LzoAlgorithm algorithm, LzoConstraint constraint) {
        if (algorithm == null) {
            return new LzoCompressor1x_1();
        }
        switch (algorithm) {
            case LZO1X: {
                return new LzoCompressor1x_1();
            }
            case LZO1Y: {
                return new LzoCompressor1y_1();
            }
        }
        throw new UnsupportedOperationException("Unsupported algorithm " + (Object)((Object)algorithm));
    }

    public LzoDecompressor newDecompressor(LzoAlgorithm algorithm, LzoConstraint constraint) {
        if (algorithm == null) {
            throw new NullPointerException("No algorithm specified.");
        }
        switch (algorithm) {
            case LZO1X: {
                if (constraint == LzoConstraint.SAFETY) {
                    return new LzoDecompressor1x_safe();
                }
                return new LzoDecompressor1x();
            }
            case LZO1Y: {
                if (constraint == LzoConstraint.SAFETY) {
                    return new LzoDecompressor1y_safe();
                }
                return new LzoDecompressor1y();
            }
            case LZO1Z: {
                if (constraint == LzoConstraint.SAFETY) {
                    return new LzoDecompressor1z_safe();
                }
                return new LzoDecompressor1z();
            }
        }
        throw new UnsupportedOperationException("Unsupported algorithm " + (Object)((Object)algorithm));
    }

    private static class Inner {
        private static final LzoLibrary INSTANCE = new LzoLibrary();

        private Inner() {
        }
    }
}

