/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import java.util.Arrays;
import org.anarres.lzo.AbstractLzo1Compressor;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.lzo_uintp;

public class LzoCompressor1x_1
extends AbstractLzo1Compressor {
    private static final int init = 0;
    private static final int next = 1;
    private static final int try_match = 2;
    private static final int literal = 3;
    private static final int m_len_done = 4;
    private final int[] dictionary = new int[16384];

    public LzoCompressor1x_1() {
        super(LzoAlgorithm.LZO1X, new LzoConstraint[0]);
    }

    private static int UA_GET32(byte[] in, int in_ptr) {
        return (in[in_ptr] & 0xFF) << 24 | (in[in_ptr + 1] & 0xFF) << 16 | (in[in_ptr + 2] & 0xFF) << 8 | in[in_ptr + 3] & 0xFF;
    }

    static int compress_core(byte[] in, int in_base, int in_len, byte[] out, int out_base, lzo_uintp out_len, int ti, int[] dict) {
        int in_ptr = in_base;
        int out_ptr = out_base;
        int in_end = in_base + in_len;
        int ip_end = in_base + in_len - 20;
        int ii = in_ptr - ti;
        int state = 0;
        in_ptr += ti < 4 ? 4 - ti : 0;
        int m_pos = Integer.MIN_VALUE;
        int m_len = Integer.MIN_VALUE;
        int m_off = Integer.MIN_VALUE;
        block5: while (true) {
            switch (state) {
                case 0: 
                case 3: {
                    in_ptr += 1 + (in_ptr - ii >> 5);
                }
                case 1: {
                    if (in_ptr >= ip_end) break block5;
                    int dv = LzoCompressor1x_1.UA_GET32(in, in_ptr);
                    int dindex = (int)(((long)(405029533 * dv) >> 18 & 0x3FFFL) << 0);
                    m_pos = in_base + dict[dindex];
                    dict[dindex] = in_ptr - in_base;
                    if (dv != LzoCompressor1x_1.UA_GET32(in, m_pos)) {
                        state = 3;
                        continue block5;
                    }
                    int t = in_ptr - ii;
                    if (t != 0) {
                        if (t <= 3) {
                            int n = out_ptr - 2;
                            out[n] = (byte)(out[n] | (byte)t);
                            do {
                                out[out_ptr++] = in[ii++];
                            } while (--t > 0);
                        } else {
                            if (t <= 18) {
                                out[out_ptr++] = (byte)(t - 3);
                            } else {
                                int tt;
                                out[out_ptr++] = 0;
                                for (tt = t - 18; tt > 255; tt -= 255) {
                                    out[out_ptr++] = 0;
                                }
                                assert (tt > 0) : "Assertion failed: tt > 0";
                                out[out_ptr++] = (byte)tt;
                            }
                            do {
                                out[out_ptr++] = in[ii++];
                            } while (--t > 0);
                        }
                    }
                    if (in[in_ptr + (m_len = 4)] == in[m_pos + m_len]) {
                        do {
                            if (in_ptr + ++m_len < ip_end) continue;
                            state = 4;
                            continue block5;
                        } while (in[in_ptr + m_len] == in[m_pos + m_len]);
                    }
                }
                case 4: {
                    m_off = in_ptr - m_pos;
                    ii = in_ptr += m_len;
                    if (m_len <= 8 && m_off <= 2048) {
                        out[out_ptr++] = (byte)(m_len - 1 << 5 | (--m_off & 7) << 2);
                        out[out_ptr++] = (byte)(m_off >> 3);
                    } else if (m_off <= 16384) {
                        --m_off;
                        if (m_len <= 33) {
                            out[out_ptr++] = (byte)(0x20 | m_len - 2);
                        } else {
                            m_len -= 33;
                            out[out_ptr++] = 32;
                            while (m_len > 255) {
                                m_len -= 255;
                                out[out_ptr++] = 0;
                            }
                            out[out_ptr++] = (byte)m_len;
                        }
                        out[out_ptr++] = (byte)(m_off << 2);
                        out[out_ptr++] = (byte)(m_off >> 6);
                    } else {
                        m_off -= 16384;
                        if (m_len <= 9) {
                            out[out_ptr++] = (byte)(0x10 | m_off >> 11 & 8 | m_len - 2);
                        } else {
                            m_len -= 9;
                            out[out_ptr++] = (byte)(0x10 | m_off >> 11 & 8);
                            while (m_len > 255) {
                                m_len -= 255;
                                out[out_ptr++] = 0;
                            }
                            out[out_ptr++] = (byte)m_len;
                        }
                        out[out_ptr++] = (byte)(m_off << 2);
                        out[out_ptr++] = (byte)(m_off >> 6);
                    }
                    state = 1;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unknown state " + state);
                }
            }
            break;
        }
        out_len.value = out_ptr - out_base;
        return in_end - ii;
    }

    public static int compress(byte[] in, int in_base, int in_len, byte[] out, int out_base, lzo_uintp out_len, Object wrkmem) {
        int ll_end;
        int l;
        int ll;
        int in_ptr = in_base;
        int out_ptr = out_base;
        int t = 0;
        for (l = in_len; l > 20 && (ll_end = in_ptr + (ll = (ll = l) <= 49152 ? ll : 49152)) + (t + ll >> 5) > ll_end; l -= ll) {
            int[] dict = (int[])wrkmem;
            Arrays.fill(dict, 0);
            t = LzoCompressor1x_1.compress_core(in, in_ptr, ll, out, out_ptr, out_len, t, dict);
            in_ptr += ll;
            out_ptr += out_len.value;
        }
        if ((t += l) > 0) {
            int ii = in_base + in_len - t;
            if (out_ptr == out_base && t <= 238) {
                out[out_ptr++] = (byte)(17 + t);
            } else if (t <= 3) {
                int n = out_ptr - 2;
                out[n] = (byte)(out[n] | (byte)t);
            } else if (t <= 18) {
                out[out_ptr++] = (byte)(t - 3);
            } else {
                int tt;
                out[out_ptr++] = 0;
                for (tt = t - 18; tt > 255; tt -= 255) {
                    out[out_ptr++] = 0;
                }
                assert (tt > 0) : "Assertion failed: tt > 0";
                out[out_ptr++] = (byte)tt;
            }
            do {
                out[out_ptr++] = in[ii++];
            } while (--t > 0);
        }
        out[out_ptr++] = 17;
        out[out_ptr++] = 0;
        out[out_ptr++] = 0;
        out_len.value = out_ptr - out_base;
        return 0;
    }

    public int compress(byte[] in, int in_base, int in_len, byte[] out, int out_base, lzo_uintp out_len) {
        return LzoCompressor1x_1.compress(in, in_base, in_len, out, out_base, out_len, this.dictionary);
    }
}

