(ns quantum.ui.revision)

; COMMIT AND UNDO/REDO

#_(defnt commit!*
  ([^quantum.ui.core.FXObservableAtom x states]
    (swap! states coll/updates-in+
      [:last-modified :instant] (fn' (time/now))
      [:last-modified :item   ] (fn' x)
      [x :index ] (whenf1 nil? (fn' 0) (MWA inc))
      [x :states] (fn1 conj (-> x :immutable deref)))))

#_(defn commit! [states x] (commit!* x states))

#_(defnt oswap!*
  ([^javafx.collections.transformation.FilteredList x states f args]
    (println "OSWAP WITH ARGS CLASS" (class args))
    (condp = f
      conj    (fx/run<!! (-> x .getSource (.addAll args)))
      assoc   (fx/run<!!
                (doseq [i v (into {} args)]
                  (.set (.getSource x) i v)))
      update  (let [i        (first args)
                    update-f (second args)]
                (fx/run<!! (.set (.getSource x) i (update-f (.get (.getSource x) i)))))
      (throw+ (Err. :illegal-operation "Not an allowed operation for oswap:" f))))
  ([^quantum.ui.core.FXObservableAtom x states commit? f args]
    (oswap!* (:observable x) states f args)
    (apply swap! (:immutable x) f args)
    (when commit? (commit!* x states))
    x))

#_(defn oswap! [states commit? x f & args]
  (oswap!* x states commit? f args))

#_(defnt oreset!*
  ([^javafx.collections.transformation.FilteredList x-0 states x-f]
    (log/pr :always 3)
    (println "ORESET WITH NEW-X CLASS" (class x-f))
    (fx/run<!!
      (log/pr :always 4)
      (.clear (.getSource x-0))
      (.addAll (.getSource x-0) x-f)))
  ([^quantum.ui.core.FXObservableAtom x states commit? x-f]
    (log/pr :always 5)
    (oreset!* (:observable x) states x-f)
    (reset! (:immutable x) x-f)
    (when commit? (commit!* x states))
    (log/pr :always 6)
    x))

#_(defn oreset! [states commit? x-0 x-f] (oreset!* x-0 states commit? x-f))

#_(defn coordinate-state! [states x]
  (log/pr :always 1)
  (let [i (get-in @states [x :index])]
    (log/pr :always 2)
    (oreset! states false x (get-in @states [x :states i]))))

; TODO doesn't fully work
#_(defn redo!
  "Increments the pointer"
  ([states] (if-let [item (-> @states :last-modified :item)]
              (redo! states item false)
              (do (log/pr :debug "Nothing to redo.")
                  false)))
  ([states x] (redo! states x false))
  ([states x full?]
    (throw-unless (contains? @states x) "Can't redo because doesn't exist")
    (if (-> @states (get x) :index (= (lasti x)))
        (do (log/pr :debug "No more to redo.")
            false)
        (do (swap! states update x
              (fn [x-n] (update x-n :index (if full?
                                               (fn' (lasti x-n))
                                               (whenf1 (fn1 < (lasti x-n)) inc)))))
            (coordinate-state! states x)
            true))))

#_(defn undo!
  "Decrements the pointer"
  ([states] (if-let [item (-> @states :last-modified :item)]
              (undo! states item false)
              (do (log/pr :debug "Nothing to undo.")
                  false)))
  ([states x] (undo! states x false))
  ([states x full?]
    (throw-unless (contains? @states x) "Can't undo because doesn't exist")
    (if (-> @states (get x) :index (= 0))
        (do (log/pr :debug "No more to undo.")
            false)
        (do (swap! states update x
              (fn [x-n] (update x-n :index (if full?
                                               (fn' 0)
                                               (whenf1 (fn1 > 0) dec)))))
            (coordinate-state! states x)
            true))))

#_(defnt add-undo-redo!*
  ([^quantum.ui.core.FXObservableAtom x states]
    (swap! states assoc x {:index 0 :states [(-> x :immutable deref)]})))
#_(defn add-undo-redo! [states x] (add-undo-redo!* x states) true)

#_(defnt unsaved-changes?
  [^clojure.lang.Atom states]
  (val? (fn-> val :index (> 0)) @states))

#_(defnt revert!
  ([^clojure.lang.Atom states]
    (doseq [component meta- @states]
      (undo! states component true)
      (add-undo-redo! states component))))

#_(defn append-data!
  {:todo ["Rename, etc."]}
  [states source dest]
  (oreset! states true dest
    (coll/index-with-ids
      (catvec
        (-> dest :immutable deref)
        (vec source)))))
