(ns quantum.ir.cluster
  (:refer-clojure :exclude [reduce for])
  (:require
    [clojure.core :as core]
    [quantum.core.collections :as coll
      :refer [#?@(:clj [for lfor reduce join kmap])
              map+ vals+ filter+ filter-vals+ flatten-1+ range+ ffilter
              reduce-count]
      #?@(:cljs [:refer-macros [for lfor reduce join kmap]])]
    [quantum.core.numeric :as num]
    [quantum.numeric.core
      :refer [find-max-by]]
    [quantum.numeric.vectors :as v]
    [quantum.core.fn :as fn
      :refer [<- fn-> fn->>]]
    [quantum.core.cache
      :refer [#?(:clj defmemoized)]
      #?@(:cljs [:refer-macros  [defmemoized]])]
    [quantum.core.error
      :refer [->ex]]
    [quantum.core.logic
      :refer [coll-or #?@(:clj [condpc])]
      #?@(:clj [:refer-macros [condpc]])]
    [quantum.numeric.core
      :refer [∏ ∑ sum]]))

(defn cost
  "Measures how expensive it is to merge 2 clusters"
  [type ci cj]
  (condp = type
    :single-linkage   (apply min ; TODO faster algorithm
                         (lfor [xi ci xj cj]
                           (v/dist xi xj)))
    :complete-linkage (apply max ; TODO faster algorithm
                        (lfor [xi ci xj cj]
                          (v/dist xi xj)))
    :average-linkage       (throw (->ex :todo))
    :average-group-linkage (throw (->ex :todo))
    :k-means          nil #_(->> clusters
                           (map+ (fn [ci]
                                   (let [r (v/centroid ci)]
                                     (->> ci (map+ (fn [p] (v/dist* p r))) sum))))
                           (join []))))

(comment
 "           01 02 03 04 05 06 07 08 09 10 11
  :hot       1                               
  :chocolate 1                               
  :cocoa     1  1     1                      
  :beans     1     1                         
  :harvest   0     1                         
  :ghana     0  1  1                         
  :africa    0  1                            
  :butter    0        1  1                   
  :truffles  0           1                   
  :sweet     0              1  1      1  1   
  :chocolate 0              1                
  :sugar     0                 1   1  1      
  :cane      0                     1         
  :brazil    0                     1         
  :beet      0                        1      
  :cake      0                           1 1 
  :icing     0                           1   
  :black     0                             1 
  :forest    0                             1 " )
{1 []}

(defn k-means-clustering [k & xs])

#_(defn k-means-clustering
  [k & xs]
  (let [clusters ?]
    (loop [change false
           i      0
           clusters' clusters]
      (if (and (> i 0) (= change false))
          clusters'
          (let [_ (for [i (range 0 N)]
                    (let [ck (centroid )
                          k' (apply min (get xs))]
                      (if )))]
            (recur ?
                   (inc i)
                   clusters')))))
  #_(let [ck ?]
    (for []
      (dist* Xi (centroid ck)))))

#_(->> clusters
     (map+ (fn [ci]
             (let [r (centroid ci)]
               (->> ci (map+ (fn [p] (dist* p r))) sum))))
     (join []))