(ns quantum.core.untyped.collections
  (:refer-clojure :exclude [assoc-in flatten get])
  (:require [clojure.core :as core]))

(defn assoc-in
  "Like `assoc-in`, but allows multiple k-v pair arguments like `assoc`."
  ([  ks v] (fn [x] (core/assoc-in x ks v)))
  ([x ks v] (core/assoc-in x ks v))
  ([x ks v & ks-vs]
    (reduce (fn [x' [ks' v']] (assoc-in x' ks' v'))
            (assoc-in x ks v)
            (partition-all 2 ks-vs))))

(defn get
  ([  k]      (fn [x] (core/get x k)))
  ([x k]      (core/get x k))
  ([x k else] (core/get x k else)))

(defn flatten
  ([] core/flatten)
  ([xs] (core/flatten xs))
  ([xs n]
    (if (<= n 0)
        xs
        (recur (apply concat xs) (dec n)))))

