(ns quantum.core.classes.reg
  (:require-quantum [:core])
  #?(:clj (:import org.reflections.Reflections
                 org.reflections.scanners.SubTypesScanner)))

#?(:clj
(defonce clojure-classes-unevaled
  (->> (Reflections. "clojure" (into-array [(SubTypesScanner. false)]))
       (.getAllTypes)
       (remove (fn [^String s] (.contains s "__"))) ; to remove auto-genned classes
       (remove (fn [^String s] (.contains s ".proxy$")))
       (map symbol)
       (into (sorted-set)))))

(defonce java-classes-unevaled
  ^{:source ["https://cloud.google.com/appengine/docs/java/jrewhitelist"
             "http://docs.oracle.com/javase/7/docs/api/allclasses-noframe.html"]}
'#{java.awt.datatransfer.DataFlavor
  java.awt.datatransfer.MimeType
  java.awt.datatransfer.Transferable
  java.beans.AppletInitializer
  java.beans.BeanDescriptor
  java.beans.BeanInfo
  java.beans.Beans
  java.beans.ConstructorProperties
  java.beans.Customizer
  java.beans.DefaultPersistenceDelegate
  java.beans.DesignMode
  java.beans.Encoder
  java.beans.EventHandler
  java.beans.EventSetDescriptor
  java.beans.ExceptionListener
  java.beans.Expression
  java.beans.FeatureDescriptor
  java.beans.IndexedPropertyChangeEvent
  java.beans.IndexedPropertyDescriptor
  java.beans.IntrospectionException
  java.beans.Introspector
  java.beans.MethodDescriptor
  java.beans.ParameterDescriptor
  java.beans.PersistenceDelegate
  java.beans.PropertyChangeEvent
  java.beans.PropertyChangeListener
  java.beans.PropertyChangeListenerProxy
  java.beans.PropertyChangeSupport
  java.beans.PropertyDescriptor
  java.beans.PropertyEditor
  java.beans.PropertyEditorManager
  java.beans.PropertyEditorSupport
  java.beans.PropertyVetoException
  java.beans.SimpleBeanInfo
  java.beans.Statement
  java.beans.Transient
  java.beans.VetoableChangeListener
  java.beans.VetoableChangeListenerProxy
  java.beans.VetoableChangeSupport
  java.beans.Visibility
  java.beans.XMLDecoder
  java.beans.XMLEncoder
  java.beans.beancontext.BeanContext
  java.beans.beancontext.BeanContextChild
  java.beans.beancontext.BeanContextChildComponentProxy
  java.beans.beancontext.BeanContextChildSupport
  java.beans.beancontext.BeanContextContainerProxy
  java.beans.beancontext.BeanContextEvent
  java.beans.beancontext.BeanContextMembershipEvent
  java.beans.beancontext.BeanContextMembershipListener
  java.beans.beancontext.BeanContextProxy
  java.beans.beancontext.BeanContextServiceAvailableEvent
  java.beans.beancontext.BeanContextServiceProvider
  java.beans.beancontext.BeanContextServiceProviderBeanInfo
  java.beans.beancontext.BeanContextServiceRevokedEvent
  java.beans.beancontext.BeanContextServiceRevokedListener
  java.beans.beancontext.BeanContextServices
  java.beans.beancontext.BeanContextServicesListener
  java.beans.beancontext.BeanContextServicesSupport
  java.beans.beancontext.BeanContextSupport
  java.io.BufferedInputStream
  java.io.BufferedOutputStream
  java.io.BufferedReader
  java.io.BufferedWriter
  java.io.ByteArrayInputStream
  java.io.ByteArrayOutputStream
  java.io.CharArrayReader
  java.io.CharArrayWriter
  java.io.CharConversionException
  java.io.Closeable
  java.io.Console
  java.io.DataInput
  java.io.DataInputStream
  java.io.DataOutput
  java.io.DataOutputStream
  java.io.EOFException
  java.io.Externalizable
  java.io.File
  java.io.FileDescriptor
  java.io.FileFilter
  java.io.FileInputStream
  java.io.FileNotFoundException
  java.io.FileOutputStream
  java.io.FilePermission
  java.io.FileReader
  java.io.FileSystem
  java.io.FileWriter
  java.io.FilenameFilter
  java.io.FilterInputStream
  java.io.FilterOutputStream
  java.io.FilterReader
  java.io.FilterWriter
  java.io.Flushable
  java.io.IOError
  java.io.IOException
  java.io.InputStream
  java.io.InputStreamReader
  java.io.InterruptedIOException
  java.io.InvalidClassException
  java.io.InvalidObjectException
  java.io.LineNumberInputStream
  java.io.LineNumberReader
  java.io.NotActiveException
  java.io.NotSerializableException
  java.io.ObjectInput
  java.io.ObjectInputStream
  java.io.ObjectInputValidation
  java.io.ObjectOutput
  java.io.ObjectOutputStream
  java.io.ObjectStreamClass
  java.io.ObjectStreamConstants
  java.io.ObjectStreamException
  java.io.ObjectStreamField
  java.io.OptionalDataException
  java.io.OutputStream
  java.io.OutputStreamWriter
  java.io.PipedInputStream
  java.io.PipedOutputStream
  java.io.PipedReader
  java.io.PipedWriter
  java.io.PrintStream
  java.io.PrintWriter
  java.io.PushbackInputStream
  java.io.PushbackReader
  java.io.RandomAccessFile
  java.io.Reader
  java.io.SequenceInputStream
  java.io.Serializable
  java.io.SerializablePermission
  java.io.StreamCorruptedException
  java.io.StreamTokenizer
  java.io.StringBufferInputStream
  java.io.StringReader
  java.io.StringWriter
  java.io.SyncFailedException
  java.io.UTFDataFormatException
  java.io.UncheckedIOException
  java.io.UnsupportedEncodingException
  java.io.WriteAbortedException
  java.io.Writer
  java.lang.AbstractMethodError
  java.lang.AbstractStringBuilder
  java.lang.Appendable
  java.lang.ArithmeticException
  java.lang.ArrayIndexOutOfBoundsException
  java.lang.ArrayStoreException
  java.lang.AssertionError
  java.lang.AutoCloseable
  java.lang.Boolean
  java.lang.BootstrapMethodError
  java.lang.Byte
  java.lang.CharSequence
  java.lang.Character
  java.lang.CharacterData
  java.lang.Class
  java.lang.ClassCastException
  java.lang.ClassCircularityError
  java.lang.ClassFormatError
  java.lang.ClassLoader
  java.lang.ClassNotFoundException
  java.lang.ClassValue
  java.lang.CloneNotSupportedException
  java.lang.Cloneable
  java.lang.Comparable
  java.lang.Compiler
  java.lang.Deprecated
  java.lang.Double
  java.lang.Enum
  java.lang.EnumConstantNotPresentException
  java.lang.Error
  java.lang.Exception
  java.lang.ExceptionInInitializerError
  java.lang.Float
  java.lang.FunctionalInterface
  java.lang.IllegalAccessError
  java.lang.IllegalAccessException
  java.lang.IllegalArgumentException
  java.lang.IllegalMonitorStateException
  java.lang.IllegalStateException
  java.lang.IllegalThreadStateException
  java.lang.IncompatibleClassChangeError
  java.lang.IndexOutOfBoundsException
  java.lang.InheritableThreadLocal
  java.lang.InstantiationError
  java.lang.InstantiationException
  java.lang.Integer
  java.lang.InternalError
  java.lang.InterruptedException
  java.lang.Iterable
  java.lang.LinkageError
  java.lang.Long
  java.lang.Math
  java.lang.NegativeArraySizeException
  java.lang.NoClassDefFoundError
  java.lang.NoSuchFieldError
  java.lang.NoSuchFieldException
  java.lang.NoSuchMethodError
  java.lang.NoSuchMethodException
  java.lang.NullPointerException
  java.lang.Number
  java.lang.NumberFormatException
  java.lang.Object
  java.lang.OutOfMemoryError
  java.lang.Override
  java.lang.Package
  java.lang.Process
  java.lang.ProcessBuilder
  java.lang.Readable
  java.lang.ReflectiveOperationException
  java.lang.Runnable
  java.lang.Runtime
  java.lang.RuntimeException
  java.lang.RuntimePermission
  java.lang.SafeVarargs
  java.lang.SecurityException
  java.lang.SecurityManager
  java.lang.Short
  java.lang.StackOverflowError
  java.lang.StackTraceElement
  java.lang.StrictMath
  java.lang.String
  java.lang.StringBuffer
  java.lang.StringBuilder
  java.lang.StringIndexOutOfBoundsException
  java.lang.SuppressWarnings
  java.lang.System
  java.lang.Thread
  java.lang.ThreadDeath
  java.lang.ThreadGroup
  java.lang.ThreadLocal
  java.lang.Throwable
  java.lang.TypeNotPresentException
  java.lang.UnknownError
  java.lang.UnsatisfiedLinkError
  java.lang.UnsupportedClassVersionError
  java.lang.UnsupportedOperationException
  java.lang.VerifyError
  java.lang.VirtualMachineError
  java.lang.Void
  java.lang.annotation.Annotation
  java.lang.annotation.AnnotationFormatError
  java.lang.annotation.AnnotationTypeMismatchException
  java.lang.annotation.Documented
  java.lang.annotation.ElementType
  java.lang.annotation.IncompleteAnnotationException
  java.lang.annotation.Inherited
  java.lang.annotation.Native
  java.lang.annotation.Repeatable
  java.lang.annotation.Retention
  java.lang.annotation.RetentionPolicy
  java.lang.annotation.Target
  java.lang.invoke.CallSite
  java.lang.invoke.ConstantCallSite
  java.lang.invoke.LambdaConversionException
  java.lang.invoke.LambdaMetafactory
  java.lang.invoke.MethodHandle
  java.lang.invoke.MethodHandleInfo
  java.lang.invoke.MethodHandleProxies
  java.lang.invoke.MethodHandles
  java.lang.invoke.MethodType
  java.lang.invoke.MutableCallSite
  java.lang.invoke.SerializedLambda
  java.lang.invoke.SwitchPoint
  java.lang.invoke.VolatileCallSite
  java.lang.invoke.WrongMethodTypeException
  java.lang.management.BufferPoolMXBean
  java.lang.management.ClassLoadingMXBean
  java.lang.management.CompilationMXBean
  java.lang.management.GarbageCollectorMXBean
  java.lang.management.LockInfo
  java.lang.management.ManagementFactory
  java.lang.management.ManagementPermission
  java.lang.management.MemoryMXBean
  java.lang.management.MemoryManagerMXBean
  java.lang.management.MemoryNotificationInfo
  java.lang.management.MemoryPoolMXBean
  java.lang.management.MemoryType
  java.lang.management.MemoryUsage
  java.lang.management.MonitorInfo
  java.lang.management.OperatingSystemMXBean
  java.lang.management.PlatformLoggingMXBean
  java.lang.management.PlatformManagedObject
  java.lang.management.RuntimeMXBean
  java.lang.management.ThreadInfo
  java.lang.management.ThreadMXBean
  java.lang.ref.PhantomReference
  java.lang.ref.Reference
  java.lang.ref.ReferenceQueue
  java.lang.ref.SoftReference
  java.lang.ref.WeakReference
  java.lang.reflect.AccessibleObject
  java.lang.reflect.AnnotatedArrayType
  java.lang.reflect.AnnotatedElement
  java.lang.reflect.AnnotatedParameterizedType
  java.lang.reflect.AnnotatedType
  java.lang.reflect.AnnotatedTypeVariable
  java.lang.reflect.AnnotatedWildcardType
  java.lang.reflect.Array
  java.lang.reflect.Constructor
  java.lang.reflect.Executable
  java.lang.reflect.Field
  java.lang.reflect.GenericArrayType
  java.lang.reflect.GenericDeclaration
  java.lang.reflect.GenericSignatureFormatError
  java.lang.reflect.InvocationHandler
  java.lang.reflect.InvocationTargetException
  java.lang.reflect.MalformedParameterizedTypeException
  java.lang.reflect.MalformedParametersException
  java.lang.reflect.Member
  java.lang.reflect.Method
  java.lang.reflect.Modifier
  java.lang.reflect.Parameter
  java.lang.reflect.ParameterizedType
  java.lang.reflect.Proxy
  java.lang.reflect.ReflectPermission
  java.lang.reflect.Type
  java.lang.reflect.TypeVariable
  java.lang.reflect.UndeclaredThrowableException
  java.lang.reflect.WildcardType
  java.math.BigDecimal
  java.math.BigInteger
  java.math.MathContext
  java.math.RoundingMode
  java.net.Authenticator
  java.net.BindException
  java.net.CacheRequest
  java.net.CacheResponse
  java.net.ConnectException
  java.net.ContentHandler
  java.net.ContentHandlerFactory
  java.net.CookieHandler
  java.net.CookieManager
  java.net.CookiePolicy
  java.net.CookieStore
  java.net.DatagramPacket
  java.net.DatagramSocket
  java.net.DatagramSocketImpl
  java.net.DatagramSocketImplFactory
  java.net.FileNameMap
  java.net.HttpCookie
  java.net.HttpRetryException
  java.net.HttpURLConnection
  java.net.IDN
  java.net.Inet4Address
  java.net.Inet6Address
  java.net.InetAddress
  java.net.InetSocketAddress
  java.net.InterfaceAddress
  java.net.JarURLConnection
  java.net.MalformedURLException
  java.net.MulticastSocket
  java.net.NetPermission
  java.net.NetworkInterface
  java.net.NoRouteToHostException
  java.net.PasswordAuthentication
  java.net.PortUnreachableException
  java.net.ProtocolException
  java.net.ProtocolFamily
  java.net.Proxy
  java.net.ProxySelector
  java.net.ResponseCache
  java.net.SecureCacheResponse
  java.net.ServerSocket
  java.net.Socket
  java.net.SocketAddress
  java.net.SocketException
  java.net.SocketImpl
  java.net.SocketImplFactory
  java.net.SocketOption
  java.net.SocketOptions
  java.net.SocketPermission
  java.net.SocketTimeoutException
  java.net.StandardProtocolFamily
  java.net.StandardSocketOptions
  java.net.URI
  java.net.URISyntaxException
  java.net.URL
  java.net.URLClassLoader
  java.net.URLConnection
  java.net.URLDecoder
  java.net.URLEncoder
  java.net.URLPermission
  java.net.URLStreamHandler
  java.net.URLStreamHandlerFactory
  java.net.UnknownHostException
  java.net.UnknownServiceException
  java.nio.Buffer
  java.nio.BufferOverflowException
  java.nio.BufferUnderflowException
  java.nio.ByteBuffer
  java.nio.ByteOrder
  java.nio.CharBuffer
  java.nio.DoubleBuffer
  java.nio.FloatBuffer
  java.nio.IntBuffer
  java.nio.InvalidMarkException
  java.nio.LongBuffer
  java.nio.MappedByteBuffer
  java.nio.ReadOnlyBufferException
  java.nio.ShortBuffer
  java.nio.channels.AcceptPendingException
  java.nio.channels.AlreadyBoundException
  java.nio.channels.AlreadyConnectedException
  java.nio.channels.AsynchronousByteChannel
  java.nio.channels.AsynchronousChannel
  java.nio.channels.AsynchronousChannelGroup
  java.nio.channels.AsynchronousCloseException
  java.nio.channels.AsynchronousFileChannel
  java.nio.channels.AsynchronousServerSocketChannel
  java.nio.channels.AsynchronousSocketChannel
  java.nio.channels.ByteChannel
  java.nio.channels.CancelledKeyException
  java.nio.channels.Channel
  java.nio.channels.Channels
  java.nio.channels.ClosedByInterruptException
  java.nio.channels.ClosedChannelException
  java.nio.channels.ClosedSelectorException
  java.nio.channels.CompletionHandler
  java.nio.channels.ConnectionPendingException
  java.nio.channels.DatagramChannel
  java.nio.channels.FileChannel
  java.nio.channels.FileLock
  java.nio.channels.FileLockInterruptionException
  java.nio.channels.GatheringByteChannel
  java.nio.channels.IllegalBlockingModeException
  java.nio.channels.IllegalChannelGroupException
  java.nio.channels.IllegalSelectorException
  java.nio.channels.InterruptedByTimeoutException
  java.nio.channels.InterruptibleChannel
  java.nio.channels.MembershipKey
  java.nio.channels.MulticastChannel
  java.nio.channels.NetworkChannel
  java.nio.channels.NoConnectionPendingException
  java.nio.channels.NonReadableChannelException
  java.nio.channels.NonWritableChannelException
  java.nio.channels.NotYetBoundException
  java.nio.channels.NotYetConnectedException
  java.nio.channels.OverlappingFileLockException
  java.nio.channels.Pipe
  java.nio.channels.ReadPendingException
  java.nio.channels.ReadableByteChannel
  java.nio.channels.ScatteringByteChannel
  java.nio.channels.SeekableByteChannel
  java.nio.channels.SelectableChannel
  java.nio.channels.SelectionKey
  java.nio.channels.Selector
  java.nio.channels.ServerSocketChannel
  java.nio.channels.ShutdownChannelGroupException
  java.nio.channels.SocketChannel
  java.nio.channels.UnresolvedAddressException
  java.nio.channels.UnsupportedAddressTypeException
  java.nio.channels.WritableByteChannel
  java.nio.channels.WritePendingException
  java.nio.channels.spi.AbstractInterruptibleChannel
  java.nio.channels.spi.AbstractSelectableChannel
  java.nio.channels.spi.AbstractSelectionKey
  java.nio.channels.spi.AbstractSelector
  java.nio.channels.spi.AsynchronousChannelProvider
  java.nio.channels.spi.SelectorProvider
  java.nio.charset.CharacterCodingException
  java.nio.charset.Charset
  java.nio.charset.CharsetDecoder
  java.nio.charset.CharsetEncoder
  java.nio.charset.CoderMalfunctionError
  java.nio.charset.CoderResult
  java.nio.charset.CodingErrorAction
  java.nio.charset.IllegalCharsetNameException
  java.nio.charset.MalformedInputException
  java.nio.charset.StandardCharsets
  java.nio.charset.UnmappableCharacterException
  java.nio.charset.UnsupportedCharsetException
  java.nio.charset.spi.CharsetProvider
  java.nio.file.AccessDeniedException
  java.nio.file.AccessMode
  java.nio.file.AtomicMoveNotSupportedException
  java.nio.file.ClosedDirectoryStreamException
  java.nio.file.ClosedFileSystemException
  java.nio.file.ClosedWatchServiceException
  java.nio.file.CopyOption
  java.nio.file.DirectoryIteratorException
  java.nio.file.DirectoryNotEmptyException
  java.nio.file.DirectoryStream
  java.nio.file.FileAlreadyExistsException
  java.nio.file.FileStore
  java.nio.file.FileSystem
  java.nio.file.FileSystemAlreadyExistsException
  java.nio.file.FileSystemException
  java.nio.file.FileSystemLoopException
  java.nio.file.FileSystemNotFoundException
  java.nio.file.FileSystems
  java.nio.file.FileVisitOption
  java.nio.file.FileVisitResult
  java.nio.file.FileVisitor
  java.nio.file.Files
  java.nio.file.InvalidPathException
  java.nio.file.LinkOption
  java.nio.file.LinkPermission
  java.nio.file.NoSuchFileException
  java.nio.file.NotDirectoryException
  java.nio.file.NotLinkException
  java.nio.file.OpenOption
  java.nio.file.Path
  java.nio.file.PathMatcher
  java.nio.file.Paths
  java.nio.file.ProviderMismatchException
  java.nio.file.ProviderNotFoundException
  java.nio.file.ReadOnlyFileSystemException
  java.nio.file.SecureDirectoryStream
  java.nio.file.SimpleFileVisitor
  java.nio.file.StandardCopyOption
  java.nio.file.StandardOpenOption
  java.nio.file.StandardWatchEventKinds
  java.nio.file.WatchEvent
  java.nio.file.WatchKey
  java.nio.file.WatchService
  java.nio.file.Watchable
  java.nio.file.attribute.AclEntry
  java.nio.file.attribute.AclEntryFlag
  java.nio.file.attribute.AclEntryPermission
  java.nio.file.attribute.AclEntryType
  java.nio.file.attribute.AclFileAttributeView
  java.nio.file.attribute.AttributeView
  java.nio.file.attribute.BasicFileAttributeView
  java.nio.file.attribute.BasicFileAttributes
  java.nio.file.attribute.DosFileAttributeView
  java.nio.file.attribute.DosFileAttributes
  java.nio.file.attribute.FileAttribute
  java.nio.file.attribute.FileAttributeView
  java.nio.file.attribute.FileOwnerAttributeView
  java.nio.file.attribute.FileStoreAttributeView
  java.nio.file.attribute.FileTime
  java.nio.file.attribute.GroupPrincipal
  java.nio.file.attribute.PosixFileAttributeView
  java.nio.file.attribute.PosixFileAttributes
  java.nio.file.attribute.PosixFilePermission
  java.nio.file.attribute.PosixFilePermissions
  java.nio.file.attribute.UserDefinedFileAttributeView
  java.nio.file.attribute.UserPrincipal
  java.nio.file.attribute.UserPrincipalLookupService
  java.nio.file.attribute.UserPrincipalNotFoundException
  java.rmi.RemoteException
  java.security.AccessControlContext
  java.security.AccessControlException
  java.security.AccessController
  java.security.AlgorithmConstraints
  java.security.AlgorithmParameterGenerator
  java.security.AlgorithmParameterGeneratorSpi
  java.security.AlgorithmParameters
  java.security.AlgorithmParametersSpi
  java.security.AllPermission
  java.security.AuthProvider
  java.security.BasicPermission
  java.security.Certificate
  java.security.CodeSigner
  java.security.CodeSource
  java.security.CryptoPrimitive
  java.security.DigestException
  java.security.DigestInputStream
  java.security.DigestOutputStream
  java.security.DomainCombiner
  java.security.DomainLoadStoreParameter
  java.security.GeneralSecurityException
  java.security.Guard
  java.security.GuardedObject
  java.security.Identity
  java.security.IdentityScope
  java.security.InvalidAlgorithmParameterException
  java.security.InvalidKeyException
  java.security.InvalidParameterException
  java.security.Key
  java.security.KeyException
  java.security.KeyFactory
  java.security.KeyFactorySpi
  java.security.KeyManagementException
  java.security.KeyPair
  java.security.KeyPairGenerator
  java.security.KeyPairGeneratorSpi
  java.security.KeyRep
  java.security.KeyStore
  java.security.KeyStoreException
  java.security.KeyStoreSpi
  java.security.MessageDigest
  java.security.MessageDigestSpi
  java.security.NoSuchAlgorithmException
  java.security.NoSuchProviderException
  java.security.PKCS12Attribute
  java.security.Permission
  java.security.PermissionCollection
  java.security.Permissions
  java.security.Policy
  java.security.PolicySpi
  java.security.Principal
  java.security.PrivateKey
  java.security.PrivilegedAction
  java.security.PrivilegedActionException
  java.security.PrivilegedExceptionAction
  java.security.ProtectionDomain
  java.security.Provider
  java.security.ProviderException
  java.security.PublicKey
  java.security.SecureClassLoader
  java.security.SecureRandom
  java.security.SecureRandomSpi
  java.security.Security
  java.security.SecurityPermission
  java.security.Signature
  java.security.SignatureException
  java.security.SignatureSpi
  java.security.SignedObject
  java.security.Signer
  java.security.Timestamp
  java.security.URIParameter
  java.security.UnrecoverableEntryException
  java.security.UnrecoverableKeyException
  java.security.UnresolvedPermission
  java.security.acl.Acl
  java.security.acl.AclEntry
  java.security.acl.AclNotFoundException
  java.security.acl.Group
  java.security.acl.LastOwnerException
  java.security.acl.NotOwnerException
  java.security.acl.Owner
  java.security.acl.Permission
  java.security.cert.CRL
  java.security.cert.CRLException
  java.security.cert.CRLReason
  java.security.cert.CRLSelector
  java.security.cert.CertPath
  java.security.cert.CertPathBuilder
  java.security.cert.CertPathBuilderException
  java.security.cert.CertPathBuilderResult
  java.security.cert.CertPathBuilderSpi
  java.security.cert.CertPathChecker
  java.security.cert.CertPathParameters
  java.security.cert.CertPathValidator
  java.security.cert.CertPathValidatorException
  java.security.cert.CertPathValidatorResult
  java.security.cert.CertPathValidatorSpi
  java.security.cert.CertSelector
  java.security.cert.CertStore
  java.security.cert.CertStoreException
  java.security.cert.CertStoreParameters
  java.security.cert.CertStoreSpi
  java.security.cert.Certificate
  java.security.cert.CertificateEncodingException
  java.security.cert.CertificateException
  java.security.cert.CertificateExpiredException
  java.security.cert.CertificateFactory
  java.security.cert.CertificateFactorySpi
  java.security.cert.CertificateNotYetValidException
  java.security.cert.CertificateParsingException
  java.security.cert.CertificateRevokedException
  java.security.cert.CollectionCertStoreParameters
  java.security.cert.Extension
  java.security.cert.LDAPCertStoreParameters
  java.security.cert.PKIXBuilderParameters
  java.security.cert.PKIXCertPathBuilderResult
  java.security.cert.PKIXCertPathChecker
  java.security.cert.PKIXCertPathValidatorResult
  java.security.cert.PKIXParameters
  java.security.cert.PKIXReason
  java.security.cert.PKIXRevocationChecker
  java.security.cert.PolicyNode
  java.security.cert.PolicyQualifierInfo
  java.security.cert.TrustAnchor
  java.security.cert.X509CRL
  java.security.cert.X509CRLEntry
  java.security.cert.X509CRLSelector
  java.security.cert.X509CertSelector
  java.security.cert.X509Certificate
  java.security.cert.X509Extension
  java.security.interfaces.DSAKey
  java.security.interfaces.DSAKeyPairGenerator
  java.security.interfaces.DSAParams
  java.security.interfaces.DSAPrivateKey
  java.security.interfaces.DSAPublicKey
  java.security.interfaces.ECKey
  java.security.interfaces.ECPrivateKey
  java.security.interfaces.ECPublicKey
  java.security.interfaces.RSAKey
  java.security.interfaces.RSAMultiPrimePrivateCrtKey
  java.security.interfaces.RSAPrivateCrtKey
  java.security.interfaces.RSAPrivateKey
  java.security.interfaces.RSAPublicKey
  java.security.spec.AlgorithmParameterSpec
  java.security.spec.DSAGenParameterSpec
  java.security.spec.DSAParameterSpec
  java.security.spec.DSAPrivateKeySpec
  java.security.spec.DSAPublicKeySpec
  java.security.spec.ECField
  java.security.spec.ECFieldF2m
  java.security.spec.ECFieldFp
  java.security.spec.ECGenParameterSpec
  java.security.spec.ECParameterSpec
  java.security.spec.ECPoint
  java.security.spec.ECPrivateKeySpec
  java.security.spec.ECPublicKeySpec
  java.security.spec.EllipticCurve
  java.security.spec.EncodedKeySpec
  java.security.spec.InvalidKeySpecException
  java.security.spec.InvalidParameterSpecException
  java.security.spec.KeySpec
  java.security.spec.MGF1ParameterSpec
  java.security.spec.PKCS8EncodedKeySpec
  java.security.spec.PSSParameterSpec
  java.security.spec.RSAKeyGenParameterSpec
  java.security.spec.RSAMultiPrimePrivateCrtKeySpec
  java.security.spec.RSAOtherPrimeInfo
  java.security.spec.RSAPrivateCrtKeySpec
  java.security.spec.RSAPrivateKeySpec
  java.security.spec.RSAPublicKeySpec
  java.security.spec.X509EncodedKeySpec
  java.sql.Array
  java.sql.BatchUpdateException
  java.sql.Blob
  java.sql.CallableStatement
  java.sql.ClientInfoStatus
  java.sql.Clob
  java.sql.Connection
  java.sql.DataTruncation
  java.sql.DatabaseMetaData
  java.sql.Date
  java.sql.Driver
  java.sql.DriverAction
  java.sql.DriverManager
  java.sql.DriverPropertyInfo
  java.sql.JDBCType
  java.sql.NClob
  java.sql.ParameterMetaData
  java.sql.PreparedStatement
  java.sql.PseudoColumnUsage
  java.sql.Ref
  java.sql.ResultSet
  java.sql.ResultSetMetaData
  java.sql.RowId
  java.sql.RowIdLifetime
  java.sql.SQLClientInfoException
  java.sql.SQLData
  java.sql.SQLDataException
  java.sql.SQLException
  java.sql.SQLFeatureNotSupportedException
  java.sql.SQLInput
  java.sql.SQLIntegrityConstraintViolationException
  java.sql.SQLInvalidAuthorizationSpecException
  java.sql.SQLNonTransientConnectionException
  java.sql.SQLNonTransientException
  java.sql.SQLOutput
  java.sql.SQLPermission
  java.sql.SQLRecoverableException
  java.sql.SQLSyntaxErrorException
  java.sql.SQLTimeoutException
  java.sql.SQLTransactionRollbackException
  java.sql.SQLTransientConnectionException
  java.sql.SQLTransientException
  java.sql.SQLType
  java.sql.SQLWarning
  java.sql.SQLXML
  java.sql.Savepoint
  java.sql.Statement
  java.sql.Struct
  java.sql.Time
  java.sql.Timestamp
  java.sql.Types
  java.sql.Wrapper
  java.text.Annotation
  java.text.AttributedCharacterIterator
  java.text.AttributedString
  java.text.Bidi
  java.text.BreakIterator
  java.text.CharacterIterator
  java.text.ChoiceFormat
  java.text.CollationElementIterator
  java.text.CollationKey
  java.text.Collator
  java.text.DateFormat
  java.text.DateFormatSymbols
  java.text.DecimalFormat
  java.text.DecimalFormatSymbols
  java.text.FieldPosition
  java.text.Format
  java.text.MessageFormat
  java.text.Normalizer
  java.text.NumberFormat
  java.text.ParseException
  java.text.ParsePosition
  java.text.RuleBasedCollator
  java.text.SimpleDateFormat
  java.text.StringCharacterIterator
  java.text.spi.BreakIteratorProvider
  java.text.spi.CollatorProvider
  java.text.spi.DateFormatProvider
  java.text.spi.DateFormatSymbolsProvider
  java.text.spi.DecimalFormatSymbolsProvider
  java.text.spi.NumberFormatProvider
  java.time.Clock
  java.time.DateTimeException
  java.time.DayOfWeek
  java.time.Duration
  java.time.Instant
  java.time.LocalDate
  java.time.LocalDateTime
  java.time.LocalTime
  java.time.Month
  java.time.MonthDay
  java.time.OffsetDateTime
  java.time.OffsetTime
  java.time.Period
  java.time.Year
  java.time.YearMonth
  java.time.ZoneId
  java.time.ZoneOffset
  java.time.ZonedDateTime
  java.time.chrono.AbstractChronology
  java.time.chrono.ChronoLocalDate
  java.time.chrono.ChronoLocalDateTime
  java.time.chrono.ChronoPeriod
  java.time.chrono.ChronoZonedDateTime
  java.time.chrono.Chronology
  java.time.chrono.Era
  java.time.chrono.HijrahChronology
  java.time.chrono.HijrahDate
  java.time.chrono.HijrahEra
  java.time.chrono.IsoChronology
  java.time.chrono.IsoEra
  java.time.chrono.JapaneseChronology
  java.time.chrono.JapaneseDate
  java.time.chrono.JapaneseEra
  java.time.chrono.MinguoChronology
  java.time.chrono.MinguoDate
  java.time.chrono.MinguoEra
  java.time.chrono.ThaiBuddhistChronology
  java.time.chrono.ThaiBuddhistDate
  java.time.chrono.ThaiBuddhistEra
  java.time.format.DateTimeFormatter
  java.time.format.DateTimeFormatterBuilder
  java.time.format.DateTimeParseException
  java.time.format.DecimalStyle
  java.time.format.FormatStyle
  java.time.format.ResolverStyle
  java.time.format.SignStyle
  java.time.format.TextStyle
  java.time.temporal.ChronoField
  java.time.temporal.ChronoUnit
  java.time.temporal.IsoFields
  java.time.temporal.JulianFields
  java.time.temporal.Temporal
  java.time.temporal.TemporalAccessor
  java.time.temporal.TemporalAdjuster
  java.time.temporal.TemporalAdjusters
  java.time.temporal.TemporalAmount
  java.time.temporal.TemporalField
  java.time.temporal.TemporalQueries
  java.time.temporal.TemporalQuery
  java.time.temporal.TemporalUnit
  java.time.temporal.UnsupportedTemporalTypeException
  java.time.temporal.ValueRange
  java.time.temporal.WeekFields
  java.util.AbstractCollection
  java.util.AbstractList
  java.util.AbstractMap
  java.util.AbstractQueue
  java.util.AbstractSequentialList
  java.util.AbstractSet
  java.util.ArrayDeque
  java.util.ArrayList
  java.util.Arrays
  java.util.Base64
  java.util.BitSet
  java.util.Calendar
  java.util.Collection
  java.util.Collections
  java.util.Comparator
  java.util.ConcurrentModificationException
  java.util.Currency
  java.util.Date
  java.util.Deque
  java.util.Dictionary
  java.util.DoubleSummaryStatistics
  java.util.DuplicateFormatFlagsException
  java.util.EmptyStackException
  java.util.EnumMap
  java.util.EnumSet
  java.util.Enumeration
  java.util.EventListener
  java.util.EventListenerProxy
  java.util.EventObject
  java.util.FormatFlagsConversionMismatchException
  java.util.Formattable
  java.util.FormattableFlags
  java.util.Formatter
  java.util.FormatterClosedException
  java.util.GregorianCalendar
  java.util.HashMap
  java.util.HashSet
  java.util.Hashtable
  java.util.IdentityHashMap
  java.util.IllegalFormatCodePointException
  java.util.IllegalFormatConversionException
  java.util.IllegalFormatException
  java.util.IllegalFormatFlagsException
  java.util.IllegalFormatPrecisionException
  java.util.IllegalFormatWidthException
  java.util.IllformedLocaleException
  java.util.InputMismatchException
  java.util.IntSummaryStatistics
  java.util.InvalidPropertiesFormatException
  java.util.Iterator
  java.util.LinkedHashMap
  java.util.LinkedHashSet
  java.util.LinkedList
  java.util.List
  java.util.ListIterator
  java.util.ListResourceBundle
  java.util.Locale
  java.util.LongSummaryStatistics
  java.util.Map
  java.util.MissingFormatArgumentException
  java.util.MissingFormatWidthException
  java.util.MissingResourceException
  java.util.NavigableMap
  java.util.NavigableSet
  java.util.NoSuchElementException
  java.util.Objects
  java.util.Observable
  java.util.Observer
  java.util.Optional
  java.util.OptionalDouble
  java.util.OptionalInt
  java.util.OptionalLong
  java.util.PrimitiveIterator
  java.util.PriorityQueue
  java.util.Properties
  java.util.PropertyPermission
  java.util.PropertyResourceBundle
  java.util.Queue
  java.util.Random
  java.util.RandomAccess
  java.util.ResourceBundle
  java.util.Scanner
  java.util.ServiceConfigurationError
  java.util.ServiceLoader
  java.util.Set
  java.util.SimpleTimeZone
  java.util.SortedMap
  java.util.SortedSet
  java.util.Spliterator
  java.util.Spliterators
  java.util.SplittableRandom
  java.util.Stack
  java.util.StringJoiner
  java.util.StringTokenizer
  java.util.TimeZone
  java.util.Timer
  java.util.TimerTask
  java.util.TooManyListenersException
  java.util.TreeMap
  java.util.TreeSet
  java.util.UUID
  java.util.UnknownFormatConversionException
  java.util.UnknownFormatFlagsException
  java.util.Vector
  java.util.WeakHashMap
  java.util.concurrent.AbstractExecutorService
  java.util.concurrent.ArrayBlockingQueue
  java.util.concurrent.BlockingDeque
  java.util.concurrent.BlockingQueue
  java.util.concurrent.BrokenBarrierException
  java.util.concurrent.Callable
  java.util.concurrent.CancellationException
  java.util.concurrent.CompletableFuture
  java.util.concurrent.CompletionException
  java.util.concurrent.CompletionService
  java.util.concurrent.CompletionStage
  java.util.concurrent.ConcurrentHashMap
  java.util.concurrent.ConcurrentLinkedDeque
  java.util.concurrent.ConcurrentLinkedQueue
  java.util.concurrent.ConcurrentMap
  java.util.concurrent.ConcurrentNavigableMap
  java.util.concurrent.ConcurrentSkipListMap
  java.util.concurrent.ConcurrentSkipListSet
  java.util.concurrent.CopyOnWriteArrayList
  java.util.concurrent.CopyOnWriteArraySet
  java.util.concurrent.CountDownLatch
  java.util.concurrent.CountedCompleter
  java.util.concurrent.CyclicBarrier
  java.util.concurrent.DelayQueue
  java.util.concurrent.Delayed
  java.util.concurrent.Exchanger
  java.util.concurrent.ExecutionException
  java.util.concurrent.Executor
  java.util.concurrent.ExecutorCompletionService
  java.util.concurrent.ExecutorService
  java.util.concurrent.Executors
  java.util.concurrent.ForkJoinPool
  java.util.concurrent.ForkJoinTask
  java.util.concurrent.ForkJoinWorkerThread
  java.util.concurrent.Future
  java.util.concurrent.FutureTask
  java.util.concurrent.LinkedBlockingDeque
  java.util.concurrent.LinkedBlockingQueue
  java.util.concurrent.LinkedTransferQueue
  java.util.concurrent.Phaser
  java.util.concurrent.PriorityBlockingQueue
  java.util.concurrent.RecursiveAction
  java.util.concurrent.RecursiveTask
  java.util.concurrent.RejectedExecutionException
  java.util.concurrent.RejectedExecutionHandler
  java.util.concurrent.RunnableFuture
  java.util.concurrent.RunnableScheduledFuture
  java.util.concurrent.ScheduledExecutorService
  java.util.concurrent.ScheduledFuture
  java.util.concurrent.ScheduledThreadPoolExecutor
  java.util.concurrent.Semaphore
  java.util.concurrent.SynchronousQueue
  java.util.concurrent.ThreadFactory
  java.util.concurrent.ThreadLocalRandom
  java.util.concurrent.ThreadPoolExecutor
  java.util.concurrent.TimeUnit
  java.util.concurrent.TimeoutException
  java.util.concurrent.TransferQueue
  java.util.concurrent.atomic.AtomicBoolean
  java.util.concurrent.atomic.AtomicInteger
  java.util.concurrent.atomic.AtomicIntegerArray
  java.util.concurrent.atomic.AtomicIntegerFieldUpdater
  java.util.concurrent.atomic.AtomicLong
  java.util.concurrent.atomic.AtomicLongArray
  java.util.concurrent.atomic.AtomicLongFieldUpdater
  java.util.concurrent.atomic.AtomicMarkableReference
  java.util.concurrent.atomic.AtomicReference
  java.util.concurrent.atomic.AtomicReferenceArray
  java.util.concurrent.atomic.AtomicReferenceFieldUpdater
  java.util.concurrent.atomic.AtomicStampedReference
  java.util.concurrent.atomic.DoubleAccumulator
  java.util.concurrent.atomic.DoubleAdder
  java.util.concurrent.atomic.LongAccumulator
  java.util.concurrent.atomic.LongAdder
  java.util.concurrent.locks.AbstractOwnableSynchronizer
  java.util.concurrent.locks.AbstractQueuedLongSynchronizer
  java.util.concurrent.locks.AbstractQueuedSynchronizer
  java.util.concurrent.locks.Condition
  java.util.concurrent.locks.Lock
  java.util.concurrent.locks.LockSupport
  java.util.concurrent.locks.ReadWriteLock
  java.util.concurrent.locks.ReentrantLock
  java.util.concurrent.locks.ReentrantReadWriteLock
  java.util.concurrent.locks.StampedLock
  java.util.function.BiConsumer
  java.util.function.BiFunction
  java.util.function.BiPredicate
  java.util.function.BinaryOperator
  java.util.function.BooleanSupplier
  java.util.function.Consumer
  java.util.function.DoubleBinaryOperator
  java.util.function.DoubleConsumer
  java.util.function.DoubleFunction
  java.util.function.DoublePredicate
  java.util.function.DoubleSupplier
  java.util.function.DoubleToIntFunction
  java.util.function.DoubleToLongFunction
  java.util.function.DoubleUnaryOperator
  java.util.function.Function
  java.util.function.IntBinaryOperator
  java.util.function.IntConsumer
  java.util.function.IntFunction
  java.util.function.IntPredicate
  java.util.function.IntSupplier
  java.util.function.IntToDoubleFunction
  java.util.function.IntToLongFunction
  java.util.function.IntUnaryOperator
  java.util.function.LongBinaryOperator
  java.util.function.LongConsumer
  java.util.function.LongFunction
  java.util.function.LongPredicate
  java.util.function.LongSupplier
  java.util.function.LongToDoubleFunction
  java.util.function.LongToIntFunction
  java.util.function.LongUnaryOperator
  java.util.function.ObjDoubleConsumer
  java.util.function.ObjIntConsumer
  java.util.function.ObjLongConsumer
  java.util.function.Predicate
  java.util.function.Supplier
  java.util.function.ToDoubleBiFunction
  java.util.function.ToDoubleFunction
  java.util.function.ToIntBiFunction
  java.util.function.ToIntFunction
  java.util.function.ToLongBiFunction
  java.util.function.ToLongFunction
  java.util.function.UnaryOperator
  java.util.jar.Attributes
  java.util.jar.JarEntry
  java.util.jar.JarException
  java.util.jar.JarFile
  java.util.jar.JarInputStream
  java.util.jar.JarOutputStream
  java.util.jar.Manifest
  java.util.jar.Pack200
  java.util.logging.ConsoleHandler
  java.util.logging.ErrorManager
  java.util.logging.FileHandler
  java.util.logging.Filter
  java.util.logging.Formatter
  java.util.logging.Handler
  java.util.logging.Level
  java.util.logging.LogManager
  java.util.logging.LogRecord
  java.util.logging.Logger
  java.util.logging.LoggingMXBean
  java.util.logging.LoggingPermission
  java.util.logging.MemoryHandler
  java.util.logging.SimpleFormatter
  java.util.logging.SocketHandler
  java.util.logging.StreamHandler
  java.util.logging.XMLFormatter
  java.util.regex.MatchResult
  java.util.regex.Matcher
  java.util.regex.Pattern
  java.util.regex.PatternSyntaxException
  java.util.spi.CalendarDataProvider
  java.util.spi.CalendarNameProvider
  java.util.spi.CurrencyNameProvider
  java.util.spi.LocaleNameProvider
  java.util.spi.LocaleServiceProvider
  java.util.spi.ResourceBundleControlProvider
  java.util.spi.TimeZoneNameProvider
  java.util.stream.BaseStream
  java.util.stream.Collector
  java.util.stream.Collectors
  java.util.stream.DoubleStream
  java.util.stream.IntStream
  java.util.stream.LongStream
  java.util.stream.Node
  java.util.stream.Stream
  java.util.stream.StreamSupport
  java.util.zip.Adler32
  java.util.zip.CRC32
  java.util.zip.CheckedInputStream
  java.util.zip.CheckedOutputStream
  java.util.zip.Checksum
  java.util.zip.DataFormatException
  java.util.zip.Deflater
  java.util.zip.DeflaterInputStream
  java.util.zip.DeflaterOutputStream
  java.util.zip.GZIPInputStream
  java.util.zip.GZIPOutputStream
  java.util.zip.Inflater
  java.util.zip.InflaterInputStream
  java.util.zip.InflaterOutputStream
  java.util.zip.ZipConstants
  java.util.zip.ZipEntry
  java.util.zip.ZipError
  java.util.zip.ZipException
  java.util.zip.ZipFile
  java.util.zip.ZipInputStream
  java.util.zip.ZipOutputStream
  javassist.Modifier
  javassist.bytecode.Descriptor
  javassist.bytecode.MethodHandleInfo
  javassist.bytecode.annotation.Annotation
  javax.accessibility.Accessible
  javax.accessibility.AccessibleAction
  javax.accessibility.AccessibleAttributeSequence
  javax.accessibility.AccessibleBundle
  javax.accessibility.AccessibleComponent
  javax.accessibility.AccessibleContext
  javax.accessibility.AccessibleEditableText
  javax.accessibility.AccessibleExtendedComponent
  javax.accessibility.AccessibleExtendedTable
  javax.accessibility.AccessibleExtendedText
  javax.accessibility.AccessibleHyperlink
  javax.accessibility.AccessibleHypertext
  javax.accessibility.AccessibleIcon
  javax.accessibility.AccessibleKeyBinding
  javax.accessibility.AccessibleRelation
  javax.accessibility.AccessibleRelationSet
  javax.accessibility.AccessibleResourceBundle
  javax.accessibility.AccessibleRole
  javax.accessibility.AccessibleSelection
  javax.accessibility.AccessibleState
  javax.accessibility.AccessibleStateSet
  javax.accessibility.AccessibleStreamable
  javax.accessibility.AccessibleTable
  javax.accessibility.AccessibleTableModelChange
  javax.accessibility.AccessibleText
  javax.accessibility.AccessibleTextSequence
  javax.accessibility.AccessibleValue
  javax.activation.ActivationDataFlavor
  javax.activation.CommandInfo
  javax.activation.CommandMap
  javax.activation.CommandObject
  javax.activation.DataContentHandler
  javax.activation.DataContentHandlerFactory
  javax.activation.DataHandler
  javax.activation.DataHandlerDataSource
  javax.activation.DataSource
  javax.activation.DataSourceDataContentHandler
  javax.activation.FileDataSource
  javax.activation.FileTypeMap
  javax.activation.MailcapCommandMap
  javax.activation.MimeType
  javax.activation.MimeTypeParameterList
  javax.activation.MimeTypeParseException
  javax.activation.MimetypesFileTypeMap
  javax.activation.ObjectDataContentHandler
  javax.activation.SecuritySupport
  javax.activation.URLDataSource
  javax.activation.UnsupportedDataTypeException
  javax.activity.ActivityCompletedException
  javax.activity.ActivityRequiredException
  javax.activity.InvalidActivityException
  javax.annotation.Generated
  javax.annotation.PostConstruct
  javax.annotation.PreDestroy
  javax.annotation.Resource
  javax.annotation.Resources
  javax.annotation.processing.AbstractProcessor
  javax.annotation.processing.Completion
  javax.annotation.processing.Completions
  javax.annotation.processing.Filer
  javax.annotation.processing.FilerException
  javax.annotation.processing.Messager
  javax.annotation.processing.ProcessingEnvironment
  javax.annotation.processing.Processor
  javax.annotation.processing.RoundEnvironment
  javax.annotation.processing.SupportedAnnotationTypes
  javax.annotation.processing.SupportedOptions
  javax.annotation.processing.SupportedSourceVersion
  javax.crypto.AEADBadTagException
  javax.crypto.BadPaddingException
  javax.crypto.Cipher
  javax.crypto.CipherInputStream
  javax.crypto.CipherOutputStream
  javax.crypto.CipherSpi
  javax.crypto.EncryptedPrivateKeyInfo
  javax.crypto.ExemptionMechanism
  javax.crypto.ExemptionMechanismException
  javax.crypto.ExemptionMechanismSpi
  javax.crypto.IllegalBlockSizeException
  javax.crypto.KeyAgreement
  javax.crypto.KeyAgreementSpi
  javax.crypto.KeyGenerator
  javax.crypto.KeyGeneratorSpi
  javax.crypto.Mac
  javax.crypto.MacSpi
  javax.crypto.NoSuchPaddingException
  javax.crypto.NullCipher
  javax.crypto.SealedObject
  javax.crypto.SecretKey
  javax.crypto.SecretKeyFactory
  javax.crypto.SecretKeyFactorySpi
  javax.crypto.ShortBufferException
  javax.crypto.interfaces.DHKey
  javax.crypto.interfaces.DHPrivateKey
  javax.crypto.interfaces.DHPublicKey
  javax.crypto.interfaces.PBEKey
  javax.crypto.spec.DESKeySpec
  javax.crypto.spec.DESedeKeySpec
  javax.crypto.spec.DHGenParameterSpec
  javax.crypto.spec.DHParameterSpec
  javax.crypto.spec.DHPrivateKeySpec
  javax.crypto.spec.DHPublicKeySpec
  javax.crypto.spec.GCMParameterSpec
  javax.crypto.spec.IvParameterSpec
  javax.crypto.spec.OAEPParameterSpec
  javax.crypto.spec.PBEKeySpec
  javax.crypto.spec.PBEParameterSpec
  javax.crypto.spec.PSource
  javax.crypto.spec.RC2ParameterSpec
  javax.crypto.spec.RC5ParameterSpec
  javax.crypto.spec.SecretKeySpec
  javax.jws.HandlerChain
  javax.jws.Oneway
  javax.jws.WebMethod
  javax.jws.WebParam
  javax.jws.WebResult
  javax.jws.WebService
  javax.jws.soap.InitParam
  javax.jws.soap.SOAPBinding
  javax.jws.soap.SOAPMessageHandler
  javax.jws.soap.SOAPMessageHandlers
  javax.lang.model.AnnotatedConstruct
  javax.lang.model.SourceVersion
  javax.lang.model.UnknownEntityException
  javax.lang.model.element.AnnotationMirror
  javax.lang.model.element.AnnotationValue
  javax.lang.model.element.AnnotationValueVisitor
  javax.lang.model.element.Element
  javax.lang.model.element.ElementKind
  javax.lang.model.element.ElementVisitor
  javax.lang.model.element.ExecutableElement
  javax.lang.model.element.Modifier
  javax.lang.model.element.Name
  javax.lang.model.element.NestingKind
  javax.lang.model.element.PackageElement
  javax.lang.model.element.Parameterizable
  javax.lang.model.element.QualifiedNameable
  javax.lang.model.element.TypeElement
  javax.lang.model.element.TypeParameterElement
  javax.lang.model.element.UnknownAnnotationValueException
  javax.lang.model.element.UnknownElementException
  javax.lang.model.element.VariableElement
  javax.lang.model.type.ArrayType
  javax.lang.model.type.DeclaredType
  javax.lang.model.type.ErrorType
  javax.lang.model.type.ExecutableType
  javax.lang.model.type.MirroredTypeException
  javax.lang.model.type.MirroredTypesException
  javax.lang.model.type.NoType
  javax.lang.model.type.NullType
  javax.lang.model.type.PrimitiveType
  javax.lang.model.type.ReferenceType
  javax.lang.model.type.TypeKind
  javax.lang.model.type.TypeMirror
  javax.lang.model.type.TypeVariable
  javax.lang.model.type.TypeVisitor
  javax.lang.model.type.UnionType
  javax.lang.model.type.UnknownTypeException
  javax.lang.model.type.WildcardType
  javax.lang.model.util.AbstractAnnotationValueVisitor6
  javax.lang.model.util.AbstractAnnotationValueVisitor7
  javax.lang.model.util.AbstractElementVisitor6
  javax.lang.model.util.AbstractElementVisitor7
  javax.lang.model.util.AbstractTypeVisitor6
  javax.lang.model.util.AbstractTypeVisitor7
  javax.lang.model.util.ElementFilter
  javax.lang.model.util.ElementKindVisitor6
  javax.lang.model.util.ElementKindVisitor7
  javax.lang.model.util.ElementScanner6
  javax.lang.model.util.ElementScanner7
  javax.lang.model.util.Elements
  javax.lang.model.util.SimpleAnnotationValueVisitor6
  javax.lang.model.util.SimpleAnnotationValueVisitor7
  javax.lang.model.util.SimpleElementVisitor6
  javax.lang.model.util.SimpleElementVisitor7
  javax.lang.model.util.SimpleTypeVisitor6
  javax.lang.model.util.SimpleTypeVisitor7
  javax.lang.model.util.TypeKindVisitor6
  javax.lang.model.util.TypeKindVisitor7
  javax.lang.model.util.Types
  javax.management.Attribute
  javax.management.AttributeChangeNotification
  javax.management.AttributeChangeNotificationFilter
  javax.management.AttributeList
  javax.management.AttributeNotFoundException
  javax.management.AttributeValueExp
  javax.management.BadAttributeValueExpException
  javax.management.BadBinaryOpValueExpException
  javax.management.BadStringOperationException
  javax.management.DefaultLoaderRepository
  javax.management.Descriptor
  javax.management.DescriptorAccess
  javax.management.DescriptorKey
  javax.management.DescriptorRead
  javax.management.DynamicMBean
  javax.management.ImmutableDescriptor
  javax.management.InstanceAlreadyExistsException
  javax.management.InstanceNotFoundException
  javax.management.IntrospectionException
  javax.management.InvalidApplicationException
  javax.management.InvalidAttributeValueException
  javax.management.JMException
  javax.management.JMRuntimeException
  javax.management.JMX
  javax.management.ListenerNotFoundException
  javax.management.MBeanAttributeInfo
  javax.management.MBeanConstructorInfo
  javax.management.MBeanException
  javax.management.MBeanFeatureInfo
  javax.management.MBeanInfo
  javax.management.MBeanNotificationInfo
  javax.management.MBeanOperationInfo
  javax.management.MBeanParameterInfo
  javax.management.MBeanPermission
  javax.management.MBeanRegistration
  javax.management.MBeanRegistrationException
  javax.management.MBeanServer
  javax.management.MBeanServerBuilder
  javax.management.MBeanServerConnection
  javax.management.MBeanServerDelegate
  javax.management.MBeanServerDelegateMBean
  javax.management.MBeanServerFactory
  javax.management.MBeanServerInvocationHandler
  javax.management.MBeanServerNotification
  javax.management.MBeanServerPermission
  javax.management.MBeanTrustPermission
  javax.management.MXBean
  javax.management.MalformedObjectNameException
  javax.management.NotCompliantMBeanException
  javax.management.Notification
  javax.management.NotificationBroadcaster
  javax.management.NotificationBroadcasterSupport
  javax.management.NotificationEmitter
  javax.management.NotificationFilter
  javax.management.NotificationFilterSupport
  javax.management.NotificationListener
  javax.management.ObjectInstance
  javax.management.ObjectName
  javax.management.OperationsException
  javax.management.PersistentMBean
  javax.management.Query
  javax.management.QueryEval
  javax.management.QueryExp
  javax.management.ReflectionException
  javax.management.RuntimeErrorException
  javax.management.RuntimeMBeanException
  javax.management.RuntimeOperationsException
  javax.management.ServiceNotFoundException
  javax.management.StandardEmitterMBean
  javax.management.StandardMBean
  javax.management.StringValueExp
  javax.management.ValueExp
  javax.naming.CompositeName
  javax.naming.InvalidNameException
  javax.naming.Name
  javax.naming.NamingEnumeration
  javax.naming.NamingException
  javax.naming.directory.Attribute
  javax.naming.directory.Attributes
  javax.naming.ldap.LdapName
  javax.naming.ldap.Rdn
  javax.net.DefaultSocketFactory
  javax.net.ServerSocketFactory
  javax.net.SocketFactory
  javax.net.ssl.CertPathTrustManagerParameters
  javax.net.ssl.DefaultSSLServerSocketFactory
  javax.net.ssl.DefaultSSLSocketFactory
  javax.net.ssl.ExtendedSSLSession
  javax.net.ssl.HandshakeCompletedEvent
  javax.net.ssl.HandshakeCompletedListener
  javax.net.ssl.HostnameVerifier
  javax.net.ssl.HttpsURLConnection
  javax.net.ssl.KeyManager
  javax.net.ssl.KeyManagerFactory
  javax.net.ssl.KeyManagerFactorySpi
  javax.net.ssl.KeyStoreBuilderParameters
  javax.net.ssl.ManagerFactoryParameters
  javax.net.ssl.SNIHostName
  javax.net.ssl.SNIMatcher
  javax.net.ssl.SNIServerName
  javax.net.ssl.SSLContext
  javax.net.ssl.SSLContextSpi
  javax.net.ssl.SSLEngine
  javax.net.ssl.SSLEngineResult
  javax.net.ssl.SSLException
  javax.net.ssl.SSLHandshakeException
  javax.net.ssl.SSLKeyException
  javax.net.ssl.SSLParameters
  javax.net.ssl.SSLPeerUnverifiedException
  javax.net.ssl.SSLPermission
  javax.net.ssl.SSLProtocolException
  javax.net.ssl.SSLServerSocket
  javax.net.ssl.SSLServerSocketFactory
  javax.net.ssl.SSLSession
  javax.net.ssl.SSLSessionBindingEvent
  javax.net.ssl.SSLSessionBindingListener
  javax.net.ssl.SSLSessionContext
  javax.net.ssl.SSLSocket
  javax.net.ssl.SSLSocketFactory
  javax.net.ssl.StandardConstants
  javax.net.ssl.TrustManager
  javax.net.ssl.TrustManagerFactory
  javax.net.ssl.TrustManagerFactorySpi
  javax.net.ssl.X509ExtendedKeyManager
  javax.net.ssl.X509ExtendedTrustManager
  javax.net.ssl.X509KeyManager
  javax.net.ssl.X509TrustManager
  javax.script.AbstractScriptEngine
  javax.script.Bindings
  javax.script.Compilable
  javax.script.CompiledScript
  javax.script.Invocable
  javax.script.ScriptContext
  javax.script.ScriptEngine
  javax.script.ScriptEngineFactory
  javax.script.ScriptEngineManager
  javax.script.ScriptException
  javax.script.SimpleBindings
  javax.script.SimpleScriptContext
  javax.security.auth.AuthPermission
  javax.security.auth.DestroyFailedException
  javax.security.auth.Destroyable
  javax.security.auth.Policy
  javax.security.auth.PrivateCredentialPermission
  javax.security.auth.RefreshFailedException
  javax.security.auth.Refreshable
  javax.security.auth.Subject
  javax.security.auth.SubjectDomainCombiner
  javax.security.auth.callback.Callback
  javax.security.auth.callback.CallbackHandler
  javax.security.auth.callback.ChoiceCallback
  javax.security.auth.callback.ConfirmationCallback
  javax.security.auth.callback.LanguageCallback
  javax.security.auth.callback.NameCallback
  javax.security.auth.callback.PasswordCallback
  javax.security.auth.callback.TextInputCallback
  javax.security.auth.callback.TextOutputCallback
  javax.security.auth.callback.UnsupportedCallbackException
  javax.security.auth.kerberos.DelegationPermission
  javax.security.auth.kerberos.KerberosKey
  javax.security.auth.kerberos.KerberosPrincipal
  javax.security.auth.kerberos.KerberosTicket
  javax.security.auth.kerberos.ServicePermission
  javax.security.auth.login.AccountException
  javax.security.auth.login.AccountExpiredException
  javax.security.auth.login.AccountLockedException
  javax.security.auth.login.AccountNotFoundException
  javax.security.auth.login.AppConfigurationEntry
  javax.security.auth.login.Configuration
  javax.security.auth.login.ConfigurationSpi
  javax.security.auth.login.CredentialException
  javax.security.auth.login.CredentialExpiredException
  javax.security.auth.login.CredentialNotFoundException
  javax.security.auth.login.FailedLoginException
  javax.security.auth.login.LoginContext
  javax.security.auth.login.LoginException
  javax.security.auth.spi.LoginModule
  javax.security.auth.x500.X500Principal
  javax.security.auth.x500.X500PrivateCredential
  javax.security.cert.Certificate
  javax.security.cert.CertificateEncodingException
  javax.security.cert.CertificateException
  javax.security.cert.CertificateExpiredException
  javax.security.cert.CertificateNotYetValidException
  javax.security.cert.CertificateParsingException
  javax.security.cert.X509Certificate
  javax.security.sasl.AuthenticationException
  javax.security.sasl.AuthorizeCallback
  javax.security.sasl.RealmCallback
  javax.security.sasl.RealmChoiceCallback
  javax.security.sasl.Sasl
  javax.security.sasl.SaslClient
  javax.security.sasl.SaslClientFactory
  javax.security.sasl.SaslException
  javax.security.sasl.SaslServer
  javax.security.sasl.SaslServerFactory
  javax.sql.CommonDataSource
  javax.sql.ConnectionEvent
  javax.sql.ConnectionEventListener
  javax.sql.ConnectionPoolDataSource
  javax.sql.DataSource
  javax.sql.PooledConnection
  javax.sql.RowSet
  javax.sql.RowSetEvent
  javax.sql.RowSetInternal
  javax.sql.RowSetListener
  javax.sql.RowSetMetaData
  javax.sql.RowSetReader
  javax.sql.RowSetWriter
  javax.sql.StatementEvent
  javax.sql.StatementEventListener
  javax.sql.XAConnection
  javax.sql.XADataSource
  javax.sql.rowset.BaseRowSet
  javax.sql.rowset.CachedRowSet
  javax.sql.rowset.FilteredRowSet
  javax.sql.rowset.JdbcRowSet
  javax.sql.rowset.JoinRowSet
  javax.sql.rowset.Joinable
  javax.sql.rowset.Predicate
  javax.sql.rowset.RowSetFactory
  javax.sql.rowset.RowSetMetaDataImpl
  javax.sql.rowset.RowSetWarning
  javax.sql.rowset.WebRowSet
  javax.sql.rowset.serial.SQLInputImpl
  javax.sql.rowset.serial.SQLOutputImpl
  javax.sql.rowset.serial.SerialArray
  javax.sql.rowset.serial.SerialBlob
  javax.sql.rowset.serial.SerialClob
  javax.sql.rowset.serial.SerialDatalink
  javax.sql.rowset.serial.SerialException
  javax.sql.rowset.serial.SerialJavaObject
  javax.sql.rowset.serial.SerialRef
  javax.sql.rowset.serial.SerialStruct
  javax.sql.rowset.spi.SyncFactory
  javax.sql.rowset.spi.SyncFactoryException
  javax.sql.rowset.spi.SyncProvider
  javax.sql.rowset.spi.SyncProviderException
  javax.sql.rowset.spi.SyncResolver
  javax.sql.rowset.spi.TransactionalWriter
  javax.sql.rowset.spi.XmlReader
  javax.sql.rowset.spi.XmlWriter
  javax.transaction.InvalidTransactionException
  javax.transaction.TransactionRequiredException
  javax.transaction.TransactionRolledbackException
  javax.transaction.xa.XAException
  javax.transaction.xa.XAResource
  javax.transaction.xa.Xid
  javax.xml.XMLConstants
  javax.xml.bind.Binder
  javax.xml.bind.DataBindingException
  javax.xml.bind.DatatypeConverter
  javax.xml.bind.DatatypeConverterInterface
  javax.xml.bind.Element
  javax.xml.bind.JAXB
  javax.xml.bind.JAXBContext
  javax.xml.bind.JAXBElement
  javax.xml.bind.JAXBException
  javax.xml.bind.JAXBIntrospector
  javax.xml.bind.JAXBPermission
  javax.xml.bind.MarshalException
  javax.xml.bind.Marshaller
  javax.xml.bind.NotIdentifiableEvent
  javax.xml.bind.ParseConversionEvent
  javax.xml.bind.PrintConversionEvent
  javax.xml.bind.PropertyException
  javax.xml.bind.SchemaOutputResolver
  javax.xml.bind.TypeConstraintException
  javax.xml.bind.UnmarshalException
  javax.xml.bind.Unmarshaller
  javax.xml.bind.UnmarshallerHandler
  javax.xml.bind.ValidationEvent
  javax.xml.bind.ValidationEventHandler
  javax.xml.bind.ValidationEventLocator
  javax.xml.bind.ValidationException
  javax.xml.bind.Validator
  javax.xml.bind.annotation.DomHandler
  javax.xml.bind.annotation.W3CDomHandler
  javax.xml.bind.annotation.XmlAccessOrder
  javax.xml.bind.annotation.XmlAccessType
  javax.xml.bind.annotation.XmlAccessorOrder
  javax.xml.bind.annotation.XmlAccessorType
  javax.xml.bind.annotation.XmlAnyAttribute
  javax.xml.bind.annotation.XmlAnyElement
  javax.xml.bind.annotation.XmlAttachmentRef
  javax.xml.bind.annotation.XmlAttribute
  javax.xml.bind.annotation.XmlElement
  javax.xml.bind.annotation.XmlElementDecl
  javax.xml.bind.annotation.XmlElementRef
  javax.xml.bind.annotation.XmlElementRefs
  javax.xml.bind.annotation.XmlElementWrapper
  javax.xml.bind.annotation.XmlElements
  javax.xml.bind.annotation.XmlEnum
  javax.xml.bind.annotation.XmlEnumValue
  javax.xml.bind.annotation.XmlID
  javax.xml.bind.annotation.XmlIDREF
  javax.xml.bind.annotation.XmlInlineBinaryData
  javax.xml.bind.annotation.XmlList
  javax.xml.bind.annotation.XmlMimeType
  javax.xml.bind.annotation.XmlMixed
  javax.xml.bind.annotation.XmlNs
  javax.xml.bind.annotation.XmlNsForm
  javax.xml.bind.annotation.XmlRegistry
  javax.xml.bind.annotation.XmlRootElement
  javax.xml.bind.annotation.XmlSchema
  javax.xml.bind.annotation.XmlSchemaType
  javax.xml.bind.annotation.XmlSchemaTypes
  javax.xml.bind.annotation.XmlSeeAlso
  javax.xml.bind.annotation.XmlTransient
  javax.xml.bind.annotation.XmlType
  javax.xml.bind.annotation.XmlValue
  javax.xml.bind.annotation.adapters.CollapsedStringAdapter
  javax.xml.bind.annotation.adapters.HexBinaryAdapter
  javax.xml.bind.annotation.adapters.NormalizedStringAdapter
  javax.xml.bind.annotation.adapters.XmlAdapter
  javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter
  javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters
  javax.xml.bind.attachment.AttachmentMarshaller
  javax.xml.bind.attachment.AttachmentUnmarshaller
  javax.xml.bind.helpers.AbstractMarshallerImpl
  javax.xml.bind.helpers.AbstractUnmarshallerImpl
  javax.xml.bind.helpers.DefaultValidationEventHandler
  javax.xml.bind.helpers.NotIdentifiableEventImpl
  javax.xml.bind.helpers.ParseConversionEventImpl
  javax.xml.bind.helpers.PrintConversionEventImpl
  javax.xml.bind.helpers.ValidationEventImpl
  javax.xml.bind.helpers.ValidationEventLocatorImpl
  javax.xml.bind.util.JAXBResult
  javax.xml.bind.util.JAXBSource
  javax.xml.bind.util.ValidationEventCollector
  javax.xml.crypto.AlgorithmMethod
  javax.xml.crypto.Data
  javax.xml.crypto.KeySelector
  javax.xml.crypto.KeySelectorException
  javax.xml.crypto.KeySelectorResult
  javax.xml.crypto.MarshalException
  javax.xml.crypto.NoSuchMechanismException
  javax.xml.crypto.NodeSetData
  javax.xml.crypto.OctetStreamData
  javax.xml.crypto.URIDereferencer
  javax.xml.crypto.URIReference
  javax.xml.crypto.URIReferenceException
  javax.xml.crypto.XMLCryptoContext
  javax.xml.crypto.XMLStructure
  javax.xml.crypto.dom.DOMCryptoContext
  javax.xml.crypto.dom.DOMStructure
  javax.xml.crypto.dom.DOMURIReference
  javax.xml.crypto.dsig.CanonicalizationMethod
  javax.xml.crypto.dsig.DigestMethod
  javax.xml.crypto.dsig.Manifest
  javax.xml.crypto.dsig.Reference
  javax.xml.crypto.dsig.SignatureMethod
  javax.xml.crypto.dsig.SignatureProperties
  javax.xml.crypto.dsig.SignatureProperty
  javax.xml.crypto.dsig.SignedInfo
  javax.xml.crypto.dsig.Transform
  javax.xml.crypto.dsig.TransformException
  javax.xml.crypto.dsig.TransformService
  javax.xml.crypto.dsig.XMLObject
  javax.xml.crypto.dsig.XMLSignContext
  javax.xml.crypto.dsig.XMLSignature
  javax.xml.crypto.dsig.XMLSignatureException
  javax.xml.crypto.dsig.XMLSignatureFactory
  javax.xml.crypto.dsig.XMLValidateContext
  javax.xml.crypto.dsig.dom.DOMSignContext
  javax.xml.crypto.dsig.dom.DOMValidateContext
  javax.xml.crypto.dsig.keyinfo.KeyInfo
  javax.xml.crypto.dsig.keyinfo.KeyInfoFactory
  javax.xml.crypto.dsig.keyinfo.KeyName
  javax.xml.crypto.dsig.keyinfo.KeyValue
  javax.xml.crypto.dsig.keyinfo.PGPData
  javax.xml.crypto.dsig.keyinfo.RetrievalMethod
  javax.xml.crypto.dsig.keyinfo.X509Data
  javax.xml.crypto.dsig.keyinfo.X509IssuerSerial
  javax.xml.crypto.dsig.spec.C14NMethodParameterSpec
  javax.xml.crypto.dsig.spec.DigestMethodParameterSpec
  javax.xml.crypto.dsig.spec.ExcC14NParameterSpec
  javax.xml.crypto.dsig.spec.HMACParameterSpec
  javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec
  javax.xml.crypto.dsig.spec.TransformParameterSpec
  javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec
  javax.xml.crypto.dsig.spec.XPathFilterParameterSpec
  javax.xml.crypto.dsig.spec.XPathType
  javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec
  javax.xml.datatype.DatatypeConfigurationException
  javax.xml.datatype.DatatypeConstants
  javax.xml.datatype.DatatypeFactory
  javax.xml.datatype.Duration
  javax.xml.datatype.XMLGregorianCalendar
  javax.xml.namespace.NamespaceContext
  javax.xml.namespace.QName
  javax.xml.parsers.DocumentBuilder
  javax.xml.parsers.DocumentBuilderFactory
  javax.xml.parsers.FactoryConfigurationError
  javax.xml.parsers.ParserConfigurationException
  javax.xml.parsers.SAXParser
  javax.xml.parsers.SAXParserFactory
  javax.xml.soap.AttachmentPart
  javax.xml.soap.Detail
  javax.xml.soap.DetailEntry
  javax.xml.soap.MessageFactory
  javax.xml.soap.MimeHeader
  javax.xml.soap.MimeHeaders
  javax.xml.soap.Name
  javax.xml.soap.Node
  javax.xml.soap.SAAJMetaFactory
  javax.xml.soap.SAAJResult
  javax.xml.soap.SOAPBody
  javax.xml.soap.SOAPBodyElement
  javax.xml.soap.SOAPConnection
  javax.xml.soap.SOAPConnectionFactory
  javax.xml.soap.SOAPConstants
  javax.xml.soap.SOAPElement
  javax.xml.soap.SOAPElementFactory
  javax.xml.soap.SOAPEnvelope
  javax.xml.soap.SOAPException
  javax.xml.soap.SOAPFactory
  javax.xml.soap.SOAPFault
  javax.xml.soap.SOAPFaultElement
  javax.xml.soap.SOAPHeader
  javax.xml.soap.SOAPHeaderElement
  javax.xml.soap.SOAPMessage
  javax.xml.soap.SOAPPart
  javax.xml.soap.Text
  javax.xml.stream.EventFilter
  javax.xml.stream.FactoryConfigurationError
  javax.xml.stream.FactoryFinder
  javax.xml.stream.Location
  javax.xml.stream.SecuritySupport
  javax.xml.stream.StreamFilter
  javax.xml.stream.XMLEventFactory
  javax.xml.stream.XMLEventReader
  javax.xml.stream.XMLEventWriter
  javax.xml.stream.XMLInputFactory
  javax.xml.stream.XMLOutputFactory
  javax.xml.stream.XMLReporter
  javax.xml.stream.XMLResolver
  javax.xml.stream.XMLStreamConstants
  javax.xml.stream.XMLStreamException
  javax.xml.stream.XMLStreamReader
  javax.xml.stream.XMLStreamWriter
  javax.xml.stream.events.Attribute
  javax.xml.stream.events.Characters
  javax.xml.stream.events.Comment
  javax.xml.stream.events.DTD
  javax.xml.stream.events.EndDocument
  javax.xml.stream.events.EndElement
  javax.xml.stream.events.EntityDeclaration
  javax.xml.stream.events.EntityReference
  javax.xml.stream.events.Namespace
  javax.xml.stream.events.NotationDeclaration
  javax.xml.stream.events.ProcessingInstruction
  javax.xml.stream.events.StartDocument
  javax.xml.stream.events.StartElement
  javax.xml.stream.events.XMLEvent
  javax.xml.stream.util.EventReaderDelegate
  javax.xml.stream.util.StreamReaderDelegate
  javax.xml.stream.util.XMLEventAllocator
  javax.xml.stream.util.XMLEventConsumer
  javax.xml.transform.ErrorListener
  javax.xml.transform.OutputKeys
  javax.xml.transform.Result
  javax.xml.transform.Source
  javax.xml.transform.SourceLocator
  javax.xml.transform.Templates
  javax.xml.transform.Transformer
  javax.xml.transform.TransformerConfigurationException
  javax.xml.transform.TransformerException
  javax.xml.transform.TransformerFactory
  javax.xml.transform.TransformerFactoryConfigurationError
  javax.xml.transform.URIResolver
  javax.xml.transform.dom.DOMLocator
  javax.xml.transform.dom.DOMResult
  javax.xml.transform.dom.DOMSource
  javax.xml.transform.sax.SAXResult
  javax.xml.transform.sax.SAXSource
  javax.xml.transform.sax.SAXTransformerFactory
  javax.xml.transform.sax.TemplatesHandler
  javax.xml.transform.sax.TransformerHandler
  javax.xml.transform.stream.StreamResult
  javax.xml.transform.stream.StreamSource
  javax.xml.validation.Schema
  javax.xml.validation.SchemaFactory
  javax.xml.validation.SchemaFactoryLoader
  javax.xml.validation.TypeInfoProvider
  javax.xml.validation.Validator
  javax.xml.validation.ValidatorHandler
  javax.xml.ws.Action
  javax.xml.ws.AsyncHandler
  javax.xml.ws.Binding
  javax.xml.ws.BindingProvider
  javax.xml.ws.BindingType
  javax.xml.ws.Dispatch
  javax.xml.ws.Endpoint
  javax.xml.ws.EndpointContext
  javax.xml.ws.EndpointReference
  javax.xml.ws.FaultAction
  javax.xml.ws.Holder
  javax.xml.ws.LogicalMessage
  javax.xml.ws.ProtocolException
  javax.xml.ws.Provider
  javax.xml.ws.RequestWrapper
  javax.xml.ws.RespectBinding
  javax.xml.ws.RespectBindingFeature
  javax.xml.ws.Response
  javax.xml.ws.ResponseWrapper
  javax.xml.ws.Service
  javax.xml.ws.ServiceMode
  javax.xml.ws.WebEndpoint
  javax.xml.ws.WebFault
  javax.xml.ws.WebServiceClient
  javax.xml.ws.WebServiceContext
  javax.xml.ws.WebServiceException
  javax.xml.ws.WebServiceFeature
  javax.xml.ws.WebServicePermission
  javax.xml.ws.WebServiceProvider
  javax.xml.ws.WebServiceRef
  javax.xml.ws.WebServiceRefs
  javax.xml.ws.handler.Handler
  javax.xml.ws.handler.HandlerResolver
  javax.xml.ws.handler.LogicalHandler
  javax.xml.ws.handler.LogicalMessageContext
  javax.xml.ws.handler.MessageContext
  javax.xml.ws.handler.PortInfo
  javax.xml.ws.handler.soap.SOAPHandler
  javax.xml.ws.handler.soap.SOAPMessageContext
  javax.xml.ws.soap.Addressing
  javax.xml.ws.soap.AddressingFeature
  javax.xml.ws.soap.MTOM
  javax.xml.ws.soap.MTOMFeature
  javax.xml.ws.soap.SOAPBinding
  javax.xml.ws.soap.SOAPFaultException
  javax.xml.ws.spi.Invoker
  javax.xml.ws.spi.Provider
  javax.xml.ws.spi.ServiceDelegate
  javax.xml.ws.spi.WebServiceFeatureAnnotation
  javax.xml.ws.spi.http.HttpContext
  javax.xml.ws.spi.http.HttpExchange
  javax.xml.ws.spi.http.HttpHandler
  javax.xml.ws.wsaddressing.W3CEndpointReference
  javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder
  javax.xml.xpath.XPath
  javax.xml.xpath.XPathConstants
  javax.xml.xpath.XPathException
  javax.xml.xpath.XPathExpression
  javax.xml.xpath.XPathExpressionException
  javax.xml.xpath.XPathFactory
  javax.xml.xpath.XPathFactoryConfigurationException
  javax.xml.xpath.XPathFunction
  javax.xml.xpath.XPathFunctionException
  javax.xml.xpath.XPathFunctionResolver
  javax.xml.xpath.XPathVariableResolver
  sun.invoke.util.Wrapper
  sun.management.FileSystem
  sun.management.ManagementFactory
  sun.management.Util
  sun.misc.ClassFileTransformer
  sun.misc.Lock
  sun.misc.Queue
  sun.misc.Ref
  sun.misc.Request
  sun.misc.Resource
  sun.misc.Service
  sun.misc.ServiceConfigurationError
  sun.misc.Timer
  sun.net.ProgressMonitor
  sun.net.www.URLConnection
  sun.net.www.protocol.file.Handler
  sun.net.www.protocol.http.Handler
  sun.net.www.protocol.http.HttpURLConnection
  sun.net.www.protocol.jar.Handler
  sun.net.www.protocol.jar.JarURLConnection
  sun.nio.ch.Invoker
  sun.nio.ch.Port
  sun.nio.ch.Util
  sun.nio.cs.StandardCharsets
  sun.reflect.Label
  sun.reflect.generics.tree.Signature
  sun.security.krb5.Checksum
  sun.security.krb5.internal.Authenticator
  sun.security.pkcs.EncryptedPrivateKeyInfo
  sun.security.provider.DSAKeyPairGenerator
  sun.security.provider.DSAPrivateKey
  sun.security.provider.DSAPublicKey
  sun.security.provider.SecureRandom
  sun.security.provider.certpath.State
  sun.security.ssl.Authenticator
  sun.security.ssl.Utilities
  sun.security.util.Resources
  sun.security.validator.Validator
  sun.security.x509.Extension
  sun.util.calendar.Era
  sun.util.locale.Extension})