(ns quantum.core.network.deploy)

(require '[quantum.core.ns                 :as ns :refer :all])
(ns/require-all *ns* :clj :lib)
(require '[quantum.http.url :as url])

(require '[org.httpkit.client              :as http])
(require '[quantum.auth.core               :as auth])
(require '[quantum.http.core               :as qhttp])
(import 'quantum.http.core.HTTPLogEntry)
(require '[quantum.core.data.json          :as json]) 


(def heroku-help-center
  "https://devcenter.heroku.com/articles/getting-started-with-clojure")

(def apps (atom #{"ramsey"}))
(def default-app (atom "ramsey"))


(defn create!
  [^String app-name]
  (sh/exec! [:projects app-name] "heroku" "create"))

(defn ^Int count-dynos
  "Count the number of dynos running on the given app."
  ([]
    (count-dynos @default-app))
  ([^String app-name]
    (sh/exec! [:projects app-name] "heroku" "ps")
    (-> @sh/processes (get "heroku ps")
        :out last+ first
        (take-afteri+ "web (")
        (take-untili+ "X):")
        str/val)))

(defn scale-to!
  "Scaling the application may require account verification.
   For each application, Heroku provides 750 free dyno-hours."
  ([^Int dynos]
    (scale-to @default-app dynos))
  ([^String app-name ^Int dynos]
    (sh/exec! [:projects app-name]
      "heroku" "ps:scale" (str "web=" dynos))))

(defn deploy!
  ([]
    (deploy @default-app))
  ([^String app-name]
    (sh/exec! [:projects app-name] "git" "push"   "heroku" "master"))
  ([^String app-name ^String commit-desc]
    (sh/exec! [:projects app-name] "git" "add"    ".")
    (sh/exec! [:projects app-name] "git" "commit" "-m" (str "\"" commit-desc "\""))
    (deploy! app-name)))

(defn visit
  ([]
    (visit @default-app))
  ([^String app-name]
    (sh/exec! [:projects app-name] "heroku" "open")))

(defn dep-deploy! [^String repo-name]
  (sh/exec! [:projects repo-name] "lein" "install"))


