{
    var _ns_ = {
            id: 'wisp.sequence',
            doc: void 0
        };
    var wisp_runtime = require('./runtime');
    var isNil = wisp_runtime.isNil;
    var isVector = wisp_runtime.isVector;
    var isFn = wisp_runtime.isFn;
    var isNumber = wisp_runtime.isNumber;
    var isString = wisp_runtime.isString;
    var isDictionary = wisp_runtime.isDictionary;
    var keyValues = wisp_runtime.keyValues;
    var str = wisp_runtime.str;
    var dec = wisp_runtime.dec;
    var inc = wisp_runtime.inc;
    var merge = wisp_runtime.merge;
    var dictionary = wisp_runtime.dictionary;
}
var List = function List(head, tail) {
    this.head = head;
    this.tail = tail || list();
    this.length = inc(count(this.tail));
    return this;
};
List.prototype.length = 0;
List.type = 'wisp.list';
List.prototype.type = List.type;
List.prototype.tail = Object.create(List.prototype);
List.prototype.toString = function () {
    return function loop() {
        var recur = loop;
        var resultø1 = '';
        var listø1 = this;
        do {
            recur = isEmpty(listø1) ? '' + '(' + resultø1.substr(1) + ')' : (loop[0] = '' + resultø1 + ' ' + (isVector(first(listø1)) ? '' + '[' + first(listø1).join(' ') + ']' : isNil(first(listø1)) ? 'nil' : isString(first(listø1)) ? JSON.stringify(first(listø1)) : isNumber(first(listø1)) ? JSON.stringify(first(listø1)) : first(listø1)), loop[1] = rest(listø1), loop);
        } while (resultø1 = loop[0], listø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var lazySeqValue = function lazySeqValue(lazySeq) {
    return !lazySeq.realized ? (lazySeq.realized = true) && (lazySeq.x = lazySeq.x()) : lazySeq.x;
};
var LazySeq = function LazySeq(realized, x) {
    this.realized = realized || false;
    this.x = x;
    return this;
};
LazySeq.type = 'wisp.lazy.seq';
LazySeq.prototype.type = LazySeq.type;
var lazySeq = exports.lazySeq = function lazySeq(realized, body) {
        return new LazySeq(realized, body);
    };
var isLazySeq = exports.isLazySeq = function isLazySeq(value) {
        return value && LazySeq.type === value.type;
    };
void 0;
var isList = exports.isList = function isList(value) {
        return value && List.type === value.type;
    };
var list = exports.list = function list() {
        return arguments.length === 0 ? Object.create(List.prototype) : Array.prototype.slice.call(arguments).reduceRight(function (tail, head) {
            return cons(head, tail);
        }, list());
    };
var cons = exports.cons = function cons(head, tail) {
        return new List(head, tail);
    };
var reverseList = function reverseList(sequence) {
    return function loop() {
        var recur = loop;
        var itemsø1 = [];
        var sourceø1 = sequence;
        do {
            recur = isEmpty(sourceø1) ? list.apply(void 0, itemsø1) : (loop[0] = [first(sourceø1)].concat(itemsø1), loop[1] = rest(sourceø1), loop);
        } while (itemsø1 = loop[0], sourceø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var isSequential = exports.isSequential = function isSequential(x) {
        return isList(x) || isVector(x) || isLazySeq(x) || isDictionary(x) || isString(x);
    };
var reverse = exports.reverse = function reverse(sequence) {
        return isList(sequence) ? reverseList(sequence) : isVector(sequence) ? sequence.reverse() : isNil(sequence) ? list() : 'else' ? reverse(seq(sequence)) : void 0;
    };
var map = exports.map = function map(f, sequence) {
        return isVector(sequence) ? sequence.map(function ($1) {
            return f($1);
        }) : isList(sequence) ? mapList(f, sequence) : isNil(sequence) ? list() : 'else' ? map(f, seq(sequence)) : void 0;
    };
var mapList = function mapList(f, sequence) {
    return function loop() {
        var recur = loop;
        var resultø1 = list();
        var itemsø1 = sequence;
        do {
            recur = isEmpty(itemsø1) ? reverse(resultø1) : (loop[0] = cons(f(first(itemsø1)), resultø1), loop[1] = rest(itemsø1), loop);
        } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var filter = exports.filter = function filter(isF, sequence) {
        return isVector(sequence) ? sequence.filter(isF) : isList(sequence) ? filterList(isF, sequence) : isNil(sequence) ? list() : 'else' ? filter(isF, seq(sequence)) : void 0;
    };
var filterList = function filterList(isF, sequence) {
    return function loop() {
        var recur = loop;
        var resultø1 = list();
        var itemsø1 = sequence;
        do {
            recur = isEmpty(itemsø1) ? reverse(resultø1) : (loop[0] = isF(first(itemsø1)) ? cons(first(itemsø1), resultø1) : resultø1, loop[1] = rest(itemsø1), loop);
        } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var reduce = exports.reduce = function reduce(f) {
        var params = Array.prototype.slice.call(arguments, 1);
        return function () {
            var hasInitialø1 = count(params) >= 2;
            var initialø1 = hasInitialø1 ? first(params) : void 0;
            var sequenceø1 = hasInitialø1 ? second(params) : first(params);
            return isNil(sequenceø1) ? initialø1 : isVector(sequenceø1) ? hasInitialø1 ? sequenceø1.reduce(f, initialø1) : sequenceø1.reduce(f) : isList(sequenceø1) ? hasInitialø1 ? reduceList(f, initialø1, sequenceø1) : reduceList(f, first(sequenceø1), rest(sequenceø1)) : 'else' ? reduce(f, initialø1, seq(sequenceø1)) : void 0;
        }.call(this);
    };
var reduceList = function reduceList(f, initial, sequence) {
    return function loop() {
        var recur = loop;
        var resultø1 = initial;
        var itemsø1 = sequence;
        do {
            recur = isEmpty(itemsø1) ? resultø1 : (loop[0] = f(resultø1, first(itemsø1)), loop[1] = rest(itemsø1), loop);
        } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var count = exports.count = function count(sequence) {
        return isNil(sequence) ? 0 : seq(sequence).length;
    };
var isEmpty = exports.isEmpty = function isEmpty(sequence) {
        return count(sequence) === 0;
    };
var first = exports.first = function first(sequence) {
        return isNil(sequence) ? void 0 : isList(sequence) ? sequence.head : isVector(sequence) || isString(sequence) ? (sequence || 0)[0] : isLazySeq(sequence) ? first(lazySeqValue(sequence)) : 'else' ? first(seq(sequence)) : void 0;
    };
var second = exports.second = function second(sequence) {
        return isNil(sequence) ? void 0 : isList(sequence) ? first(rest(sequence)) : isVector(sequence) || isString(sequence) ? (sequence || 0)[1] : isLazySeq(sequence) ? second(lazySeqValue(sequence)) : 'else' ? first(rest(seq(sequence))) : void 0;
    };
var third = exports.third = function third(sequence) {
        return isNil(sequence) ? void 0 : isList(sequence) ? first(rest(rest(sequence))) : isVector(sequence) || isString(sequence) ? (sequence || 0)[2] : isLazySeq(sequence) ? third(lazySeqValue(sequence)) : 'else' ? second(rest(seq(sequence))) : void 0;
    };
var rest = exports.rest = function rest(sequence) {
        return isNil(sequence) ? list() : isList(sequence) ? sequence.tail : isVector(sequence) || isString(sequence) ? sequence.slice(1) : isLazySeq(sequence) ? rest(lazySeqValue(sequence)) : 'else' ? rest(seq(sequence)) : void 0;
    };
var lastOfList = function lastOfList(list) {
    return function loop() {
        var recur = loop;
        var itemø1 = first(list);
        var itemsø1 = rest(list);
        do {
            recur = isEmpty(itemsø1) ? itemø1 : (loop[0] = first(itemsø1), loop[1] = rest(itemsø1), loop);
        } while (itemø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var last = exports.last = function last(sequence) {
        return isVector(sequence) || isString(sequence) ? (sequence || 0)[dec(count(sequence))] : isList(sequence) ? lastOfList(sequence) : isNil(sequence) ? void 0 : isLazySeq(sequence) ? last(lazySeqValue(sequence)) : 'else' ? last(seq(sequence)) : void 0;
    };
var butlast = exports.butlast = function butlast(sequence) {
        return function () {
            var itemsø1 = isNil(sequence) ? void 0 : isString(sequence) ? subs(sequence, 0, dec(count(sequence))) : isVector(sequence) ? sequence.slice(0, dec(count(sequence))) : isList(sequence) ? list.apply(void 0, butlast(vec(sequence))) : isLazySeq(sequence) ? butlast(lazySeqValue(sequence)) : 'else' ? butlast(seq(sequence)) : void 0;
            return !(isNil(itemsø1) || isEmpty(itemsø1)) ? itemsø1 : void 0;
        }.call(this);
    };
var take = exports.take = function take(n, sequence) {
        return isNil(sequence) ? list() : isVector(sequence) ? takeFromVector(n, sequence) : isList(sequence) ? takeFromList(n, sequence) : isLazySeq(sequence) ? take(n, lazySeqValue(sequence)) : 'else' ? take(n, seq(sequence)) : void 0;
    };
var takeVectorWhile = function takeVectorWhile(predicate, vector) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var tailø1 = vector;
        var headø1 = first(vector);
        do {
            recur = !isEmpty(tailø1) && predicate(headø1) ? (loop[0] = conj(resultø1, headø1), loop[1] = rest(tailø1), loop[2] = first(tailø1), loop) : resultø1;
        } while (resultø1 = loop[0], tailø1 = loop[1], headø1 = loop[2], recur === loop);
        return recur;
    }.call(this);
};
var takeListWhile = function takeListWhile(predicate, items) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var tailø1 = items;
        var headø1 = first(items);
        do {
            recur = !isEmpty(tailø1) && isPredicate(headø1) ? (loop[0] = conj(resultø1, headø1), loop[1] = rest(tailø1), loop[2] = first(tailø1), loop) : list.apply(void 0, resultø1);
        } while (resultø1 = loop[0], tailø1 = loop[1], headø1 = loop[2], recur === loop);
        return recur;
    }.call(this);
};
var takeWhile = exports.takeWhile = function takeWhile(predicate, sequence) {
        return isNil(sequence) ? list() : isVector(sequence) ? takeVectorWhile(predicate, sequence) : isList(sequence) ? takeVectorWhile(predicate, sequence) : 'else' ? takeWhile(predicate, lazySeqValue(sequence)) : void 0;
    };
var takeFromVector = function takeFromVector(n, vector) {
    return vector.slice(0, n);
};
var takeFromList = function takeFromList(n, sequence) {
    return function loop() {
        var recur = loop;
        var takenø1 = list();
        var itemsø1 = sequence;
        var nø2 = n;
        do {
            recur = nø2 === 0 || isEmpty(itemsø1) ? reverse(takenø1) : (loop[0] = cons(first(itemsø1), takenø1), loop[1] = rest(itemsø1), loop[2] = dec(nø2), loop);
        } while (takenø1 = loop[0], itemsø1 = loop[1], nø2 = loop[2], recur === loop);
        return recur;
    }.call(this);
};
var dropFromList = function dropFromList(n, sequence) {
    return function loop() {
        var recur = loop;
        var leftø1 = n;
        var itemsø1 = sequence;
        do {
            recur = leftø1 < 1 || isEmpty(itemsø1) ? itemsø1 : (loop[0] = dec(leftø1), loop[1] = rest(itemsø1), loop);
        } while (leftø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var drop = exports.drop = function drop(n, sequence) {
        return n <= 0 ? sequence : isString(sequence) ? sequence.substr(n) : isVector(sequence) ? sequence.slice(n) : isList(sequence) ? dropFromList(n, sequence) : isNil(sequence) ? list() : isLazySeq(sequence) ? drop(n, lazySeqValue(sequence)) : 'else' ? drop(n, seq(sequence)) : void 0;
    };
var conjList = function conjList(sequence, items) {
    return reduce(function (result, item) {
        return cons(item, result);
    }, sequence, items);
};
var conj = exports.conj = function conj(sequence) {
        var items = Array.prototype.slice.call(arguments, 1);
        return isVector(sequence) ? sequence.concat(items) : isString(sequence) ? '' + sequence + str.apply(void 0, items) : isNil(sequence) ? list.apply(void 0, reverse(items)) : isList(sequence) || isLazySeq() ? conjList(sequence, items) : isDictionary(sequence) ? merge(sequence, merge.apply(void 0, items)) : 'else' ? (function () {
            throw TypeError('' + 'Type can\'t be conjoined ' + sequence);
        })() : void 0;
    };
var assoc = exports.assoc = function assoc(source) {
        var keyValues = Array.prototype.slice.call(arguments, 1);
        return conj(source, dictionary.apply(void 0, keyValues));
    };
var concat = exports.concat = function concat() {
        var sequences = Array.prototype.slice.call(arguments, 0);
        return reverse(reduce(function (result, sequence) {
            return reduce(function (result, item) {
                return cons(item, result);
            }, result, seq(sequence));
        }, list(), sequences));
    };
var seq = exports.seq = function seq(sequence) {
        return isNil(sequence) ? void 0 : isVector(sequence) || isList(sequence) || isLazySeq(sequence) ? sequence : isString(sequence) ? Array.prototype.slice.call(sequence) : isDictionary(sequence) ? keyValues(sequence) : 'default' ? (function () {
            throw TypeError('' + 'Can not seq ' + sequence);
        })() : void 0;
    };
var isSeq = exports.isSeq = function isSeq(sequence) {
        return isList(sequence) || isLazySeq(sequence);
    };
var listToVector = function listToVector(source) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var listø1 = source;
        do {
            recur = isEmpty(listø1) ? resultø1 : (loop[0] = (function () {
                resultø1.push(first(listø1));
                return resultø1;
            })(), loop[1] = rest(listø1), loop);
        } while (resultø1 = loop[0], listø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var vec = exports.vec = function vec(sequence) {
        return isNil(sequence) ? [] : isVector(sequence) ? sequence : isList(sequence) ? listToVector(sequence) : 'else' ? vec(seq(sequence)) : void 0;
    };
var sort = exports.sort = function sort(f, items) {
        return function () {
            var hasComparatorø1 = isFn(f);
            var itemsø2 = !hasComparatorø1 && isNil(items) ? f : items;
            var compareø1 = hasComparatorø1 ? function (a, b) {
                    return f(a, b) ? 0 : 1;
                } : void 0;
            return isNil(itemsø2) ? list() : isVector(itemsø2) ? itemsø2.sort(compareø1) : isList(itemsø2) ? list.apply(void 0, vec(itemsø2).sort(compareø1)) : isDictionary(itemsø2) ? seq(itemsø2).sort(compareø1) : 'else' ? sort(f, seq(itemsø2)) : void 0;
        }.call(this);
    };
var repeat = exports.repeat = function repeat(n, x) {
        return function loop() {
            var recur = loop;
            var nø2 = n;
            var resultø1 = [];
            do {
                recur = nø2 <= 0 ? resultø1 : (loop[0] = dec(nø2), loop[1] = conj(resultø1, x), loop);
            } while (nø2 = loop[0], resultø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var isEvery = exports.isEvery = function isEvery(predicate, sequence) {
        return vec(sequence).every(function ($1) {
            return predicate($1);
        });
    };
var some = exports.some = function some(predicate, sequence) {
        return function loop() {
            var recur = loop;
            var itemsø1 = sequence;
            do {
                recur = isEmpty(itemsø1) ? false : predicate(first(itemsø1)) ? true : 'else' ? (loop[0] = rest(itemsø1), loop) : void 0;
            } while (itemsø1 = loop[0], recur === loop);
            return recur;
        }.call(this);
    };
var partition = exports.partition = function partition() {
        switch (arguments.length) {
        case 2:
            var n = arguments[0];
            var coll = arguments[1];
            return partition(n, n, coll);
        case 3:
            var n = arguments[0];
            var step = arguments[1];
            var coll = arguments[2];
            return partition(n, step, [], coll);
        case 4:
            var n = arguments[0];
            var step = arguments[1];
            var pad = arguments[2];
            var coll = arguments[3];
            return function loop() {
                var recur = loop;
                var resultø1 = [];
                var itemsø1 = seq(coll);
                do {
                    recur = function () {
                        var chunkø1 = take(n, itemsø1);
                        var sizeø1 = count(chunkø1);
                        return sizeø1 === n ? (loop[0] = conj(resultø1, chunkø1), loop[1] = drop(step, itemsø1), loop) : 0 === sizeø1 ? resultø1 : n > sizeø1 + count(pad) ? resultø1 : 'else' ? conj(resultø1, take(n, vec(concat(chunkø1, pad)))) : void 0;
                    }.call(this);
                } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
                return recur;
            }.call(this);
        default:
            throw RangeError('Wrong number of arguments passed');
        }
    };
var interleave = exports.interleave = function interleave() {
        switch (arguments.length) {
        case 2:
            var ax = arguments[0];
            var bx = arguments[1];
            return function loop() {
                var recur = loop;
                var cxø1 = [];
                var axø2 = ax;
                var bxø2 = bx;
                do {
                    recur = isEmpty(axø2) || isEmpty(bxø2) ? seq(cxø1) : (loop[0] = conj(cxø1, first(axø2), first(bxø2)), loop[1] = rest(axø2), loop[2] = rest(bxø2), loop);
                } while (cxø1 = loop[0], axø2 = loop[1], bxø2 = loop[2], recur === loop);
                return recur;
            }.call(this);
        default:
            var sequences = Array.prototype.slice.call(arguments, 0);
            return function loop() {
                var recur = loop;
                var resultø1 = [];
                var sequencesø2 = sequences;
                do {
                    recur = some(isEmpty, sequencesø2) ? resultø1 : (loop[0] = concat(resultø1, map(first, sequencesø2)), loop[1] = map(rest, sequencesø2), loop);
                } while (resultø1 = loop[0], sequencesø2 = loop[1], recur === loop);
                return recur;
            }.call(this);
        }
    };
var nth = exports.nth = function nth(sequence, index, notFound) {
        return isNil(sequence) ? notFound : isList(sequence) ? index < count(sequence) ? first(drop(index, sequence)) : notFound : isVector(sequence) || isString(sequence) ? index < count(sequence) ? sequence[index] : notFound : isLazySeq(sequence) ? nth(lazySeqValue(sequence), index, notFound) : 'else' ? (function () {
            throw TypeError('Unsupported type');
        })() : void 0;
    };
//# sourceMappingURL=data:application/json;base64,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
