{
    var _ns_ = {
        id: 'wisp.backend.escodegen.writer',
        doc: void 0
    };
    var wisp_reader = require('./../../reader');
    var readFromString = wisp_reader.readFromString;
    var wisp_ast = require('./../../ast');
    var meta = wisp_ast.meta;
    var withMeta = wisp_ast.withMeta;
    var isSymbol = wisp_ast.isSymbol;
    var symbol = wisp_ast.symbol;
    var isKeyword = wisp_ast.isKeyword;
    var keyword = wisp_ast.keyword;
    var namespace = wisp_ast.namespace;
    var isUnquote = wisp_ast.isUnquote;
    var isUnquoteSplicing = wisp_ast.isUnquoteSplicing;
    var isQuote = wisp_ast.isQuote;
    var isSyntaxQuote = wisp_ast.isSyntaxQuote;
    var name = wisp_ast.name;
    var gensym = wisp_ast.gensym;
    var prStr = wisp_ast.prStr;
    var wisp_sequence = require('./../../sequence');
    var isEmpty = wisp_sequence.isEmpty;
    var count = wisp_sequence.count;
    var isList = wisp_sequence.isList;
    var list = wisp_sequence.list;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var cons = wisp_sequence.cons;
    var conj = wisp_sequence.conj;
    var butlast = wisp_sequence.butlast;
    var reverse = wisp_sequence.reverse;
    var reduce = wisp_sequence.reduce;
    var vec = wisp_sequence.vec;
    var last = wisp_sequence.last;
    var map = wisp_sequence.map;
    var filter = wisp_sequence.filter;
    var take = wisp_sequence.take;
    var concat = wisp_sequence.concat;
    var partition = wisp_sequence.partition;
    var repeat = wisp_sequence.repeat;
    var interleave = wisp_sequence.interleave;
    var assoc = wisp_sequence.assoc;
    var wisp_runtime = require('./../../runtime');
    var isOdd = wisp_runtime.isOdd;
    var isDictionary = wisp_runtime.isDictionary;
    var dictionary = wisp_runtime.dictionary;
    var merge = wisp_runtime.merge;
    var keys = wisp_runtime.keys;
    var vals = wisp_runtime.vals;
    var isContainsVector = wisp_runtime.isContainsVector;
    var mapDictionary = wisp_runtime.mapDictionary;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isVector = wisp_runtime.isVector;
    var isBoolean = wisp_runtime.isBoolean;
    var subs = wisp_runtime.subs;
    var reFind = wisp_runtime.reFind;
    var isTrue = wisp_runtime.isTrue;
    var isFalse = wisp_runtime.isFalse;
    var isNil = wisp_runtime.isNil;
    var isRePattern = wisp_runtime.isRePattern;
    var inc = wisp_runtime.inc;
    var dec = wisp_runtime.dec;
    var str = wisp_runtime.str;
    var char = wisp_runtime.char;
    var int = wisp_runtime.int;
    var isEqual = wisp_runtime.isEqual;
    var isStrictEqual = wisp_runtime.isStrictEqual;
    var wisp_string = require('./../../string');
    var split = wisp_string.split;
    var join = wisp_string.join;
    var upperCase = wisp_string.upperCase;
    var replace = wisp_string.replace;
    var triml = wisp_string.triml;
    var wisp_expander = require('./../../expander');
    var installMacro = wisp_expander.installMacro;
    var escodegen = require('escodegen');
    var generate = escodegen.generate;
}
var __uniqueChar__ = exports.__uniqueChar__ = 'ø';
var toCamelJoin = exports.toCamelJoin = function toCamelJoin(prefix, key) {
    return '' + prefix + (!isEmpty(prefix) && !isEmpty(key) ? '' + upperCase((key || 0)[0]) + subs(key, 1) : key);
};
var toPrivatePrefix = exports.toPrivatePrefix = function toPrivatePrefix(id) {
    return function () {
        var spaceDelimitedø1 = join(' ', split(id, /-/));
        var leftTrimmedø1 = triml(spaceDelimitedø1);
        var nø1 = count(id) - count(leftTrimmedø1);
        return nø1 > 0 ? '' + join('_', repeat(inc(nø1), '')) + subs(id, nø1) : id;
    }.call(this);
};
var translateIdentifierWord = exports.translateIdentifierWord = function translateIdentifierWord(form) {
    var id = name(form);
    id = id === '*' ? 'multiply' : id === '/' ? 'divide' : id === '+' ? 'sum' : id === '-' ? 'subtract' : id === '=' ? 'equal?' : id === '==' ? 'strict-equal?' : id === '<=' ? 'not-greater-than' : id === '>=' ? 'not-less-than' : id === '>' ? 'greater-than' : id === '<' ? 'less-than' : id === '->' ? 'thread-first' : 'else' ? id : void 0;
    id = join('_', split(id, '*'));
    id = join('_', split(id, '.'));
    id = subs(id, 0, 2) === '->' ? subs(join('-to-', split(id, '->')), 1) : join('-to-', split(id, '->'));
    id = join(split(id, '!'));
    id = join('$', split(id, '%'));
    id = join('-equal-', split(id, '='));
    id = join('-plus-', split(id, '+'));
    id = join('-and-', split(id, '&'));
    id = last(id) === '?' ? '' + 'is-' + subs(id, 0, dec(count(id))) : id;
    id = toPrivatePrefix(id);
    id = reduce(toCamelJoin, '', split(id, '-'));
    return id;
};
var translateIdentifier = exports.translateIdentifier = function translateIdentifier(form) {
    return function () {
        var nsø1 = namespace(form);
        return '' + (nsø1 && !isEqual(nsø1, 'js') ? '' + translateIdentifierWord(namespace(form)) + '.' : '') + join('.', map(translateIdentifierWord, split(name(form), '.')));
    }.call(this);
};
var errorArgCount = exports.errorArgCount = function errorArgCount(callee, n) {
    return (function () {
        throw SyntaxError('' + 'Wrong number of arguments (' + n + ') passed to: ' + callee);
    })();
};
var inheritLocation = exports.inheritLocation = function inheritLocation(body) {
    return function () {
        var startø1 = ((first(body) || 0)['loc'] || 0)['start'];
        var endø1 = ((last(body) || 0)['loc'] || 0)['end'];
        return !(isNil(startø1) || isNil(endø1)) ? {
            'start': startø1,
            'end': endø1
        } : void 0;
    }.call(this);
};
var writeLocation = exports.writeLocation = function writeLocation(form, original) {
    return function () {
        var dataø1 = meta(form);
        var inheritedø1 = meta(original);
        var startø1 = (form || 0)['start'] || (dataø1 || 0)['start'] || (inheritedø1 || 0)['start'];
        var endø1 = (form || 0)['end'] || (dataø1 || 0)['end'] || (inheritedø1 || 0)['end'];
        return !isNil(startø1) ? {
            'loc': {
                'start': {
                    'line': inc((startø1 || 0)['line']),
                    'column': (startø1 || 0)['column']
                },
                'end': {
                    'line': inc((endø1 || 0)['line']),
                    'column': (endø1 || 0)['column']
                }
            }
        } : {};
    }.call(this);
};
var __writers__ = exports.__writers__ = {};
var installWriter = exports.installWriter = function installWriter(op, writer) {
    return (__writers__ || 0)[op] = writer;
};
var writeOp = exports.writeOp = function writeOp(op, form) {
    return function () {
        var writerø1 = (__writers__ || 0)[op];
        !writerø1 ? (function () {
            throw Error('' + 'Assert failed: ' + ('' + 'Unsupported operation: ' + op) + 'writer');
        })() : void 0;
        return conj(writeLocation((form || 0)['form'], (form || 0)['original-form']), writerø1(form));
    }.call(this);
};
var __specials__ = exports.__specials__ = {};
var installSpecial = exports.installSpecial = function installSpecial(op, writer) {
    return (__specials__ || 0)[name(op)] = writer;
};
var writeSpecial = exports.writeSpecial = function writeSpecial(writer, form) {
    return conj(writeLocation((form || 0)['form'], (form || 0)['original-form']), writer.apply(void 0, (form || 0)['params']));
};
var writeNil = exports.writeNil = function writeNil(form) {
    return {
        'type': 'UnaryExpression',
        'operator': 'void',
        'argument': {
            'type': 'Literal',
            'value': 0
        },
        'prefix': true
    };
};
installWriter('nil', writeNil);
var writeLiteral = exports.writeLiteral = function writeLiteral(form) {
    return {
        'type': 'Literal',
        'value': form
    };
};
var writeList = exports.writeList = function writeList(form) {
    return {
        'type': 'CallExpression',
        'callee': write({
            'op': 'var',
            'form': symbol(void 0, 'list')
        }),
        'arguments': map(write, (form || 0)['items'])
    };
};
installWriter('list', writeList);
var writeSymbol = exports.writeSymbol = function writeSymbol(form) {
    return {
        'type': 'CallExpression',
        'callee': write({
            'op': 'var',
            'form': symbol(void 0, 'symbol')
        }),
        'arguments': [
            writeConstant((form || 0)['namespace']),
            writeConstant((form || 0)['name'])
        ]
    };
};
installWriter('symbol', writeSymbol);
var writeConstant = exports.writeConstant = function writeConstant(form) {
    return isNil(form) ? writeNil(form) : isKeyword(form) ? writeLiteral(namespace(form) ? '' + namespace(form) + '/' + name(form) : name(form)) : isNumber(form) ? writeNumber(form.valueOf()) : isString(form) ? writeString(form) : 'else' ? writeLiteral(form) : void 0;
};
installWriter('constant', function ($1) {
    return writeConstant(($1 || 0)['form']);
});
var writeString = exports.writeString = function writeString(form) {
    return {
        'type': 'Literal',
        'value': '' + form
    };
};
var writeNumber = exports.writeNumber = function writeNumber(form) {
    return form < 0 ? {
        'type': 'UnaryExpression',
        'operator': '-',
        'prefix': true,
        'argument': writeNumber(form * -1)
    } : writeLiteral(form);
};
var writeKeyword = exports.writeKeyword = function writeKeyword(form) {
    return {
        'type': 'Literal',
        'value': (form || 0)['form']
    };
};
installWriter('keyword', writeKeyword);
var toIdentifier = exports.toIdentifier = function toIdentifier(form) {
    return {
        'type': 'Identifier',
        'name': translateIdentifier(form)
    };
};
var writeBindingVar = exports.writeBindingVar = function writeBindingVar(form) {
    return function () {
        var baseIdø1 = (form || 0)['id'];
        var resolvedIdø1 = (form || 0)['shadow'] ? symbol(void 0, '' + translateIdentifier(baseIdø1) + __uniqueChar__ + (form || 0)['depth']) : baseIdø1;
        return conj(toIdentifier(resolvedIdø1), writeLocation(baseIdø1));
    }.call(this);
};
var writeVar = exports.writeVar = function writeVar(node) {
    return isEqual('binding', ((node || 0)['binding'] || 0)['type']) ? conj(writeBindingVar((node || 0)['binding']), writeLocation((node || 0)['form'])) : conj(writeLocation((node || 0)['form']), toIdentifier((node || 0)['form']));
};
installWriter('var', writeVar);
installWriter('param', writeVar);
var writeInvoke = exports.writeInvoke = function writeInvoke(form) {
    return {
        'type': 'CallExpression',
        'callee': write((form || 0)['callee']),
        'arguments': map(write, (form || 0)['params'])
    };
};
installWriter('invoke', writeInvoke);
var writeVector = exports.writeVector = function writeVector(form) {
    return {
        'type': 'ArrayExpression',
        'elements': map(write, (form || 0)['items'])
    };
};
installWriter('vector', writeVector);
var writeDictionary = exports.writeDictionary = function writeDictionary(form) {
    return function () {
        var propertiesø1 = partition(2, interleave((form || 0)['keys'], (form || 0)['values']));
        return {
            'type': 'ObjectExpression',
            'properties': map(function (pair) {
                return function () {
                    var keyø1 = first(pair);
                    var valueø1 = second(pair);
                    return {
                        'kind': 'init',
                        'type': 'Property',
                        'key': isEqual('symbol', (keyø1 || 0)['op']) ? writeConstant('' + (keyø1 || 0)['form']) : write(keyø1),
                        'value': write(valueø1)
                    };
                }.call(this);
            }, propertiesø1)
        };
    }.call(this);
};
installWriter('dictionary', writeDictionary);
var writeExport = exports.writeExport = function writeExport(form) {
    return write({
        'op': 'set!',
        'target': {
            'op': 'member-expression',
            'computed': false,
            'target': {
                'op': 'var',
                'form': withMeta(symbol(void 0, 'exports'), meta(((form || 0)['id'] || 0)['form']))
            },
            'property': (form || 0)['id'],
            'form': ((form || 0)['id'] || 0)['form']
        },
        'value': (form || 0)['init'],
        'form': ((form || 0)['id'] || 0)['form']
    });
};
var writeDef = exports.writeDef = function writeDef(form) {
    return conj({
        'type': 'VariableDeclaration',
        'kind': 'var',
        'declarations': [conj({
                'type': 'VariableDeclarator',
                'id': write((form || 0)['id']),
                'init': conj((form || 0)['export'] ? writeExport(form) : write((form || 0)['init']))
            }, writeLocation(((form || 0)['id'] || 0)['form']))]
    }, writeLocation((form || 0)['form'], (form || 0)['original-form']));
};
installWriter('def', writeDef);
var writeBinding = exports.writeBinding = function writeBinding(form) {
    return function () {
        var idø1 = writeBindingVar(form);
        var initø1 = write((form || 0)['init']);
        return {
            'type': 'VariableDeclaration',
            'kind': 'var',
            'loc': inheritLocation([
                idø1,
                initø1
            ]),
            'declarations': [{
                    'type': 'VariableDeclarator',
                    'id': idø1,
                    'init': initø1
                }]
        };
    }.call(this);
};
installWriter('binding', writeBinding);
var writeThrow = exports.writeThrow = function writeThrow(form) {
    return toExpression(conj({
        'type': 'ThrowStatement',
        'argument': write((form || 0)['throw'])
    }, writeLocation((form || 0)['form'], (form || 0)['original-form'])));
};
installWriter('throw', writeThrow);
var writeNew = exports.writeNew = function writeNew(form) {
    return {
        'type': 'NewExpression',
        'callee': write((form || 0)['constructor']),
        'arguments': map(write, (form || 0)['params'])
    };
};
installWriter('new', writeNew);
var writeSet = exports.writeSet = function writeSet(form) {
    return {
        'type': 'AssignmentExpression',
        'operator': '=',
        'left': write((form || 0)['target']),
        'right': write((form || 0)['value'])
    };
};
installWriter('set!', writeSet);
var writeAget = exports.writeAget = function writeAget(form) {
    return {
        'type': 'MemberExpression',
        'computed': (form || 0)['computed'],
        'object': write((form || 0)['target']),
        'property': write((form || 0)['property'])
    };
};
installWriter('member-expression', writeAget);
var __statements__ = exports.__statements__ = {
    'EmptyStatement': true,
    'BlockStatement': true,
    'ExpressionStatement': true,
    'IfStatement': true,
    'LabeledStatement': true,
    'BreakStatement': true,
    'ContinueStatement': true,
    'SwitchStatement': true,
    'ReturnStatement': true,
    'ThrowStatement': true,
    'TryStatement': true,
    'WhileStatement': true,
    'DoWhileStatement': true,
    'ForStatement': true,
    'ForInStatement': true,
    'ForOfStatement': true,
    'LetStatement': true,
    'VariableDeclaration': true,
    'FunctionDeclaration': true
};
var writeStatement = exports.writeStatement = function writeStatement(form) {
    return toStatement(write(form));
};
var toStatement = exports.toStatement = function toStatement(node) {
    return (__statements__ || 0)[(node || 0)['type']] ? node : {
        'type': 'ExpressionStatement',
        'expression': node,
        'loc': (node || 0)['loc']
    };
};
var toReturn = exports.toReturn = function toReturn(form) {
    return conj({
        'type': 'ReturnStatement',
        'argument': write(form)
    }, writeLocation((form || 0)['form'], (form || 0)['original-form']));
};
var writeBody = exports.writeBody = function writeBody(form) {
    return function () {
        var statementsø1 = map(writeStatement, (form || 0)['statements'] || []);
        var resultø1 = (form || 0)['result'] ? toReturn((form || 0)['result']) : void 0;
        return resultø1 ? conj(statementsø1, resultø1) : statementsø1;
    }.call(this);
};
var toBlock = exports.toBlock = function toBlock(body) {
    return isVector(body) ? {
        'type': 'BlockStatement',
        'body': body,
        'loc': inheritLocation(body)
    } : {
        'type': 'BlockStatement',
        'body': [body],
        'loc': (body || 0)['loc']
    };
};
var toExpression = exports.toExpression = function toExpression() {
    var body = Array.prototype.slice.call(arguments, 0);
    return {
        'type': 'CallExpression',
        'arguments': [],
        'loc': inheritLocation(body),
        'callee': toSequence([{
                'type': 'FunctionExpression',
                'id': void 0,
                'params': [],
                'defaults': [],
                'expression': false,
                'generator': false,
                'rest': void 0,
                'body': toBlock(body)
            }])
    };
};
var writeDo = exports.writeDo = function writeDo(form) {
    return (meta(first((form || 0)['form'])) || 0)['block'] ? toBlock(writeBody(conj(form, {
        'result': void 0,
        'statements': conj((form || 0)['statements'], (form || 0)['result'])
    }))) : toExpression.apply(void 0, writeBody(form));
};
installWriter('do', writeDo);
var writeIf = exports.writeIf = function writeIf(form) {
    return {
        'type': 'ConditionalExpression',
        'test': write((form || 0)['test']),
        'consequent': write((form || 0)['consequent']),
        'alternate': write((form || 0)['alternate'])
    };
};
installWriter('if', writeIf);
var writeTry = exports.writeTry = function writeTry(form) {
    return function () {
        var handlerø1 = (form || 0)['handler'];
        var finalizerø1 = (form || 0)['finalizer'];
        return toExpression(conj({
            'type': 'TryStatement',
            'guardedHandlers': [],
            'block': toBlock(writeBody((form || 0)['body'])),
            'handlers': handlerø1 ? [{
                    'type': 'CatchClause',
                    'param': write((handlerø1 || 0)['name']),
                    'body': toBlock(writeBody(handlerø1))
                }] : [],
            'finalizer': finalizerø1 ? toBlock(writeBody(finalizerø1)) : !handlerø1 ? toBlock([]) : 'else' ? void 0 : void 0
        }, writeLocation((form || 0)['form'], (form || 0)['original-form'])));
    }.call(this);
};
installWriter('try', writeTry);
var writeBindingValue = function writeBindingValue(form) {
    return write((form || 0)['init']);
};
var writeBindingParam = function writeBindingParam(form) {
    return writeVar({ 'form': (form || 0)['name'] });
};
var writeBinding = exports.writeBinding = function writeBinding(form) {
    return write({
        'op': 'def',
        'var': form,
        'init': (form || 0)['init'],
        'form': form
    });
};
var writeLet = exports.writeLet = function writeLet(form) {
    return function () {
        var bodyø1 = conj(form, { 'statements': vec(concat((form || 0)['bindings'], (form || 0)['statements'])) });
        return toIife(toBlock(writeBody(bodyø1)));
    }.call(this);
};
installWriter('let', writeLet);
var toRebind = exports.toRebind = function toRebind(form) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var bindingsø1 = (form || 0)['bindings'];
        do {
            recur = isEmpty(bindingsø1) ? resultø1 : (loop[0] = conj(resultø1, {
                'type': 'AssignmentExpression',
                'operator': '=',
                'left': writeBindingVar(first(bindingsø1)),
                'right': {
                    'type': 'MemberExpression',
                    'computed': true,
                    'object': {
                        'type': 'Identifier',
                        'name': 'loop'
                    },
                    'property': {
                        'type': 'Literal',
                        'value': count(resultø1)
                    }
                }
            }), loop[1] = rest(bindingsø1), loop);
        } while (resultø1 = loop[0], bindingsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var toSequence = exports.toSequence = function toSequence(expressions) {
    return {
        'type': 'SequenceExpression',
        'expressions': expressions
    };
};
var toIife = exports.toIife = function toIife(body, id) {
    return {
        'type': 'CallExpression',
        'arguments': [{ 'type': 'ThisExpression' }],
        'callee': {
            'type': 'MemberExpression',
            'computed': false,
            'object': {
                'type': 'FunctionExpression',
                'id': id,
                'params': [],
                'defaults': [],
                'expression': false,
                'generator': false,
                'rest': void 0,
                'body': body
            },
            'property': {
                'type': 'Identifier',
                'name': 'call'
            }
        }
    };
};
var toLoopInit = exports.toLoopInit = function toLoopInit() {
    return {
        'type': 'VariableDeclaration',
        'kind': 'var',
        'declarations': [{
                'type': 'VariableDeclarator',
                'id': {
                    'type': 'Identifier',
                    'name': 'recur'
                },
                'init': {
                    'type': 'Identifier',
                    'name': 'loop'
                }
            }]
    };
};
var toDoWhile = exports.toDoWhile = function toDoWhile(body, test) {
    return {
        'type': 'DoWhileStatement',
        'body': body,
        'test': test
    };
};
var toSetRecur = exports.toSetRecur = function toSetRecur(form) {
    return {
        'type': 'AssignmentExpression',
        'operator': '=',
        'left': {
            'type': 'Identifier',
            'name': 'recur'
        },
        'right': write(form)
    };
};
var toLoop = exports.toLoop = function toLoop(form) {
    return toSequence(conj(toRebind(form), {
        'type': 'BinaryExpression',
        'operator': '===',
        'left': {
            'type': 'Identifier',
            'name': 'recur'
        },
        'right': {
            'type': 'Identifier',
            'name': 'loop'
        }
    }));
};
var writeLoop = exports.writeLoop = function writeLoop(form) {
    return function () {
        var statementsø1 = (form || 0)['statements'];
        var resultø1 = (form || 0)['result'];
        var bindingsø1 = (form || 0)['bindings'];
        var loopBodyø1 = conj(map(writeStatement, statementsø1), toStatement(toSetRecur(resultø1)));
        var bodyø1 = concat([toLoopInit()], map(write, bindingsø1), [toDoWhile(toBlock(vec(loopBodyø1)), toLoop(form))], [{
                'type': 'ReturnStatement',
                'argument': {
                    'type': 'Identifier',
                    'name': 'recur'
                }
            }]);
        return toIife(toBlock(vec(bodyø1)), symbol(void 0, 'loop'));
    }.call(this);
};
installWriter('loop', writeLoop);
var toRecur = exports.toRecur = function toRecur(form) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var paramsø1 = (form || 0)['params'];
        do {
            recur = isEmpty(paramsø1) ? resultø1 : (loop[0] = conj(resultø1, {
                'type': 'AssignmentExpression',
                'operator': '=',
                'right': write(first(paramsø1)),
                'left': {
                    'type': 'MemberExpression',
                    'computed': true,
                    'object': {
                        'type': 'Identifier',
                        'name': 'loop'
                    },
                    'property': {
                        'type': 'Literal',
                        'value': count(resultø1)
                    }
                }
            }), loop[1] = rest(paramsø1), loop);
        } while (resultø1 = loop[0], paramsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var writeRecur = exports.writeRecur = function writeRecur(form) {
    return toSequence(conj(toRecur(form), {
        'type': 'Identifier',
        'name': 'loop'
    }));
};
installWriter('recur', writeRecur);
var fallbackOverload = exports.fallbackOverload = function fallbackOverload() {
    return {
        'type': 'SwitchCase',
        'test': void 0,
        'consequent': [{
                'type': 'ThrowStatement',
                'argument': {
                    'type': 'CallExpression',
                    'callee': {
                        'type': 'Identifier',
                        'name': 'RangeError'
                    },
                    'arguments': [{
                            'type': 'Literal',
                            'value': 'Wrong number of arguments passed'
                        }]
                }
            }]
    };
};
var spliceBinding = exports.spliceBinding = function spliceBinding(form) {
    return {
        'op': 'def',
        'id': last((form || 0)['params']),
        'init': {
            'op': 'invoke',
            'callee': {
                'op': 'var',
                'form': symbol(void 0, 'Array.prototype.slice.call')
            },
            'params': [
                {
                    'op': 'var',
                    'form': symbol(void 0, 'arguments')
                },
                {
                    'op': 'constant',
                    'form': (form || 0)['arity'],
                    'type': 'number'
                }
            ]
        }
    };
};
var writeOverloadingParams = exports.writeOverloadingParams = function writeOverloadingParams(params) {
    return reduce(function (forms, param) {
        return conj(forms, {
            'op': 'def',
            'id': param,
            'init': {
                'op': 'member-expression',
                'computed': true,
                'target': {
                    'op': 'var',
                    'form': symbol(void 0, 'arguments')
                },
                'property': {
                    'op': 'constant',
                    'type': 'number',
                    'form': count(forms)
                }
            }
        });
    }, [], params);
};
var writeOverloadingFn = exports.writeOverloadingFn = function writeOverloadingFn(form) {
    return function () {
        var overloadsø1 = map(writeFnOverload, (form || 0)['methods']);
        return {
            'params': [],
            'body': toBlock({
                'type': 'SwitchStatement',
                'discriminant': {
                    'type': 'MemberExpression',
                    'computed': false,
                    'object': {
                        'type': 'Identifier',
                        'name': 'arguments'
                    },
                    'property': {
                        'type': 'Identifier',
                        'name': 'length'
                    }
                },
                'cases': (form || 0)['variadic'] ? overloadsø1 : conj(overloadsø1, fallbackOverload())
            })
        };
    }.call(this);
};
var writeFnOverload = exports.writeFnOverload = function writeFnOverload(form) {
    return function () {
        var paramsø1 = (form || 0)['params'];
        var bindingsø1 = (form || 0)['variadic'] ? conj(writeOverloadingParams(butlast(paramsø1)), spliceBinding(form)) : writeOverloadingParams(paramsø1);
        var statementsø1 = vec(concat(bindingsø1, (form || 0)['statements']));
        return {
            'type': 'SwitchCase',
            'test': !(form || 0)['variadic'] ? {
                'type': 'Literal',
                'value': (form || 0)['arity']
            } : void 0,
            'consequent': writeBody(conj(form, { 'statements': statementsø1 }))
        };
    }.call(this);
};
var writeSimpleFn = exports.writeSimpleFn = function writeSimpleFn(form) {
    return function () {
        var methodø1 = first((form || 0)['methods']);
        var paramsø1 = (methodø1 || 0)['variadic'] ? butlast((methodø1 || 0)['params']) : (methodø1 || 0)['params'];
        var bodyø1 = (methodø1 || 0)['variadic'] ? conj(methodø1, { 'statements': vec(cons(spliceBinding(methodø1), (methodø1 || 0)['statements'])) }) : methodø1;
        return {
            'params': map(writeVar, paramsø1),
            'body': toBlock(writeBody(bodyø1))
        };
    }.call(this);
};
var resolve = exports.resolve = function resolve(from, to) {
    return function () {
        var requirerø1 = split(name(from), '.');
        var requirementø1 = split(name(to), '.');
        var isRelativeø1 = !(name(from) === name(to)) && first(requirerø1) === first(requirementø1);
        return isRelativeø1 ? function loop() {
            var recur = loop;
            var fromø2 = requirerø1;
            var toø2 = requirementø1;
            do {
                recur = first(fromø2) === first(toø2) ? (loop[0] = rest(fromø2), loop[1] = rest(toø2), loop) : join('/', concat(['.'], repeat(dec(count(fromø2)), '..'), toø2));
            } while (fromø2 = loop[0], toø2 = loop[1], recur === loop);
            return recur;
        }.call(this) : join('/', requirementø1);
    }.call(this);
};
var idToNs = exports.idToNs = function idToNs(id) {
    return symbol(void 0, join('*', split(name(id), '.')));
};
var writeRequire = exports.writeRequire = function writeRequire(form, requirer) {
    return function () {
        var nsBindingø1 = {
            'op': 'def',
            'id': {
                'op': 'var',
                'type': 'identifier',
                'form': idToNs((form || 0)['ns'])
            },
            'init': {
                'op': 'invoke',
                'callee': {
                    'op': 'var',
                    'type': 'identifier',
                    'form': symbol(void 0, 'require')
                },
                'params': [{
                        'op': 'constant',
                        'form': resolve(requirer, (form || 0)['ns'])
                    }]
            }
        };
        var nsAliasø1 = (form || 0)['alias'] ? {
            'op': 'def',
            'id': {
                'op': 'var',
                'type': 'identifier',
                'form': idToNs((form || 0)['alias'])
            },
            'init': (nsBindingø1 || 0)['id']
        } : void 0;
        var referencesø1 = reduce(function (references, form) {
            return conj(references, {
                'op': 'def',
                'id': {
                    'op': 'var',
                    'type': 'identifier',
                    'form': (form || 0)['rename'] || (form || 0)['name']
                },
                'init': {
                    'op': 'member-expression',
                    'computed': false,
                    'target': (nsBindingø1 || 0)['id'],
                    'property': {
                        'op': 'var',
                        'type': 'identifier',
                        'form': (form || 0)['name']
                    }
                }
            });
        }, [], (form || 0)['refer']);
        return vec(cons(nsBindingø1, nsAliasø1 ? cons(nsAliasø1, referencesø1) : referencesø1));
    }.call(this);
};
var writeNs = exports.writeNs = function writeNs(form) {
    return function () {
        var nodeø1 = (form || 0)['form'];
        var requirerø1 = (form || 0)['name'];
        var nsBindingø1 = {
            'op': 'def',
            'original-form': nodeø1,
            'id': {
                'op': 'var',
                'type': 'identifier',
                'original-form': first(nodeø1),
                'form': symbol(void 0, '*ns*')
            },
            'init': {
                'op': 'dictionary',
                'form': nodeø1,
                'keys': [
                    {
                        'op': 'var',
                        'type': 'identifier',
                        'original-form': nodeø1,
                        'form': symbol(void 0, 'id')
                    },
                    {
                        'op': 'var',
                        'type': 'identifier',
                        'original-form': nodeø1,
                        'form': symbol(void 0, 'doc')
                    }
                ],
                'values': [
                    {
                        'op': 'constant',
                        'type': 'identifier',
                        'original-form': (form || 0)['name'],
                        'form': name((form || 0)['name'])
                    },
                    {
                        'op': 'constant',
                        'original-form': nodeø1,
                        'form': (form || 0)['doc']
                    }
                ]
            }
        };
        var requirementsø1 = vec(concat.apply(void 0, map(function ($1) {
            return writeRequire($1, requirerø1);
        }, (form || 0)['require'])));
        return toBlock(map(write, vec(cons(nsBindingø1, requirementsø1))));
    }.call(this);
};
installWriter('ns', writeNs);
var writeFn = exports.writeFn = function writeFn(form) {
    return function () {
        var baseø1 = count((form || 0)['methods']) > 1 ? writeOverloadingFn(form) : writeSimpleFn(form);
        return conj(baseø1, {
            'type': 'FunctionExpression',
            'id': (form || 0)['id'] ? writeVar((form || 0)['id']) : void 0,
            'defaults': void 0,
            'rest': void 0,
            'generator': false,
            'expression': false
        });
    }.call(this);
};
installWriter('fn', writeFn);
var write = exports.write = function write(form) {
    return function () {
        var opø1 = (form || 0)['op'];
        var writerø1 = isEqual('invoke', (form || 0)['op']) && isEqual('var', ((form || 0)['callee'] || 0)['op']) && (__specials__ || 0)[name(((form || 0)['callee'] || 0)['form'])];
        return writerø1 ? writeSpecial(writerø1, form) : writeOp((form || 0)['op'], form);
    }.call(this);
};
var write_ = exports.write_ = function write_() {
    var forms = Array.prototype.slice.call(arguments, 0);
    return function () {
        var bodyø1 = map(writeStatement, forms);
        return {
            'type': 'Program',
            'body': bodyø1,
            'loc': inheritLocation(bodyø1)
        };
    }.call(this);
};
var compile = exports.compile = function compile() {
    switch (arguments.length) {
    case 1:
        var form = arguments[0];
        return compile({}, form);
    default:
        var options = arguments[0];
        var forms = Array.prototype.slice.call(arguments, 1);
        return generate(write_.apply(void 0, forms), options);
    }
};
var getMacro = exports.getMacro = function getMacro(target, property) {
    return list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, 'or')].concat([target], [0]))], [property]));
};
installMacro('get', getMacro);
var installLogicalOperator = exports.installLogicalOperator = function installLogicalOperator(callee, operator, fallback) {
    var writeLogicalOperator = function writeLogicalOperator() {
        var operands = Array.prototype.slice.call(arguments, 0);
        return function () {
            var nø1 = count(operands);
            return isEqual(nø1, 0) ? writeConstant(fallback) : isEqual(nø1, 1) ? write(first(operands)) : 'else' ? reduce(function (left, right) {
                return {
                    'type': 'LogicalExpression',
                    'operator': operator,
                    'left': left,
                    'right': write(right)
                };
            }, write(first(operands)), rest(operands)) : void 0;
        }.call(this);
    };
    return installSpecial(callee, writeLogicalOperator);
};
installLogicalOperator('or', '||', void 0);
installLogicalOperator('and', '&&', true);
var installUnaryOperator = exports.installUnaryOperator = function installUnaryOperator(callee, operator, isPrefix) {
    var writeUnaryOperator = function writeUnaryOperator() {
        var params = Array.prototype.slice.call(arguments, 0);
        return count(params) === 1 ? {
            'type': 'UnaryExpression',
            'operator': operator,
            'argument': write(first(params)),
            'prefix': isPrefix
        } : errorArgCount(callee, count(params));
    };
    return installSpecial(callee, writeUnaryOperator);
};
installUnaryOperator('not', '!');
installUnaryOperator('bit-not', '~');
var installBinaryOperator = exports.installBinaryOperator = function installBinaryOperator(callee, operator) {
    var writeBinaryOperator = function writeBinaryOperator() {
        var params = Array.prototype.slice.call(arguments, 0);
        return count(params) < 2 ? errorArgCount(callee, count(params)) : reduce(function (left, right) {
            return {
                'type': 'BinaryExpression',
                'operator': operator,
                'left': left,
                'right': write(right)
            };
        }, write(first(params)), rest(params));
    };
    return installSpecial(callee, writeBinaryOperator);
};
installBinaryOperator('bit-and', '&');
installBinaryOperator('bit-or', '|');
installBinaryOperator('bit-xor', '^');
installBinaryOperator('bit-shift-left', '<<');
installBinaryOperator('bit-shift-right', '>>');
installBinaryOperator('bit-shift-right-zero-fil', '>>>');
var installArithmeticOperator = exports.installArithmeticOperator = function installArithmeticOperator(callee, operator, isValid, fallback) {
    var writeBinaryOperator = function writeBinaryOperator(left, right) {
        return {
            'type': 'BinaryExpression',
            'operator': name(operator),
            'left': left,
            'right': write(right)
        };
    };
    var writeArithmeticOperator = function writeArithmeticOperator() {
        var params = Array.prototype.slice.call(arguments, 0);
        return function () {
            var nø1 = count(params);
            return isValid && !isValid(nø1) ? errorArgCount(name(callee), nø1) : nø1 == 0 ? writeLiteral(fallback) : nø1 == 1 ? reduce(writeBinaryOperator, writeLiteral(fallback), params) : 'else' ? reduce(writeBinaryOperator, write(first(params)), rest(params)) : void 0;
        }.call(this);
    };
    return installSpecial(callee, writeArithmeticOperator);
};
installArithmeticOperator('+', '+', void 0, 0);
installArithmeticOperator('-', '-', function ($1) {
    return $1 >= 1;
}, 0);
installArithmeticOperator('*', '*', void 0, 1);
installArithmeticOperator(keyword('/'), keyword('/'), function ($1) {
    return $1 >= 1;
}, 1);
installArithmeticOperator('mod', keyword('%'), function ($1) {
    return $1 == 2;
}, 1);
var installComparisonOperator = exports.installComparisonOperator = function installComparisonOperator(callee, operator, fallback) {
    var writeComparisonOperator = function writeComparisonOperator() {
        switch (arguments.length) {
        case 0:
            return errorArgCount(callee, 0);
        case 1:
            var form = arguments[0];
            return toSequence([
                write(form),
                writeLiteral(fallback)
            ]);
        case 2:
            var left = arguments[0];
            var right = arguments[1];
            return {
                'type': 'BinaryExpression',
                'operator': operator,
                'left': write(left),
                'right': write(right)
            };
        default:
            var left = arguments[0];
            var right = arguments[1];
            var more = Array.prototype.slice.call(arguments, 2);
            return reduce(function (left, right) {
                return {
                    'type': 'LogicalExpression',
                    'operator': '&&',
                    'left': left,
                    'right': {
                        'type': 'BinaryExpression',
                        'operator': operator,
                        'left': isEqual('LogicalExpression', (left || 0)['type']) ? ((left || 0)['right'] || 0)['right'] : (left || 0)['right'],
                        'right': write(right)
                    }
                };
            }, writeComparisonOperator(left, right), more);
        }
    };
    return installSpecial(callee, writeComparisonOperator);
};
installComparisonOperator('==', '==', true);
installComparisonOperator('>', '>', true);
installComparisonOperator('>=', '>=', true);
installComparisonOperator('<', '<', true);
installComparisonOperator('<=', '<=', true);
var isWriteIdentical = exports.isWriteIdentical = function isWriteIdentical() {
    var params = Array.prototype.slice.call(arguments, 0);
    return count(params) === 2 ? {
        'type': 'BinaryExpression',
        'operator': '===',
        'left': write(first(params)),
        'right': write(second(params))
    } : errorArgCount('identical?', count(params));
};
installSpecial('identical?', isWriteIdentical);
var isWriteInstance = exports.isWriteInstance = function isWriteInstance() {
    var params = Array.prototype.slice.call(arguments, 0);
    return function () {
        var constructorø1 = first(params);
        var instanceø1 = second(params);
        return count(params) < 1 ? errorArgCount('instance?', count(params)) : {
            'type': 'BinaryExpression',
            'operator': 'instanceof',
            'left': instanceø1 ? write(instanceø1) : writeConstant(instanceø1),
            'right': write(constructorø1)
        };
    }.call(this);
};
installSpecial('instance?', isWriteInstance);
var expandApply = exports.expandApply = function expandApply(f) {
    var params = Array.prototype.slice.call(arguments, 1);
    return function () {
        var prefixø1 = vec(butlast(params));
        return isEmpty(prefixø1) ? list.apply(void 0, [symbol(void 0, '.apply')].concat([f], [void 0], vec(params))) : list.apply(void 0, [symbol(void 0, '.apply')].concat([f], [void 0], [list.apply(void 0, [symbol(void 0, '.concat')].concat([prefixø1], [last(params)]))]));
    }.call(this);
};
installMacro('apply', expandApply);
var expandPrint = exports.expandPrint = function expandPrint(_andForm) {
    var more = Array.prototype.slice.call(arguments, 1);
    'Prints the object(s) to the output for human consumption.';
    return function () {
        var opø1 = withMeta(symbol(void 0, 'console.log'), meta(_andForm));
        return list.apply(void 0, [opø1].concat(vec(more)));
    }.call(this);
};
installMacro('print', withMeta(expandPrint, { 'implicit': ['&form'] }));
var expandStr = exports.expandStr = function expandStr() {
    var forms = Array.prototype.slice.call(arguments, 0);
    return list.apply(void 0, [symbol(void 0, '+')].concat([''], vec(forms)));
};
installMacro('str', expandStr);
var expandDebug = exports.expandDebug = function expandDebug() {
    return symbol(void 0, 'debugger');
};
installMacro('debugger!', expandDebug);
var expandAssert = exports.expandAssert = function expandAssert() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return expandAssert(x, '');
    case 2:
        var x = arguments[0];
        var message = arguments[1];
        return function () {
            var formø1 = prStr(x);
            return list.apply(void 0, [symbol(void 0, 'if')].concat([list.apply(void 0, [symbol(void 0, 'not')].concat([x]))], [list.apply(void 0, [symbol(void 0, 'throw')].concat([list.apply(void 0, [symbol(void 0, 'Error')].concat([list.apply(void 0, [symbol(void 0, 'str')].concat(['Assert failed: '], [message], [formø1]))]))]))]));
        }.call(this);
    default:
        throw RangeError('Wrong number of arguments passed');
    }
};
installMacro('assert', expandAssert);
var expandDefprotocol = exports.expandDefprotocol = function expandDefprotocol(_andEnv, id) {
    var forms = Array.prototype.slice.call(arguments, 2);
    return function () {
        var nsø1 = name(((_andEnv || 0)['ns'] || 0)['name']);
        var protocolNameø1 = name(id);
        var protocolDocø1 = isString(first(forms)) ? first(forms) : void 0;
        var protocolMethodsø1 = protocolDocø1 ? rest(forms) : forms;
        var protocolø1 = reduce(function (protocol, method) {
            return function () {
                var methodNameø1 = first(method);
                var idø2 = idToNs('' + nsø1 + '$' + protocolNameø1 + '$' + name(methodNameø1));
                return conj(protocol, {
                    'id': methodNameø1,
                    'fn': list.apply(void 0, [symbol(void 0, 'fn')].concat([idø2], [[symbol(void 0, 'self')].concat()], [list.apply(void 0, [symbol(void 0, 'def')].concat([symbol(void 0, 'f')], [list.apply(void 0, [symbol(void 0, 'cond')].concat([list.apply(void 0, [symbol(void 0, 'identical?')].concat([symbol(void 0, 'self')], [symbol(void 0, 'null')]))], [list.apply(void 0, [symbol(void 0, '.-nil')].concat([idø2]))], [list.apply(void 0, [symbol(void 0, 'identical?')].concat([symbol(void 0, 'self')], [void 0]))], [list.apply(void 0, [symbol(void 0, '.-nil')].concat([idø2]))], ['\uA789else'], [list.apply(void 0, [symbol(void 0, 'or')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([symbol(void 0, 'self')], [list.apply(void 0, [symbol(void 0, 'quote')].concat([idø2]))]))], [list.apply(void 0, [symbol(void 0, 'aget')].concat([idø2], [list.apply(void 0, [symbol(void 0, '.replace')].concat([list.apply(void 0, [symbol(void 0, '.replace')].concat([list.apply(void 0, [symbol(void 0, '.call')].concat([symbol(void 0, 'Object.prototype.toString')], [symbol(void 0, 'self')]))], ['[object '], ['']))], [/\]$/], ['']))]))], [list.apply(void 0, [symbol(void 0, '.-_')].concat([idø2]))]))]))]))], [list.apply(void 0, [symbol(void 0, '.apply')].concat([symbol(void 0, 'f')], [symbol(void 0, 'self')], [symbol(void 0, 'arguments')]))]))
                });
            }.call(this);
        }, [], protocolMethodsø1);
        var fnsø1 = map(function (form) {
            return list.apply(void 0, [symbol(void 0, 'def')].concat([(form || 0)['id']], [list.apply(void 0, [symbol(void 0, 'aget')].concat([id], [list.apply(void 0, [symbol(void 0, 'quote')].concat([(form || 0)['id']]))]))]));
        }, protocolø1);
        var satisfyø1 = assoc({}, symbol(void 0, 'wisp_core$IProtocol$id'), '' + nsø1 + '/' + protocolNameø1);
        var bodyø1 = reduce(function (body, method) {
            return assoc(body, (method || 0)['id'], (method || 0)['fn']);
        }, satisfyø1, protocolø1);
        return list.apply(void 0, [withMeta(symbol(void 0, 'do'), { 'block': true })].concat([list.apply(void 0, [symbol(void 0, 'def')].concat([id], [bodyø1]))], vec(fnsø1), [id]));
    }.call(this);
};
installMacro('defprotocol', withMeta(expandDefprotocol, { 'implicit': ['&env'] }));
var expandDeftype = exports.expandDeftype = function expandDeftype(id, fields) {
    var forms = Array.prototype.slice.call(arguments, 2);
    return function () {
        var typeInitø1 = map(function (field) {
            return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([symbol(void 0, 'this')], [list.apply(void 0, [symbol(void 0, 'quote')].concat([field]))]))], [field]));
        }, fields);
        var constructorø1 = conj(typeInitø1, symbol(void 0, 'this'));
        var methodInitø1 = map(function (field) {
            return list.apply(void 0, [symbol(void 0, 'def')].concat([field], [list.apply(void 0, [symbol(void 0, 'aget')].concat([symbol(void 0, 'this')], [list.apply(void 0, [symbol(void 0, 'quote')].concat([field]))]))]));
        }, fields);
        var makeMethodø1 = function (protocol, form) {
            return function () {
                var methodNameø1 = first(form);
                var paramsø1 = second(form);
                var bodyø1 = rest(rest(form));
                var fieldNameø1 = isEqual(name(protocol), 'Object') ? list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1])) : list.apply(void 0, [symbol(void 0, '.-name')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1]))]))]));
                return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([id]))], [fieldNameø1]))], [list.apply(void 0, [symbol(void 0, 'fn')].concat([paramsø1], vec(methodInitø1), vec(bodyø1)))]));
            }.call(this);
        };
        var satisfyø1 = function (protocol) {
            return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([id]))], [list.apply(void 0, [symbol(void 0, '.-wisp_core$IProtocol$id')].concat([protocol]))]))], [true]));
        };
        var bodyø1 = reduce(function (type, form) {
            return isList(form) ? conj(type, { 'body': conj((type || 0)['body'], makeMethodø1((type || 0)['protocol'], form)) }) : conj(type, {
                'protocol': form,
                'body': conj((type || 0)['body'], satisfyø1(form))
            });
        }, {
            'protocol': void 0,
            'body': []
        }, forms);
        var methodsø1 = (bodyø1 || 0)['body'];
        return list.apply(void 0, [symbol(void 0, 'def')].concat([id], [list.apply(void 0, [symbol(void 0, 'do')].concat([list.apply(void 0, [symbol(void 0, 'defn-')].concat([id], [fields], vec(constructorø1)))], vec(methodsø1), [id]))]));
    }.call(this);
};
installMacro('deftype', expandDeftype);
installMacro('defrecord', expandDeftype);
var expandExtendType = exports.expandExtendType = function expandExtendType(type) {
    var forms = Array.prototype.slice.call(arguments, 1);
    return function () {
        var isDefaultTypeø1 = isEqual(type, symbol(void 0, 'default'));
        var isNilTypeø1 = isNil(type);
        var typeNameø1 = isNil(type) ? symbol('nil') : isEqual(type, symbol(void 0, 'default')) ? symbol(void 0, '_') : isEqual(type, symbol(void 0, 'number')) ? symbol(void 0, 'Number') : isEqual(type, symbol(void 0, 'string')) ? symbol(void 0, 'String') : isEqual(type, symbol(void 0, 'boolean')) ? symbol(void 0, 'Boolean') : isEqual(type, symbol(void 0, 'vector')) ? symbol(void 0, 'Array') : isEqual(type, symbol(void 0, 'function')) ? symbol(void 0, 'Function') : isEqual(type, symbol(void 0, 're-pattern')) ? symbol(void 0, 'RegExp') : isEqual(namespace(type), 'js') ? type : 'else' ? void 0 : void 0;
        var satisfyø1 = function (protocol) {
            return typeNameø1 ? list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([symbol('' + 'wisp_core$IProtocol$' + name(typeNameø1))]))]))], [true])) : list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([type]))], [list.apply(void 0, [symbol(void 0, '.-wisp_core$IProtocol$id')].concat([protocol]))]))], [true]));
        };
        var makeMethodø1 = function (protocol, form) {
            return function () {
                var methodNameø1 = first(form);
                var paramsø1 = second(form);
                var bodyø1 = rest(rest(form));
                var targetø1 = typeNameø1 ? list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1]))]))], [list.apply(void 0, [symbol(void 0, 'quote')].concat([typeNameø1]))])) : list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([type]))], [list.apply(void 0, [symbol(void 0, '.-name')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1]))]))]))]));
                return list.apply(void 0, [symbol(void 0, 'set!')].concat([targetø1], [list.apply(void 0, [symbol(void 0, 'fn')].concat([paramsø1], vec(bodyø1)))]));
            }.call(this);
        };
        var bodyø1 = reduce(function (body, form) {
            return isList(form) ? conj(body, { 'methods': conj((body || 0)['methods'], makeMethodø1((body || 0)['protocol'], form)) }) : conj(body, {
                'protocol': form,
                'methods': conj((body || 0)['methods'], satisfyø1(form))
            });
        }, {
            'protocol': void 0,
            'methods': []
        }, forms);
        var methodsø1 = (bodyø1 || 0)['methods'];
        return list.apply(void 0, [symbol(void 0, 'do')].concat(vec(methodsø1), [void 0]));
    }.call(this);
};
installMacro('extend-type', expandExtendType);
var expandExtendProtocol = exports.expandExtendProtocol = function expandExtendProtocol(protocol) {
    var forms = Array.prototype.slice.call(arguments, 1);
    return function () {
        var specsø1 = reduce(function (specs, form) {
            return isList(form) ? cons({
                'type': (first(specs) || 0)['type'],
                'methods': conj((first(specs) || 0)['methods'], form)
            }, rest(specs)) : cons({
                'type': form,
                'methods': []
            }, specs);
        }, void 0, forms);
        var bodyø1 = map(function (form) {
            return list.apply(void 0, [symbol(void 0, 'extend-type')].concat([(form || 0)['type']], [protocol], vec((form || 0)['methods'])));
        }, specsø1);
        return list.apply(void 0, [symbol(void 0, 'do')].concat(vec(bodyø1), [void 0]));
    }.call(this);
};
installMacro('extend-protocol', expandExtendProtocol);
var asetExpand = exports.asetExpand = function asetExpand() {
    switch (arguments.length) {
    case 3:
        var target = arguments[0];
        var field = arguments[1];
        var value = arguments[2];
        return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([target], [field]))], [value]));
    default:
        var target = arguments[0];
        var field = arguments[1];
        var subField = arguments[2];
        var subFieldsAndValue = Array.prototype.slice.call(arguments, 3);
        return function () {
            var resolvedTargetø1 = reduce(function (form, node) {
                return list.apply(void 0, [symbol(void 0, 'aget')].concat([form], [node]));
            }, list.apply(void 0, [symbol(void 0, 'aget')].concat([target], [field])), cons(subField, butlast(subFieldsAndValue)));
            var valueø1 = last(subFieldsAndValue);
            return list.apply(void 0, [symbol(void 0, 'set!')].concat([resolvedTargetø1], [valueø1]));
        }.call(this);
    }
};
installMacro('aset', asetExpand);
var alengthExpand = exports.alengthExpand = function alengthExpand(array) {
    return list.apply(void 0, [symbol(void 0, '.-length')].concat([array]));
};
installMacro('alength', alengthExpand);
//# sourceMappingURL=data:application/json;base64,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
