{
    var _ns_ = {
            id: 'wisp.string',
            doc: void 0
        };
    var wisp_runtime = require('./runtime');
    var str = wisp_runtime.str;
    var subs = wisp_runtime.subs;
    var reMatches = wisp_runtime.reMatches;
    var isNil = wisp_runtime.isNil;
    var isString = wisp_runtime.isString;
    var isRePattern = wisp_runtime.isRePattern;
    var wisp_sequence = require('./sequence');
    var vec = wisp_sequence.vec;
    var isEmpty = wisp_sequence.isEmpty;
}
var split = exports.split = function split(string, pattern, limit) {
        return string.split(pattern, limit);
    };
var splitLines = exports.splitLines = function splitLines(s) {
        return split(s, /\n|\r\n/);
    };
var join = exports.join = function join() {
        switch (arguments.length) {
        case 1:
            var coll = arguments[0];
            return str.apply(void 0, vec(coll));
        case 2:
            var separator = arguments[0];
            var coll = arguments[1];
            return vec(coll).join(separator);
        default:
            throw RangeError('Wrong number of arguments passed');
        }
    };
var upperCase = exports.upperCase = function upperCase(string) {
        return string.toUpperCase();
    };
var lowerCase = exports.lowerCase = function lowerCase(string) {
        return string.toLowerCase();
    };
var capitalize = exports.capitalize = function capitalize(s) {
        return count(s) < 2 ? upperCase(s) : '' + upperCase(subs(s, 0, 1)) + lowerCase(subs(s, 1));
    };
var ESCAPE_PATTERN = new RegExp('([-()\\[\\]{}+?*.$\\^|,:#<!\\\\])', 'g');
var patternEscape = exports.patternEscape = function patternEscape(source) {
        return source.replace(ESCAPE_PATTERN, '\\$1').replace(new RegExp('\\x08', 'g'), '\\x08');
    };
var replaceFirst = exports.replaceFirst = function replaceFirst(string, match, replacement) {
        return string.replace(match, replacement);
    };
var replace = exports.replace = function replace(string, match, replacement) {
        return isString(match) ? string.replace(new RegExp(patternEscape(match), 'g'), replacement) : isRePattern(match) ? string.replace(new RegExp(match.source, 'g'), replacement) : 'else' ? (function () {
            throw '' + 'Invalid match arg: ' + match;
        })() : void 0;
    };
var __LEFTSPACES__ = exports.__LEFTSPACES__ = /^\s\s*/;
var __RIGHTSPACES__ = exports.__RIGHTSPACES__ = /\s\s*$/;
var __SPACES__ = exports.__SPACES__ = /^\s\s*$/;
var triml = exports.triml = isNil(''.trimLeft) ? function (string) {
        return string.replace(__LEFTSPACES__, '');
    } : function (string) {
        return string.trimLeft();
    };
var trimr = exports.trimr = isNil(''.trimRight) ? function (string) {
        return string.replace(__RIGHTSPACES__, '');
    } : function (string) {
        return string.trimRight();
    };
var trim = exports.trim = isNil(''.trim) ? function (string) {
        return string.replace(__LEFTSPACES__).replace(__RIGHTSPACES__);
    } : function (string) {
        return string.trim();
    };
var isBlank = exports.isBlank = function isBlank(string) {
        return isNil(string) || isEmpty(string) || reMatches(__SPACES__, string);
    };
var reverse = exports.reverse = function reverse(string) {
        return join('', string.split(/(?:)/).reverse());
    };
//# sourceMappingURL=data:application/json;base64,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
