{
    var _ns_ = {
            id: 'wisp.runtime',
            doc: 'Core primitives required for runtime'
        };
}
var identity = exports.identity = function identity(x) {
        return x;
    };
var complement = exports.complement = function complement(f) {
        return function () {
            switch (arguments.length) {
            case 0:
                return !f();
            case 1:
                var x = arguments[0];
                return !f(x);
            case 2:
                var x = arguments[0];
                var y = arguments[1];
                return !f(x, y);
            default:
                var x = arguments[0];
                var y = arguments[1];
                var zs = Array.prototype.slice.call(arguments, 2);
                return !f.apply(void 0, [
                    x,
                    y
                ].concat(zs));
            }
        };
    };
var isOdd = exports.isOdd = function isOdd(n) {
        return n % 2 === 1;
    };
var isEven = exports.isEven = function isEven(n) {
        return n % 2 === 0;
    };
var isDictionary = exports.isDictionary = function isDictionary(form) {
        return isObject(form) && isObject(Object.getPrototypeOf(form)) && isNil(Object.getPrototypeOf(Object.getPrototypeOf(form)));
    };
var dictionary = exports.dictionary = function dictionary() {
        var pairs = Array.prototype.slice.call(arguments, 0);
        return function loop() {
            var recur = loop;
            var keyValuesø1 = pairs;
            var resultø1 = {};
            do {
                recur = keyValuesø1.length ? (function () {
                    resultø1[keyValuesø1[0]] = keyValuesø1[1];
                    return loop[0] = keyValuesø1.slice(2), loop[1] = resultø1, loop;
                })() : resultø1;
            } while (keyValuesø1 = loop[0], resultø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var keys = exports.keys = function keys(dictionary) {
        return Object.keys(dictionary);
    };
var vals = exports.vals = function vals(dictionary) {
        return keys(dictionary).map(function (key) {
            return (dictionary || 0)[key];
        });
    };
var keyValues = exports.keyValues = function keyValues(dictionary) {
        return keys(dictionary).map(function (key) {
            return [
                key,
                (dictionary || 0)[key]
            ];
        });
    };
var merge = exports.merge = function merge() {
        return Object.create(Object.prototype, Array.prototype.slice.call(arguments).reduce(function (descriptor, dictionary) {
            isObject(dictionary) ? Object.keys(dictionary).forEach(function (key) {
                return (descriptor || 0)[key] = Object.getOwnPropertyDescriptor(dictionary, key);
            }) : void 0;
            return descriptor;
        }, Object.create(Object.prototype)));
    };
var isSatisfies = exports.isSatisfies = function isSatisfies(protocol, x) {
        return protocol.wisp_core$IProtocol$_ || (x === void 0 ? protocol.wisp_core$IProtocol$nil || false : x === null ? protocol.wisp_core$IProtocol$nil || false : 'else' ? x[protocol.wisp_core$IProtocol$id] || protocol['' + 'wisp_core$IProtocol$' + Object.prototype.toString.call(x).replace('[object ', '').replace(/\]$/, '')] || false : void 0);
    };
var isContainsVector = exports.isContainsVector = function isContainsVector(vector, element) {
        return vector.indexOf(element) >= 0;
    };
var mapDictionary = exports.mapDictionary = function mapDictionary(source, f) {
        return Object.keys(source).reduce(function (target, key) {
            (target || 0)[key] = f((source || 0)[key]);
            return target;
        }, {});
    };
var toString = exports.toString = Object.prototype.toString;
var isFn = exports.isFn = typeof(/./) === 'function' ? function (x) {
        return toString.call(x) === '[object Function]';
    } : function (x) {
        return typeof(x) === 'function';
    };
var isError = exports.isError = function isError(x) {
        return x instanceof Error || toString.call(x) === '[object Error]';
    };
var isString = exports.isString = function isString(x) {
        return typeof(x) === 'string' || toString.call(x) === '[object String]';
    };
var isNumber = exports.isNumber = function isNumber(x) {
        return typeof(x) === 'number' || toString.call(x) === '[object Number]';
    };
var isVector = exports.isVector = isFn(Array.isArray) ? Array.isArray : function (x) {
        return toString.call(x) === '[object Array]';
    };
var isDate = exports.isDate = function isDate(x) {
        return toString.call(x) === '[object Date]';
    };
var isBoolean = exports.isBoolean = function isBoolean(x) {
        return x === true || x === false || toString.call(x) === '[object Boolean]';
    };
var isRePattern = exports.isRePattern = function isRePattern(x) {
        return toString.call(x) === '[object RegExp]';
    };
var isObject = exports.isObject = function isObject(x) {
        return x && typeof(x) === 'object';
    };
var isNil = exports.isNil = function isNil(x) {
        return x === void 0 || x === null;
    };
var isTrue = exports.isTrue = function isTrue(x) {
        return x === true;
    };
var isFalse = exports.isFalse = function isFalse(x) {
        return x === false;
    };
var reFind = exports.reFind = function reFind(re, s) {
        return function () {
            var matchesø1 = re.exec(s);
            return !isNil(matchesø1) ? matchesø1.length === 1 ? (matchesø1 || 0)[0] : matchesø1 : void 0;
        }.call(this);
    };
var reMatches = exports.reMatches = function reMatches(pattern, source) {
        return function () {
            var matchesø1 = pattern.exec(source);
            return !isNil(matchesø1) && (matchesø1 || 0)[0] === source ? matchesø1.length === 1 ? (matchesø1 || 0)[0] : matchesø1 : void 0;
        }.call(this);
    };
var rePattern = exports.rePattern = function rePattern(s) {
        return function () {
            var matchø1 = reFind(/^(?:\(\?([idmsux]*)\))?(.*)/, s);
            return new RegExp((matchø1 || 0)[2], (matchø1 || 0)[1]);
        }.call(this);
    };
var inc = exports.inc = function inc(x) {
        return x + 1;
    };
var dec = exports.dec = function dec(x) {
        return x - 1;
    };
var str = exports.str = function str() {
        return String.prototype.concat.apply('', arguments);
    };
var char = exports.char = function char(code) {
        return String.fromCharCode(code);
    };
var int = exports.int = function int(x) {
        return isNumber(x) ? x >= 0 ? Math.floor(x) : Math.floor(x) : x.charCodeAt(0);
    };
var subs = exports.subs = function subs(string, start, end) {
        return string.substring(start, end);
    };
var isPatternEqual = function isPatternEqual(x, y) {
    return isRePattern(x) && isRePattern(y) && x.source === y.source && x.global === y.global && x.multiline === y.multiline && x.ignoreCase === y.ignoreCase;
};
var isDateEqual = function isDateEqual(x, y) {
    return isDate(x) && isDate(y) && Number(x) === Number(y);
};
var isDictionaryEqual = function isDictionaryEqual(x, y) {
    return isObject(x) && isObject(y) && function () {
        var xKeysø1 = keys(x);
        var yKeysø1 = keys(y);
        var xCountø1 = xKeysø1.length;
        var yCountø1 = yKeysø1.length;
        return xCountø1 === yCountø1 && function loop() {
            var recur = loop;
            var indexø1 = 0;
            var countø1 = xCountø1;
            var keysø1 = xKeysø1;
            do {
                recur = indexø1 < countø1 ? isEquivalent((x || 0)[(keysø1 || 0)[indexø1]], (y || 0)[(keysø1 || 0)[indexø1]]) ? (loop[0] = inc(indexø1), loop[1] = countø1, loop[2] = keysø1, loop) : false : true;
            } while (indexø1 = loop[0], countø1 = loop[1], keysø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }.call(this);
};
var isVectorEqual = function isVectorEqual(x, y) {
    return isVector(x) && isVector(y) && x.length === y.length && function loop() {
        var recur = loop;
        var xsø1 = x;
        var ysø1 = y;
        var indexø1 = 0;
        var countø1 = x.length;
        do {
            recur = indexø1 < countø1 ? isEquivalent((xsø1 || 0)[indexø1], (ysø1 || 0)[indexø1]) ? (loop[0] = xsø1, loop[1] = ysø1, loop[2] = inc(indexø1), loop[3] = countø1, loop) : false : true;
        } while (xsø1 = loop[0], ysø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
        return recur;
    }.call(this);
};
var isEquivalent = function isEquivalent() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return true;
    case 2:
        var x = arguments[0];
        var y = arguments[1];
        return x === y || (isNil(x) ? isNil(y) : isNil(y) ? isNil(x) : isString(x) ? isString(y) && x.toString() === y.toString() : isNumber(x) ? isNumber(y) && x.valueOf() === y.valueOf() : isFn(x) ? false : isBoolean(x) ? false : isDate(x) ? isDateEqual(x, y) : isVector(x) ? isVectorEqual(x, y, [], []) : isRePattern(x) ? isPatternEqual(x, y) : 'else' ? isDictionaryEqual(x, y) : void 0);
    default:
        var x = arguments[0];
        var y = arguments[1];
        var more = Array.prototype.slice.call(arguments, 2);
        return function loop() {
            var recur = loop;
            var previousø1 = x;
            var currentø1 = y;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = isEquivalent(previousø1, currentø1) && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
            } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
            return recur;
        }.call(this);
    }
};
var isEqual = exports.isEqual = isEquivalent;
var isStrictEqual = exports.isStrictEqual = function isStrictEqual() {
        switch (arguments.length) {
        case 1:
            var x = arguments[0];
            return true;
        case 2:
            var x = arguments[0];
            var y = arguments[1];
            return x === y;
        default:
            var x = arguments[0];
            var y = arguments[1];
            var more = Array.prototype.slice.call(arguments, 2);
            return function loop() {
                var recur = loop;
                var previousø1 = x;
                var currentø1 = y;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = previousø1 == currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
                } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
                return recur;
            }.call(this);
        }
    };
var greaterThan = exports.greaterThan = function greaterThan() {
        switch (arguments.length) {
        case 1:
            var x = arguments[0];
            return true;
        case 2:
            var x = arguments[0];
            var y = arguments[1];
            return x > y;
        default:
            var x = arguments[0];
            var y = arguments[1];
            var more = Array.prototype.slice.call(arguments, 2);
            return function loop() {
                var recur = loop;
                var previousø1 = x;
                var currentø1 = y;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = previousø1 > currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
                } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
                return recur;
            }.call(this);
        }
    };
var notLessThan = exports.notLessThan = function notLessThan() {
        switch (arguments.length) {
        case 1:
            var x = arguments[0];
            return true;
        case 2:
            var x = arguments[0];
            var y = arguments[1];
            return x >= y;
        default:
            var x = arguments[0];
            var y = arguments[1];
            var more = Array.prototype.slice.call(arguments, 2);
            return function loop() {
                var recur = loop;
                var previousø1 = x;
                var currentø1 = y;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = previousø1 >= currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
                } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
                return recur;
            }.call(this);
        }
    };
var lessThan = exports.lessThan = function lessThan() {
        switch (arguments.length) {
        case 1:
            var x = arguments[0];
            return true;
        case 2:
            var x = arguments[0];
            var y = arguments[1];
            return x < y;
        default:
            var x = arguments[0];
            var y = arguments[1];
            var more = Array.prototype.slice.call(arguments, 2);
            return function loop() {
                var recur = loop;
                var previousø1 = x;
                var currentø1 = y;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = previousø1 < currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
                } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
                return recur;
            }.call(this);
        }
    };
var notGreaterThan = exports.notGreaterThan = function notGreaterThan() {
        switch (arguments.length) {
        case 1:
            var x = arguments[0];
            return true;
        case 2:
            var x = arguments[0];
            var y = arguments[1];
            return x <= y;
        default:
            var x = arguments[0];
            var y = arguments[1];
            var more = Array.prototype.slice.call(arguments, 2);
            return function loop() {
                var recur = loop;
                var previousø1 = x;
                var currentø1 = y;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = previousø1 <= currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
                } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
                return recur;
            }.call(this);
        }
    };
var sum = exports.sum = function sum() {
        switch (arguments.length) {
        case 0:
            return 0;
        case 1:
            var a = arguments[0];
            return a;
        case 2:
            var a = arguments[0];
            var b = arguments[1];
            return a + b;
        case 3:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            return a + b + c;
        case 4:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            return a + b + c + d;
        case 5:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            return a + b + c + d + e;
        case 6:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            return a + b + c + d + e + f;
        default:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            var more = Array.prototype.slice.call(arguments, 6);
            return function loop() {
                var recur = loop;
                var valueø1 = a + b + c + d + e + f;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = indexø1 < countø1 ? (loop[0] = valueø1 + (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
                } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
                return recur;
            }.call(this);
        }
    };
var subtract = exports.subtract = function subtract() {
        switch (arguments.length) {
        case 0:
            return (function () {
                throw TypeError('Wrong number of args passed to: -');
            })();
        case 1:
            var a = arguments[0];
            return 0 - a;
        case 2:
            var a = arguments[0];
            var b = arguments[1];
            return a - b;
        case 3:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            return a - b - c;
        case 4:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            return a - b - c - d;
        case 5:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            return a - b - c - d - e;
        case 6:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            return a - b - c - d - e - f;
        default:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            var more = Array.prototype.slice.call(arguments, 6);
            return function loop() {
                var recur = loop;
                var valueø1 = a - b - c - d - e - f;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = indexø1 < countø1 ? (loop[0] = valueø1 - (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
                } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
                return recur;
            }.call(this);
        }
    };
var divide = exports.divide = function divide() {
        switch (arguments.length) {
        case 0:
            return (function () {
                throw TypeError('Wrong number of args passed to: /');
            })();
        case 1:
            var a = arguments[0];
            return 1 / a;
        case 2:
            var a = arguments[0];
            var b = arguments[1];
            return a / b;
        case 3:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            return a / b / c;
        case 4:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            return a / b / c / d;
        case 5:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            return a / b / c / d / e;
        case 6:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            return a / b / c / d / e / f;
        default:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            var more = Array.prototype.slice.call(arguments, 6);
            return function loop() {
                var recur = loop;
                var valueø1 = a / b / c / d / e / f;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = indexø1 < countø1 ? (loop[0] = valueø1 / (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
                } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
                return recur;
            }.call(this);
        }
    };
var multiply = exports.multiply = function multiply() {
        switch (arguments.length) {
        case 0:
            return 1;
        case 1:
            var a = arguments[0];
            return a;
        case 2:
            var a = arguments[0];
            var b = arguments[1];
            return a * b;
        case 3:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            return a * b * c;
        case 4:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            return a * b * c * d;
        case 5:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            return a * b * c * d * e;
        case 6:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            return a * b * c * d * e * f;
        default:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            var more = Array.prototype.slice.call(arguments, 6);
            return function loop() {
                var recur = loop;
                var valueø1 = a * b * c * d * e * f;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = indexø1 < countø1 ? (loop[0] = valueø1 * (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
                } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
                return recur;
            }.call(this);
        }
    };
var and = exports.and = function and() {
        switch (arguments.length) {
        case 0:
            return true;
        case 1:
            var a = arguments[0];
            return a;
        case 2:
            var a = arguments[0];
            var b = arguments[1];
            return a && b;
        case 3:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            return a && b && c;
        case 4:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            return a && b && c && d;
        case 5:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            return a && b && c && d && e;
        case 6:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            return a && b && c && d && e && f;
        default:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            var more = Array.prototype.slice.call(arguments, 6);
            return function loop() {
                var recur = loop;
                var valueø1 = a && b && c && d && e && f;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = indexø1 < countø1 ? (loop[0] = valueø1 && (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
                } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
                return recur;
            }.call(this);
        }
    };
var or = exports.or = function or() {
        switch (arguments.length) {
        case 0:
            return void 0;
        case 1:
            var a = arguments[0];
            return a;
        case 2:
            var a = arguments[0];
            var b = arguments[1];
            return a || b;
        case 3:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            return a || b || c;
        case 4:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            return a || b || c || d;
        case 5:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            return a || b || c || d || e;
        case 6:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            return a || b || c || d || e || f;
        default:
            var a = arguments[0];
            var b = arguments[1];
            var c = arguments[2];
            var d = arguments[3];
            var e = arguments[4];
            var f = arguments[5];
            var more = Array.prototype.slice.call(arguments, 6);
            return function loop() {
                var recur = loop;
                var valueø1 = a || b || c || d || e || f;
                var indexø1 = 0;
                var countø1 = more.length;
                do {
                    recur = indexø1 < countø1 ? (loop[0] = valueø1 || (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
                } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
                return recur;
            }.call(this);
        }
    };
var print = exports.print = function print() {
        var more = Array.prototype.slice.call(arguments, 0);
        return console.log.apply(void 0, more);
    };
var max = exports.max = Math.max;
var min = exports.min = Math.min;
var isNan = exports.isNan = isNaN;
//# sourceMappingURL=data:application/json;base64,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
