{
    var _ns_ = {
        id: 'wisp.string',
        doc: void 0
    };
    var wisp_runtime = require('./runtime');
    var str = wisp_runtime.str;
    var subs = wisp_runtime.subs;
    var reMatches = wisp_runtime.reMatches;
    var isNil = wisp_runtime.isNil;
    var isString = wisp_runtime.isString;
    var isRePattern = wisp_runtime.isRePattern;
    var wisp_sequence = require('./sequence');
    var vec = wisp_sequence.vec;
    var isEmpty = wisp_sequence.isEmpty;
}
var split = exports.split = function split(string, pattern, limit) {
    return string.split(pattern, limit);
};
var splitLines = exports.splitLines = function splitLines(s) {
    return split(s, /\n|\r\n/);
};
var join = exports.join = function join() {
    switch (arguments.length) {
    case 1:
        var coll = arguments[0];
        return str.apply(void 0, vec(coll));
    case 2:
        var separator = arguments[0];
        var coll = arguments[1];
        return vec(coll).join(separator);
    default:
        throw RangeError('Wrong number of arguments passed');
    }
};
var upperCase = exports.upperCase = function upperCase(string) {
    return string.toUpperCase();
};
var lowerCase = exports.lowerCase = function lowerCase(string) {
    return string.toLowerCase();
};
var capitalize = exports.capitalize = function capitalize(s) {
    return count(s) < 2 ? upperCase(s) : '' + upperCase(subs(s, 0, 1)) + lowerCase(subs(s, 1));
};
var ESCAPE_PATTERN = new RegExp('([-()\\[\\]{}+?*.$\\^|,:#<!\\\\])', 'g');
var patternEscape = exports.patternEscape = function patternEscape(source) {
    return source.replace(ESCAPE_PATTERN, '\\$1').replace(new RegExp('\\x08', 'g'), '\\x08');
};
var replaceFirst = exports.replaceFirst = function replaceFirst(string, match, replacement) {
    return string.replace(match, replacement);
};
var replace = exports.replace = function replace(string, match, replacement) {
    return isString(match) ? string.replace(new RegExp(patternEscape(match), 'g'), replacement) : isRePattern(match) ? string.replace(new RegExp(match.source, 'g'), replacement) : 'else' ? (function () {
        throw '' + 'Invalid match arg: ' + match;
    })() : void 0;
};
var __LEFTSPACES__ = exports.__LEFTSPACES__ = /^\s\s*/;
var __RIGHTSPACES__ = exports.__RIGHTSPACES__ = /\s\s*$/;
var __SPACES__ = exports.__SPACES__ = /^\s\s*$/;
var triml = exports.triml = isNil(''.trimLeft) ? function (string) {
    return string.replace(__LEFTSPACES__, '');
} : function (string) {
    return string.trimLeft();
};
var trimr = exports.trimr = isNil(''.trimRight) ? function (string) {
    return string.replace(__RIGHTSPACES__, '');
} : function (string) {
    return string.trimRight();
};
var trim = exports.trim = isNil(''.trim) ? function (string) {
    return string.replace(__LEFTSPACES__).replace(__RIGHTSPACES__);
} : function (string) {
    return string.trim();
};
var isBlank = exports.isBlank = function isBlank(string) {
    return isNil(string) || isEmpty(string) || reMatches(__SPACES__, string);
};
var reverse = exports.reverse = function reverse(string) {
    return join('', string.split(/(?:)/).reverse());
};
//# sourceMappingURL=data:application/json;base64,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
