{
    var _ns_ = {
        id: 'wisp.runtime',
        doc: 'Core primitives required for runtime'
    };
}
var identity = exports.identity = function identity(x) {
    return x;
};
var complement = exports.complement = function complement(f) {
    return function () {
        switch (arguments.length) {
        case 0:
            return !f();
        case 1:
            var x = arguments[0];
            return !f(x);
        case 2:
            var x = arguments[0];
            var y = arguments[1];
            return !f(x, y);
        default:
            var x = arguments[0];
            var y = arguments[1];
            var zs = Array.prototype.slice.call(arguments, 2);
            return !f.apply(void 0, [
                x,
                y
            ].concat(zs));
        }
    };
};
var isOdd = exports.isOdd = function isOdd(n) {
    return n % 2 === 1;
};
var isEven = exports.isEven = function isEven(n) {
    return n % 2 === 0;
};
var isDictionary = exports.isDictionary = function isDictionary(form) {
    return isObject(form) && isObject(Object.getPrototypeOf(form)) && isNil(Object.getPrototypeOf(Object.getPrototypeOf(form)));
};
var dictionary = exports.dictionary = function dictionary() {
    var pairs = Array.prototype.slice.call(arguments, 0);
    return function loop() {
        var recur = loop;
        var keyValuesø1 = pairs;
        var resultø1 = {};
        do {
            recur = keyValuesø1.length ? (function () {
                resultø1[keyValuesø1[0]] = keyValuesø1[1];
                return loop[0] = keyValuesø1.slice(2), loop[1] = resultø1, loop;
            })() : resultø1;
        } while (keyValuesø1 = loop[0], resultø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var keys = exports.keys = function keys(dictionary) {
    return Object.keys(dictionary);
};
var vals = exports.vals = function vals(dictionary) {
    return keys(dictionary).map(function (key) {
        return (dictionary || 0)[key];
    });
};
var keyValues = exports.keyValues = function keyValues(dictionary) {
    return keys(dictionary).map(function (key) {
        return [
            key,
            (dictionary || 0)[key]
        ];
    });
};
var merge = exports.merge = function merge() {
    return Object.create(Object.prototype, Array.prototype.slice.call(arguments).reduce(function (descriptor, dictionary) {
        isObject(dictionary) ? Object.keys(dictionary).forEach(function (key) {
            return (descriptor || 0)[key] = Object.getOwnPropertyDescriptor(dictionary, key);
        }) : void 0;
        return descriptor;
    }, Object.create(Object.prototype)));
};
var isSatisfies = exports.isSatisfies = function isSatisfies(protocol, x) {
    return protocol.wisp_core$IProtocol$_ || (x === void 0 ? protocol.wisp_core$IProtocol$nil || false : x === null ? protocol.wisp_core$IProtocol$nil || false : 'else' ? x[protocol.wisp_core$IProtocol$id] || protocol['' + 'wisp_core$IProtocol$' + Object.prototype.toString.call(x).replace('[object ', '').replace(/\]$/, '')] || false : void 0);
};
var isContainsVector = exports.isContainsVector = function isContainsVector(vector, element) {
    return vector.indexOf(element) >= 0;
};
var mapDictionary = exports.mapDictionary = function mapDictionary(source, f) {
    return Object.keys(source).reduce(function (target, key) {
        (target || 0)[key] = f((source || 0)[key]);
        return target;
    }, {});
};
var toString = exports.toString = Object.prototype.toString;
var isFn = exports.isFn = typeof(/./) === 'function' ? function (x) {
    return toString.call(x) === '[object Function]';
} : function (x) {
    return typeof(x) === 'function';
};
var isError = exports.isError = function isError(x) {
    return x instanceof Error || toString.call(x) === '[object Error]';
};
var isString = exports.isString = function isString(x) {
    return typeof(x) === 'string' || toString.call(x) === '[object String]';
};
var isNumber = exports.isNumber = function isNumber(x) {
    return typeof(x) === 'number' || toString.call(x) === '[object Number]';
};
var isVector = exports.isVector = isFn(Array.isArray) ? Array.isArray : function (x) {
    return toString.call(x) === '[object Array]';
};
var isDate = exports.isDate = function isDate(x) {
    return toString.call(x) === '[object Date]';
};
var isBoolean = exports.isBoolean = function isBoolean(x) {
    return x === true || x === false || toString.call(x) === '[object Boolean]';
};
var isRePattern = exports.isRePattern = function isRePattern(x) {
    return toString.call(x) === '[object RegExp]';
};
var isObject = exports.isObject = function isObject(x) {
    return x && typeof(x) === 'object';
};
var isNil = exports.isNil = function isNil(x) {
    return x === void 0 || x === null;
};
var isTrue = exports.isTrue = function isTrue(x) {
    return x === true;
};
var isFalse = exports.isFalse = function isFalse(x) {
    return x === false;
};
var reFind = exports.reFind = function reFind(re, s) {
    return function () {
        var matchesø1 = re.exec(s);
        return !isNil(matchesø1) ? matchesø1.length === 1 ? (matchesø1 || 0)[0] : matchesø1 : void 0;
    }.call(this);
};
var reMatches = exports.reMatches = function reMatches(pattern, source) {
    return function () {
        var matchesø1 = pattern.exec(source);
        return !isNil(matchesø1) && (matchesø1 || 0)[0] === source ? matchesø1.length === 1 ? (matchesø1 || 0)[0] : matchesø1 : void 0;
    }.call(this);
};
var rePattern = exports.rePattern = function rePattern(s) {
    return function () {
        var matchø1 = reFind(/^(?:\(\?([idmsux]*)\))?(.*)/, s);
        return new RegExp((matchø1 || 0)[2], (matchø1 || 0)[1]);
    }.call(this);
};
var inc = exports.inc = function inc(x) {
    return x + 1;
};
var dec = exports.dec = function dec(x) {
    return x - 1;
};
var str = exports.str = function str() {
    return String.prototype.concat.apply('', arguments);
};
var char = exports.char = function char(code) {
    return String.fromCharCode(code);
};
var int = exports.int = function int(x) {
    return isNumber(x) ? x >= 0 ? Math.floor(x) : Math.floor(x) : x.charCodeAt(0);
};
var subs = exports.subs = function subs(string, start, end) {
    return string.substring(start, end);
};
var isPatternEqual = function isPatternEqual(x, y) {
    return isRePattern(x) && isRePattern(y) && x.source === y.source && x.global === y.global && x.multiline === y.multiline && x.ignoreCase === y.ignoreCase;
};
var isDateEqual = function isDateEqual(x, y) {
    return isDate(x) && isDate(y) && Number(x) === Number(y);
};
var isDictionaryEqual = function isDictionaryEqual(x, y) {
    return isObject(x) && isObject(y) && function () {
        var xKeysø1 = keys(x);
        var yKeysø1 = keys(y);
        var xCountø1 = xKeysø1.length;
        var yCountø1 = yKeysø1.length;
        return xCountø1 === yCountø1 && function loop() {
            var recur = loop;
            var indexø1 = 0;
            var countø1 = xCountø1;
            var keysø1 = xKeysø1;
            do {
                recur = indexø1 < countø1 ? isEquivalent((x || 0)[(keysø1 || 0)[indexø1]], (y || 0)[(keysø1 || 0)[indexø1]]) ? (loop[0] = inc(indexø1), loop[1] = countø1, loop[2] = keysø1, loop) : false : true;
            } while (indexø1 = loop[0], countø1 = loop[1], keysø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }.call(this);
};
var isVectorEqual = function isVectorEqual(x, y) {
    return isVector(x) && isVector(y) && x.length === y.length && function loop() {
        var recur = loop;
        var xsø1 = x;
        var ysø1 = y;
        var indexø1 = 0;
        var countø1 = x.length;
        do {
            recur = indexø1 < countø1 ? isEquivalent((xsø1 || 0)[indexø1], (ysø1 || 0)[indexø1]) ? (loop[0] = xsø1, loop[1] = ysø1, loop[2] = inc(indexø1), loop[3] = countø1, loop) : false : true;
        } while (xsø1 = loop[0], ysø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
        return recur;
    }.call(this);
};
var isEquivalent = function isEquivalent() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return true;
    case 2:
        var x = arguments[0];
        var y = arguments[1];
        return x === y || (isNil(x) ? isNil(y) : isNil(y) ? isNil(x) : isString(x) ? isString(y) && x.toString() === y.toString() : isNumber(x) ? isNumber(y) && x.valueOf() === y.valueOf() : isFn(x) ? false : isBoolean(x) ? false : isDate(x) ? isDateEqual(x, y) : isVector(x) ? isVectorEqual(x, y, [], []) : isRePattern(x) ? isPatternEqual(x, y) : 'else' ? isDictionaryEqual(x, y) : void 0);
    default:
        var x = arguments[0];
        var y = arguments[1];
        var more = Array.prototype.slice.call(arguments, 2);
        return function loop() {
            var recur = loop;
            var previousø1 = x;
            var currentø1 = y;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = isEquivalent(previousø1, currentø1) && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
            } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
            return recur;
        }.call(this);
    }
};
var isEqual = exports.isEqual = isEquivalent;
var isStrictEqual = exports.isStrictEqual = function isStrictEqual() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return true;
    case 2:
        var x = arguments[0];
        var y = arguments[1];
        return x === y;
    default:
        var x = arguments[0];
        var y = arguments[1];
        var more = Array.prototype.slice.call(arguments, 2);
        return function loop() {
            var recur = loop;
            var previousø1 = x;
            var currentø1 = y;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = previousø1 == currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
            } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
            return recur;
        }.call(this);
    }
};
var greaterThan = exports.greaterThan = function greaterThan() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return true;
    case 2:
        var x = arguments[0];
        var y = arguments[1];
        return x > y;
    default:
        var x = arguments[0];
        var y = arguments[1];
        var more = Array.prototype.slice.call(arguments, 2);
        return function loop() {
            var recur = loop;
            var previousø1 = x;
            var currentø1 = y;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = previousø1 > currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
            } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
            return recur;
        }.call(this);
    }
};
var notLessThan = exports.notLessThan = function notLessThan() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return true;
    case 2:
        var x = arguments[0];
        var y = arguments[1];
        return x >= y;
    default:
        var x = arguments[0];
        var y = arguments[1];
        var more = Array.prototype.slice.call(arguments, 2);
        return function loop() {
            var recur = loop;
            var previousø1 = x;
            var currentø1 = y;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = previousø1 >= currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
            } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
            return recur;
        }.call(this);
    }
};
var lessThan = exports.lessThan = function lessThan() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return true;
    case 2:
        var x = arguments[0];
        var y = arguments[1];
        return x < y;
    default:
        var x = arguments[0];
        var y = arguments[1];
        var more = Array.prototype.slice.call(arguments, 2);
        return function loop() {
            var recur = loop;
            var previousø1 = x;
            var currentø1 = y;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = previousø1 < currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
            } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
            return recur;
        }.call(this);
    }
};
var notGreaterThan = exports.notGreaterThan = function notGreaterThan() {
    switch (arguments.length) {
    case 1:
        var x = arguments[0];
        return true;
    case 2:
        var x = arguments[0];
        var y = arguments[1];
        return x <= y;
    default:
        var x = arguments[0];
        var y = arguments[1];
        var more = Array.prototype.slice.call(arguments, 2);
        return function loop() {
            var recur = loop;
            var previousø1 = x;
            var currentø1 = y;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = previousø1 <= currentø1 && (indexø1 < countø1 ? (loop[0] = currentø1, loop[1] = (more || 0)[indexø1], loop[2] = inc(indexø1), loop[3] = countø1, loop) : true);
            } while (previousø1 = loop[0], currentø1 = loop[1], indexø1 = loop[2], countø1 = loop[3], recur === loop);
            return recur;
        }.call(this);
    }
};
var sum = exports.sum = function sum() {
    switch (arguments.length) {
    case 0:
        return 0;
    case 1:
        var a = arguments[0];
        return a;
    case 2:
        var a = arguments[0];
        var b = arguments[1];
        return a + b;
    case 3:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        return a + b + c;
    case 4:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        return a + b + c + d;
    case 5:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        return a + b + c + d + e;
    case 6:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        return a + b + c + d + e + f;
    default:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        var more = Array.prototype.slice.call(arguments, 6);
        return function loop() {
            var recur = loop;
            var valueø1 = a + b + c + d + e + f;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = indexø1 < countø1 ? (loop[0] = valueø1 + (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
            } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }
};
var subtract = exports.subtract = function subtract() {
    switch (arguments.length) {
    case 0:
        return (function () {
            throw TypeError('Wrong number of args passed to: -');
        })();
    case 1:
        var a = arguments[0];
        return 0 - a;
    case 2:
        var a = arguments[0];
        var b = arguments[1];
        return a - b;
    case 3:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        return a - b - c;
    case 4:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        return a - b - c - d;
    case 5:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        return a - b - c - d - e;
    case 6:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        return a - b - c - d - e - f;
    default:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        var more = Array.prototype.slice.call(arguments, 6);
        return function loop() {
            var recur = loop;
            var valueø1 = a - b - c - d - e - f;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = indexø1 < countø1 ? (loop[0] = valueø1 - (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
            } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }
};
var divide = exports.divide = function divide() {
    switch (arguments.length) {
    case 0:
        return (function () {
            throw TypeError('Wrong number of args passed to: /');
        })();
    case 1:
        var a = arguments[0];
        return 1 / a;
    case 2:
        var a = arguments[0];
        var b = arguments[1];
        return a / b;
    case 3:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        return a / b / c;
    case 4:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        return a / b / c / d;
    case 5:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        return a / b / c / d / e;
    case 6:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        return a / b / c / d / e / f;
    default:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        var more = Array.prototype.slice.call(arguments, 6);
        return function loop() {
            var recur = loop;
            var valueø1 = a / b / c / d / e / f;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = indexø1 < countø1 ? (loop[0] = valueø1 / (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
            } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }
};
var multiply = exports.multiply = function multiply() {
    switch (arguments.length) {
    case 0:
        return 1;
    case 1:
        var a = arguments[0];
        return a;
    case 2:
        var a = arguments[0];
        var b = arguments[1];
        return a * b;
    case 3:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        return a * b * c;
    case 4:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        return a * b * c * d;
    case 5:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        return a * b * c * d * e;
    case 6:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        return a * b * c * d * e * f;
    default:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        var more = Array.prototype.slice.call(arguments, 6);
        return function loop() {
            var recur = loop;
            var valueø1 = a * b * c * d * e * f;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = indexø1 < countø1 ? (loop[0] = valueø1 * (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
            } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }
};
var and = exports.and = function and() {
    switch (arguments.length) {
    case 0:
        return true;
    case 1:
        var a = arguments[0];
        return a;
    case 2:
        var a = arguments[0];
        var b = arguments[1];
        return a && b;
    case 3:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        return a && b && c;
    case 4:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        return a && b && c && d;
    case 5:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        return a && b && c && d && e;
    case 6:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        return a && b && c && d && e && f;
    default:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        var more = Array.prototype.slice.call(arguments, 6);
        return function loop() {
            var recur = loop;
            var valueø1 = a && b && c && d && e && f;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = indexø1 < countø1 ? (loop[0] = valueø1 && (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
            } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }
};
var or = exports.or = function or() {
    switch (arguments.length) {
    case 0:
        return void 0;
    case 1:
        var a = arguments[0];
        return a;
    case 2:
        var a = arguments[0];
        var b = arguments[1];
        return a || b;
    case 3:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        return a || b || c;
    case 4:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        return a || b || c || d;
    case 5:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        return a || b || c || d || e;
    case 6:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        return a || b || c || d || e || f;
    default:
        var a = arguments[0];
        var b = arguments[1];
        var c = arguments[2];
        var d = arguments[3];
        var e = arguments[4];
        var f = arguments[5];
        var more = Array.prototype.slice.call(arguments, 6);
        return function loop() {
            var recur = loop;
            var valueø1 = a || b || c || d || e || f;
            var indexø1 = 0;
            var countø1 = more.length;
            do {
                recur = indexø1 < countø1 ? (loop[0] = valueø1 || (more || 0)[indexø1], loop[1] = inc(indexø1), loop[2] = countø1, loop) : valueø1;
            } while (valueø1 = loop[0], indexø1 = loop[1], countø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }
};
var print = exports.print = function print() {
    var more = Array.prototype.slice.call(arguments, 0);
    return console.log.apply(void 0, more);
};
var max = exports.max = Math.max;
var min = exports.min = Math.min;
var isNan = exports.isNan = isNaN;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFub255bW91cy53aXNwIl0sIm5hbWVzIjpbIl9uc18iLCJpZCIsImRvYyIsImlkZW50aXR5IiwiZXhwb3J0cyIsIngiLCJjb21wbGVtZW50IiwiZiIsInkiLCJ6cyIsImlzT2RkIiwibiIsImlzRXZlbiIsImlzRGljdGlvbmFyeSIsImZvcm0iLCJpc09iamVjdCIsIk9iamVjdCIsImdldFByb3RvdHlwZU9mIiwiaXNOaWwiLCJkaWN0aW9uYXJ5IiwicGFpcnMiLCJrZXlWYWx1ZXPDuDEiLCJyZXN1bHTDuDEiLCJsZW5ndGgiLCJzbGljZSIsImtleXMiLCJ2YWxzIiwibWFwIiwia2V5Iiwia2V5VmFsdWVzIiwibWVyZ2UiLCJjcmVhdGUiLCJwcm90b3R5cGUiLCJBcnJheSIsInByb3RvdHlwZS5zbGljZSIsImNhbGwiLCJhcmd1bWVudHMiLCJyZWR1Y2UiLCJkZXNjcmlwdG9yIiwiZm9yRWFjaCIsImdldE93blByb3BlcnR5RGVzY3JpcHRvciIsImlzU2F0aXNmaWVzIiwicHJvdG9jb2wiLCJ3aXNwX2NvcmUkSVByb3RvY29sJF8iLCJ3aXNwX2NvcmUkSVByb3RvY29sJG5pbCIsIm51bGwiLCJ3aXNwX2NvcmUkSVByb3RvY29sJGlkIiwicHJvdG90eXBlLnRvU3RyaW5nIiwicmVwbGFjZSIsImlzQ29udGFpbnNWZWN0b3IiLCJ2ZWN0b3IiLCJlbGVtZW50IiwiaW5kZXhPZiIsIm1hcERpY3Rpb25hcnkiLCJzb3VyY2UiLCJ0YXJnZXQiLCJ0b1N0cmluZyIsImlzRm4iLCJ0eXBlb2YiLCJpc0Vycm9yIiwiRXJyb3IiLCJpc1N0cmluZyIsImlzTnVtYmVyIiwiaXNWZWN0b3IiLCJpc0FycmF5IiwiaXNEYXRlIiwiaXNCb29sZWFuIiwiaXNSZVBhdHRlcm4iLCJpc1RydWUiLCJpc0ZhbHNlIiwicmVGaW5kIiwicmUiLCJzIiwibWF0Y2hlc8O4MSIsImV4ZWMiLCJyZU1hdGNoZXMiLCJwYXR0ZXJuIiwicmVQYXR0ZXJuIiwibWF0Y2jDuDEiLCJSZWdFeHAiLCJpbmMiLCJkZWMiLCJzdHIiLCJTdHJpbmciLCJwcm90b3R5cGUuY29uY2F0IiwiYXBwbHkiLCJjaGFyIiwiY29kZSIsImZyb21DaGFyQ29kZSIsImludCIsIk1hdGgiLCJmbG9vciIsImNoYXJDb2RlQXQiLCJzdWJzIiwic3RyaW5nIiwic3RhcnQiLCJlbmQiLCJzdWJzdHJpbmciLCJpc1BhdHRlcm5FcXVhbCIsImdsb2JhbCIsIm11bHRpbGluZSIsImlnbm9yZUNhc2UiLCJpc0RhdGVFcXVhbCIsIk51bWJlciIsImlzRGljdGlvbmFyeUVxdWFsIiwieEtleXPDuDEiLCJ5S2V5c8O4MSIsInhDb3VudMO4MSIsInlDb3VudMO4MSIsImluZGV4w7gxIiwiY291bnTDuDEiLCJrZXlzw7gxIiwiaXNFcXVpdmFsZW50IiwiaXNWZWN0b3JFcXVhbCIsInhzw7gxIiwieXPDuDEiLCJ2YWx1ZU9mIiwibW9yZSIsInByZXZpb3Vzw7gxIiwiY3VycmVudMO4MSIsImlzRXF1YWwiLCJpc1N0cmljdEVxdWFsIiwiZ3JlYXRlclRoYW4iLCJub3RMZXNzVGhhbiIsImxlc3NUaGFuIiwibm90R3JlYXRlclRoYW4iLCJzdW0iLCJhIiwiYiIsImMiLCJkIiwiZSIsInZhbHVlw7gxIiwic3VidHJhY3QiLCJUeXBlRXJyb3IiLCJkaXZpZGUiLCJtdWx0aXBseSIsImFuZCIsIm9yIiwicHJpbnQiLCJjb25zb2xlIiwibG9nIiwibWF4IiwibWluIiwiaXNOYW4iLCJpc05hTiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxRQUFDQSxJLEdBQUQ7QUFBQSxRQUFBQyxFLEVBQUksY0FBSjtBQUFBLFFBQUFDLEcsRUFDRSxzQ0FERjtBQUFBO0FBQUE7QUFHQSxJQUFNQyxRQUFBLEdBQUFDLE9BQUEsQ0FBQUQsUUFBQSxHQUFOLFNBQU1BLFFBQU4sQ0FFR0UsQ0FGSCxFQUVNO0FBQUEsV0FBQUEsQ0FBQTtBQUFBLENBRk4sQ0FIQTtBQU9BLElBQU1DLFVBQUEsR0FBQUYsT0FBQSxDQUFBRSxVQUFBLEdBQU4sU0FBTUEsVUFBTixDQUdHQyxDQUhILEVBR007QUFBQSx1Qjs7O1lBQ00sUUFBTUEsQ0FBRCxFQUFMLEM7O2dCQUNGRixDQUFBLEc7WUFBRyxRQUFNRSxDQUFELENBQUdGLENBQUgsQ0FBTCxDOztnQkFDSEEsQ0FBQSxHO2dCQUFFRyxDQUFBLEc7WUFBRyxRQUFNRCxDQUFELENBQUdGLENBQUgsRUFBS0csQ0FBTCxDQUFMLEM7O2dCQUNMSCxDQUFBLEc7Z0JBQUVHLENBQUEsRztnQkFBSUMsRUFBQSxHO1lBQUksUUFBWUYsQyxNQUFQLEMsTUFBQSxFO2dCQUFTRixDO2dCQUFFRyxDO3FCQUFFQyxFLENBQWIsQ0FBTCxDOztLQUpkO0FBQUEsQ0FITixDQVBBO0FBZ0JBLElBQWVDLEtBQUEsR0FBQU4sT0FBQSxDQUFBTSxLQUFBLEdBQWYsU0FBZUEsS0FBZixDQUFxQkMsQ0FBckIsRUFDRTtBQUFBLFdBQWlCQSxDQUFMLEdBQU8sQ0FBbkIsS0FBc0IsQ0FBdEI7QUFBQSxDQURGLENBaEJBO0FBbUJBLElBQWVDLE1BQUEsR0FBQVIsT0FBQSxDQUFBUSxNQUFBLEdBQWYsU0FBZUEsTUFBZixDQUFzQkQsQ0FBdEIsRUFDRTtBQUFBLFdBQWlCQSxDQUFMLEdBQU8sQ0FBbkIsS0FBc0IsQ0FBdEI7QUFBQSxDQURGLENBbkJBO0FBc0JBLElBQWVFLFlBQUEsR0FBQVQsT0FBQSxDQUFBUyxZQUFBLEdBQWYsU0FBZUEsWUFBZixDQUVHQyxJQUZILEVBR0U7QUFBQSxXQUFNQyxRQUFELENBQVNELElBQVQsQyxJQUVDQyxRQUFELENBQTRCQyxNQUFsQixDQUFDQyxjQUFGLENBQTBCSCxJQUExQixDQUFULENBRkwsSUFHTUksS0FBRCxDQUF5QkYsTUFBbEIsQ0FBQ0MsY0FBRixDQUE2Q0QsTUFBbEIsQ0FBQ0MsY0FBRixDQUEwQkgsSUFBMUIsQ0FBMUIsQ0FBTixDQUhMO0FBQUEsQ0FIRixDQXRCQTtBQThCQSxJQUFNSyxVQUFBLEdBQUFmLE9BQUEsQ0FBQWUsVUFBQSxHQUFOLFNBQU1BLFVBQU4sRztRQUdLQyxLQUFBLEc7SUFHSCxPOztRQUFPLElBQUFDLFcsR0FBV0QsS0FBWCxDO1FBQ0EsSUFBQUUsUSxHQUFPLEVBQVAsQzs7b0JBQ1NELFdBQVYsQ0FBR0UsTUFBUCxHLGFBRUk7QUFBQSxnQkFBWUQsUUFBTixDQUFtQkQsV0FBTixDQUFpQixDQUFqQixDQUFiLENBQU4sR0FDWUEsV0FBTixDQUFpQixDQUFqQixDQUROO0FBQUEsZ0JBRUEsTyxVQUFlQSxXQUFQLENBQUNHLEtBQUYsQ0FBbUIsQ0FBbkIsQ0FBUCxFLFVBQTZCRixRQUE3QixFLElBQUEsQ0FGQTtBQUFBLGEsQ0FBQSxFQUZKLEdBS0VBLFE7aUJBUEdELFcsWUFDQUMsUTs7VUFEUCxDLElBQUEsRTtDQU5GLENBOUJBO0FBNkNBLElBQU1HLElBQUEsR0FBQXJCLE9BQUEsQ0FBQXFCLElBQUEsR0FBTixTQUFNQSxJQUFOLENBRUdOLFVBRkgsRUFHRTtBQUFBLFdBQU9ILE1BQU4sQ0FBQ1MsSUFBRixDQUFjTixVQUFkO0FBQUEsQ0FIRixDQTdDQTtBQWtEQSxJQUFNTyxJQUFBLEdBQUF0QixPQUFBLENBQUFzQixJQUFBLEdBQU4sU0FBTUEsSUFBTixDQUVHUCxVQUZILEVBR0U7QUFBQSxXQUFPTSxJQUFELENBQU1OLFVBQU4sQ0FBTCxDQUFDUSxHQUFGLENBQ00sVUFBS0MsR0FBTCxFQUFVO0FBQUEsZSxDQUFLVCxVLE1BQUwsQ0FBZ0JTLEdBQWhCO0FBQUEsS0FEaEI7QUFBQSxDQUhGLENBbERBO0FBd0RBLElBQU1DLFNBQUEsR0FBQXpCLE9BQUEsQ0FBQXlCLFNBQUEsR0FBTixTQUFNQSxTQUFOLENBQ0dWLFVBREgsRUFFRTtBQUFBLFdBQU9NLElBQUQsQ0FBTU4sVUFBTixDQUFMLENBQUNRLEdBQUYsQ0FDTSxVQUFLQyxHQUFMLEVBQVU7QUFBQTtBQUFBLFlBQUNBLEdBQUQ7QUFBQSxZLENBQVVULFUsTUFBTCxDQUFnQlMsR0FBaEIsQ0FBTDtBQUFBO0FBQUEsS0FEaEI7QUFBQSxDQUZGLENBeERBO0FBNkRBLElBQU1FLEtBQUEsR0FBQTFCLE9BQUEsQ0FBQTBCLEtBQUEsR0FBTixTQUFNQSxLQUFOLEdBS0U7QUFBQSxXQUFDZCxNQUFBLENBQU9lLE1BQVIsQ0FDQ2YsTUFBQSxDQUFPZ0IsU0FEUixFQUdTQyxLQUFBLENBQU1DLGVBQVosQ0FBQ0MsSUFBRixDQUE2QkMsU0FBN0IsQ0FEQSxDQUFDQyxNQUFGLENBRUMsVUFBS0MsVUFBTCxFQUFnQm5CLFVBQWhCLEVBQ0U7QUFBQSxRQUFLSixRQUFELENBQVNJLFVBQVQsQ0FBSixHQUVJSCxNQUFBLENBQU9TLElBQVIsQ0FBYU4sVUFBYixDQURBLENBQUNvQixPQUFGLENBRUMsVUFBS1gsR0FBTCxFQUNFO0FBQUEsbUIsQ0FDTVUsVSxNQUFMLENBQWdCVixHQUFoQixDQURELEdBRUVaLE1BQUEsQ0FBT3dCLHdCQUFSLENBQW9DckIsVUFBcEMsRUFBK0NTLEdBQS9DLENBRkQ7QUFBQSxTQUhILENBREYsRyxNQUFBO0FBQUEsUUFPQSxPQUFBVSxVQUFBLENBUEE7QUFBQSxLQUhILEVBV0V0QixNQUFBLENBQU9lLE1BQVIsQ0FBZWYsTUFBQSxDQUFPZ0IsU0FBdEIsQ0FYRCxDQUZEO0FBQUEsQ0FMRixDQTdEQTtBQWtGQSxJQUFlUyxXQUFBLEdBQUFyQyxPQUFBLENBQUFxQyxXQUFBLEdBQWYsU0FBZUEsV0FBZixDQUVHQyxRQUZILEVBRVlyQyxDQUZaLEVBR0U7QUFBQSxXQUE2QnFDLFFBQXpCLENBQUdDLHFCQUFQLElBQ0ksQ0FBa0J0QyxDQUFaLEssTUFBTixHQUNxQ3FDLFFBQTNCLENBQUdFLHVCQUFQLEksS0FETixHQUdrQnZDLENBQVosS0FBY3dDLEksR0FDaUJILFFBQTNCLENBQUdFLHVCQUFQLEksaUJBRWdCdkMsQ0FBTixDQUFjcUMsUUFBTixDQUFnQkksc0JBQXhCLEMsSUFDTUosUUFBTixDLEtBQ1csc0JBQUwsR0FDZ0MxQixNQUFBLENBQU8rQixrQkFBYixDQUFDWixJQUFGLENBQWlDOUIsQ0FBakMsQ0FBVCxDQUFDMkMsT0FBRixDQUNVLFVBRFYsRUFDcUIsRUFEckIsQ0FBVCxDQUFDQSxPQUFGLENBRVUsS0FGVixFQUVpQixFQUZqQixDQUZYLENBREosSSxjQU5aLENBREo7QUFBQSxDQUhGLENBbEZBO0FBb0dBLElBQWVDLGdCQUFBLEdBQUE3QyxPQUFBLENBQUE2QyxnQkFBQSxHQUFmLFNBQWVBLGdCQUFmLENBRUdDLE1BRkgsRUFFVUMsT0FGVixFQUdFO0FBQUEsV0FBZUQsTUFBVixDQUFDRSxPQUFGLENBQWtCRCxPQUFsQixDQUFKLElBQStCLENBQS9CO0FBQUEsQ0FIRixDQXBHQTtBQTBHQSxJQUFNRSxhQUFBLEdBQUFqRCxPQUFBLENBQUFpRCxhQUFBLEdBQU4sU0FBTUEsYUFBTixDQUVHQyxNQUZILEVBRVUvQyxDQUZWLEVBR0U7QUFBQSxXQUFnQlMsTUFBTixDQUFDUyxJQUFGLENBQWM2QixNQUFkLENBQVIsQ0FBQ2pCLE1BQUYsQ0FDUyxVQUFLa0IsTUFBTCxFQUFZM0IsR0FBWixFQUNHO0FBQUEsUSxDQUFXMkIsTSxNQUFMLENBQVkzQixHQUFaLENBQU4sR0FBd0JyQixDQUFELEMsQ0FBUStDLE0sTUFBTCxDQUFZMUIsR0FBWixDQUFILENBQXZCO0FBQUEsUUFDQSxPQUFBMkIsTUFBQSxDQURBO0FBQUEsS0FGWixFQUdvQixFQUhwQjtBQUFBLENBSEYsQ0ExR0E7QUFrSEEsSUFBS0MsUUFBQSxHQUFBcEQsT0FBQSxDQUFBb0QsUUFBQSxHQUFVeEMsTUFBQSxDQUFPK0Isa0JBQXRCLENBbEhBO0FBb0hBLElBR0VVLElBQUEsR0FBQXJELE9BQUEsQ0FBQXFELElBQUEsR0FDaUJDLE1BQUQsQ0FBUSxHQUFSLENBQVosS0FBMEIsVUFBOUIsR0FDRSxVQUNHckQsQ0FESCxFQUVFO0FBQUEsV0FBbUJtRCxRQUFOLENBQUNyQixJQUFGLENBQWlCOUIsQ0FBakIsQ0FBWixLQUFnQyxtQkFBaEM7QUFBQSxDQUhKLEdBSUUsVUFDR0EsQ0FESCxFQUVFO0FBQUEsV0FBYXFELE1BQUQsQ0FBUXJELENBQVIsQ0FBWixLQUF1QixVQUF2QjtBQUFBLENBVk4sQ0FwSEE7QUFnSUEsSUFBZXNELE9BQUEsR0FBQXZELE9BQUEsQ0FBQXVELE9BQUEsR0FBZixTQUFlQSxPQUFmLENBRUd0RCxDQUZILEVBR0U7QUFBQSxXQUFxQkEsQ0FBakIsWUFBV3VELEtBQWYsSUFDdUJKLFFBQU4sQ0FBQ3JCLElBQUYsQ0FBaUI5QixDQUFqQixDQUFaLEtBQWdDLGdCQURwQztBQUFBLENBSEYsQ0FoSUE7QUFzSUEsSUFBZXdELFFBQUEsR0FBQXpELE9BQUEsQ0FBQXlELFFBQUEsR0FBZixTQUFlQSxRQUFmLENBRUd4RCxDQUZILEVBR0U7QUFBQSxXQUFpQnFELE1BQUQsQ0FBUXJELENBQVIsQ0FBWixLQUF1QixRQUEzQixJQUN1Qm1ELFFBQU4sQ0FBQ3JCLElBQUYsQ0FBaUI5QixDQUFqQixDQUFaLEtBQWdDLGlCQURwQztBQUFBLENBSEYsQ0F0SUE7QUE0SUEsSUFBZXlELFFBQUEsR0FBQTFELE9BQUEsQ0FBQTBELFFBQUEsR0FBZixTQUFlQSxRQUFmLENBRUd6RCxDQUZILEVBR0U7QUFBQSxXQUFpQnFELE1BQUQsQ0FBUXJELENBQVIsQ0FBWixLQUF1QixRQUEzQixJQUN1Qm1ELFFBQU4sQ0FBQ3JCLElBQUYsQ0FBaUI5QixDQUFqQixDQUFaLEtBQWdDLGlCQURwQztBQUFBLENBSEYsQ0E1SUE7QUFrSkEsSUFHRTBELFFBQUEsR0FBQTNELE9BQUEsQ0FBQTJELFFBQUEsR0FDS04sSUFBRCxDQUFLeEIsS0FBQSxDQUFNK0IsT0FBWCxDQUFKLEdBQ0UvQixLQUFBLENBQU0rQixPQURSLEdBRUUsVUFBSzNELENBQUwsRUFBUTtBQUFBLFdBQW1CbUQsUUFBTixDQUFDckIsSUFBRixDQUFpQjlCLENBQWpCLENBQVosS0FBZ0MsZ0JBQWhDO0FBQUEsQ0FOWixDQWxKQTtBQTBKQSxJQUFlNEQsTUFBQSxHQUFBN0QsT0FBQSxDQUFBNkQsTUFBQSxHQUFmLFNBQWVBLE1BQWYsQ0FFRzVELENBRkgsRUFHRTtBQUFBLFdBQW1CbUQsUUFBTixDQUFDckIsSUFBRixDQUFpQjlCLENBQWpCLENBQVosS0FBZ0MsZUFBaEM7QUFBQSxDQUhGLENBMUpBO0FBK0pBLElBQWU2RCxTQUFBLEdBQUE5RCxPQUFBLENBQUE4RCxTQUFBLEdBQWYsU0FBZUEsU0FBZixDQUVHN0QsQ0FGSCxFQUdFO0FBQUEsV0FBZ0JBLENBQVosSyxRQUNZQSxDQUFaLEssS0FESixJQUV1Qm1ELFFBQU4sQ0FBQ3JCLElBQUYsQ0FBaUI5QixDQUFqQixDQUFaLEtBQWdDLGtCQUZwQztBQUFBLENBSEYsQ0EvSkE7QUFzS0EsSUFBZThELFdBQUEsR0FBQS9ELE9BQUEsQ0FBQStELFdBQUEsR0FBZixTQUFlQSxXQUFmLENBRUc5RCxDQUZILEVBR0U7QUFBQSxXQUFtQm1ELFFBQU4sQ0FBQ3JCLElBQUYsQ0FBaUI5QixDQUFqQixDQUFaLEtBQWdDLGlCQUFoQztBQUFBLENBSEYsQ0F0S0E7QUE0S0EsSUFBZVUsUUFBQSxHQUFBWCxPQUFBLENBQUFXLFFBQUEsR0FBZixTQUFlQSxRQUFmLENBRUdWLENBRkgsRUFHRTtBQUFBLFdBQUtBLENBQUwsSUFBb0JxRCxNQUFELENBQVFyRCxDQUFSLENBQVosS0FBdUIsUUFBOUI7QUFBQSxDQUhGLENBNUtBO0FBaUxBLElBQWVhLEtBQUEsR0FBQWQsT0FBQSxDQUFBYyxLQUFBLEdBQWYsU0FBZUEsS0FBZixDQUVHYixDQUZILEVBR0U7QUFBQSxXQUFnQkEsQ0FBWixLLE1BQUosSUFDZ0JBLENBQVosS0FBY3dDLElBRGxCO0FBQUEsQ0FIRixDQWpMQTtBQXVMQSxJQUFldUIsTUFBQSxHQUFBaEUsT0FBQSxDQUFBZ0UsTUFBQSxHQUFmLFNBQWVBLE1BQWYsQ0FFRy9ELENBRkgsRUFHRTtBQUFBLFdBQVlBLENBQVosSyxJQUFBO0FBQUEsQ0FIRixDQXZMQTtBQTRMQSxJQUFlZ0UsT0FBQSxHQUFBakUsT0FBQSxDQUFBaUUsT0FBQSxHQUFmLFNBQWVBLE9BQWYsQ0FFR2hFLENBRkgsRUFHRTtBQUFBLFdBQVlBLENBQVosSyxLQUFBO0FBQUEsQ0FIRixDQTVMQTtBQWlNQSxJQUFNaUUsTUFBQSxHQUFBbEUsT0FBQSxDQUFBa0UsTUFBQSxHQUFOLFNBQU1BLE1BQU4sQ0FLR0MsRUFMSCxFQUtNQyxDQUxOLEVBTUU7QUFBQSxXLFlBQU07QUFBQSxZQUFBQyxTLEdBQWVGLEVBQU4sQ0FBQ0csSUFBRixDQUFVRixDQUFWLENBQVI7QUFBQSxRQUNKLE9BQUksQ0FBTXRELEtBQUQsQ0FBTXVELFNBQU4sQ0FBVCxHQUM0QkEsU0FBVixDQUFHbEQsTUFBZixLQUErQixDQUFuQyxHLENBQ09rRCxTLE1BQUwsQ0FBYSxDQUFiLENBREYsR0FFRUEsU0FISixHLE1BQUEsQ0FESTtBQUFBLEssS0FBTixDLElBQUE7QUFBQSxDQU5GLENBak1BO0FBNk1BLElBQU1FLFNBQUEsR0FBQXZFLE9BQUEsQ0FBQXVFLFNBQUEsR0FBTixTQUFNQSxTQUFOLENBQ0dDLE9BREgsRUFDV3RCLE1BRFgsRUFFRTtBQUFBLFcsWUFBTTtBQUFBLFlBQUFtQixTLEdBQWVHLE9BQU4sQ0FBQ0YsSUFBRixDQUFlcEIsTUFBZixDQUFSO0FBQUEsUUFDSixPQUFTLENBQU1wQyxLQUFELENBQU11RCxTQUFOLENBQVYsSSxDQUNzQkEsUyxNQUFMLENBQWEsQ0FBYixDQUFaLEtBQTRCbkIsTUFEckMsR0FFNEJtQixTQUFWLENBQUdsRCxNQUFmLEtBQStCLENBQW5DLEcsQ0FDT2tELFMsTUFBTCxDQUFhLENBQWIsQ0FERixHQUVFQSxTQUpKLEcsTUFBQSxDQURJO0FBQUEsSyxLQUFOLEMsSUFBQTtBQUFBLENBRkYsQ0E3TUE7QUFzTkEsSUFBTUksU0FBQSxHQUFBekUsT0FBQSxDQUFBeUUsU0FBQSxHQUFOLFNBQU1BLFNBQU4sQ0FFR0wsQ0FGSCxFQUdFO0FBQUEsVyxZQUFNO0FBQUEsWUFBQU0sTyxHQUFPUixNQUFELENBQVMsNkJBQVQsRUFBd0NFLENBQXhDLENBQU47QUFBQSxRQUNKLFdBQUtPLE1BQUwsQyxDQUFpQkQsTyxNQUFMLENBQVcsQ0FBWCxDQUFaLEUsQ0FBK0JBLE8sTUFBTCxDQUFXLENBQVgsQ0FBMUIsRUFESTtBQUFBLEssS0FBTixDLElBQUE7QUFBQSxDQUhGLENBdE5BO0FBNE5BLElBQU1FLEdBQUEsR0FBQTVFLE9BQUEsQ0FBQTRFLEdBQUEsR0FBTixTQUFNQSxHQUFOLENBQ0czRSxDQURILEVBRUU7QUFBQSxXQUFHQSxDQUFILEdBQUssQ0FBTDtBQUFBLENBRkYsQ0E1TkE7QUFnT0EsSUFBTTRFLEdBQUEsR0FBQTdFLE9BQUEsQ0FBQTZFLEdBQUEsR0FBTixTQUFNQSxHQUFOLENBQ0c1RSxDQURILEVBRUU7QUFBQSxXQUFHQSxDQUFILEdBQUssQ0FBTDtBQUFBLENBRkYsQ0FoT0E7QUFvT0EsSUFBTTZFLEdBQUEsR0FBQTlFLE9BQUEsQ0FBQThFLEdBQUEsR0FBTixTQUFNQSxHQUFOLEdBS0U7QUFBQSxXQUFRQyxNQUFBLENBQU9DLGdCQUFkLENBQUNDLEtBQUYsQ0FBZ0MsRUFBaEMsRUFBbUNqRCxTQUFuQztBQUFBLENBTEYsQ0FwT0E7QUEyT0EsSUFBTWtELElBQUEsR0FBQWxGLE9BQUEsQ0FBQWtGLElBQUEsR0FBTixTQUFNQSxJQUFOLENBRUdDLElBRkgsRUFHRTtBQUFBLFdBQWVKLE1BQWQsQ0FBQ0ssWUFBRixDQUFzQkQsSUFBdEI7QUFBQSxDQUhGLENBM09BO0FBaVBBLElBQU1FLEdBQUEsR0FBQXJGLE9BQUEsQ0FBQXFGLEdBQUEsR0FBTixTQUFNQSxHQUFOLENBRUdwRixDQUZILEVBR0U7QUFBQSxXQUFLeUQsUUFBRCxDQUFTekQsQ0FBVCxDQUFKLEdBQ1VBLENBQUosSUFBTSxDQUFWLEdBQ1VxRixJQUFQLENBQUNDLEtBQUYsQ0FBYXRGLENBQWIsQ0FERixHQUVVcUYsSUFBUCxDQUFDQyxLQUFGLENBQWF0RixDQUFiLENBSEosR0FJZUEsQ0FBWixDQUFDdUYsVUFBRixDQUFlLENBQWYsQ0FKRjtBQUFBLENBSEYsQ0FqUEE7QUEwUEEsSUFBTUMsSUFBQSxHQUFBekYsT0FBQSxDQUFBeUYsSUFBQSxHQUFOLFNBQU1BLElBQU4sQ0FLSUMsTUFMSixFQUtXQyxLQUxYLEVBS2lCQyxHQUxqQixFQU1HO0FBQUEsV0FBWUYsTUFBWCxDQUFDRyxTQUFGLENBQW1CRixLQUFuQixFQUF5QkMsR0FBekI7QUFBQSxDQU5ILENBMVBBO0FBa1FBLElBQWdCRSxjQUFBLEdBQWhCLFNBQWdCQSxjQUFoQixDQUNHN0YsQ0FESCxFQUNLRyxDQURMLEVBRUU7QUFBQSxXQUFNMkQsV0FBRCxDQUFhOUQsQ0FBYixDLElBQ0M4RCxXQUFELENBQWEzRCxDQUFiLEMsSUFDc0JILENBQVYsQ0FBR2lELE1BQWYsS0FBbUM5QyxDQUFWLENBQUc4QyxNLElBQ05qRCxDQUFWLENBQUc4RixNQUFmLEtBQW1DM0YsQ0FBVixDQUFHMkYsTSxJQUNIOUYsQ0FBYixDQUFHK0YsU0FBZixLQUF5QzVGLENBQWIsQ0FBRzRGLFNBSnBDLElBSytCL0YsQ0FBZCxDQUFHZ0csVUFBZixLQUEyQzdGLENBQWQsQ0FBRzZGLFVBTHJDO0FBQUEsQ0FGRixDQWxRQTtBQTJRQSxJQUFnQkMsV0FBQSxHQUFoQixTQUFnQkEsV0FBaEIsQ0FDR2pHLENBREgsRUFDS0csQ0FETCxFQUVFO0FBQUEsV0FBTXlELE1BQUQsQ0FBTzVELENBQVAsQyxJQUNDNEQsTUFBRCxDQUFPekQsQ0FBUCxDQURMLElBRWtCK0YsTUFBRCxDQUFRbEcsQ0FBUixDQUFaLEtBQXdCa0csTUFBRCxDQUFRL0YsQ0FBUixDQUY1QjtBQUFBLENBRkYsQ0EzUUE7QUFrUkEsSUFBZ0JnRyxpQkFBQSxHQUFoQixTQUFnQkEsaUJBQWhCLENBQ0duRyxDQURILEVBQ0tHLENBREwsRUFFRTtBQUFBLFdBQU1PLFFBQUQsQ0FBU1YsQ0FBVCxDLElBQ0NVLFFBQUQsQ0FBU1AsQ0FBVCxDQURMLEksWUFFVztBQUFBLFlBQUFpRyxPLEdBQVFoRixJQUFELENBQU1wQixDQUFOLENBQVA7QUFBQSxRQUNBLElBQUFxRyxPLEdBQVFqRixJQUFELENBQU1qQixDQUFOLENBQVAsQ0FEQTtBQUFBLFFBRUEsSUFBQW1HLFEsR0FBa0JGLE9BQVYsQ0FBR2xGLE1BQVgsQ0FGQTtBQUFBLFFBR0EsSUFBQXFGLFEsR0FBa0JGLE9BQVYsQ0FBR25GLE1BQVgsQ0FIQTtBQUFBLFFBSUosT0FBaUJvRixRQUFaLEtBQW9CQyxRQUF6QixJOztZQUNZLElBQUFDLE8sR0FBTSxDQUFOLEM7WUFDQSxJQUFBQyxPLEdBQU1ILFFBQU4sQztZQUNBLElBQUFJLE0sR0FBS04sT0FBTCxDOzt3QkFDRUksT0FBSCxHQUFTQyxPQUFiLEdBQ09FLFlBQUQsQyxDQUFrQjNHLEMsTUFBTCxDLENBQVkwRyxNLE1BQUwsQ0FBVUYsT0FBVixDQUFQLENBQWIsRSxDQUNrQnJHLEMsTUFBTCxDLENBQVl1RyxNLE1BQUwsQ0FBVUYsT0FBVixDQUFQLENBRGIsQ0FBSixHQUVFLEMsVUFBUTdCLEdBQUQsQ0FBSzZCLE9BQUwsQ0FBUCxFLFVBQW1CQyxPQUFuQixFLFVBQXlCQyxNQUF6QixFLElBQUEsQ0FGRixHLEtBREYsRztxQkFIS0YsTyxZQUNBQyxPLFlBQ0FDLE07O2NBRlAsQyxJQUFBLENBREwsQ0FKSTtBQUFBLEssS0FBTixDLElBQUEsQ0FGTDtBQUFBLENBRkYsQ0FsUkE7QUFxU0EsSUFBZ0JFLGFBQUEsR0FBaEIsU0FBZ0JBLGFBQWhCLENBQ0c1RyxDQURILEVBQ0tHLENBREwsRUFFRTtBQUFBLFdBQU11RCxRQUFELENBQVMxRCxDQUFULEMsSUFDQzBELFFBQUQsQ0FBU3ZELENBQVQsQyxJQUNzQkgsQ0FBVixDQUFHa0IsTUFBZixLQUFtQ2YsQ0FBVixDQUFHZSxNQUZqQyxJOztRQUdZLElBQUEyRixJLEdBQUc3RyxDQUFILEM7UUFDQSxJQUFBOEcsSSxHQUFHM0csQ0FBSCxDO1FBQ0EsSUFBQXFHLE8sR0FBTSxDQUFOLEM7UUFDQSxJQUFBQyxPLEdBQWdCekcsQ0FBVixDQUFHa0IsTUFBVCxDOztvQkFDQ3NGLE9BQUgsR0FBU0MsT0FBYixHQUNPRSxZQUFELEMsQ0FBa0JFLEksTUFBTCxDQUFRTCxPQUFSLENBQWIsRSxDQUFpQ00sSSxNQUFMLENBQVFOLE9BQVIsQ0FBNUIsQ0FBSixHQUNJLEMsVUFBT0ssSUFBUCxFLFVBQVVDLElBQVYsRSxVQUFjbkMsR0FBRCxDQUFLNkIsT0FBTCxDQUFiLEUsVUFBeUJDLE9BQXpCLEUsSUFBQSxDQURKLEcsS0FERixHO2lCQUpNSSxJLFlBQ0FDLEksWUFDQU4sTyxZQUNBQyxPOztVQUhQLEMsSUFBQSxDQUhMO0FBQUEsQ0FGRixDQXJTQTtBQW9UQSxJQUFnQkUsWUFBQSxHQUFoQixTQUFnQkEsWUFBaEIsRzs7O1lBS0kzRyxDQUFBLEc7OztZQUNBQSxDQUFBLEc7WUFBRUcsQ0FBQSxHO1FBQUcsT0FBZ0JILENBQVosS0FBY0csQ0FBbEIsSUFDSSxDQUFPVSxLQUFELENBQU1iLENBQU4sQ0FBTixHQUFnQmEsS0FBRCxDQUFNVixDQUFOLENBQWYsR0FDT1UsS0FBRCxDQUFNVixDQUFOLEMsR0FBVVUsS0FBRCxDQUFNYixDQUFOLEMsR0FDUndELFFBQUQsQ0FBU3hELENBQVQsQyxHQUFrQndELFFBQUQsQ0FBU3JELENBQVQsQ0FBTCxJQUF3Q0gsQ0FBVixDQUFDbUQsUUFBRixFQUFaLEtBQ3VCaEQsQ0FBVixDQUFDZ0QsUUFBRixFLEdBQ3hDTSxRQUFELENBQVN6RCxDQUFULEMsR0FBa0J5RCxRQUFELENBQVN0RCxDQUFULENBQUwsSUFBdUNILENBQVQsQ0FBQytHLE9BQUYsRUFBWixLQUNzQjVHLENBQVQsQ0FBQzRHLE9BQUYsRSxHQUN4QzNELElBQUQsQ0FBS3BELENBQUwsQyxXQUNDNkQsU0FBRCxDQUFVN0QsQ0FBVixDLFdBQ0M0RCxNQUFELENBQU81RCxDQUFQLEMsR0FBV2lHLFdBQUQsQ0FBYWpHLENBQWIsRUFBZUcsQ0FBZixDLEdBQ1R1RCxRQUFELENBQVMxRCxDQUFULEMsR0FBYTRHLGFBQUQsQ0FBZTVHLENBQWYsRUFBaUJHLENBQWpCLEVBQW1CLEVBQW5CLEVBQXNCLEVBQXRCLEMsR0FDWDJELFdBQUQsQ0FBYTlELENBQWIsQyxHQUFpQjZGLGNBQUQsQ0FBZ0I3RixDQUFoQixFQUFrQkcsQ0FBbEIsQyxZQUNUZ0csaUJBQUQsQ0FBbUJuRyxDQUFuQixFQUFxQkcsQ0FBckIsQyxTQVhaLENBREosQzs7WUFhTEgsQ0FBQSxHO1lBQUVHLENBQUEsRztZQUFJNkcsSUFBQSxHO1FBQ1AsTzs7WUFBTyxJQUFBQyxVLEdBQVNqSCxDQUFULEM7WUFDQSxJQUFBa0gsUyxHQUFRL0csQ0FBUixDO1lBQ0EsSUFBQXFHLE8sR0FBTSxDQUFOLEM7WUFDQSxJQUFBQyxPLEdBQWdCTyxJQUFWLENBQUc5RixNQUFULEM7O3dCQUNBeUYsWUFBRCxDQUFhTSxVQUFiLEVBQXNCQyxTQUF0QixDQUFMLElBQ0ssQ0FBT1YsT0FBSCxHQUFTQyxPQUFiLEdBQ0MsQyxVQUFPUyxTQUFQLEUsV0FDWUYsSSxNQUFMLENBQVVSLE9BQVYsQ0FEUCxFLFVBRVE3QixHQUFELENBQUs2QixPQUFMLENBRlAsRSxVQUdPQyxPQUhQLEUsSUFBQSxDQURELEcsSUFBQSxDO3FCQUxDUSxVLFlBQ0FDLFMsWUFDQVYsTyxZQUNBQyxPOztjQUhQLEMsSUFBQSxFOztDQXBCSCxDQXBUQTtBQW9WQSxJQUFLVSxPQUFBLEdBQUFwSCxPQUFBLENBQUFvSCxPQUFBLEdBQUVSLFlBQVAsQ0FwVkE7QUFzVkEsSUFBZVMsYUFBQSxHQUFBckgsT0FBQSxDQUFBcUgsYUFBQSxHQUFmLFNBQWVBLGFBQWYsRzs7O1lBS0lwSCxDQUFBLEc7OztZQUNBQSxDQUFBLEc7WUFBRUcsQ0FBQSxHO1FBQUcsT0FBWUgsQ0FBWixLQUFjRyxDQUFkLEM7O1lBQ0xILENBQUEsRztZQUFFRyxDQUFBLEc7WUFBSTZHLElBQUEsRztRQUNQLE87O1lBQU8sSUFBQUMsVSxHQUFTakgsQ0FBVCxDO1lBQ0EsSUFBQWtILFMsR0FBUS9HLENBQVIsQztZQUNBLElBQUFxRyxPLEdBQU0sQ0FBTixDO1lBQ0EsSUFBQUMsTyxHQUFnQk8sSUFBVixDQUFHOUYsTUFBVCxDOzt3QkFDRytGLFVBQUosSUFBYUMsU0FBbEIsSUFDSyxDQUFPVixPQUFILEdBQVNDLE9BQWIsR0FDQyxDLFVBQU9TLFNBQVAsRSxXQUNZRixJLE1BQUwsQ0FBVVIsT0FBVixDQURQLEUsVUFFUTdCLEdBQUQsQ0FBSzZCLE9BQUwsQ0FGUCxFLFVBR09DLE9BSFAsRSxJQUFBLENBREQsRyxJQUFBLEM7cUJBTENRLFUsWUFDQUMsUyxZQUNBVixPLFlBQ0FDLE87O2NBSFAsQyxJQUFBLEU7O0NBUkgsQ0F0VkE7QUEyV0EsSUFBZVksV0FBQSxHQUFBdEgsT0FBQSxDQUFBc0gsV0FBQSxHQUFmLFNBQWVBLFdBQWYsRzs7O1lBR0lySCxDQUFBLEc7OztZQUNBQSxDQUFBLEc7WUFBRUcsQ0FBQSxHO1FBQUcsT0FBR0gsQ0FBSCxHQUFLRyxDQUFMLEM7O1lBQ0xILENBQUEsRztZQUFFRyxDQUFBLEc7WUFBSTZHLElBQUEsRztRQUNQLE87O1lBQU8sSUFBQUMsVSxHQUFTakgsQ0FBVCxDO1lBQ0EsSUFBQWtILFMsR0FBUS9HLENBQVIsQztZQUNBLElBQUFxRyxPLEdBQU0sQ0FBTixDO1lBQ0EsSUFBQUMsTyxHQUFnQk8sSUFBVixDQUFHOUYsTUFBVCxDOzt3QkFDRStGLFVBQUgsR0FBWUMsU0FBakIsSUFDSyxDQUFPVixPQUFILEdBQVNDLE9BQWIsR0FDQyxDLFVBQU9TLFNBQVAsRSxXQUNZRixJLE1BQUwsQ0FBVVIsT0FBVixDQURQLEUsVUFFUTdCLEdBQUQsQ0FBSzZCLE9BQUwsQ0FGUCxFLFVBR09DLE9BSFAsRSxJQUFBLENBREQsRyxJQUFBLEM7cUJBTENRLFUsWUFDQUMsUyxZQUNBVixPLFlBQ0FDLE87O2NBSFAsQyxJQUFBLEU7O0NBTkgsQ0EzV0E7QUE2WEEsSUFBZWEsV0FBQSxHQUFBdkgsT0FBQSxDQUFBdUgsV0FBQSxHQUFmLFNBQWVBLFdBQWYsRzs7O1lBR0l0SCxDQUFBLEc7OztZQUNBQSxDQUFBLEc7WUFBRUcsQ0FBQSxHO1FBQUcsT0FBSUgsQ0FBSixJQUFNRyxDQUFOLEM7O1lBQ0xILENBQUEsRztZQUFFRyxDQUFBLEc7WUFBSTZHLElBQUEsRztRQUNQLE87O1lBQU8sSUFBQUMsVSxHQUFTakgsQ0FBVCxDO1lBQ0EsSUFBQWtILFMsR0FBUS9HLENBQVIsQztZQUNBLElBQUFxRyxPLEdBQU0sQ0FBTixDO1lBQ0EsSUFBQUMsTyxHQUFnQk8sSUFBVixDQUFHOUYsTUFBVCxDOzt3QkFDRytGLFVBQUosSUFBYUMsU0FBbEIsSUFDSyxDQUFPVixPQUFILEdBQVNDLE9BQWIsR0FDQyxDLFVBQU9TLFNBQVAsRSxXQUNZRixJLE1BQUwsQ0FBVVIsT0FBVixDQURQLEUsVUFFUTdCLEdBQUQsQ0FBSzZCLE9BQUwsQ0FGUCxFLFVBR09DLE9BSFAsRSxJQUFBLENBREQsRyxJQUFBLEM7cUJBTENRLFUsWUFDQUMsUyxZQUNBVixPLFlBQ0FDLE87O2NBSFAsQyxJQUFBLEU7O0NBTkgsQ0E3WEE7QUFnWkEsSUFBZWMsUUFBQSxHQUFBeEgsT0FBQSxDQUFBd0gsUUFBQSxHQUFmLFNBQWVBLFFBQWYsRzs7O1lBR0l2SCxDQUFBLEc7OztZQUNBQSxDQUFBLEc7WUFBRUcsQ0FBQSxHO1FBQUcsT0FBR0gsQ0FBSCxHQUFLRyxDQUFMLEM7O1lBQ0xILENBQUEsRztZQUFFRyxDQUFBLEc7WUFBSTZHLElBQUEsRztRQUNQLE87O1lBQU8sSUFBQUMsVSxHQUFTakgsQ0FBVCxDO1lBQ0EsSUFBQWtILFMsR0FBUS9HLENBQVIsQztZQUNBLElBQUFxRyxPLEdBQU0sQ0FBTixDO1lBQ0EsSUFBQUMsTyxHQUFnQk8sSUFBVixDQUFHOUYsTUFBVCxDOzt3QkFDRStGLFVBQUgsR0FBWUMsU0FBakIsSUFDSyxDQUFPVixPQUFILEdBQVNDLE9BQWIsR0FDQyxDLFVBQU9TLFNBQVAsRSxXQUNZRixJLE1BQUwsQ0FBVVIsT0FBVixDQURQLEUsVUFFUTdCLEdBQUQsQ0FBSzZCLE9BQUwsQ0FGUCxFLFVBR09DLE9BSFAsRSxJQUFBLENBREQsRyxJQUFBLEM7cUJBTENRLFUsWUFDQUMsUyxZQUNBVixPLFlBQ0FDLE87O2NBSFAsQyxJQUFBLEU7O0NBTkgsQ0FoWkE7QUFtYUEsSUFBZWUsY0FBQSxHQUFBekgsT0FBQSxDQUFBeUgsY0FBQSxHQUFmLFNBQWVBLGNBQWYsRzs7O1lBR0l4SCxDQUFBLEc7OztZQUNBQSxDQUFBLEc7WUFBRUcsQ0FBQSxHO1FBQUcsT0FBSUgsQ0FBSixJQUFNRyxDQUFOLEM7O1lBQ0xILENBQUEsRztZQUFFRyxDQUFBLEc7WUFBSTZHLElBQUEsRztRQUNQLE87O1lBQU8sSUFBQUMsVSxHQUFTakgsQ0FBVCxDO1lBQ0EsSUFBQWtILFMsR0FBUS9HLENBQVIsQztZQUNBLElBQUFxRyxPLEdBQU0sQ0FBTixDO1lBQ0EsSUFBQUMsTyxHQUFnQk8sSUFBVixDQUFHOUYsTUFBVCxDOzt3QkFDRytGLFVBQUosSUFBYUMsU0FBbEIsSUFDSyxDQUFPVixPQUFILEdBQVNDLE9BQWIsR0FDQyxDLFVBQU9TLFNBQVAsRSxXQUNZRixJLE1BQUwsQ0FBVVIsT0FBVixDQURQLEUsVUFFUTdCLEdBQUQsQ0FBSzZCLE9BQUwsQ0FGUCxFLFVBR09DLE9BSFAsRSxJQUFBLENBREQsRyxJQUFBLEM7cUJBTENRLFUsWUFDQUMsUyxZQUNBVixPLFlBQ0FDLE87O2NBSFAsQyxJQUFBLEU7O0NBTkgsQ0FuYUE7QUFxYkEsSUFBZWdCLEdBQUEsR0FBQTFILE9BQUEsQ0FBQTBILEdBQUEsR0FBZixTQUFlQSxHQUFmLEc7OztRQUNNLFM7O1lBQ0ZDLENBQUEsRztRQUFHLE9BQUFBLENBQUEsQzs7WUFDSEEsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdELENBQUgsR0FBS0MsQ0FBTCxDOztZQUNMRCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdGLEMsR0FBRUMsQ0FBTCxHQUFPQyxDQUFQLEM7O1lBQ1BGLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdILEMsR0FBRUMsQyxHQUFFQyxDQUFQLEdBQVNDLENBQVQsQzs7WUFDVEgsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdKLEMsR0FBRUMsQyxHQUFFQyxDLEdBQUVDLENBQVQsR0FBV0MsQ0FBWCxDOztZQUNYSixDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUU1SCxDQUFBLEc7UUFBRyxPQUFHd0gsQyxHQUFFQyxDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDQUFYLEdBQWE1SCxDQUFiLEM7O1lBQ2J3SCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUU1SCxDQUFBLEc7WUFBSThHLElBQUEsRztRQUNmLE87O1lBQU8sSUFBQWUsTyxHQUFTTCxDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDLEdBQUVDLENBQVgsR0FBYTVILENBQW5CLEM7WUFDQSxJQUFBc0csTyxHQUFNLENBQU4sQztZQUNBLElBQUFDLE8sR0FBZ0JPLElBQVYsQ0FBRzlGLE1BQVQsQzs7d0JBQ0VzRixPQUFILEdBQVNDLE9BQWIsR0FDRSxDLFVBQVVzQixPQUFILEcsQ0FBY2YsSSxNQUFMLENBQVVSLE9BQVYsQ0FBaEIsRSxVQUNRN0IsR0FBRCxDQUFLNkIsT0FBTCxDQURQLEUsVUFFT0MsT0FGUCxFLElBQUEsQ0FERixHQUlFc0IsTztxQkFQR0EsTyxZQUNBdkIsTyxZQUNBQyxPOztjQUZQLEMsSUFBQSxFOztDQVRILENBcmJBO0FBdWNBLElBQWV1QixRQUFBLEdBQUFqSSxPQUFBLENBQUFpSSxRQUFBLEdBQWYsU0FBZUEsUUFBZixHOzs7UUFDTSxPLGFBQUE7QUFBQSxrQkFBUUMsU0FBRCxDQUFXLG1DQUFYLENBQVA7QUFBQSxTLENBQUEsRzs7WUFDRlAsQ0FBQSxHO1FBQUcsT0FBRyxDQUFILEdBQUtBLENBQUwsQzs7WUFDSEEsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdELENBQUgsR0FBS0MsQ0FBTCxDOztZQUNMRCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdGLEMsR0FBRUMsQ0FBTCxHQUFPQyxDQUFQLEM7O1lBQ1BGLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdILEMsR0FBRUMsQyxHQUFFQyxDQUFQLEdBQVNDLENBQVQsQzs7WUFDVEgsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdKLEMsR0FBRUMsQyxHQUFFQyxDLEdBQUVDLENBQVQsR0FBV0MsQ0FBWCxDOztZQUNYSixDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUU1SCxDQUFBLEc7UUFBRyxPQUFHd0gsQyxHQUFFQyxDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDQUFYLEdBQWE1SCxDQUFiLEM7O1lBQ2J3SCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUU1SCxDQUFBLEc7WUFBSThHLElBQUEsRztRQUNmLE87O1lBQU8sSUFBQWUsTyxHQUFTTCxDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDLEdBQUVDLENBQVgsR0FBYTVILENBQW5CLEM7WUFDQSxJQUFBc0csTyxHQUFNLENBQU4sQztZQUNBLElBQUFDLE8sR0FBZ0JPLElBQVYsQ0FBRzlGLE1BQVQsQzs7d0JBQ0VzRixPQUFILEdBQVNDLE9BQWIsR0FDRSxDLFVBQVVzQixPQUFILEcsQ0FBY2YsSSxNQUFMLENBQVVSLE9BQVYsQ0FBaEIsRSxVQUNRN0IsR0FBRCxDQUFLNkIsT0FBTCxDQURQLEUsVUFFT0MsT0FGUCxFLElBQUEsQ0FERixHQUlFc0IsTztxQkFQR0EsTyxZQUNBdkIsTyxZQUNBQyxPOztjQUZQLEMsSUFBQSxFOztDQVRILENBdmNBO0FBeWRBLElBQWV5QixNQUFBLEdBQUFuSSxPQUFBLENBQUFtSSxNQUFBLEdBQWYsU0FBZUEsTUFBZixHOzs7UUFDTSxPLGFBQUE7QUFBQSxrQkFBUUQsU0FBRCxDQUFXLG1DQUFYLENBQVA7QUFBQSxTLENBQUEsRzs7WUFDRlAsQ0FBQSxHO1FBQUcsT0FBRyxDQUFILEdBQUtBLENBQUwsQzs7WUFDSEEsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdELENBQUgsR0FBS0MsQ0FBTCxDOztZQUNMRCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdGLEMsR0FBRUMsQ0FBTCxHQUFPQyxDQUFQLEM7O1lBQ1BGLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdILEMsR0FBRUMsQyxHQUFFQyxDQUFQLEdBQVNDLENBQVQsQzs7WUFDVEgsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztRQUFHLE9BQUdKLEMsR0FBRUMsQyxHQUFFQyxDLEdBQUVDLENBQVQsR0FBV0MsQ0FBWCxDOztZQUNYSixDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUU1SCxDQUFBLEc7UUFBRyxPQUFHd0gsQyxHQUFFQyxDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDQUFYLEdBQWE1SCxDQUFiLEM7O1lBQ2J3SCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUU1SCxDQUFBLEc7WUFBSThHLElBQUEsRztRQUNmLE87O1lBQU8sSUFBQWUsTyxHQUFTTCxDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDLEdBQUVDLENBQVgsR0FBYTVILENBQW5CLEM7WUFDQSxJQUFBc0csTyxHQUFNLENBQU4sQztZQUNBLElBQUFDLE8sR0FBZ0JPLElBQVYsQ0FBRzlGLE1BQVQsQzs7d0JBQ0VzRixPQUFILEdBQVNDLE9BQWIsR0FDRSxDLFVBQVVzQixPQUFILEcsQ0FBY2YsSSxNQUFMLENBQVVSLE9BQVYsQ0FBaEIsRSxVQUNRN0IsR0FBRCxDQUFLNkIsT0FBTCxDQURQLEUsVUFFT0MsT0FGUCxFLElBQUEsQ0FERixHQUlFc0IsTztxQkFQR0EsTyxZQUNBdkIsTyxZQUNBQyxPOztjQUZQLEMsSUFBQSxFOztDQVRILENBemRBO0FBMmVBLElBQWUwQixRQUFBLEdBQUFwSSxPQUFBLENBQUFvSSxRQUFBLEdBQWYsU0FBZUEsUUFBZixHOzs7UUFDTSxTOztZQUNGVCxDQUFBLEc7UUFBRyxPQUFBQSxDQUFBLEM7O1lBQ0hBLENBQUEsRztZQUFFQyxDQUFBLEc7UUFBRyxPQUFHRCxDQUFILEdBQUtDLENBQUwsQzs7WUFDTEQsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7UUFBRyxPQUFHRixDLEdBQUVDLENBQUwsR0FBT0MsQ0FBUCxDOztZQUNQRixDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7UUFBRyxPQUFHSCxDLEdBQUVDLEMsR0FBRUMsQ0FBUCxHQUFTQyxDQUFULEM7O1lBQ1RILENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7UUFBRyxPQUFHSixDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDQUFULEdBQVdDLENBQVgsQzs7WUFDWEosQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFNUgsQ0FBQSxHO1FBQUcsT0FBR3dILEMsR0FBRUMsQyxHQUFFQyxDLEdBQUVDLEMsR0FBRUMsQ0FBWCxHQUFhNUgsQ0FBYixDOztZQUNid0gsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFNUgsQ0FBQSxHO1lBQUk4RyxJQUFBLEc7UUFDZixPOztZQUFPLElBQUFlLE8sR0FBU0wsQyxHQUFFQyxDLEdBQUVDLEMsR0FBRUMsQyxHQUFFQyxDQUFYLEdBQWE1SCxDQUFuQixDO1lBQ0EsSUFBQXNHLE8sR0FBTSxDQUFOLEM7WUFDQSxJQUFBQyxPLEdBQWdCTyxJQUFWLENBQUc5RixNQUFULEM7O3dCQUNFc0YsT0FBSCxHQUFTQyxPQUFiLEdBQ0UsQyxVQUFVc0IsT0FBSCxHLENBQWNmLEksTUFBTCxDQUFVUixPQUFWLENBQWhCLEUsVUFDUTdCLEdBQUQsQ0FBSzZCLE9BQUwsQ0FEUCxFLFVBRU9DLE9BRlAsRSxJQUFBLENBREYsR0FJRXNCLE87cUJBUEdBLE8sWUFDQXZCLE8sWUFDQUMsTzs7Y0FGUCxDLElBQUEsRTs7Q0FUSCxDQTNlQTtBQTZmQSxJQUFlMkIsR0FBQSxHQUFBckksT0FBQSxDQUFBcUksR0FBQSxHQUFmLFNBQWVBLEdBQWYsRzs7Ozs7WUFFSVYsQ0FBQSxHO1FBQUcsT0FBQUEsQ0FBQSxDOztZQUNIQSxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBS0QsQ0FBTCxJQUFPQyxDQUFQLEM7O1lBQ0xELENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBS0YsQyxJQUFFQyxDQUFQLElBQVNDLENBQVQsQzs7WUFDUEYsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBS0gsQyxJQUFFQyxDLElBQUVDLENBQVQsSUFBV0MsQ0FBWCxDOztZQUNUSCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBS0osQyxJQUFFQyxDLElBQUVDLEMsSUFBRUMsQ0FBWCxJQUFhQyxDQUFiLEM7O1lBQ1hKLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRTVILENBQUEsRztRQUFHLE9BQUt3SCxDLElBQUVDLEMsSUFBRUMsQyxJQUFFQyxDLElBQUVDLENBQWIsSUFBZTVILENBQWYsQzs7WUFDYndILENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRTVILENBQUEsRztZQUFJOEcsSUFBQSxHO1FBQ2YsTzs7WUFBTyxJQUFBZSxPLEdBQVdMLEMsSUFBRUMsQyxJQUFFQyxDLElBQUVDLEMsSUFBRUMsQ0FBYixJQUFlNUgsQ0FBckIsQztZQUNBLElBQUFzRyxPLEdBQU0sQ0FBTixDO1lBQ0EsSUFBQUMsTyxHQUFnQk8sSUFBVixDQUFHOUYsTUFBVCxDOzt3QkFDRXNGLE9BQUgsR0FBU0MsT0FBYixHQUNFLEMsVUFBWXNCLE9BQUwsSSxDQUFnQmYsSSxNQUFMLENBQVVSLE9BQVYsQ0FBbEIsRSxVQUNRN0IsR0FBRCxDQUFLNkIsT0FBTCxDQURQLEUsVUFFT0MsT0FGUCxFLElBQUEsQ0FERixHQUlFc0IsTztxQkFQR0EsTyxZQUNBdkIsTyxZQUNBQyxPOztjQUZQLEMsSUFBQSxFOztDQVRILENBN2ZBO0FBK2dCQSxJQUFlNEIsRUFBQSxHQUFBdEksT0FBQSxDQUFBc0ksRUFBQSxHQUFmLFNBQWVBLEVBQWYsRzs7Ozs7WUFFSVgsQ0FBQSxHO1FBQUcsT0FBQUEsQ0FBQSxDOztZQUNIQSxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBSUQsQ0FBSixJQUFNQyxDQUFOLEM7O1lBQ0xELENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBSUYsQyxJQUFFQyxDQUFOLElBQVFDLENBQVIsQzs7WUFDUEYsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBSUgsQyxJQUFFQyxDLElBQUVDLENBQVIsSUFBVUMsQ0FBVixDOztZQUNUSCxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1FBQUcsT0FBSUosQyxJQUFFQyxDLElBQUVDLEMsSUFBRUMsQ0FBVixJQUFZQyxDQUFaLEM7O1lBQ1hKLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRTVILENBQUEsRztRQUFHLE9BQUl3SCxDLElBQUVDLEMsSUFBRUMsQyxJQUFFQyxDLElBQUVDLENBQVosSUFBYzVILENBQWQsQzs7WUFDYndILENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRUMsQ0FBQSxHO1lBQUVDLENBQUEsRztZQUFFQyxDQUFBLEc7WUFBRTVILENBQUEsRztZQUFJOEcsSUFBQSxHO1FBQ2YsTzs7WUFBTyxJQUFBZSxPLEdBQVVMLEMsSUFBRUMsQyxJQUFFQyxDLElBQUVDLEMsSUFBRUMsQ0FBWixJQUFjNUgsQ0FBcEIsQztZQUNBLElBQUFzRyxPLEdBQU0sQ0FBTixDO1lBQ0EsSUFBQUMsTyxHQUFnQk8sSUFBVixDQUFHOUYsTUFBVCxDOzt3QkFDRXNGLE9BQUgsR0FBU0MsT0FBYixHQUNFLEMsVUFBV3NCLE9BQUosSSxDQUFlZixJLE1BQUwsQ0FBVVIsT0FBVixDQUFqQixFLFVBQ1E3QixHQUFELENBQUs2QixPQUFMLENBRFAsRSxVQUVPQyxPQUZQLEUsSUFBQSxDQURGLEdBSUVzQixPO3FCQVBHQSxPLFlBQ0F2QixPLFlBQ0FDLE87O2NBRlAsQyxJQUFBLEU7O0NBVEgsQ0EvZ0JBO0FBaWlCQSxJQUFNNkIsS0FBQSxHQUFBdkksT0FBQSxDQUFBdUksS0FBQSxHQUFOLFNBQU1BLEtBQU4sRztRQUNLdEIsSUFBQSxHO0lBQ0gsT0FBT3VCLE9BQUEsQ0FBUUMsRyxNQUFmLEMsTUFBQSxFQUFtQnhCLElBQW5CLEU7Q0FGRixDQWppQkE7QUFxaUJBLElBQUt5QixHQUFBLEdBQUExSSxPQUFBLENBQUEwSSxHQUFBLEdBQUlwRCxJQUFBLENBQUtvRCxHQUFkLENBcmlCQTtBQXNpQkEsSUFBS0MsR0FBQSxHQUFBM0ksT0FBQSxDQUFBMkksR0FBQSxHQUFJckQsSUFBQSxDQUFLcUQsR0FBZCxDQXRpQkE7QUF1aUJBLElBQUtDLEtBQUEsR0FBQTVJLE9BQUEsQ0FBQTRJLEtBQUEsR0FBS0MsS0FBViIsInNvdXJjZXNDb250ZW50IjpbIihucyB3aXNwLnJ1bnRpbWVcbiAgXCJDb3JlIHByaW1pdGl2ZXMgcmVxdWlyZWQgZm9yIHJ1bnRpbWVcIilcblxuKGRlZm4gaWRlbnRpdHlcbiAgXCJSZXR1cm5zIGl0cyBhcmd1bWVudC5cIlxuICBbeF0geClcblxuKGRlZm4gY29tcGxlbWVudFxuICBcIlRha2VzIGEgZm4gZiBhbmQgcmV0dXJucyBhIGZuIHRoYXQgdGFrZXMgdGhlIHNhbWUgYXJndW1lbnRzIGFzIGYsXG4gIGhhcyB0aGUgc2FtZSBlZmZlY3RzLCBpZiBhbnksIGFuZCByZXR1cm5zIHRoZSBvcHBvc2l0ZSB0cnV0aCB2YWx1ZS5cIlxuICBbZl0gKGZuIFxuICAgICAgICAoW10gKG5vdCAoZikpKVxuICAgICAgICAoW3hdIChub3QgKGYgeCkpKVxuICAgICAgICAoW3ggeV0gKG5vdCAoZiB4IHkpKSlcbiAgICAgICAgKFt4IHkgJiB6c10gKG5vdCAoYXBwbHkgZiB4IHkgenMpKSkpKVxuXG4oZGVmbiBeYm9vbGVhbiBvZGQ/IFtuXVxuICAoaWRlbnRpY2FsPyAobW9kIG4gMikgMSkpXG5cbihkZWZuIF5ib29sZWFuIGV2ZW4/IFtuXVxuICAoaWRlbnRpY2FsPyAobW9kIG4gMikgMCkpXG5cbihkZWZuIF5ib29sZWFuIGRpY3Rpb25hcnk/XG4gIFwiUmV0dXJucyB0cnVlIGlmIGRpY3Rpb25hcnlcIlxuICBbZm9ybV1cbiAgKGFuZCAob2JqZWN0PyBmb3JtKVxuICAgICAgIDs7IEluaGVyaXRzIHJpZ2h0IGZvcm0gT2JqZWN0LnByb3RvdHlwZVxuICAgICAgIChvYmplY3Q/ICguZ2V0LXByb3RvdHlwZS1vZiBPYmplY3QgZm9ybSkpXG4gICAgICAgKG5pbD8gKC5nZXQtcHJvdG90eXBlLW9mIE9iamVjdCAoLmdldC1wcm90b3R5cGUtb2YgT2JqZWN0IGZvcm0pKSkpKVxuXG4oZGVmbiBkaWN0aW9uYXJ5XG4gIFwiQ3JlYXRlcyBkaWN0aW9uYXJ5IG9mIGdpdmVuIGFyZ3VtZW50cy4gT2RkIGluZGV4ZWQgYXJndW1lbnRzXG4gIGFyZSB1c2VkIGZvciBrZXlzIGFuZCBldmVucyBmb3IgdmFsdWVzXCJcbiAgWyYgcGFpcnNdXG4gIDsgVE9ETzogV2Ugc2hvdWxkIGNvbnZlcnQga2V5d29yZHMgdG8gbmFtZXMgdG8gbWFrZSBzdXJlIHRoYXQga2V5cyBhcmUgbm90XG4gIDsgdXNlZCBpbiB0aGVpciBrZXl3b3JkIGZvcm0uXG4gIChsb29wIFtrZXktdmFsdWVzIHBhaXJzXG4gICAgICAgICByZXN1bHQge31dXG4gICAgKGlmICguLWxlbmd0aCBrZXktdmFsdWVzKVxuICAgICAgKGRvXG4gICAgICAgIChzZXQhIChhZ2V0IHJlc3VsdCAoYWdldCBrZXktdmFsdWVzIDApKVxuICAgICAgICAgICAgICAoYWdldCBrZXktdmFsdWVzIDEpKVxuICAgICAgICAocmVjdXIgKC5zbGljZSBrZXktdmFsdWVzIDIpIHJlc3VsdCkpXG4gICAgICByZXN1bHQpKSlcblxuKGRlZm4ga2V5c1xuICBcIlJldHVybnMgYSBzZXF1ZW5jZSBvZiB0aGUgbWFwJ3Mga2V5c1wiXG4gIFtkaWN0aW9uYXJ5XVxuICAoLmtleXMgT2JqZWN0IGRpY3Rpb25hcnkpKVxuXG4oZGVmbiB2YWxzXG4gIFwiUmV0dXJucyBhIHNlcXVlbmNlIG9mIHRoZSBtYXAncyB2YWx1ZXMuXCJcbiAgW2RpY3Rpb25hcnldXG4gICgubWFwIChrZXlzIGRpY3Rpb25hcnkpXG4gICAgICAgIChmbiBba2V5XSAoZ2V0IGRpY3Rpb25hcnkga2V5KSkpKVxuXG4oZGVmbiBrZXktdmFsdWVzXG4gIFtkaWN0aW9uYXJ5XVxuICAoLm1hcCAoa2V5cyBkaWN0aW9uYXJ5KVxuICAgICAgICAoZm4gW2tleV0gW2tleSAoZ2V0IGRpY3Rpb25hcnkga2V5KV0pKSlcblxuKGRlZm4gbWVyZ2VcbiAgXCJSZXR1cm5zIGEgZGljdGlvbmFyeSB0aGF0IGNvbnNpc3RzIG9mIHRoZSByZXN0IG9mIHRoZSBtYXBzIGNvbmotZWQgb250b1xuICB0aGUgZmlyc3QuIElmIGEga2V5IG9jY3VycyBpbiBtb3JlIHRoYW4gb25lIG1hcCwgdGhlIG1hcHBpbmcgZnJvbVxuICB0aGUgbGF0dGVyIChsZWZ0LXRvLXJpZ2h0KSB3aWxsIGJlIHRoZSBtYXBwaW5nIGluIHRoZSByZXN1bHQuXCJcbiAgW11cbiAgKE9iamVjdC5jcmVhdGVcbiAgIE9iamVjdC5wcm90b3R5cGVcbiAgICgucmVkdWNlXG4gICAgKC5jYWxsIEFycmF5LnByb3RvdHlwZS5zbGljZSBhcmd1bWVudHMpXG4gICAgKGZuIFtkZXNjcmlwdG9yIGRpY3Rpb25hcnldXG4gICAgICAoaWYgKG9iamVjdD8gZGljdGlvbmFyeSlcbiAgICAgICAgKC5mb3ItZWFjaFxuICAgICAgICAgKE9iamVjdC5rZXlzIGRpY3Rpb25hcnkpXG4gICAgICAgICAoZm4gW2tleV1cbiAgICAgICAgICAgKHNldCFcbiAgICAgICAgICAgIChnZXQgZGVzY3JpcHRvciBrZXkpXG4gICAgICAgICAgICAoT2JqZWN0LmdldC1vd24tcHJvcGVydHktZGVzY3JpcHRvciBkaWN0aW9uYXJ5IGtleSkpKSkpXG4gICAgICBkZXNjcmlwdG9yKVxuICAgIChPYmplY3QuY3JlYXRlIE9iamVjdC5wcm90b3R5cGUpKSkpXG5cblxuKGRlZm4gXmJvb2xlYW4gc2F0aXNmaWVzP1xuICBcIlJldHVybnMgdHJ1ZSBpZiB4IHNhdGlzZmllcyB0aGUgcHJvdG9jb2xcIlxuICBbcHJvdG9jb2wgeF1cbiAgKG9yICguLXdpc3BfY29yZSRJUHJvdG9jb2wkXyBwcm90b2NvbClcbiAgICAgIChjb25kIChpZGVudGljYWw/IHggbmlsKVxuICAgICAgICAgICAgKG9yICguLXdpc3BfY29yZSRJUHJvdG9jb2wkbmlsIHByb3RvY29sKSBmYWxzZSlcblxuICAgICAgICAgICAgKGlkZW50aWNhbD8geCBudWxsKVxuICAgICAgICAgICAgKG9yICguLXdpc3BfY29yZSRJUHJvdG9jb2wkbmlsIHByb3RvY29sKSBmYWxzZSlcblxuICAgICAgICAgICAgOmVsc2UgKG9yIChhZ2V0IHggKGFnZXQgcHJvdG9jb2wgJ3dpc3BfY29yZSRJUHJvdG9jb2wkaWQpKVxuICAgICAgICAgICAgICAgICAgICAgIChhZ2V0IHByb3RvY29sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgKHN0ciBcIndpc3BfY29yZSRJUHJvdG9jb2wkXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICgucmVwbGFjZSAoLnJlcGxhY2UgKC5jYWxsIE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcgeClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJbb2JqZWN0IFwiIFwiXCIpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgI1wiXFxdJFwiIFwiXCIpKSlcbiAgICAgICAgICAgICAgICAgICAgICBmYWxzZSkpKSlcblxuKGRlZm4gXmJvb2xlYW4gY29udGFpbnMtdmVjdG9yP1xuICBcIlJldHVybnMgdHJ1ZSBpZiB2ZWN0b3IgY29udGFpbnMgZ2l2ZW4gZWxlbWVudFwiXG4gIFt2ZWN0b3IgZWxlbWVudF1cbiAgKD49ICguaW5kZXgtb2YgdmVjdG9yIGVsZW1lbnQpIDApKVxuXG5cbihkZWZuIG1hcC1kaWN0aW9uYXJ5XG4gIFwiTWFwcyBkaWN0aW9uYXJ5IHZhbHVlcyBieSBhcHBseWluZyBgZmAgdG8gZWFjaCBvbmVcIlxuICBbc291cmNlIGZdXG4gICgucmVkdWNlICgua2V5cyBPYmplY3Qgc291cmNlKVxuICAgICAgICAgICAoZm4gW3RhcmdldCBrZXldXG4gICAgICAgICAgICAgIChzZXQhIChnZXQgdGFyZ2V0IGtleSkgKGYgKGdldCBzb3VyY2Uga2V5KSkpXG4gICAgICAgICAgICAgIHRhcmdldCkge30pKVxuXG4oZGVmIHRvLXN0cmluZyBPYmplY3QucHJvdG90eXBlLnRvLXN0cmluZylcblxuKGRlZlxuICBeezp0YWcgYm9vbGVhblxuICAgIDpkb2MgXCJSZXR1cm5zIHRydWUgaWYgeCBpcyBhIGZ1bmN0aW9uXCJ9XG4gIGZuP1xuICAoaWYgKGlkZW50aWNhbD8gKHR5cGVvZiAjXCIuXCIpIFwiZnVuY3Rpb25cIilcbiAgICAoZm5cbiAgICAgIFt4XVxuICAgICAgKGlkZW50aWNhbD8gKC5jYWxsIHRvLXN0cmluZyB4KSBcIltvYmplY3QgRnVuY3Rpb25dXCIpKVxuICAgIChmblxuICAgICAgW3hdXG4gICAgICAoaWRlbnRpY2FsPyAodHlwZW9mIHgpIFwiZnVuY3Rpb25cIikpKSlcblxuKGRlZm4gXmJvb2xlYW4gZXJyb3I/XG4gIFwiUmV0dXJucyB0cnVlIGlmIHggaXMgb2YgZXJyb3IgdHlwZVwiXG4gIFt4XVxuICAob3IgKGluc3RhbmNlPyBFcnJvciB4KVxuICAgICAgKGlkZW50aWNhbD8gKC5jYWxsIHRvLXN0cmluZyB4KSBcIltvYmplY3QgRXJyb3JdXCIpKSlcblxuKGRlZm4gXmJvb2xlYW4gc3RyaW5nP1xuICBcIlJldHVybiB0cnVlIGlmIHggaXMgYSBzdHJpbmdcIlxuICBbeF1cbiAgKG9yIChpZGVudGljYWw/ICh0eXBlb2YgeCkgXCJzdHJpbmdcIilcbiAgICAgIChpZGVudGljYWw/ICguY2FsbCB0by1zdHJpbmcgeCkgXCJbb2JqZWN0IFN0cmluZ11cIikpKVxuXG4oZGVmbiBeYm9vbGVhbiBudW1iZXI/XG4gIFwiUmV0dXJuIHRydWUgaWYgeCBpcyBhIG51bWJlclwiXG4gIFt4XVxuICAob3IgKGlkZW50aWNhbD8gKHR5cGVvZiB4KSBcIm51bWJlclwiKVxuICAgICAgKGlkZW50aWNhbD8gKC5jYWxsIHRvLXN0cmluZyB4KSBcIltvYmplY3QgTnVtYmVyXVwiKSkpXG5cbihkZWZcbiAgXns6dGFnIGJvb2xlYW5cbiAgICA6ZG9jIFwiUmV0dXJucyB0cnVlIGlmIHggaXMgYSB2ZWN0b3JcIn1cbiAgdmVjdG9yP1xuICAoaWYgKGZuPyBBcnJheS5pc0FycmF5KVxuICAgIEFycmF5LmlzQXJyYXlcbiAgICAoZm4gW3hdIChpZGVudGljYWw/ICguY2FsbCB0by1zdHJpbmcgeCkgXCJbb2JqZWN0IEFycmF5XVwiKSkpKVxuXG4oZGVmbiBeYm9vbGVhbiBkYXRlP1xuICBcIlJldHVybnMgdHJ1ZSBpZiB4IGlzIGEgZGF0ZVwiXG4gIFt4XVxuICAoaWRlbnRpY2FsPyAoLmNhbGwgdG8tc3RyaW5nIHgpIFwiW29iamVjdCBEYXRlXVwiKSlcblxuKGRlZm4gXmJvb2xlYW4gYm9vbGVhbj9cbiAgXCJSZXR1cm5zIHRydWUgaWYgeCBpcyBhIGJvb2xlYW5cIlxuICBbeF1cbiAgKG9yIChpZGVudGljYWw/IHggdHJ1ZSlcbiAgICAgIChpZGVudGljYWw/IHggZmFsc2UpXG4gICAgICAoaWRlbnRpY2FsPyAoLmNhbGwgdG8tc3RyaW5nIHgpIFwiW29iamVjdCBCb29sZWFuXVwiKSkpXG5cbihkZWZuIF5ib29sZWFuIHJlLXBhdHRlcm4/XG4gIFwiUmV0dXJucyB0cnVlIGlmIHggaXMgYSByZWd1bGFyIGV4cHJlc3Npb25cIlxuICBbeF1cbiAgKGlkZW50aWNhbD8gKC5jYWxsIHRvLXN0cmluZyB4KSBcIltvYmplY3QgUmVnRXhwXVwiKSlcblxuXG4oZGVmbiBeYm9vbGVhbiBvYmplY3Q/XG4gIFwiUmV0dXJucyB0cnVlIGlmIHggaXMgYW4gb2JqZWN0XCJcbiAgW3hdXG4gIChhbmQgeCAoaWRlbnRpY2FsPyAodHlwZW9mIHgpIFwib2JqZWN0XCIpKSlcblxuKGRlZm4gXmJvb2xlYW4gbmlsP1xuICBcIlJldHVybnMgdHJ1ZSBpZiB4IGlzIHVuZGVmaW5lZCBvciBudWxsXCJcbiAgW3hdXG4gIChvciAoaWRlbnRpY2FsPyB4IG5pbClcbiAgICAgIChpZGVudGljYWw/IHggbnVsbCkpKVxuXG4oZGVmbiBeYm9vbGVhbiB0cnVlP1xuICBcIlJldHVybnMgdHJ1ZSBpZiB4IGlzIHRydWVcIlxuICBbeF1cbiAgKGlkZW50aWNhbD8geCB0cnVlKSlcblxuKGRlZm4gXmJvb2xlYW4gZmFsc2U/XG4gIFwiUmV0dXJucyB0cnVlIGlmIHggaXMgZmFsc2VcIlxuICBbeF1cbiAgKGlkZW50aWNhbD8geCBmYWxzZSkpXG5cbihkZWZuIHJlLWZpbmRcbiAgXCJSZXR1cm5zIHRoZSBmaXJzdCByZWdleCBtYXRjaCwgaWYgYW55LCBvZiBzIHRvIHJlLCB1c2luZ1xuICByZS5leGVjKHMpLiBSZXR1cm5zIGEgdmVjdG9yLCBjb250YWluaW5nIGZpcnN0IHRoZSBtYXRjaGluZ1xuICBzdWJzdHJpbmcsIHRoZW4gYW55IGNhcHR1cmluZyBncm91cHMgaWYgdGhlIHJlZ3VsYXIgZXhwcmVzc2lvbiBjb250YWluc1xuICBjYXB0dXJpbmcgZ3JvdXBzLlwiXG4gIFtyZSBzXVxuICAobGV0IFttYXRjaGVzICguZXhlYyByZSBzKV1cbiAgICAoaWYgKG5vdCAobmlsPyBtYXRjaGVzKSlcbiAgICAgIChpZiAoaWRlbnRpY2FsPyAoLi1sZW5ndGggbWF0Y2hlcykgMSlcbiAgICAgICAgKGdldCBtYXRjaGVzIDApXG4gICAgICAgIG1hdGNoZXMpKSkpXG5cbihkZWZuIHJlLW1hdGNoZXNcbiAgW3BhdHRlcm4gc291cmNlXVxuICAobGV0IFttYXRjaGVzICguZXhlYyBwYXR0ZXJuIHNvdXJjZSldXG4gICAgKGlmIChhbmQgKG5vdCAobmlsPyBtYXRjaGVzKSlcbiAgICAgICAgICAgICAoaWRlbnRpY2FsPyAoZ2V0IG1hdGNoZXMgMCkgc291cmNlKSlcbiAgICAgIChpZiAoaWRlbnRpY2FsPyAoLi1sZW5ndGggbWF0Y2hlcykgMSlcbiAgICAgICAgKGdldCBtYXRjaGVzIDApXG4gICAgICAgIG1hdGNoZXMpKSkpXG5cbihkZWZuIHJlLXBhdHRlcm5cbiAgXCJSZXR1cm5zIGFuIGluc3RhbmNlIG9mIFJlZ0V4cCB3aGljaCBoYXMgY29tcGlsZWQgdGhlIHByb3ZpZGVkIHN0cmluZy5cIlxuICBbc11cbiAgKGxldCBbbWF0Y2ggKHJlLWZpbmQgI1wiXig/OlxcKFxcPyhbaWRtc3V4XSopXFwpKT8oLiopXCIgcyldXG4gICAgKG5ldyBSZWdFeHAgKGdldCBtYXRjaCAyKSAoZ2V0IG1hdGNoIDEpKSkpXG5cbihkZWZuIGluY1xuICBbeF1cbiAgKCsgeCAxKSlcblxuKGRlZm4gZGVjXG4gIFt4XVxuICAoLSB4IDEpKVxuXG4oZGVmbiBzdHJcbiAgXCJXaXRoIG5vIGFyZ3MsIHJldHVybnMgdGhlIGVtcHR5IHN0cmluZy4gV2l0aCBvbmUgYXJnIHgsIHJldHVybnNcbiAgeC50b1N0cmluZygpLiAgKHN0ciBuaWwpIHJldHVybnMgdGhlIGVtcHR5IHN0cmluZy4gV2l0aCBtb3JlIHRoYW5cbiAgb25lIGFyZywgcmV0dXJucyB0aGUgY29uY2F0ZW5hdGlvbiBvZiB0aGUgc3RyIHZhbHVlcyBvZiB0aGUgYXJncy5cIlxuICBbXVxuICAoLmFwcGx5IFN0cmluZy5wcm90b3R5cGUuY29uY2F0IFwiXCIgYXJndW1lbnRzKSlcblxuKGRlZm4gY2hhclxuICBcIkNvZXJjZSB0byBjaGFyXCJcbiAgW2NvZGVdXG4gICguZnJvbUNoYXJDb2RlIFN0cmluZyBjb2RlKSlcblxuXG4oZGVmbiBpbnRcbiAgXCJDb2VyY2UgdG8gaW50IGJ5IHN0cmlwcGluZyBkZWNpbWFsIHBsYWNlcy5cIlxuICBbeF1cbiAgKGlmIChudW1iZXI/IHgpXG4gICAgKGlmICg+PSB4IDApXG4gICAgICAoLmZsb29yIE1hdGggeClcbiAgICAgICguZmxvb3IgTWF0aCB4KSlcbiAgICAoLmNoYXJDb2RlQXQgeCAwKSkpXG5cbihkZWZuIHN1YnNcbiAgXCJSZXR1cm5zIHRoZSBzdWJzdHJpbmcgb2YgcyBiZWdpbm5pbmcgYXQgc3RhcnQgaW5jbHVzaXZlLCBhbmQgZW5kaW5nXG4gIGF0IGVuZCAoZGVmYXVsdHMgdG8gbGVuZ3RoIG9mIHN0cmluZyksIGV4Y2x1c2l2ZS5cIlxuICB7OmFkZGVkIFwiMS4wXCJcbiAgIDpzdGF0aWMgdHJ1ZX1cbiAgIFtzdHJpbmcgc3RhcnQgZW5kXVxuICAgKC5zdWJzdHJpbmcgc3RyaW5nIHN0YXJ0IGVuZCkpXG5cbihkZWZuLSBeYm9vbGVhbiBwYXR0ZXJuLWVxdWFsP1xuICBbeCB5XVxuICAoYW5kIChyZS1wYXR0ZXJuPyB4KVxuICAgICAgIChyZS1wYXR0ZXJuPyB5KVxuICAgICAgIChpZGVudGljYWw/ICguLXNvdXJjZSB4KSAoLi1zb3VyY2UgeSkpXG4gICAgICAgKGlkZW50aWNhbD8gKC4tZ2xvYmFsIHgpICguLWdsb2JhbCB5KSlcbiAgICAgICAoaWRlbnRpY2FsPyAoLi1tdWx0aWxpbmUgeCkgKC4tbXVsdGlsaW5lIHkpKVxuICAgICAgIChpZGVudGljYWw/ICguLWlnbm9yZUNhc2UgeCkgKC4taWdub3JlQ2FzZSB5KSkpKVxuXG4oZGVmbi0gXmJvb2xlYW4gZGF0ZS1lcXVhbD9cbiAgW3ggeV1cbiAgKGFuZCAoZGF0ZT8geClcbiAgICAgICAoZGF0ZT8geSlcbiAgICAgICAoaWRlbnRpY2FsPyAoTnVtYmVyIHgpIChOdW1iZXIgeSkpKSlcblxuXG4oZGVmbi0gXmJvb2xlYW4gZGljdGlvbmFyeS1lcXVhbD9cbiAgW3ggeV1cbiAgKGFuZCAob2JqZWN0PyB4KVxuICAgICAgIChvYmplY3Q/IHkpXG4gICAgICAgKGxldCBbeC1rZXlzIChrZXlzIHgpXG4gICAgICAgICAgICAgeS1rZXlzIChrZXlzIHkpXG4gICAgICAgICAgICAgeC1jb3VudCAoLi1sZW5ndGggeC1rZXlzKVxuICAgICAgICAgICAgIHktY291bnQgKC4tbGVuZ3RoIHkta2V5cyldXG4gICAgICAgICAoYW5kIChpZGVudGljYWw/IHgtY291bnQgeS1jb3VudClcbiAgICAgICAgICAgICAgKGxvb3AgW2luZGV4IDBcbiAgICAgICAgICAgICAgICAgICAgIGNvdW50IHgtY291bnRcbiAgICAgICAgICAgICAgICAgICAgIGtleXMgeC1rZXlzXVxuICAgICAgICAgICAgICAgIChpZiAoPCBpbmRleCBjb3VudClcbiAgICAgICAgICAgICAgICAgIChpZiAoZXF1aXZhbGVudD8gKGdldCB4IChnZXQga2V5cyBpbmRleCkpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIChnZXQgeSAoZ2V0IGtleXMgaW5kZXgpKSlcbiAgICAgICAgICAgICAgICAgICAgKHJlY3VyIChpbmMgaW5kZXgpIGNvdW50IGtleXMpXG4gICAgICAgICAgICAgICAgICAgIGZhbHNlKVxuICAgICAgICAgICAgICAgICAgdHJ1ZSkpKSkpKVxuXG4oZGVmbi0gXmJvb2xlYW4gdmVjdG9yLWVxdWFsP1xuICBbeCB5XVxuICAoYW5kICh2ZWN0b3I/IHgpXG4gICAgICAgKHZlY3Rvcj8geSlcbiAgICAgICAoaWRlbnRpY2FsPyAoLi1sZW5ndGggeCkgKC4tbGVuZ3RoIHkpKVxuICAgICAgIChsb29wIFt4cyB4XG4gICAgICAgICAgICAgIHlzIHlcbiAgICAgICAgICAgICAgaW5kZXggMFxuICAgICAgICAgICAgICBjb3VudCAoLi1sZW5ndGggeCldXG4gICAgICAgIChpZiAoPCBpbmRleCBjb3VudClcbiAgICAgICAgICAoaWYgKGVxdWl2YWxlbnQ/IChnZXQgeHMgaW5kZXgpIChnZXQgeXMgaW5kZXgpKVxuICAgICAgICAgICAgICAocmVjdXIgeHMgeXMgKGluYyBpbmRleCkgY291bnQpXG4gICAgICAgICAgICAgIGZhbHNlKVxuICAgICAgICAgIHRydWUpKSkpXG5cbihkZWZuLSBeYm9vbGVhbiBlcXVpdmFsZW50P1xuICBcIkVxdWFsaXR5LiBSZXR1cm5zIHRydWUgaWYgeCBlcXVhbHMgeSwgZmFsc2UgaWYgbm90LiBDb21wYXJlc1xuICBudW1iZXJzIGFuZCBjb2xsZWN0aW9ucyBpbiBhIHR5cGUtaW5kZXBlbmRlbnQgbWFubmVyLiBDbG9qdXJlJ3NcbiAgaW1tdXRhYmxlIGRhdGEgc3RydWN0dXJlcyBkZWZpbmUgLWVxdWl2IChhbmQgdGh1cyA9KSBhcyBhIHZhbHVlLFxuICBub3QgYW4gaWRlbnRpdHksIGNvbXBhcmlzb24uXCJcbiAgKFt4XSB0cnVlKVxuICAoW3ggeV0gKG9yIChpZGVudGljYWw/IHggeSlcbiAgICAgICAgICAgICAoY29uZCAobmlsPyB4KSAobmlsPyB5KVxuICAgICAgICAgICAgICAgICAgIChuaWw/IHkpIChuaWw/IHgpXG4gICAgICAgICAgICAgICAgICAgKHN0cmluZz8geCkgKGFuZCAoc3RyaW5nPyB5KSAoaWRlbnRpY2FsPyAoLnRvU3RyaW5nIHgpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAoLnRvU3RyaW5nIHkpKSlcbiAgICAgICAgICAgICAgICAgICAobnVtYmVyPyB4KSAoYW5kIChudW1iZXI/IHkpIChpZGVudGljYWw/ICgudmFsdWVPZiB4KVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKC52YWx1ZU9mIHkpKSlcbiAgICAgICAgICAgICAgICAgICAoZm4/IHgpIGZhbHNlXG4gICAgICAgICAgICAgICAgICAgKGJvb2xlYW4/IHgpIGZhbHNlXG4gICAgICAgICAgICAgICAgICAgKGRhdGU/IHgpIChkYXRlLWVxdWFsPyB4IHkpXG4gICAgICAgICAgICAgICAgICAgKHZlY3Rvcj8geCkgKHZlY3Rvci1lcXVhbD8geCB5IFtdIFtdKVxuICAgICAgICAgICAgICAgICAgIChyZS1wYXR0ZXJuPyB4KSAocGF0dGVybi1lcXVhbD8geCB5KVxuICAgICAgICAgICAgICAgICAgIDplbHNlIChkaWN0aW9uYXJ5LWVxdWFsPyB4IHkpKSkpXG4gIChbeCB5ICYgbW9yZV1cbiAgIChsb29wIFtwcmV2aW91cyB4XG4gICAgICAgICAgY3VycmVudCB5XG4gICAgICAgICAgaW5kZXggMFxuICAgICAgICAgIGNvdW50ICguLWxlbmd0aCBtb3JlKV1cbiAgICAoYW5kIChlcXVpdmFsZW50PyBwcmV2aW91cyBjdXJyZW50KVxuICAgICAgICAgKGlmICg8IGluZGV4IGNvdW50KVxuICAgICAgICAgIChyZWN1ciBjdXJyZW50XG4gICAgICAgICAgICAgICAgIChnZXQgbW9yZSBpbmRleClcbiAgICAgICAgICAgICAgICAgKGluYyBpbmRleClcbiAgICAgICAgICAgICAgICAgY291bnQpXG4gICAgICAgICAgdHJ1ZSkpKSkpXG5cbihkZWYgPSBlcXVpdmFsZW50PylcblxuKGRlZm4gXmJvb2xlYW4gPT1cbiAgXCJFcXVhbGl0eS4gUmV0dXJucyB0cnVlIGlmIHggZXF1YWxzIHksIGZhbHNlIGlmIG5vdC4gQ29tcGFyZXNcbiAgbnVtYmVycyBhbmQgY29sbGVjdGlvbnMgaW4gYSB0eXBlLWluZGVwZW5kZW50IG1hbm5lci4gQ2xvanVyZSdzXG4gIGltbXV0YWJsZSBkYXRhIHN0cnVjdHVyZXMgZGVmaW5lIC1lcXVpdiAoYW5kIHRodXMgPSkgYXMgYSB2YWx1ZSxcbiAgbm90IGFuIGlkZW50aXR5LCBjb21wYXJpc29uLlwiXG4gIChbeF0gdHJ1ZSlcbiAgKFt4IHldIChpZGVudGljYWw/IHggeSkpXG4gIChbeCB5ICYgbW9yZV1cbiAgIChsb29wIFtwcmV2aW91cyB4XG4gICAgICAgICAgY3VycmVudCB5XG4gICAgICAgICAgaW5kZXggMFxuICAgICAgICAgIGNvdW50ICguLWxlbmd0aCBtb3JlKV1cbiAgICAoYW5kICg9PSBwcmV2aW91cyBjdXJyZW50KVxuICAgICAgICAgKGlmICg8IGluZGV4IGNvdW50KVxuICAgICAgICAgIChyZWN1ciBjdXJyZW50XG4gICAgICAgICAgICAgICAgIChnZXQgbW9yZSBpbmRleClcbiAgICAgICAgICAgICAgICAgKGluYyBpbmRleClcbiAgICAgICAgICAgICAgICAgY291bnQpXG4gICAgICAgICAgdHJ1ZSkpKSkpXG5cblxuKGRlZm4gXmJvb2xlYW4gPlxuICBcIlJldHVybnMgbm9uLW5pbCBpZiBudW1zIGFyZSBpbiBtb25vdG9uaWNhbGx5IGRlY3JlYXNpbmcgb3JkZXIsXG4gIG90aGVyd2lzZSBmYWxzZS5cIlxuICAoW3hdIHRydWUpXG4gIChbeCB5XSAoPiB4IHkpKVxuICAoW3ggeSAmIG1vcmVdXG4gICAobG9vcCBbcHJldmlvdXMgeFxuICAgICAgICAgIGN1cnJlbnQgeVxuICAgICAgICAgIGluZGV4IDBcbiAgICAgICAgICBjb3VudCAoLi1sZW5ndGggbW9yZSldXG4gICAgKGFuZCAoPiBwcmV2aW91cyBjdXJyZW50KVxuICAgICAgICAgKGlmICg8IGluZGV4IGNvdW50KVxuICAgICAgICAgIChyZWN1ciBjdXJyZW50XG4gICAgICAgICAgICAgICAgIChnZXQgbW9yZSBpbmRleClcbiAgICAgICAgICAgICAgICAgKGluYyBpbmRleClcbiAgICAgICAgICAgICAgICAgY291bnQpXG4gICAgICAgICAgdHJ1ZSkpKSkpXG5cbihkZWZuIF5ib29sZWFuID49XG4gIFwiUmV0dXJucyBub24tbmlsIGlmIG51bXMgYXJlIGluIG1vbm90b25pY2FsbHkgZGVjcmVhc2luZyBvcmRlcixcbiAgb3RoZXJ3aXNlIGZhbHNlLlwiXG4gIChbeF0gdHJ1ZSlcbiAgKFt4IHldICg+PSB4IHkpKVxuICAoW3ggeSAmIG1vcmVdXG4gICAobG9vcCBbcHJldmlvdXMgeFxuICAgICAgICAgIGN1cnJlbnQgeVxuICAgICAgICAgIGluZGV4IDBcbiAgICAgICAgICBjb3VudCAoLi1sZW5ndGggbW9yZSldXG4gICAgKGFuZCAoPj0gcHJldmlvdXMgY3VycmVudClcbiAgICAgICAgIChpZiAoPCBpbmRleCBjb3VudClcbiAgICAgICAgICAocmVjdXIgY3VycmVudFxuICAgICAgICAgICAgICAgICAoZ2V0IG1vcmUgaW5kZXgpXG4gICAgICAgICAgICAgICAgIChpbmMgaW5kZXgpXG4gICAgICAgICAgICAgICAgIGNvdW50KVxuICAgICAgICAgIHRydWUpKSkpKVxuXG5cbihkZWZuIF5ib29sZWFuIDxcbiAgXCJSZXR1cm5zIG5vbi1uaWwgaWYgbnVtcyBhcmUgaW4gbW9ub3RvbmljYWxseSBkZWNyZWFzaW5nIG9yZGVyLFxuICBvdGhlcndpc2UgZmFsc2UuXCJcbiAgKFt4XSB0cnVlKVxuICAoW3ggeV0gKDwgeCB5KSlcbiAgKFt4IHkgJiBtb3JlXVxuICAgKGxvb3AgW3ByZXZpb3VzIHhcbiAgICAgICAgICBjdXJyZW50IHlcbiAgICAgICAgICBpbmRleCAwXG4gICAgICAgICAgY291bnQgKC4tbGVuZ3RoIG1vcmUpXVxuICAgIChhbmQgKDwgcHJldmlvdXMgY3VycmVudClcbiAgICAgICAgIChpZiAoPCBpbmRleCBjb3VudClcbiAgICAgICAgICAocmVjdXIgY3VycmVudFxuICAgICAgICAgICAgICAgICAoZ2V0IG1vcmUgaW5kZXgpXG4gICAgICAgICAgICAgICAgIChpbmMgaW5kZXgpXG4gICAgICAgICAgICAgICAgIGNvdW50KVxuICAgICAgICAgIHRydWUpKSkpKVxuXG5cbihkZWZuIF5ib29sZWFuIDw9XG4gIFwiUmV0dXJucyBub24tbmlsIGlmIG51bXMgYXJlIGluIG1vbm90b25pY2FsbHkgZGVjcmVhc2luZyBvcmRlcixcbiAgb3RoZXJ3aXNlIGZhbHNlLlwiXG4gIChbeF0gdHJ1ZSlcbiAgKFt4IHldICg8PSB4IHkpKVxuICAoW3ggeSAmIG1vcmVdXG4gICAobG9vcCBbcHJldmlvdXMgeFxuICAgICAgICAgIGN1cnJlbnQgeVxuICAgICAgICAgIGluZGV4IDBcbiAgICAgICAgICBjb3VudCAoLi1sZW5ndGggbW9yZSldXG4gICAgKGFuZCAoPD0gcHJldmlvdXMgY3VycmVudClcbiAgICAgICAgIChpZiAoPCBpbmRleCBjb3VudClcbiAgICAgICAgICAocmVjdXIgY3VycmVudFxuICAgICAgICAgICAgICAgICAoZ2V0IG1vcmUgaW5kZXgpXG4gICAgICAgICAgICAgICAgIChpbmMgaW5kZXgpXG4gICAgICAgICAgICAgICAgIGNvdW50KVxuICAgICAgICAgIHRydWUpKSkpKVxuXG4oZGVmbiBeYm9vbGVhbiArXG4gIChbXSAwKVxuICAoW2FdIGEpXG4gIChbYSBiXSAoKyBhIGIpKVxuICAoW2EgYiBjXSAoKyBhIGIgYykpXG4gIChbYSBiIGMgZF0gKCsgYSBiIGMgZCkpXG4gIChbYSBiIGMgZCBlXSAoKyBhIGIgYyBkIGUpKVxuICAoW2EgYiBjIGQgZSBmXSAoKyBhIGIgYyBkIGUgZikpXG4gIChbYSBiIGMgZCBlIGYgJiBtb3JlXVxuICAgKGxvb3AgW3ZhbHVlICgrIGEgYiBjIGQgZSBmKVxuICAgICAgICAgIGluZGV4IDBcbiAgICAgICAgICBjb3VudCAoLi1sZW5ndGggbW9yZSldXG4gICAgIChpZiAoPCBpbmRleCBjb3VudClcbiAgICAgICAocmVjdXIgKCsgdmFsdWUgKGdldCBtb3JlIGluZGV4KSlcbiAgICAgICAgICAgICAgKGluYyBpbmRleClcbiAgICAgICAgICAgICAgY291bnQpXG4gICAgICAgdmFsdWUpKSkpXG5cbihkZWZuIF5ib29sZWFuIC1cbiAgKFtdICh0aHJvdyAoVHlwZUVycm9yIFwiV3JvbmcgbnVtYmVyIG9mIGFyZ3MgcGFzc2VkIHRvOiAtXCIpKSlcbiAgKFthXSAoLSAwIGEpKVxuICAoW2EgYl0gKC0gYSBiKSlcbiAgKFthIGIgY10gKC0gYSBiIGMpKVxuICAoW2EgYiBjIGRdICgtIGEgYiBjIGQpKVxuICAoW2EgYiBjIGQgZV0gKC0gYSBiIGMgZCBlKSlcbiAgKFthIGIgYyBkIGUgZl0gKC0gYSBiIGMgZCBlIGYpKVxuICAoW2EgYiBjIGQgZSBmICYgbW9yZV1cbiAgIChsb29wIFt2YWx1ZSAoLSBhIGIgYyBkIGUgZilcbiAgICAgICAgICBpbmRleCAwXG4gICAgICAgICAgY291bnQgKC4tbGVuZ3RoIG1vcmUpXVxuICAgICAoaWYgKDwgaW5kZXggY291bnQpXG4gICAgICAgKHJlY3VyICgtIHZhbHVlIChnZXQgbW9yZSBpbmRleCkpXG4gICAgICAgICAgICAgIChpbmMgaW5kZXgpXG4gICAgICAgICAgICAgIGNvdW50KVxuICAgICAgIHZhbHVlKSkpKVxuXG4oZGVmbiBeYm9vbGVhbiAvXG4gIChbXSAodGhyb3cgKFR5cGVFcnJvciBcIldyb25nIG51bWJlciBvZiBhcmdzIHBhc3NlZCB0bzogL1wiKSkpXG4gIChbYV0gKC8gMSBhKSlcbiAgKFthIGJdICgvIGEgYikpXG4gIChbYSBiIGNdICgvIGEgYiBjKSlcbiAgKFthIGIgYyBkXSAoLyBhIGIgYyBkKSlcbiAgKFthIGIgYyBkIGVdICgvIGEgYiBjIGQgZSkpXG4gIChbYSBiIGMgZCBlIGZdICgvIGEgYiBjIGQgZSBmKSlcbiAgKFthIGIgYyBkIGUgZiAmIG1vcmVdXG4gICAobG9vcCBbdmFsdWUgKC8gYSBiIGMgZCBlIGYpXG4gICAgICAgICAgaW5kZXggMFxuICAgICAgICAgIGNvdW50ICguLWxlbmd0aCBtb3JlKV1cbiAgICAgKGlmICg8IGluZGV4IGNvdW50KVxuICAgICAgIChyZWN1ciAoLyB2YWx1ZSAoZ2V0IG1vcmUgaW5kZXgpKVxuICAgICAgICAgICAgICAoaW5jIGluZGV4KVxuICAgICAgICAgICAgICBjb3VudClcbiAgICAgICB2YWx1ZSkpKSlcblxuKGRlZm4gXmJvb2xlYW4gKlxuICAoW10gMSlcbiAgKFthXSBhKVxuICAoW2EgYl0gKCogYSBiKSlcbiAgKFthIGIgY10gKCogYSBiIGMpKVxuICAoW2EgYiBjIGRdICgqIGEgYiBjIGQpKVxuICAoW2EgYiBjIGQgZV0gKCogYSBiIGMgZCBlKSlcbiAgKFthIGIgYyBkIGUgZl0gKCogYSBiIGMgZCBlIGYpKVxuICAoW2EgYiBjIGQgZSBmICYgbW9yZV1cbiAgIChsb29wIFt2YWx1ZSAoKiBhIGIgYyBkIGUgZilcbiAgICAgICAgICBpbmRleCAwXG4gICAgICAgICAgY291bnQgKC4tbGVuZ3RoIG1vcmUpXVxuICAgICAoaWYgKDwgaW5kZXggY291bnQpXG4gICAgICAgKHJlY3VyICgqIHZhbHVlIChnZXQgbW9yZSBpbmRleCkpXG4gICAgICAgICAgICAgIChpbmMgaW5kZXgpXG4gICAgICAgICAgICAgIGNvdW50KVxuICAgICAgIHZhbHVlKSkpKVxuXG4oZGVmbiBeYm9vbGVhbiBhbmRcbiAgKFtdIHRydWUpXG4gIChbYV0gYSlcbiAgKFthIGJdIChhbmQgYSBiKSlcbiAgKFthIGIgY10gKGFuZCBhIGIgYykpXG4gIChbYSBiIGMgZF0gKGFuZCBhIGIgYyBkKSlcbiAgKFthIGIgYyBkIGVdIChhbmQgYSBiIGMgZCBlKSlcbiAgKFthIGIgYyBkIGUgZl0gKGFuZCBhIGIgYyBkIGUgZikpXG4gIChbYSBiIGMgZCBlIGYgJiBtb3JlXVxuICAgKGxvb3AgW3ZhbHVlIChhbmQgYSBiIGMgZCBlIGYpXG4gICAgICAgICAgaW5kZXggMFxuICAgICAgICAgIGNvdW50ICguLWxlbmd0aCBtb3JlKV1cbiAgICAgKGlmICg8IGluZGV4IGNvdW50KVxuICAgICAgIChyZWN1ciAoYW5kIHZhbHVlIChnZXQgbW9yZSBpbmRleCkpXG4gICAgICAgICAgICAgIChpbmMgaW5kZXgpXG4gICAgICAgICAgICAgIGNvdW50KVxuICAgICAgIHZhbHVlKSkpKVxuXG4oZGVmbiBeYm9vbGVhbiBvclxuICAoW10gbmlsKVxuICAoW2FdIGEpXG4gIChbYSBiXSAob3IgYSBiKSlcbiAgKFthIGIgY10gKG9yIGEgYiBjKSlcbiAgKFthIGIgYyBkXSAob3IgYSBiIGMgZCkpXG4gIChbYSBiIGMgZCBlXSAob3IgYSBiIGMgZCBlKSlcbiAgKFthIGIgYyBkIGUgZl0gKG9yIGEgYiBjIGQgZSBmKSlcbiAgKFthIGIgYyBkIGUgZiAmIG1vcmVdXG4gICAobG9vcCBbdmFsdWUgKG9yIGEgYiBjIGQgZSBmKVxuICAgICAgICAgIGluZGV4IDBcbiAgICAgICAgICBjb3VudCAoLi1sZW5ndGggbW9yZSldXG4gICAgIChpZiAoPCBpbmRleCBjb3VudClcbiAgICAgICAocmVjdXIgKG9yIHZhbHVlIChnZXQgbW9yZSBpbmRleCkpXG4gICAgICAgICAgICAgIChpbmMgaW5kZXgpXG4gICAgICAgICAgICAgIGNvdW50KVxuICAgICAgIHZhbHVlKSkpKVxuXG4oZGVmbiBwcmludFxuICBbJiBtb3JlXVxuICAoYXBwbHkgY29uc29sZS5sb2cgbW9yZSkpXG5cbihkZWYgbWF4IE1hdGgubWF4KVxuKGRlZiBtaW4gTWF0aC5taW4pXG4oZGVmIG5hbj8gaXNOYU4pXG4iXX0=
