{
    var _ns_ = {
            id: 'wisp.analyzer',
            doc: void 0
        };
    var wisp_ast = require('./ast');
    var meta = wisp_ast.meta;
    var withMeta = wisp_ast.withMeta;
    var isSymbol = wisp_ast.isSymbol;
    var isKeyword = wisp_ast.isKeyword;
    var isQuote = wisp_ast.isQuote;
    var symbol = wisp_ast.symbol;
    var namespace = wisp_ast.namespace;
    var name = wisp_ast.name;
    var prStr = wisp_ast.prStr;
    var isUnquote = wisp_ast.isUnquote;
    var isUnquoteSplicing = wisp_ast.isUnquoteSplicing;
    var wisp_sequence = require('./sequence');
    var isList = wisp_sequence.isList;
    var list = wisp_sequence.list;
    var conj = wisp_sequence.conj;
    var partition = wisp_sequence.partition;
    var seq = wisp_sequence.seq;
    var isEmpty = wisp_sequence.isEmpty;
    var map = wisp_sequence.map;
    var vec = wisp_sequence.vec;
    var isEvery = wisp_sequence.isEvery;
    var concat = wisp_sequence.concat;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var last = wisp_sequence.last;
    var butlast = wisp_sequence.butlast;
    var interleave = wisp_sequence.interleave;
    var cons = wisp_sequence.cons;
    var count = wisp_sequence.count;
    var some = wisp_sequence.some;
    var assoc = wisp_sequence.assoc;
    var reduce = wisp_sequence.reduce;
    var filter = wisp_sequence.filter;
    var isSeq = wisp_sequence.isSeq;
    var wisp_runtime = require('./runtime');
    var isNil = wisp_runtime.isNil;
    var isDictionary = wisp_runtime.isDictionary;
    var isVector = wisp_runtime.isVector;
    var keys = wisp_runtime.keys;
    var vals = wisp_runtime.vals;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isBoolean = wisp_runtime.isBoolean;
    var isDate = wisp_runtime.isDate;
    var isRePattern = wisp_runtime.isRePattern;
    var isEven = wisp_runtime.isEven;
    var isEqual = wisp_runtime.isEqual;
    var max = wisp_runtime.max;
    var dec = wisp_runtime.dec;
    var dictionary = wisp_runtime.dictionary;
    var subs = wisp_runtime.subs;
    var inc = wisp_runtime.inc;
    var dec = wisp_runtime.dec;
    var wisp_expander = require('./expander');
    var macroexpand = wisp_expander.macroexpand;
    var wisp_string = require('./string');
    var split = wisp_string.split;
    var join = wisp_string.join;
}
var syntaxError = exports.syntaxError = function syntaxError(message, form) {
        return function () {
            var metadataø1 = meta(form);
            var lineø1 = ((metadataø1 || 0)['start'] || 0)['line'];
            var uriø1 = (metadataø1 || 0)['uri'];
            var columnø1 = ((metadataø1 || 0)['start'] || 0)['column'];
            var errorø1 = SyntaxError('' + message + '\n' + 'Form: ' + prStr(form) + '\n' + 'URI: ' + uriø1 + '\n' + 'Line: ' + lineø1 + '\n' + 'Column: ' + columnø1);
            errorø1.lineNumber = lineø1;
            errorø1.line = lineø1;
            errorø1.columnNumber = columnø1;
            errorø1.column = columnø1;
            errorø1.fileName = uriø1;
            errorø1.uri = uriø1;
            return (function () {
                throw errorø1;
            })();
        }.call(this);
    };
var analyzeKeyword = exports.analyzeKeyword = function analyzeKeyword(env, form) {
        return {
            'op': 'constant',
            'form': form
        };
    };
var __specials__ = exports.__specials__ = {};
var installSpecial = exports.installSpecial = function installSpecial(op, analyzer) {
        return (__specials__ || 0)[name(op)] = analyzer;
    };
var analyzeSpecial = exports.analyzeSpecial = function analyzeSpecial(analyzer, env, form) {
        return function () {
            var metadataø1 = meta(form);
            var astø1 = analyzer(env, form);
            return conj({
                'start': (metadataø1 || 0)['start'],
                'end': (metadataø1 || 0)['end']
            }, astø1);
        }.call(this);
    };
var analyzeIf = exports.analyzeIf = function analyzeIf(env, form) {
        return function () {
            var formsø1 = rest(form);
            var testø1 = analyze(env, first(formsø1));
            var consequentø1 = analyze(env, second(formsø1));
            var alternateø1 = analyze(env, third(formsø1));
            count(formsø1) < 2 ? syntaxError('Malformed if expression, too few operands', form) : void 0;
            return {
                'op': 'if',
                'form': form,
                'test': testø1,
                'consequent': consequentø1,
                'alternate': alternateø1
            };
        }.call(this);
    };
installSpecial('if', analyzeIf);
var analyzeThrow = exports.analyzeThrow = function analyzeThrow(env, form) {
        return function () {
            var expressionø1 = analyze(env, second(form));
            return {
                'op': 'throw',
                'form': form,
                'throw': expressionø1
            };
        }.call(this);
    };
installSpecial('throw', analyzeThrow);
var analyzeTry = exports.analyzeTry = function analyzeTry(env, form) {
        return function () {
            var formsø1 = vec(rest(form));
            var tailø1 = last(formsø1);
            var finalizerFormø1 = isList(tailø1) && isEqual(symbol(void 0, 'finally'), first(tailø1)) ? rest(tailø1) : void 0;
            var finalizerø1 = finalizerFormø1 ? analyzeBlock(env, finalizerFormø1) : void 0;
            var bodyFormø1 = finalizerø1 ? butlast(formsø1) : formsø1;
            var tailø2 = last(bodyFormø1);
            var handlerFormø1 = isList(tailø2) && isEqual(symbol(void 0, 'catch'), first(tailø2)) ? rest(tailø2) : void 0;
            var handlerø1 = handlerFormø1 ? conj({ 'name': analyze(env, first(handlerFormø1)) }, analyzeBlock(env, rest(handlerFormø1))) : void 0;
            var bodyø1 = handlerFormø1 ? analyzeBlock(subEnv(env), butlast(bodyFormø1)) : analyzeBlock(subEnv(env), bodyFormø1);
            return {
                'op': 'try',
                'form': form,
                'body': bodyø1,
                'handler': handlerø1,
                'finalizer': finalizerø1
            };
        }.call(this);
    };
installSpecial('try', analyzeTry);
var analyzeSet = exports.analyzeSet = function analyzeSet(env, form) {
        return function () {
            var bodyø1 = rest(form);
            var leftø1 = first(bodyø1);
            var rightø1 = second(bodyø1);
            var targetø1 = isSymbol(leftø1) ? analyzeSymbol(env, leftø1) : isList(leftø1) ? analyzeList(env, leftø1) : 'else' ? leftø1 : void 0;
            var valueø1 = analyze(env, rightø1);
            return {
                'op': 'set!',
                'target': targetø1,
                'value': valueø1,
                'form': form
            };
        }.call(this);
    };
installSpecial('set!', analyzeSet);
var analyzeNew = exports.analyzeNew = function analyzeNew(env, form) {
        return function () {
            var bodyø1 = rest(form);
            var constructorø1 = analyze(env, first(bodyø1));
            var paramsø1 = vec(map(function ($1) {
                    return analyze(env, $1);
                }, rest(bodyø1)));
            return {
                'op': 'new',
                'constructor': constructorø1,
                'form': form,
                'params': paramsø1
            };
        }.call(this);
    };
installSpecial('new', analyzeNew);
var analyzeAget = exports.analyzeAget = function analyzeAget(env, form) {
        return function () {
            var bodyø1 = rest(form);
            var targetø1 = analyze(env, first(bodyø1));
            var attributeø1 = second(bodyø1);
            var fieldø1 = isQuote(attributeø1) && isSymbol(second(attributeø1)) && second(attributeø1);
            return isNil(attributeø1) ? syntaxError('Malformed aget expression expected (aget object member)', form) : {
                'op': 'member-expression',
                'computed': !fieldø1,
                'form': form,
                'target': targetø1,
                'property': fieldø1 ? conj(analyzeSpecial(analyzeIdentifier, env, fieldø1), { 'binding': void 0 }) : analyze(env, attributeø1)
            };
        }.call(this);
    };
installSpecial('aget', analyzeAget);
var parseDef = exports.parseDef = function parseDef() {
        switch (arguments.length) {
        case 1:
            var id = arguments[0];
            return { 'id': id };
        case 2:
            var id = arguments[0];
            var init = arguments[1];
            return {
                'id': id,
                'init': init
            };
        case 3:
            var id = arguments[0];
            var doc = arguments[1];
            var init = arguments[2];
            return {
                'id': id,
                'doc': doc,
                'init': init
            };
        default:
            throw RangeError('Wrong number of arguments passed');
        }
    };
var analyzeDef = exports.analyzeDef = function analyzeDef(env, form) {
        return function () {
            var paramsø1 = parseDef.apply(void 0, vec(rest(form)));
            var idø1 = (paramsø1 || 0)['id'];
            var metadataø1 = meta(idø1);
            var bindingø1 = analyzeSpecial(analyzeDeclaration, env, idø1);
            var initø1 = analyze(env, (paramsø1 || 0)['init']);
            var docø1 = (paramsø1 || 0)['doc'] || (metadataø1 || 0)['doc'];
            return {
                'op': 'def',
                'doc': docø1,
                'id': bindingø1,
                'init': initø1,
                'export': (env || 0)['top'] && !(metadataø1 || 0)['private'],
                'form': form
            };
        }.call(this);
    };
installSpecial('def', analyzeDef);
var analyzeDo = exports.analyzeDo = function analyzeDo(env, form) {
        return function () {
            var expressionsø1 = rest(form);
            var bodyø1 = analyzeBlock(env, expressionsø1);
            return conj(bodyø1, {
                'op': 'do',
                'form': form
            });
        }.call(this);
    };
installSpecial('do', analyzeDo);
var analyzeSymbol = exports.analyzeSymbol = function analyzeSymbol(env, form) {
        return function () {
            var formsø1 = split(name(form), '.');
            var metadataø1 = meta(form);
            var startø1 = (metadataø1 || 0)['start'];
            var endø1 = (metadataø1 || 0)['end'];
            var expansionø1 = count(formsø1) > 1 ? list(symbol(void 0, 'aget'), withMeta(symbol(first(formsø1)), conj(metadataø1, {
                    'start': startø1,
                    'end': {
                        'line': (endø1 || 0)['line'],
                        'column': 1 + (startø1 || 0)['column'] + count(first(formsø1))
                    }
                })), list(symbol(void 0, 'quote'), withMeta(symbol(join('.', rest(formsø1))), conj(metadataø1, {
                    'end': endø1,
                    'start': {
                        'line': (startø1 || 0)['line'],
                        'column': 1 + (startø1 || 0)['column'] + count(first(formsø1))
                    }
                })))) : void 0;
            return expansionø1 ? analyze(env, withMeta(expansionø1, meta(form))) : analyzeSpecial(analyzeIdentifier, env, form);
        }.call(this);
    };
var analyzeIdentifier = exports.analyzeIdentifier = function analyzeIdentifier(env, form) {
        return {
            'op': 'var',
            'type': 'identifier',
            'form': form,
            'start': (meta(form) || 0)['start'],
            'end': (meta(form) || 0)['end'],
            'binding': resolveBinding(env, form)
        };
    };
var unresolvedBinding = exports.unresolvedBinding = function unresolvedBinding(env, form) {
        return {
            'op': 'unresolved-binding',
            'type': 'unresolved-binding',
            'identifier': {
                'type': 'identifier',
                'form': symbol(namespace(form), name(form))
            },
            'start': (meta(form) || 0)['start'],
            'end': (meta(form) || 0)['end']
        };
    };
var resolveBinding = exports.resolveBinding = function resolveBinding(env, form) {
        return ((env || 0)['locals'] || 0)[name(form)] || ((env || 0)['enclosed'] || 0)[name(form)] || unresolvedBinding(env, form);
    };
var analyzeShadow = exports.analyzeShadow = function analyzeShadow(env, id) {
        return function () {
            var bindingø1 = resolveBinding(env, id);
            return {
                'depth': inc((bindingø1 || 0)['depth'] || 0),
                'shadow': bindingø1
            };
        }.call(this);
    };
var analyzeBinding = exports.analyzeBinding = function analyzeBinding(env, form) {
        return function () {
            var idø1 = first(form);
            var bodyø1 = second(form);
            return conj(analyzeShadow(env, idø1), {
                'op': 'binding',
                'type': 'binding',
                'id': idø1,
                'init': analyze(env, bodyø1),
                'form': form
            });
        }.call(this);
    };
var analyzeDeclaration = exports.analyzeDeclaration = function analyzeDeclaration(env, form) {
        !!(namespace(form) || 1 < count(split('.', '' + form))) ? (function () {
            throw Error('' + 'Assert failed: ' + '' + '(not (or (namespace form) (< 1 (count (split "." (str form))))))');
        })() : void 0;
        return conj(analyzeShadow(env, form), {
            'op': 'var',
            'type': 'identifier',
            'depth': 0,
            'id': form,
            'form': form
        });
    };
var analyzeParam = exports.analyzeParam = function analyzeParam(env, form) {
        return conj(analyzeShadow(env, form), {
            'op': 'param',
            'type': 'parameter',
            'id': form,
            'form': form,
            'start': (meta(form) || 0)['start'],
            'end': (meta(form) || 0)['end']
        });
    };
var withBinding = exports.withBinding = function withBinding(env, form) {
        return conj(env, {
            'locals': assoc((env || 0)['locals'], name((form || 0)['id']), form),
            'bindings': conj((env || 0)['bindings'], form)
        });
    };
var withParam = exports.withParam = function withParam(env, form) {
        return conj(withBinding(env, form), { 'params': conj((env || 0)['params'], form) });
    };
var subEnv = exports.subEnv = function subEnv(env) {
        return {
            'enclosed': conj({}, (env || 0)['enclosed'], (env || 0)['locals']),
            'locals': {},
            'bindings': [],
            'params': (env || 0)['params'] || []
        };
    };
var analyzeLet_ = exports.analyzeLet_ = function analyzeLet_(env, form, isLoop) {
        return function () {
            var expressionsø1 = rest(form);
            var bindingsø1 = first(expressionsø1);
            var bodyø1 = rest(expressionsø1);
            var isValidBindingsø1 = isVector(bindingsø1) && isEven(count(bindingsø1));
            var _ø1 = !isValidBindingsø1 ? (function () {
                    throw Error('' + 'Assert failed: ' + 'bindings must be vector of even number of elements' + 'valid-bindings?');
                })() : void 0;
            var scopeø1 = reduce(function ($1, $2) {
                    return withBinding($1, analyzeBinding($1, $2));
                }, subEnv(env), partition(2, bindingsø1));
            var bindingsø2 = (scopeø1 || 0)['bindings'];
            var expressionsø2 = analyzeBlock(isLoop ? conj(scopeø1, { 'params': bindingsø2 }) : scopeø1, bodyø1);
            return {
                'op': 'let',
                'form': form,
                'start': (meta(form) || 0)['start'],
                'end': (meta(form) || 0)['end'],
                'bindings': bindingsø2,
                'statements': (expressionsø2 || 0)['statements'],
                'result': (expressionsø2 || 0)['result']
            };
        }.call(this);
    };
var analyzeLet = exports.analyzeLet = function analyzeLet(env, form) {
        return analyzeLet_(env, form, false);
    };
installSpecial('let', analyzeLet);
var analyzeLoop = exports.analyzeLoop = function analyzeLoop(env, form) {
        return conj(analyzeLet_(env, form, true), { 'op': 'loop' });
    };
installSpecial('loop', analyzeLoop);
var analyzeRecur = exports.analyzeRecur = function analyzeRecur(env, form) {
        return function () {
            var paramsø1 = (env || 0)['params'];
            var formsø1 = vec(map(function ($1) {
                    return analyze(env, $1);
                }, rest(form)));
            return isEqual(count(paramsø1), count(formsø1)) ? {
                'op': 'recur',
                'form': form,
                'params': formsø1
            } : syntaxError('Recurs with wrong number of arguments', form);
        }.call(this);
    };
installSpecial('recur', analyzeRecur);
var analyzeQuotedList = exports.analyzeQuotedList = function analyzeQuotedList(form) {
        return {
            'op': 'list',
            'items': map(analyzeQuoted, vec(form)),
            'form': form,
            'start': (meta(form) || 0)['start'],
            'end': (meta(form) || 0)['end']
        };
    };
var analyzeQuotedVector = exports.analyzeQuotedVector = function analyzeQuotedVector(form) {
        return {
            'op': 'vector',
            'items': map(analyzeQuoted, form),
            'form': form,
            'start': (meta(form) || 0)['start'],
            'end': (meta(form) || 0)['end']
        };
    };
var analyzeQuotedDictionary = exports.analyzeQuotedDictionary = function analyzeQuotedDictionary(form) {
        return function () {
            var namesø1 = vec(map(analyzeQuoted, keys(form)));
            var valuesø1 = vec(map(analyzeQuoted, vals(form)));
            return {
                'op': 'dictionary',
                'form': form,
                'keys': namesø1,
                'values': valuesø1,
                'start': (meta(form) || 0)['start'],
                'end': (meta(form) || 0)['end']
            };
        }.call(this);
    };
var analyzeQuotedSymbol = exports.analyzeQuotedSymbol = function analyzeQuotedSymbol(form) {
        return {
            'op': 'symbol',
            'name': name(form),
            'namespace': namespace(form),
            'form': form
        };
    };
var analyzeQuotedKeyword = exports.analyzeQuotedKeyword = function analyzeQuotedKeyword(form) {
        return {
            'op': 'keyword',
            'name': name(form),
            'namespace': namespace(form),
            'form': form
        };
    };
var analyzeQuoted = exports.analyzeQuoted = function analyzeQuoted(form) {
        return isSymbol(form) ? analyzeQuotedSymbol(form) : isKeyword(form) ? analyzeQuotedKeyword(form) : isList(form) ? analyzeQuotedList(form) : isVector(form) ? analyzeQuotedVector(form) : isDictionary(form) ? analyzeQuotedDictionary(form) : 'else' ? {
            'op': 'constant',
            'form': form
        } : void 0;
    };
var analyzeQuote = exports.analyzeQuote = function analyzeQuote(env, form) {
        return analyzeQuoted(second(form));
    };
installSpecial('quote', analyzeQuote);
var analyzeStatement = exports.analyzeStatement = function analyzeStatement(env, form) {
        return function () {
            var statementsø1 = (env || 0)['statements'] || [];
            var bindingsø1 = (env || 0)['bindings'] || [];
            var statementø1 = analyze(conj(env, { 'statements': void 0 }), form);
            var opø1 = (statementø1 || 0)['op'];
            var defsø1 = isEqual(opø1, 'def') ? [(statementø1 || 0)['var']] : 'else' ? void 0 : void 0;
            return conj(env, {
                'statements': conj(statementsø1, statementø1),
                'bindings': concat(bindingsø1, defsø1)
            });
        }.call(this);
    };
var analyzeBlock = exports.analyzeBlock = function analyzeBlock(env, form) {
        return function () {
            var bodyø1 = count(form) > 1 ? reduce(analyzeStatement, env, butlast(form)) : void 0;
            var resultø1 = analyze(bodyø1 || env, last(form));
            return {
                'statements': (bodyø1 || 0)['statements'],
                'result': resultø1
            };
        }.call(this);
    };
var analyzeFnMethod = exports.analyzeFnMethod = function analyzeFnMethod(env, form) {
        return function () {
            var signatureø1 = isList(form) && isVector(first(form)) ? first(form) : syntaxError('Malformed fn overload form', form);
            var bodyø1 = rest(form);
            var variadicø1 = some(function ($1) {
                    return isEqual(symbol(void 0, '&'), $1);
                }, signatureø1);
            var paramsø1 = variadicø1 ? filter(function ($1) {
                    return !isEqual(symbol(void 0, '&'), $1);
                }, signatureø1) : signatureø1;
            var arityø1 = variadicø1 ? dec(count(paramsø1)) : count(paramsø1);
            var scopeø1 = reduce(function ($1, $2) {
                    return withParam($1, analyzeParam($1, $2));
                }, conj(env, { 'params': [] }), paramsø1);
            return conj(analyzeBlock(scopeø1, bodyø1), {
                'op': 'overload',
                'variadic': variadicø1,
                'arity': arityø1,
                'params': (scopeø1 || 0)['params'],
                'form': form
            });
        }.call(this);
    };
var analyzeFn = exports.analyzeFn = function analyzeFn(env, form) {
        return function () {
            var formsø1 = rest(form);
            var formsø2 = isSymbol(first(formsø1)) ? formsø1 : cons(void 0, formsø1);
            var idø1 = first(formsø2);
            var bindingø1 = idø1 ? analyzeSpecial(analyzeDeclaration, env, idø1) : void 0;
            var bodyø1 = rest(formsø2);
            var overloadsø1 = isVector(first(bodyø1)) ? list(bodyø1) : isList(first(bodyø1)) && isVector(first(first(bodyø1))) ? bodyø1 : 'else' ? syntaxError('' + 'Malformed fn expression, ' + 'parameter declaration (' + prStr(first(bodyø1)) + ') must be a vector', form) : void 0;
            var scopeø1 = bindingø1 ? withBinding(subEnv(env), bindingø1) : subEnv(env);
            var methodsø1 = map(function ($1) {
                    return analyzeFnMethod(scopeø1, $1);
                }, vec(overloadsø1));
            var arityø1 = max.apply(void 0, map(function ($1) {
                    return ($1 || 0)['arity'];
                }, methodsø1));
            var variadicø1 = some(function ($1) {
                    return ($1 || 0)['variadic'];
                }, methodsø1);
            return {
                'op': 'fn',
                'type': 'function',
                'id': bindingø1,
                'variadic': variadicø1,
                'methods': methodsø1,
                'form': form
            };
        }.call(this);
    };
installSpecial('fn', analyzeFn);
var parseReferences = exports.parseReferences = function parseReferences(forms) {
        return reduce(function (references, form) {
            return isSeq(form) ? assoc(references, name(first(form)), vec(rest(form))) : references;
        }, {}, forms);
    };
var parseRequire = exports.parseRequire = function parseRequire(form) {
        return function () {
            var requirementø1 = isSymbol(form) ? [form] : vec(form);
            var idø1 = first(requirementø1);
            var paramsø1 = dictionary.apply(void 0, rest(requirementø1));
            var renamesø1 = (paramsø1 || 0)['\uA789rename'];
            var namesø1 = (paramsø1 || 0)['\uA789refer'];
            var aliasø1 = (paramsø1 || 0)['\uA789as'];
            var referencesø1 = !isEmpty(namesø1) ? reduce(function (refers, reference) {
                    return conj(refers, {
                        'op': 'refer',
                        'form': reference,
                        'name': reference,
                        'rename': (renamesø1 || 0)[reference] || (renamesø1 || 0)[name(reference)],
                        'ns': idø1
                    });
                }, [], namesø1) : void 0;
            return {
                'op': 'require',
                'alias': aliasø1,
                'ns': idø1,
                'refer': referencesø1,
                'form': form
            };
        }.call(this);
    };
var analyzeNs = exports.analyzeNs = function analyzeNs(env, form) {
        return function () {
            var formsø1 = rest(form);
            var nameø1 = first(formsø1);
            var bodyø1 = rest(formsø1);
            var docø1 = isString(first(bodyø1)) ? first(bodyø1) : void 0;
            var referencesø1 = parseReferences(docø1 ? rest(bodyø1) : bodyø1);
            var requirementsø1 = (referencesø1 || 0)['require'] ? map(parseRequire, (referencesø1 || 0)['require']) : void 0;
            return {
                'op': 'ns',
                'name': nameø1,
                'doc': docø1,
                'require': requirementsø1 ? vec(requirementsø1) : void 0,
                'form': form
            };
        }.call(this);
    };
installSpecial('ns', analyzeNs);
var analyzeList = exports.analyzeList = function analyzeList(env, form) {
        return function () {
            var expansionø1 = macroexpand(form, env);
            var operatorø1 = first(form);
            var analyzerø1 = isSymbol(operatorø1) && (__specials__ || 0)[name(operatorø1)];
            return !(expansionø1 === form) ? analyze(env, expansionø1) : analyzerø1 ? analyzeSpecial(analyzerø1, env, expansionø1) : 'else' ? analyzeInvoke(env, expansionø1) : void 0;
        }.call(this);
    };
var analyzeVector = exports.analyzeVector = function analyzeVector(env, form) {
        return function () {
            var itemsø1 = vec(map(function ($1) {
                    return analyze(env, $1);
                }, form));
            return {
                'op': 'vector',
                'form': form,
                'items': itemsø1
            };
        }.call(this);
    };
var analyzeDictionary = exports.analyzeDictionary = function analyzeDictionary(env, form) {
        return function () {
            var namesø1 = vec(map(function ($1) {
                    return analyze(env, $1);
                }, keys(form)));
            var valuesø1 = vec(map(function ($1) {
                    return analyze(env, $1);
                }, vals(form)));
            return {
                'op': 'dictionary',
                'keys': namesø1,
                'values': valuesø1,
                'form': form
            };
        }.call(this);
    };
var analyzeInvoke = exports.analyzeInvoke = function analyzeInvoke(env, form) {
        return function () {
            var calleeø1 = analyze(env, first(form));
            var paramsø1 = vec(map(function ($1) {
                    return analyze(env, $1);
                }, rest(form)));
            return {
                'op': 'invoke',
                'callee': calleeø1,
                'params': paramsø1,
                'form': form
            };
        }.call(this);
    };
var analyzeConstant = exports.analyzeConstant = function analyzeConstant(env, form) {
        return {
            'op': 'constant',
            'form': form
        };
    };
var analyze = exports.analyze = function analyze() {
        switch (arguments.length) {
        case 1:
            var form = arguments[0];
            return analyze({
                'locals': {},
                'bindings': [],
                'top': true
            }, form);
        case 2:
            var env = arguments[0];
            var form = arguments[1];
            return isNil(form) ? analyzeConstant(env, form) : isSymbol(form) ? analyzeSymbol(env, form) : isList(form) ? isEmpty(form) ? analyzeQuoted(form) : analyzeList(env, form) : isDictionary(form) ? analyzeDictionary(env, form) : isVector(form) ? analyzeVector(env, form) : isKeyword(form) ? analyzeKeyword(env, form) : 'else' ? analyzeConstant(env, form) : void 0;
        default:
            throw RangeError('Wrong number of arguments passed');
        }
    };
//# sourceMappingURL=data:application/json;base64,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
