{
    var _ns_ = {
            id: 'wisp.reader',
            doc: 'Reader module provides functions for reading text input\n  as wisp data structures'
        };
    var wisp_sequence = require('./sequence');
    var list = wisp_sequence.list;
    var isList = wisp_sequence.isList;
    var count = wisp_sequence.count;
    var isEmpty = wisp_sequence.isEmpty;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var map = wisp_sequence.map;
    var vec = wisp_sequence.vec;
    var cons = wisp_sequence.cons;
    var conj = wisp_sequence.conj;
    var rest = wisp_sequence.rest;
    var concat = wisp_sequence.concat;
    var last = wisp_sequence.last;
    var butlast = wisp_sequence.butlast;
    var sort = wisp_sequence.sort;
    var lazySeq = wisp_sequence.lazySeq;
    var reduce = wisp_sequence.reduce;
    var wisp_runtime = require('./runtime');
    var isOdd = wisp_runtime.isOdd;
    var dictionary = wisp_runtime.dictionary;
    var keys = wisp_runtime.keys;
    var isNil = wisp_runtime.isNil;
    var inc = wisp_runtime.inc;
    var dec = wisp_runtime.dec;
    var isVector = wisp_runtime.isVector;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isBoolean = wisp_runtime.isBoolean;
    var isObject = wisp_runtime.isObject;
    var isDictionary = wisp_runtime.isDictionary;
    var rePattern = wisp_runtime.rePattern;
    var reMatches = wisp_runtime.reMatches;
    var reFind = wisp_runtime.reFind;
    var str = wisp_runtime.str;
    var subs = wisp_runtime.subs;
    var char = wisp_runtime.char;
    var vals = wisp_runtime.vals;
    var isEqual = wisp_runtime.isEqual;
    var wisp_ast = require('./ast');
    var isSymbol = wisp_ast.isSymbol;
    var symbol = wisp_ast.symbol;
    var isKeyword = wisp_ast.isKeyword;
    var keyword = wisp_ast.keyword;
    var meta = wisp_ast.meta;
    var withMeta = wisp_ast.withMeta;
    var name = wisp_ast.name;
    var gensym = wisp_ast.gensym;
    var wisp_string = require('./string');
    var split = wisp_string.split;
    var join = wisp_string.join;
}
var pushBackReader = exports.pushBackReader = function pushBackReader(source, uri) {
        return {
            'lines': split(source, '\n'),
            'buffer': '',
            'uri': uri,
            'column': -1,
            'line': 0
        };
    };
var peekChar = exports.peekChar = function peekChar(reader) {
        return function () {
            var lineø1 = (reader || 0)['lines'][(reader || 0)['line']];
            var columnø1 = inc((reader || 0)['column']);
            return isNil(lineø1) ? void 0 : lineø1[columnø1] || '\n';
        }.call(this);
    };
var readChar = exports.readChar = function readChar(reader) {
        return function () {
            var chø1 = peekChar(reader);
            isNewline(peekChar(reader)) ? (function () {
                (reader || 0)['line'] = inc((reader || 0)['line']);
                return (reader || 0)['column'] = -1;
            })() : (reader || 0)['column'] = inc((reader || 0)['column']);
            return chø1;
        }.call(this);
    };
var isNewline = exports.isNewline = function isNewline(ch) {
        return '\n' === ch;
    };
var isBreakingWhitespace = exports.isBreakingWhitespace = function isBreakingWhitespace(ch) {
        return ch === ' ' || ch === '\t' || ch === '\n' || ch === '\r';
    };
var isWhitespace = exports.isWhitespace = function isWhitespace(ch) {
        return isBreakingWhitespace(ch) || ',' === ch;
    };
var isNumeric = exports.isNumeric = function isNumeric(ch) {
        return ch === '0' || ch === '1' || ch === '2' || ch === '3' || ch === '4' || ch === '5' || ch === '6' || ch === '7' || ch === '8' || ch === '9';
    };
var isCommentPrefix = exports.isCommentPrefix = function isCommentPrefix(ch) {
        return ';' === ch;
    };
var isNumberLiteral = exports.isNumberLiteral = function isNumberLiteral(reader, initch) {
        return isNumeric(initch) || ('+' === initch || '-' === initch) && isNumeric(peekChar(reader));
    };
var readerError = exports.readerError = function readerError(reader, message) {
        return function () {
            var textø1 = '' + message + '\n' + 'line:' + (reader || 0)['line'] + '\n' + 'column:' + (reader || 0)['column'];
            var errorø1 = SyntaxError(textø1, (reader || 0)['uri']);
            errorø1.line = (reader || 0)['line'];
            errorø1.column = (reader || 0)['column'];
            errorø1.uri = (reader || 0)['uri'];
            return (function () {
                throw errorø1;
            })();
        }.call(this);
    };
var isMacroTerminating = exports.isMacroTerminating = function isMacroTerminating(ch) {
        return !(ch === '#') && !(ch === '\'') && !(ch === ':') && macros(ch);
    };
var readToken = exports.readToken = function readToken(reader, initch) {
        return function loop() {
            var recur = loop;
            var bufferø1 = initch;
            var chø1 = peekChar(reader);
            do {
                recur = isNil(chø1) || isWhitespace(chø1) || isMacroTerminating(chø1) ? bufferø1 : (loop[0] = '' + bufferø1 + readChar(reader), loop[1] = peekChar(reader), loop);
            } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var skipLine = exports.skipLine = function skipLine(reader, _) {
        return function loop() {
            var recur = loop;
            do {
                recur = function () {
                    var chø1 = readChar(reader);
                    return chø1 === '\n' || chø1 === '\r' || isNil(chø1) ? reader : (loop);
                }.call(this);
            } while (recur === loop);
            return recur;
        }.call(this);
    };
var intPattern = exports.intPattern = rePattern('^([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?$');
var ratioPattern = exports.ratioPattern = rePattern('([-+]?[0-9]+)/([0-9]+)');
var floatPattern = exports.floatPattern = rePattern('([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?');
var matchInt = exports.matchInt = function matchInt(s) {
        return function () {
            var groupsø1 = reFind(intPattern, s);
            var group3ø1 = groupsø1[2];
            return !(isNil(group3ø1) || count(group3ø1) < 1) ? 0 : function () {
                var negateø1 = '-' === groupsø1[1] ? -1 : 1;
                var aø1 = groupsø1[3] ? [
                        groupsø1[3],
                        10
                    ] : groupsø1[4] ? [
                        groupsø1[4],
                        16
                    ] : groupsø1[5] ? [
                        groupsø1[5],
                        8
                    ] : groupsø1[7] ? [
                        groupsø1[7],
                        parseInt(groupsø1[7])
                    ] : 'else' ? [
                        void 0,
                        void 0
                    ] : void 0;
                var nø1 = aø1[0];
                var radixø1 = aø1[1];
                return isNil(nø1) ? void 0 : negateø1 * parseInt(nø1, radixø1);
            }.call(this);
        }.call(this);
    };
var matchRatio = exports.matchRatio = function matchRatio(s) {
        return function () {
            var groupsø1 = reFind(ratioPattern, s);
            var numinatorø1 = groupsø1[1];
            var denominatorø1 = groupsø1[2];
            return parseInt(numinatorø1) / parseInt(denominatorø1);
        }.call(this);
    };
var matchFloat = exports.matchFloat = function matchFloat(s) {
        return parseFloat(s);
    };
var matchNumber = exports.matchNumber = function matchNumber(s) {
        return reMatches(intPattern, s) ? matchInt(s) : reMatches(ratioPattern, s) ? matchRatio(s) : reMatches(floatPattern, s) ? matchFloat(s) : void 0;
    };
var escapeCharMap = exports.escapeCharMap = function escapeCharMap(c) {
        return c === 't' ? '\t' : c === 'r' ? '\r' : c === 'n' ? '\n' : c === '\\' ? '\\' : c === '"' ? '"' : c === 'b' ? '\b' : c === 'f' ? '\f' : 'else' ? void 0 : void 0;
    };
var read2Chars = exports.read2Chars = function read2Chars(reader) {
        return '' + readChar(reader) + readChar(reader);
    };
var read4Chars = exports.read4Chars = function read4Chars(reader) {
        return '' + readChar(reader) + readChar(reader) + readChar(reader) + readChar(reader);
    };
var unicode2Pattern = exports.unicode2Pattern = rePattern('[0-9A-Fa-f]{2}');
var unicode4Pattern = exports.unicode4Pattern = rePattern('[0-9A-Fa-f]{4}');
var validateUnicodeEscape = exports.validateUnicodeEscape = function validateUnicodeEscape(unicodePattern, reader, escapeChar, unicodeStr) {
        return reMatches(unicodePattern, unicodeStr) ? unicodeStr : readerError(reader, '' + 'Unexpected unicode escape ' + '\\' + escapeChar + unicodeStr);
    };
var makeUnicodeChar = exports.makeUnicodeChar = function makeUnicodeChar(codeStr, base) {
        return function () {
            var baseø2 = base || 16;
            var codeø1 = parseInt(codeStr, baseø2);
            return char(codeø1);
        }.call(this);
    };
var escapeChar = exports.escapeChar = function escapeChar(buffer, reader) {
        return function () {
            var chø1 = readChar(reader);
            var mapresultø1 = escapeCharMap(chø1);
            return mapresultø1 ? mapresultø1 : chø1 === 'x' ? makeUnicodeChar(validateUnicodeEscape(unicode2Pattern, reader, chø1, read2Chars(reader))) : chø1 === 'u' ? makeUnicodeChar(validateUnicodeEscape(unicode4Pattern, reader, chø1, read4Chars(reader))) : isNumeric(chø1) ? char(chø1) : 'else' ? readerError(reader, '' + 'Unexpected unicode escape ' + '\\' + chø1) : void 0;
        }.call(this);
    };
var readPast = exports.readPast = function readPast(predicate, reader) {
        return function loop() {
            var recur = loop;
            var _ø1 = void 0;
            do {
                recur = predicate(peekChar(reader)) ? (loop[0] = readChar(reader), loop) : peekChar(reader);
            } while (_ø1 = loop[0], recur === loop);
            return recur;
        }.call(this);
    };
var readDelimitedList = exports.readDelimitedList = function readDelimitedList(delim, reader, isRecursive) {
        return function loop() {
            var recur = loop;
            var formsø1 = [];
            do {
                recur = function () {
                    var _ø1 = readPast(isWhitespace, reader);
                    var chø1 = readChar(reader);
                    !chø1 ? readerError(reader, 'EOF') : void 0;
                    return delim === chø1 ? formsø1 : function () {
                        var formø1 = readForm(reader, chø1);
                        return loop[0] = formø1 === reader ? formsø1 : conj(formsø1, formø1), loop;
                    }.call(this);
                }.call(this);
            } while (formsø1 = loop[0], recur === loop);
            return recur;
        }.call(this);
    };
var notImplemented = exports.notImplemented = function notImplemented(reader, ch) {
        return readerError(reader, '' + 'Reader for ' + ch + ' not implemented yet');
    };
var readDispatch = exports.readDispatch = function readDispatch(reader, _) {
        return function () {
            var chø1 = readChar(reader);
            var dmø1 = dispatchMacros(chø1);
            return dmø1 ? dmø1(reader, _) : function () {
                var objectø1 = maybeReadTaggedType(reader, chø1);
                return objectø1 ? objectø1 : readerError(reader, 'No dispatch macro for ', chø1);
            }.call(this);
        }.call(this);
    };
var readUnmatchedDelimiter = exports.readUnmatchedDelimiter = function readUnmatchedDelimiter(rdr, ch) {
        return readerError(rdr, 'Unmatched delimiter ', ch);
    };
var readList = exports.readList = function readList(reader, _) {
        return function () {
            var formø1 = readDelimitedList(')', reader, true);
            return withMeta(list.apply(void 0, formø1), meta(formø1));
        }.call(this);
    };
var readComment = exports.readComment = function readComment(reader, _) {
        return function loop() {
            var recur = loop;
            var bufferø1 = '';
            var chø1 = readChar(reader);
            do {
                recur = isNil(chø1) || '\n' === chø1 ? reader || list(symbol(void 0, 'comment'), bufferø1) : '\\' === chø1 ? (loop[0] = '' + bufferø1 + escapeChar(bufferø1, reader), loop[1] = readChar(reader), loop) : 'else' ? (loop[0] = '' + bufferø1 + chø1, loop[1] = readChar(reader), loop) : void 0;
            } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var readVector = exports.readVector = function readVector(reader) {
        return readDelimitedList(']', reader, true);
    };
var readMap = exports.readMap = function readMap(reader) {
        return function () {
            var formø1 = readDelimitedList('}', reader, true);
            return isOdd(count(formø1)) ? readerError(reader, 'Map literal must contain an even number of forms') : withMeta(dictionary.apply(void 0, formø1), meta(formø1));
        }.call(this);
    };
var readSet = exports.readSet = function readSet(reader, _) {
        return function () {
            var formø1 = readDelimitedList('}', reader, true);
            return withMeta(concat([symbol(void 0, 'set')], formø1), meta(formø1));
        }.call(this);
    };
var readNumber = exports.readNumber = function readNumber(reader, initch) {
        return function loop() {
            var recur = loop;
            var bufferø1 = initch;
            var chø1 = peekChar(reader);
            do {
                recur = isNil(chø1) || isWhitespace(chø1) || macros(chø1) ? (function () {
                    var match = matchNumber(bufferø1);
                    return isNil(match) ? readerError(reader, 'Invalid number format [', bufferø1, ']') : new Number(match);
                })() : (loop[0] = '' + bufferø1 + readChar(reader), loop[1] = peekChar(reader), loop);
            } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var readString = exports.readString = function readString(reader) {
        return function loop() {
            var recur = loop;
            var bufferø1 = '';
            var chø1 = readChar(reader);
            do {
                recur = isNil(chø1) ? readerError(reader, 'EOF while reading string') : '\\' === chø1 ? (loop[0] = '' + bufferø1 + escapeChar(bufferø1, reader), loop[1] = readChar(reader), loop) : '"' === chø1 ? new String(bufferø1) : 'default' ? (loop[0] = '' + bufferø1 + chø1, loop[1] = readChar(reader), loop) : void 0;
            } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var readCharacter = exports.readCharacter = function readCharacter(reader) {
        return new String(readChar(reader));
    };
var readUnquote = exports.readUnquote = function readUnquote(reader) {
        return function () {
            var chø1 = peekChar(reader);
            return !chø1 ? readerError(reader, 'EOF while reading character') : chø1 === '@' ? (function () {
                readChar(reader);
                return list(symbol(void 0, 'unquote-splicing'), read(reader, true, void 0, true));
            })() : list(symbol(void 0, 'unquote'), read(reader, true, void 0, true));
        }.call(this);
    };
var specialSymbols = exports.specialSymbols = function specialSymbols(text, notFound) {
        return text === 'nil' ? void 0 : text === 'true' ? true : text === 'false' ? false : 'else' ? notFound : void 0;
    };
var readSymbol = exports.readSymbol = function readSymbol(reader, initch) {
        return function () {
            var tokenø1 = readToken(reader, initch);
            var partsø1 = split(tokenø1, '/');
            var hasNsø1 = count(partsø1) > 1 && count(tokenø1) > 1;
            var nsø1 = first(partsø1);
            var nameø1 = join('/', rest(partsø1));
            return hasNsø1 ? symbol(nsø1, nameø1) : specialSymbols(tokenø1, symbol(tokenø1));
        }.call(this);
    };
var readKeyword = exports.readKeyword = function readKeyword(reader, initch) {
        return function () {
            var tokenø1 = readToken(reader, readChar(reader));
            var partsø1 = split(tokenø1, '/');
            var nameø1 = last(partsø1);
            var nsø1 = count(partsø1) > 1 ? join('/', butlast(partsø1)) : void 0;
            var issueø1 = last(nsø1) === ':' ? 'namespace can\'t ends with ":"' : last(nameø1) === ':' ? 'name can\'t end with ":"' : last(nameø1) === '/' ? 'name can\'t end with "/"' : count(split(tokenø1, '::')) > 1 ? 'name can\'t contain "::"' : void 0;
            return issueø1 ? readerError(reader, 'Invalid token (', issueø1, '): ', tokenø1) : !nsø1 && first(nameø1) === ':' ? keyword(rest(nameø1)) : keyword(nsø1, nameø1);
        }.call(this);
    };
var desugarMeta = exports.desugarMeta = function desugarMeta(form) {
        return isKeyword(form) ? dictionary(name(form), true) : isSymbol(form) ? { 'tag': form } : isString(form) ? { 'tag': form } : isDictionary(form) ? reduce(function (result, pair) {
            (result || 0)[name(first(pair))] = second(pair);
            return result;
        }, {}, form) : 'else' ? form : void 0;
    };
var wrappingReader = exports.wrappingReader = function wrappingReader(prefix) {
        return function (reader) {
            return list(prefix, read(reader, true, void 0, true));
        };
    };
var throwingReader = exports.throwingReader = function throwingReader(msg) {
        return function (reader) {
            return readerError(reader, msg);
        };
    };
var readMeta = exports.readMeta = function readMeta(reader, _) {
        return function () {
            var metadataø1 = desugarMeta(read(reader, true, void 0, true));
            !isDictionary(metadataø1) ? readerError(reader, 'Metadata must be Symbol, Keyword, String or Map') : void 0;
            return function () {
                var formø1 = read(reader, true, void 0, true);
                return isObject(formø1) ? withMeta(formø1, conj(metadataø1, meta(formø1))) : formø1;
            }.call(this);
        }.call(this);
    };
var readRegex = exports.readRegex = function readRegex(reader) {
        return function loop() {
            var recur = loop;
            var bufferø1 = '';
            var chø1 = readChar(reader);
            do {
                recur = isNil(chø1) ? readerError(reader, 'EOF while reading string') : '\\' === chø1 ? (loop[0] = '' + bufferø1 + chø1 + readChar(reader), loop[1] = readChar(reader), loop) : '"' === chø1 ? rePattern(bufferø1) : 'default' ? (loop[0] = '' + bufferø1 + chø1, loop[1] = readChar(reader), loop) : void 0;
            } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var readParam = exports.readParam = function readParam(reader, initch) {
        return function () {
            var formø1 = readSymbol(reader, initch);
            return isEqual(formø1, symbol('%')) ? symbol('%1') : formø1;
        }.call(this);
    };
var isParam = exports.isParam = function isParam(form) {
        return isSymbol(form) && '%' === first(name(form));
    };
var lambdaParamsHash = exports.lambdaParamsHash = function lambdaParamsHash(form) {
        return isParam(form) ? dictionary(form, form) : isDictionary(form) || isVector(form) || isList(form) ? conj.apply(void 0, map(lambdaParamsHash, vec(form))) : 'else' ? {} : void 0;
    };
var lambdaParams = exports.lambdaParams = function lambdaParams(body) {
        return function () {
            var namesø1 = sort(vals(lambdaParamsHash(body)));
            var variadicø1 = isEqual(first(namesø1), symbol('%&'));
            var nø1 = variadicø1 && count(namesø1) === 1 ? 0 : parseInt(rest(name(last(namesø1))));
            var paramsø1 = function loop() {
                    var recur = loop;
                    var namesø2 = [];
                    var iø1 = 1;
                    do {
                        recur = iø1 <= nø1 ? (loop[0] = conj(namesø2, symbol('' + '%' + iø1)), loop[1] = inc(iø1), loop) : namesø2;
                    } while (namesø2 = loop[0], iø1 = loop[1], recur === loop);
                    return recur;
                }.call(this);
            return variadicø1 ? conj(paramsø1, symbol(void 0, '&'), symbol(void 0, '%&')) : namesø1;
        }.call(this);
    };
var readLambda = exports.readLambda = function readLambda(reader) {
        return function () {
            var bodyø1 = readList(reader);
            return list(symbol(void 0, 'fn'), lambdaParams(bodyø1), bodyø1);
        }.call(this);
    };
var readDiscard = exports.readDiscard = function readDiscard(reader, _) {
        read(reader, true, void 0, true);
        return reader;
    };
var macros = exports.macros = function macros(c) {
        return c === '"' ? readString : c === '\\' ? readCharacter : c === ':' ? readKeyword : c === ';' ? readComment : c === '\'' ? wrappingReader(symbol(void 0, 'quote')) : c === '@' ? wrappingReader(symbol(void 0, 'deref')) : c === '^' ? readMeta : c === '`' ? wrappingReader(symbol(void 0, 'syntax-quote')) : c === '~' ? readUnquote : c === '(' ? readList : c === ')' ? readUnmatchedDelimiter : c === '[' ? readVector : c === ']' ? readUnmatchedDelimiter : c === '{' ? readMap : c === '}' ? readUnmatchedDelimiter : c === '%' ? readParam : c === '#' ? readDispatch : 'else' ? void 0 : void 0;
    };
var dispatchMacros = exports.dispatchMacros = function dispatchMacros(s) {
        return s === '{' ? readSet : s === '(' ? readLambda : s === '<' ? throwingReader('Unreadable form') : s === '"' ? readRegex : s === '!' ? readComment : s === '_' ? readDiscard : 'else' ? void 0 : void 0;
    };
var readForm = exports.readForm = function readForm(reader, ch) {
        return function () {
            var startø1 = {
                    'line': (reader || 0)['line'],
                    'column': (reader || 0)['column']
                };
            var readMacroø1 = macros(ch);
            var formø1 = readMacroø1 ? readMacroø1(reader, ch) : isNumberLiteral(reader, ch) ? readNumber(reader, ch) : 'else' ? readSymbol(reader, ch) : void 0;
            var endø1 = {
                    'line': (reader || 0)['line'],
                    'column': inc((reader || 0)['column'])
                };
            var locationø1 = {
                    'uri': (reader || 0)['uri'],
                    'start': startø1,
                    'end': endø1
                };
            return formø1 === reader ? formø1 : !(isBoolean(formø1) || isNil(formø1) || isKeyword(formø1)) ? withMeta(formø1, conj(locationø1, meta(formø1))) : 'else' ? formø1 : void 0;
        }.call(this);
    };
var read = exports.read = function read(reader, eofIsError, sentinel, isRecursive) {
        return function loop() {
            var recur = loop;
            do {
                recur = function () {
                    var chø1 = readChar(reader);
                    var formø1 = isNil(chø1) ? eofIsError ? readerError(reader, 'EOF') : sentinel : isWhitespace(chø1) ? reader : isCommentPrefix(chø1) ? read(readComment(reader, chø1), eofIsError, sentinel, isRecursive) : 'else' ? readForm(reader, chø1) : void 0;
                    return formø1 === reader ? (loop) : formø1;
                }.call(this);
            } while (recur === loop);
            return recur;
        }.call(this);
    };
var read_ = exports.read_ = function read_(source, uri) {
        return function () {
            var readerø1 = pushBackReader(source, uri);
            var eofø1 = gensym();
            return function loop() {
                var recur = loop;
                var formsø1 = [];
                var formø1 = read(readerø1, false, eofø1, false);
                do {
                    recur = formø1 === eofø1 ? formsø1 : (loop[0] = conj(formsø1, formø1), loop[1] = read(readerø1, false, eofø1, false), loop);
                } while (formsø1 = loop[0], formø1 = loop[1], recur === loop);
                return recur;
            }.call(this);
        }.call(this);
    };
var readFromString = exports.readFromString = function readFromString(source, uri) {
        return function () {
            var readerø1 = pushBackReader(source, uri);
            return read(readerø1, true, void 0, false);
        }.call(this);
    };
var readUuid = function readUuid(uuid) {
    return isString(uuid) ? list.apply(void 0, [symbol(void 0, 'UUID.')].concat([uuid])) : readerError(void 0, 'UUID literal expects a string as its representation.');
};
var readQueue = function readQueue(items) {
    return isVector(items) ? list.apply(void 0, [symbol(void 0, 'PersistentQueue.')].concat([items])) : readerError(void 0, 'Queue literal expects a vector for its elements.');
};
var __tagTable__ = exports.__tagTable__ = dictionary('uuid', readUuid, 'queue', readQueue);
var maybeReadTaggedType = exports.maybeReadTaggedType = function maybeReadTaggedType(reader, initch) {
        return function () {
            var tagø1 = readSymbol(reader, initch);
            var pfnø1 = (__tagTable__ || 0)[name(tagø1)];
            return pfnø1 ? pfnø1(read(reader, true, void 0, false)) : readerError(reader, '' + 'Could not find tag parser for ' + name(tagø1) + ' in ' + ('' + keys(__tagTable__)));
        }.call(this);
    };
//# sourceMappingURL=data:application/json;base64,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
