{
    var _ns_ = {
        id: 'wisp.wisp',
        doc: 'Wisp program that reads wisp code from stdin and prints\n  compiled javascript code into stdout'
    };
    var fs = require('fs');
    var createReadStream = fs.createReadStream;
    var path = require('path');
    var basename = path.basename;
    var dirname = path.dirname;
    var join = path.join;
    var resolve = path.resolve;
    var module = require('module');
    var Module = module.Module;
    var commander = require('commander');
    var wisp_package = require('./package');
    var version = wisp_package.version;
    var wisp_string = require('./string');
    var split = wisp_string.split;
    var join = wisp_string.join;
    var upperCase = wisp_string.upperCase;
    var replace = wisp_string.replace;
    var wisp_sequence = require('./sequence');
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var last = wisp_sequence.last;
    var count = wisp_sequence.count;
    var reduce = wisp_sequence.reduce;
    var rest = wisp_sequence.rest;
    var conj = wisp_sequence.conj;
    var partition = wisp_sequence.partition;
    var assoc = wisp_sequence.assoc;
    var drop = wisp_sequence.drop;
    var isEmpty = wisp_sequence.isEmpty;
    var wisp_repl = require('./repl');
    var startRepl = wisp_repl.start;
    var wisp_engine_node = require('./engine/node');
    var wisp_runtime = require('./runtime');
    var str = wisp_runtime.str;
    var subs = wisp_runtime.subs;
    var isEqual = wisp_runtime.isEqual;
    var isNil = wisp_runtime.isNil;
    var wisp_ast = require('./ast');
    var prStr = wisp_ast.prStr;
    var name = wisp_ast.name;
    var wisp_compiler = require('./compiler');
    var compile = wisp_compiler.compile;
}
var compileStdin = exports.compileStdin = function compileStdin(options) {
    return withStreamContent(process.stdin, compileString, conj({}, options));
};
var compileFile = exports.compileFile = function compileFile(path, options) {
    return withStreamContent(createReadStream(path), compileString, conj({ 'source-uri': path }, options));
};
var compileString = exports.compileString = function compileString(source, options) {
    return function () {
        var channelø1 = (options || 0)['print'] || 'code';
        var outputø1 = compile(source, options);
        var contentø1 = isEqual(channelø1, 'code') ? (outputø1 || 0)['code'] : isEqual(channelø1, 'expansion') ? (outputø1 || 0)['expansion'] : 'else' ? JSON.stringify((outputø1 || 0)[channelø1], 2, 2) : void 0;
        process.stdout.write(contentø1 || 'nil');
        return (outputø1 || 0)['error'] ? (function () {
            throw outputø1.error;
        })() : void 0;
    }.call(this);
};
var withStreamContent = exports.withStreamContent = function withStreamContent(input, resume, options) {
    return function () {
        var contentø1 = '';
        input.setEncoding('utf8');
        input.resume();
        input.on('data', function ($1) {
            return contentø1 = '' + contentø1 + $1;
        });
        return input.once('end', function () {
            return resume(contentø1, options);
        });
    }.call(this);
};
var run = exports.run = function run(path) {
    return Module._load(resolve(path), null, true);
};
void 0;
var parseParams = exports.parseParams = function parseParams(params) {
    return function () {
        var optionsø1 = commander.version(version).usage('[options] <file ...>').option('-r, --run', 'compile and execute the file (same as wisp path/to/file.wisp)').option('-c, --compile', 'compile given file and prints to stdout').option('-i, --interactive', 'run an interactive wisp REPL (same as wisp with no params)').option('--print <format>', 'use custom print output `expansion`,`forms`, `ast`, `js-ast` or (default) `code`', function (x, _) {
            return '' + x;
        }, 'code').option('--no-map', 'disable source map generation').option('--source-uri <uri>', 'uri input will be associated with in source maps').option('--output-uri <uri>', 'uri output will be associated with in source maps').parse(params);
        return conj({ 'no-map': !(optionsø1 || 0)['map'] }, optionsø1);
    }.call(this);
};
var main = exports.main = function main() {
    return function () {
        var optionsø1 = parseParams(process.argv);
        var pathø1 = optionsø1.args[0];
        return optionsø1.run ? run(pathø1) : !process.stdin.isTTY ? compileStdin(optionsø1) : optionsø1.interactive ? startRepl() : optionsø1.compile ? compileFile(pathø1, optionsø1) : pathø1 ? run(pathø1) : 'else' ? startRepl() : void 0;
    }.call(this);
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFub255bW91cy53aXNwIl0sIm5hbWVzIjpbIl9uc18iLCJpZCIsImRvYyIsImNyZWF0ZVJlYWRTdHJlYW0iLCJiYXNlbmFtZSIsImRpcm5hbWUiLCJqb2luIiwicmVzb2x2ZSIsIk1vZHVsZSIsInZlcnNpb24iLCJzcGxpdCIsInVwcGVyQ2FzZSIsInJlcGxhY2UiLCJmaXJzdCIsInNlY29uZCIsImxhc3QiLCJjb3VudCIsInJlZHVjZSIsInJlc3QiLCJjb25qIiwicGFydGl0aW9uIiwiYXNzb2MiLCJkcm9wIiwiaXNFbXB0eSIsInN0YXJ0UmVwbCIsInN0YXJ0Iiwic3RyIiwic3VicyIsImlzRXF1YWwiLCJpc05pbCIsInByU3RyIiwibmFtZSIsImNvbXBpbGUiLCJjb21waWxlU3RkaW4iLCJleHBvcnRzIiwib3B0aW9ucyIsIndpdGhTdHJlYW1Db250ZW50IiwicHJvY2VzcyIsInN0ZGluIiwiY29tcGlsZVN0cmluZyIsImNvbXBpbGVGaWxlIiwicGF0aCIsInNvdXJjZSIsImNoYW5uZWzDuDEiLCJvdXRwdXTDuDEiLCJjb250ZW50w7gxIiwiSlNPTiIsInN0cmluZ2lmeSIsInN0ZG91dCIsIndyaXRlIiwiZXJyb3IiLCJpbnB1dCIsInJlc3VtZSIsInNldEVuY29kaW5nIiwib24iLCIkMSIsIm9uY2UiLCJydW4iLCJfbG9hZCIsIm51bGwiLCJwYXJzZVBhcmFtcyIsInBhcmFtcyIsIm9wdGlvbnPDuDEiLCJjb21tYW5kZXIiLCJ1c2FnZSIsIm9wdGlvbiIsIngiLCJfIiwicGFyc2UiLCJtYWluIiwiYXJndiIsInBhdGjDuDEiLCJhcmdzIiwic3RkaW4uaXNUVFkiLCJpbnRlcmFjdGl2ZSJdLCJtYXBwaW5ncyI6IjtJQUFBLElBQUNBLEksR0FBRDtBQUFBLFFBQUFDLEUsRUFBSSxXQUFKO0FBQUEsUUFBQUMsRyxFQUNFLGlHQURGO0FBQUEsTTs7UUFHd0JDLGdCQUFBLEcsR0FBQUEsZ0I7O1FBQ0VDLFFBQUEsRyxLQUFBQSxRO1FBQVNDLE9BQUEsRyxLQUFBQSxPO1FBQVFDLElBQUEsRyxLQUFBQSxJO1FBQUtDLE9BQUEsRyxLQUFBQSxPOztRQUNwQkMsTUFBQSxHLE9BQUFBLE07OztRQUVNQyxPQUFBLEcsYUFBQUEsTzs7UUFFREMsS0FBQSxHLFlBQUFBLEs7UUFBTUosSUFBQSxHLFlBQUFBLEk7UUFBS0ssU0FBQSxHLFlBQUFBLFM7UUFBV0MsT0FBQSxHLFlBQUFBLE87O1FBQ3BCQyxLQUFBLEcsY0FBQUEsSztRQUFNQyxNQUFBLEcsY0FBQUEsTTtRQUFPQyxJQUFBLEcsY0FBQUEsSTtRQUFLQyxLQUFBLEcsY0FBQUEsSztRQUFNQyxNQUFBLEcsY0FBQUEsTTtRQUFPQyxJQUFBLEcsY0FBQUEsSTtRQUMvQkMsSUFBQSxHLGNBQUFBLEk7UUFBS0MsU0FBQSxHLGNBQUFBLFM7UUFBVUMsS0FBQSxHLGNBQUFBLEs7UUFBTUMsSUFBQSxHLGNBQUFBLEk7UUFBS0MsT0FBQSxHLGNBQUFBLE87O1FBRVJDLFNBQUEsRyxVQUF0QkMsSzs7O1FBRUdDLEdBQUEsRyxhQUFBQSxHO1FBQUlDLElBQUEsRyxhQUFBQSxJO1FBQUtDLE9BQUEsRyxhQUFBQSxPO1FBQUVDLEtBQUEsRyxhQUFBQSxLOztRQUNmQyxLQUFBLEcsU0FBQUEsSztRQUFPQyxJQUFBLEcsU0FBQUEsSTs7UUFDRkMsT0FBQSxHLGNBQUFBLE87O0FBRW5DLElBQU1DLFlBQUEsR0FBQUMsT0FBQSxDQUFBRCxZQUFBLEdBQU4sU0FBTUEsWUFBTixDQUNHRSxPQURILEVBRUU7QUFBQSxXQUFDQyxpQkFBRCxDQUFxQkMsT0FBQSxDQUFRQyxLQUE3QixFQUNxQkMsYUFEckIsRUFFc0JwQixJQUFELENBQU0sRUFBTixFQUFTZ0IsT0FBVCxDQUZyQjtBQUFBLENBRkYsQztBQU9BLElBQU1LLFdBQUEsR0FBQU4sT0FBQSxDQUFBTSxXQUFBLEdBQU4sU0FBTUEsV0FBTixDQUNHQyxJQURILEVBQ1FOLE9BRFIsRUFFRTtBQUFBLFdBQUNDLGlCQUFELENBQXNCakMsZ0JBQUQsQ0FBa0JzQyxJQUFsQixDQUFyQixFQUNxQkYsYUFEckIsRUFFc0JwQixJQUFELENBQU0sRSxjQUFhc0IsSUFBYixFQUFOLEVBQXlCTixPQUF6QixDQUZyQjtBQUFBLENBRkYsQztBQU1BLElBQU1JLGFBQUEsR0FBQUwsT0FBQSxDQUFBSyxhQUFBLEdBQU4sU0FBTUEsYUFBTixDQUNHRyxNQURILEVBQ1VQLE9BRFYsRUFFRTtBQUFBLFcsWUFBTTtBQUFBLFlBQUFRLFMsSUFBb0JSLE8sTUFBUixDLE9BQUEsQ0FBSixJLE1BQVI7QUFBQSxRQUNBLElBQUFTLFEsR0FBUVosT0FBRCxDQUFTVSxNQUFULEVBQWdCUCxPQUFoQixDQUFQLENBREE7QUFBQSxRQUVBLElBQUFVLFMsR0FDV2pCLE9BQUQsQ0FBR2UsU0FBSCxFLE1BQUEsQ0FERixHLENBQzJCQyxRLE1BQVAsQyxNQUFBLENBRHBCLEdBRUdoQixPQUFELENBQUdlLFNBQUgsRSxXQUFBLEMsSUFBbUNDLFEsTUFBWixDLFdBQUEsQyxZQUNoQkUsSUFBQSxDQUFLQyxTQUFOLEMsQ0FBcUJILFEsTUFBTCxDQUFZRCxTQUFaLENBQWhCLEVBQXFDLENBQXJDLEVBQXVDLENBQXZDLEMsU0FIaEIsQ0FGQTtBQUFBLFFBTU1OLE9BQUEsQ0FBUVcsTUFBZixDQUFDQyxLQUFGLENBQTJCSixTQUFKLElBQVksS0FBbkMsRUFORTtBQUFBLFFBT0osTyxDQUFZRCxRLE1BQVIsQyxPQUFBLENBQUosRyxhQUFvQjtBQUFBLGtCQUFnQkEsUUFBVCxDQUFHTSxLQUFWO0FBQUEsUyxDQUFBLEVBQXBCLEcsTUFBQSxDQVBJO0FBQUEsSyxLQUFOLEMsSUFBQTtBQUFBLENBRkYsQztBQVdBLElBQU1kLGlCQUFBLEdBQUFGLE9BQUEsQ0FBQUUsaUJBQUEsR0FBTixTQUFNQSxpQkFBTixDQUNHZSxLQURILEVBQ1NDLE1BRFQsRUFDZ0JqQixPQURoQixFQUVFO0FBQUEsVyxZQUFNO0FBQUEsWUFBQVUsUyxHQUFRLEVBQVI7QUFBQSxRQUNVTSxLQUFiLENBQUNFLFdBQUYsQ0FBb0IsTUFBcEIsRUFESTtBQUFBLFFBRUtGLEtBQVIsQ0FBQ0MsTUFBRixHQUZJO0FBQUEsUUFHQ0QsS0FBSixDQUFDRyxFQUFGLENBQVcsTUFBWCxFQUFrQixVQUE0QkMsRUFBNUIsRTttQkFBT1YsUyxRQUFhQSxTQUFMLEdBQWFVLEU7U0FBOUMsRUFISTtBQUFBLFFBSUosT0FBT0osS0FBTixDQUFDSyxJQUFGLENBQWEsS0FBYixFQUFtQixZQUFPO0FBQUEsbUJBQUNKLE1BQUQsQ0FBUVAsU0FBUixFQUFnQlYsT0FBaEI7QUFBQSxTQUExQixFQUpJO0FBQUEsSyxLQUFOLEMsSUFBQTtBQUFBLENBRkYsQztBQVNBLElBQU1zQixHQUFBLEdBQUF2QixPQUFBLENBQUF1QixHQUFBLEdBQU4sU0FBTUEsR0FBTixDQUNHaEIsSUFESCxFQUlFO0FBQUEsV0FBQ2pDLE1BQUEsQ0FBT2tELEtBQVIsQ0FBZW5ELE9BQUQsQ0FBU2tDLElBQVQsQ0FBZCxFQUE2QmtCLElBQTdCLEUsSUFBQTtBQUFBLENBSkYsQzs7QUFlQSxJQUFNQyxXQUFBLEdBQUExQixPQUFBLENBQUEwQixXQUFBLEdBQU4sU0FBTUEsV0FBTixDQUNHQyxNQURILEVBRUU7QUFBQSxXLFlBQU07QUFBQSxZQUFBQyxTLEdBQVlDLFNBQ0MsQ0FBQ3RELE8sQ0FBUUEsTyxDQUNULENBQUN1RCxLLENBQU0sc0IsQ0FDUCxDQUFDQyxNLENBQU8sVyxFQUNBLCtELENBQ1IsQ0FBQ0EsTSxDQUFPLGUsRUFDQSx5QyxDQUNSLENBQUNBLE0sQ0FBTyxtQixFQUNBLDRELENBQ1IsQ0FBQ0EsTSxDQUFPLGtCLEVBQ0Esa0YsRUFDQSxVQUFLQyxDQUFMLEVBQU9DLENBQVAsRUFBVTtBQUFBLG1CLEVBQUEsR0FBS0QsQ0FBTDtBQUFBLFMsRUFDVixNLENBQ1IsQ0FBQ0QsTSxDQUFPLFUsRUFDQSwrQixDQUNSLENBQUNBLE0sQ0FBTyxvQixFQUNBLGtELENBQ1IsQ0FBQ0EsTSxDQUFPLG9CLEVBQ0EsbUQsQ0FDUixDQUFDRyxLQW5CTixDQW1CWVAsTUFuQlosQ0FBUjtBQUFBLFFBb0JKLE9BQUMxQyxJQUFELENBQU0sRSxVQUFTLEMsQ0FBVzJDLFMsTUFBTixDLEtBQUEsQ0FBZCxFQUFOLEVBQ01BLFNBRE4sRUFwQkk7QUFBQSxLLEtBQU4sQyxJQUFBO0FBQUEsQ0FGRixDO0FBeUJBLElBQU1PLElBQUEsR0FBQW5DLE9BQUEsQ0FBQW1DLElBQUEsR0FBTixTQUFNQSxJQUFOLEdBRUU7QUFBQSxXLFlBQU07QUFBQSxZQUFBUCxTLEdBQVNGLFdBQUQsQ0FBY3ZCLE9BQUEsQ0FBUWlDLElBQXRCLENBQVI7QUFBQSxRQUNBLElBQUFDLE0sR0FBV1QsU0FBQSxDQUFRVSxJQUFkLENBQW1CLENBQW5CLENBQUwsQ0FEQTtBQUFBLFFBRUosT0FBTVYsU0FBQSxDQUFRTCxHQUFkLEdBQW1CQSxHQUFELENBQUtjLE1BQUwsQ0FBbEIsR0FDTSxDQUFLbEMsT0FBQSxDQUFRb0MsVyxHQUFjeEMsWUFBRCxDQUFlNkIsU0FBZixDLEdBQzFCQSxTQUFBLENBQVFZLFcsR0FBYWxELFNBQUQsRSxHQUNwQnNDLFNBQUEsQ0FBUTlCLE8sR0FBU1EsV0FBRCxDQUFjK0IsTUFBZCxFQUFtQlQsU0FBbkIsQyxHQUNoQlMsTSxHQUFNZCxHQUFELENBQUtjLE1BQUwsQyxZQUNFL0MsU0FBRCxFLFNBTFosQ0FGSTtBQUFBLEssS0FBTixDLElBQUE7QUFBQSxDQUZGIiwic291cmNlc0NvbnRlbnQiOlsiKG5zIHdpc3Aud2lzcFxuICBcIldpc3AgcHJvZ3JhbSB0aGF0IHJlYWRzIHdpc3AgY29kZSBmcm9tIHN0ZGluIGFuZCBwcmludHNcbiAgY29tcGlsZWQgamF2YXNjcmlwdCBjb2RlIGludG8gc3Rkb3V0XCJcbiAgKDpyZXF1aXJlIFtmcyA6cmVmZXIgW2NyZWF0ZVJlYWRTdHJlYW1dXVxuICAgICAgICAgICAgW3BhdGggOnJlZmVyIFtiYXNlbmFtZSBkaXJuYW1lIGpvaW4gcmVzb2x2ZV1dXG4gICAgICAgICAgICBbbW9kdWxlIDpyZWZlciBbTW9kdWxlXV1cbiAgICAgICAgICAgIFtjb21tYW5kZXJdXG4gICAgICAgICAgICBbd2lzcC5wYWNrYWdlIDpyZWZlciBbdmVyc2lvbl1dXG5cbiAgICAgICAgICAgIFt3aXNwLnN0cmluZyA6cmVmZXIgW3NwbGl0IGpvaW4gdXBwZXItY2FzZSByZXBsYWNlXV1cbiAgICAgICAgICAgIFt3aXNwLnNlcXVlbmNlIDpyZWZlciBbZmlyc3Qgc2Vjb25kIGxhc3QgY291bnQgcmVkdWNlIHJlc3RcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29uaiBwYXJ0aXRpb24gYXNzb2MgZHJvcCBlbXB0eT9dXVxuXG4gICAgICAgICAgICBbd2lzcC5yZXBsIDpyZWZlciBbc3RhcnRdIDpyZW5hbWUge3N0YXJ0IHN0YXJ0LXJlcGx9XVxuICAgICAgICAgICAgW3dpc3AuZW5naW5lLm5vZGVdXG4gICAgICAgICAgICBbd2lzcC5ydW50aW1lIDpyZWZlciBbc3RyIHN1YnMgPSBuaWw/XV1cbiAgICAgICAgICAgIFt3aXNwLmFzdCA6cmVmZXIgW3ByLXN0ciBuYW1lXV1cbiAgICAgICAgICAgIFt3aXNwLmNvbXBpbGVyIDpyZWZlciBbY29tcGlsZV1dKSlcblxuKGRlZm4gY29tcGlsZS1zdGRpblxuICBbb3B0aW9uc11cbiAgKHdpdGgtc3RyZWFtLWNvbnRlbnQgcHJvY2Vzcy5zdGRpblxuICAgICAgICAgICAgICAgICAgICAgICBjb21waWxlLXN0cmluZ1xuICAgICAgICAgICAgICAgICAgICAgICAoY29uaiB7fSBvcHRpb25zKSkpXG47OyAoY29uaiB7OnNvdXJjZS11cmkgb3B0aW9uc30pIGNhdXNlcyBzZWdmYXVsdCBmb3Igc29tZSByZWFzb25cblxuKGRlZm4gY29tcGlsZS1maWxlXG4gIFtwYXRoIG9wdGlvbnNdXG4gICh3aXRoLXN0cmVhbS1jb250ZW50IChjcmVhdGVSZWFkU3RyZWFtIHBhdGgpXG4gICAgICAgICAgICAgICAgICAgICAgIGNvbXBpbGUtc3RyaW5nXG4gICAgICAgICAgICAgICAgICAgICAgIChjb25qIHs6c291cmNlLXVyaSBwYXRofSBvcHRpb25zKSkpXG5cbihkZWZuIGNvbXBpbGUtc3RyaW5nXG4gIFtzb3VyY2Ugb3B0aW9uc11cbiAgKGxldCBbY2hhbm5lbCAob3IgKDpwcmludCBvcHRpb25zKSA6Y29kZSlcbiAgICAgICAgb3V0cHV0IChjb21waWxlIHNvdXJjZSBvcHRpb25zKVxuICAgICAgICBjb250ZW50IChjb25kXG4gICAgICAgICAgICAgICAgICAoPSBjaGFubmVsIDpjb2RlKSAoOmNvZGUgb3V0cHV0KVxuICAgICAgICAgICAgICAgICAgKD0gY2hhbm5lbCA6ZXhwYW5zaW9uKSAoOmV4cGFuc2lvbiBvdXRwdXQpXG4gICAgICAgICAgICAgICAgICA6ZWxzZSAoSlNPTi5zdHJpbmdpZnkgKGdldCBvdXRwdXQgY2hhbm5lbCkgMiAyKSldXG4gICAgICAoLndyaXRlIHByb2Nlc3Muc3Rkb3V0IChvciBjb250ZW50IFwibmlsXCIpKVxuICAgIChpZiAoOmVycm9yIG91dHB1dCkgKHRocm93ICguLWVycm9yIG91dHB1dCkpKSkpXG5cbihkZWZuIHdpdGgtc3RyZWFtLWNvbnRlbnRcbiAgW2lucHV0IHJlc3VtZSBvcHRpb25zXVxuICAobGV0IFtjb250ZW50IFwiXCJdXG4gICAgKC5zZXRFbmNvZGluZyBpbnB1dCBcInV0ZjhcIilcbiAgICAoLnJlc3VtZSBpbnB1dClcbiAgICAoLm9uIGlucHV0IFwiZGF0YVwiICMoc2V0ISBjb250ZW50IChzdHIgY29udGVudCAlKSkpXG4gICAgKC5vbmNlIGlucHV0IFwiZW5kXCIgKGZuIFtdIChyZXN1bWUgY29udGVudCBvcHRpb25zKSkpKSlcblxuXG4oZGVmbiBydW5cbiAgW3BhdGhdXG4gIDs7IExvYWRpbmcgbW9kdWxlIGFzIG1haW4gb25lLCBzYW1lIHdheSBhcyBub2RlanMgZG9lcyBpdDpcbiAgOzsgaHR0cHM6Ly9naXRodWIuY29tL2pveWVudC9ub2RlL2Jsb2IvbWFzdGVyL2xpYi9tb2R1bGUuanMjTDQ4OS00OTNcbiAgKE1vZHVsZS5fbG9hZCAocmVzb2x2ZSBwYXRoKSBudWxsIHRydWUpKVxuXG4oZGVmbWFjcm8gLT5cbiAgWyYgb3BlcmF0aW9uc11cbiAgKHJlZHVjZVxuICAgKGZuIFtmb3JtIG9wZXJhdGlvbl1cbiAgICAgKGNvbnMgKGZpcnN0IG9wZXJhdGlvbilcbiAgICAgICAgICAgKGNvbnMgZm9ybSAocmVzdCBvcGVyYXRpb24pKSkpXG4gICAoZmlyc3Qgb3BlcmF0aW9ucylcbiAgIChyZXN0IG9wZXJhdGlvbnMpKSlcblxuKGRlZm4gcGFyc2UtcGFyYW1zXG4gIFtwYXJhbXNdXG4gIChsZXQgW29wdGlvbnMgKC0+IGNvbW1hbmRlclxuICAgICAgICAgICAgICAgICAgICAoLnZlcnNpb24gdmVyc2lvbilcbiAgICAgICAgICAgICAgICAgICAgKC51c2FnZSBcIltvcHRpb25zXSA8ZmlsZSAuLi4+XCIpXG4gICAgICAgICAgICAgICAgICAgICgub3B0aW9uIFwiLXIsIC0tcnVuXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJjb21waWxlIGFuZCBleGVjdXRlIHRoZSBmaWxlIChzYW1lIGFzIHdpc3AgcGF0aC90by9maWxlLndpc3ApXCIpXG4gICAgICAgICAgICAgICAgICAgICgub3B0aW9uIFwiLWMsIC0tY29tcGlsZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiY29tcGlsZSBnaXZlbiBmaWxlIGFuZCBwcmludHMgdG8gc3Rkb3V0XCIpXG4gICAgICAgICAgICAgICAgICAgICgub3B0aW9uIFwiLWksIC0taW50ZXJhY3RpdmVcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInJ1biBhbiBpbnRlcmFjdGl2ZSB3aXNwIFJFUEwgKHNhbWUgYXMgd2lzcCB3aXRoIG5vIHBhcmFtcylcIilcbiAgICAgICAgICAgICAgICAgICAgKC5vcHRpb24gXCItLXByaW50IDxmb3JtYXQ+XCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ1c2UgY3VzdG9tIHByaW50IG91dHB1dCBgZXhwYW5zaW9uYCxgZm9ybXNgLCBgYXN0YCwgYGpzLWFzdGAgb3IgKGRlZmF1bHQpIGBjb2RlYFwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIChmbiBbeCBfXSAoc3RyIHgpKVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImNvZGVcIilcbiAgICAgICAgICAgICAgICAgICAgKC5vcHRpb24gXCItLW5vLW1hcFwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiZGlzYWJsZSBzb3VyY2UgbWFwIGdlbmVyYXRpb25cIilcbiAgICAgICAgICAgICAgICAgICAgKC5vcHRpb24gXCItLXNvdXJjZS11cmkgPHVyaT5cIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInVyaSBpbnB1dCB3aWxsIGJlIGFzc29jaWF0ZWQgd2l0aCBpbiBzb3VyY2UgbWFwc1wiKVxuICAgICAgICAgICAgICAgICAgICAoLm9wdGlvbiBcIi0tb3V0cHV0LXVyaSA8dXJpPlwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwidXJpIG91dHB1dCB3aWxsIGJlIGFzc29jaWF0ZWQgd2l0aCBpbiBzb3VyY2UgbWFwc1wiKVxuICAgICAgICAgICAgICAgICAgICAoLnBhcnNlIHBhcmFtcykpXVxuICAgIChjb25qIHs6bm8tbWFwIChub3QgKDptYXAgb3B0aW9ucykpfVxuICAgICAgICAgIG9wdGlvbnMpKSlcblxuKGRlZm4gbWFpblxuICBbXVxuICAobGV0IFtvcHRpb25zIChwYXJzZS1wYXJhbXMgcHJvY2Vzcy5hcmd2KVxuICAgICAgICBwYXRoIChhZ2V0IG9wdGlvbnMuYXJncyAwKV1cbiAgICAoY29uZCBvcHRpb25zLnJ1biAocnVuIHBhdGgpXG4gICAgICAgICAgKG5vdCBwcm9jZXNzLnN0ZGluLmlzVFRZKSAoY29tcGlsZS1zdGRpbiBvcHRpb25zKVxuICAgICAgICAgIG9wdGlvbnMuaW50ZXJhY3RpdmUgKHN0YXJ0LXJlcGwpXG4gICAgICAgICAgb3B0aW9ucy5jb21waWxlIChjb21waWxlLWZpbGUgcGF0aCBvcHRpb25zKVxuICAgICAgICAgIHBhdGggKHJ1biBwYXRoKVxuICAgICAgICAgIDplbHNlIChzdGFydC1yZXBsKSkpKVxuIl19
