{
    var _ns_ = {
        id: 'wisp.sequence',
        doc: void 0
    };
    var wisp_runtime = require('./runtime');
    var isNil = wisp_runtime.isNil;
    var isVector = wisp_runtime.isVector;
    var isFn = wisp_runtime.isFn;
    var isNumber = wisp_runtime.isNumber;
    var isString = wisp_runtime.isString;
    var isDictionary = wisp_runtime.isDictionary;
    var keyValues = wisp_runtime.keyValues;
    var str = wisp_runtime.str;
    var dec = wisp_runtime.dec;
    var inc = wisp_runtime.inc;
    var merge = wisp_runtime.merge;
    var dictionary = wisp_runtime.dictionary;
}
var List = function List(head, tail) {
    this.head = head;
    this.tail = tail || list();
    this.length = inc(count(this.tail));
    return this;
};
List.prototype.length = 0;
List.type = 'wisp.list';
List.prototype.type = List.type;
List.prototype.tail = Object.create(List.prototype);
List.prototype.toString = function () {
    return function loop() {
        var recur = loop;
        var resultø1 = '';
        var listø1 = this;
        do {
            recur = isEmpty(listø1) ? '' + '(' + resultø1.substr(1) + ')' : (loop[0] = '' + resultø1 + ' ' + (isVector(first(listø1)) ? '' + '[' + first(listø1).join(' ') + ']' : isNil(first(listø1)) ? 'nil' : isString(first(listø1)) ? JSON.stringify(first(listø1)) : isNumber(first(listø1)) ? JSON.stringify(first(listø1)) : first(listø1)), loop[1] = rest(listø1), loop);
        } while (resultø1 = loop[0], listø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var lazySeqValue = function lazySeqValue(lazySeq) {
    return !lazySeq.realized ? (lazySeq.realized = true) && (lazySeq.x = lazySeq.x()) : lazySeq.x;
};
var LazySeq = function LazySeq(realized, x) {
    this.realized = realized || false;
    this.x = x;
    return this;
};
LazySeq.type = 'wisp.lazy.seq';
LazySeq.prototype.type = LazySeq.type;
var lazySeq = exports.lazySeq = function lazySeq(realized, body) {
    return new LazySeq(realized, body);
};
var isLazySeq = exports.isLazySeq = function isLazySeq(value) {
    return value && LazySeq.type === value.type;
};
void 0;
var isList = exports.isList = function isList(value) {
    return value && List.type === value.type;
};
var list = exports.list = function list() {
    return arguments.length === 0 ? Object.create(List.prototype) : Array.prototype.slice.call(arguments).reduceRight(function (tail, head) {
        return cons(head, tail);
    }, list());
};
var cons = exports.cons = function cons(head, tail) {
    return new List(head, tail);
};
var reverseList = function reverseList(sequence) {
    return function loop() {
        var recur = loop;
        var itemsø1 = [];
        var sourceø1 = sequence;
        do {
            recur = isEmpty(sourceø1) ? list.apply(void 0, itemsø1) : (loop[0] = [first(sourceø1)].concat(itemsø1), loop[1] = rest(sourceø1), loop);
        } while (itemsø1 = loop[0], sourceø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var isSequential = exports.isSequential = function isSequential(x) {
    return isList(x) || isVector(x) || isLazySeq(x) || isDictionary(x) || isString(x);
};
var reverse = exports.reverse = function reverse(sequence) {
    return isList(sequence) ? reverseList(sequence) : isVector(sequence) ? sequence.reverse() : isNil(sequence) ? list() : 'else' ? reverse(seq(sequence)) : void 0;
};
var map = exports.map = function map(f, sequence) {
    return isVector(sequence) ? sequence.map(function ($1) {
        return f($1);
    }) : isList(sequence) ? mapList(f, sequence) : isNil(sequence) ? list() : 'else' ? map(f, seq(sequence)) : void 0;
};
var mapList = function mapList(f, sequence) {
    return function loop() {
        var recur = loop;
        var resultø1 = list();
        var itemsø1 = sequence;
        do {
            recur = isEmpty(itemsø1) ? reverse(resultø1) : (loop[0] = cons(f(first(itemsø1)), resultø1), loop[1] = rest(itemsø1), loop);
        } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var filter = exports.filter = function filter(isF, sequence) {
    return isVector(sequence) ? sequence.filter(isF) : isList(sequence) ? filterList(isF, sequence) : isNil(sequence) ? list() : 'else' ? filter(isF, seq(sequence)) : void 0;
};
var filterList = function filterList(isF, sequence) {
    return function loop() {
        var recur = loop;
        var resultø1 = list();
        var itemsø1 = sequence;
        do {
            recur = isEmpty(itemsø1) ? reverse(resultø1) : (loop[0] = isF(first(itemsø1)) ? cons(first(itemsø1), resultø1) : resultø1, loop[1] = rest(itemsø1), loop);
        } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var reduce = exports.reduce = function reduce(f) {
    var params = Array.prototype.slice.call(arguments, 1);
    return function () {
        var hasInitialø1 = count(params) >= 2;
        var initialø1 = hasInitialø1 ? first(params) : void 0;
        var sequenceø1 = hasInitialø1 ? second(params) : first(params);
        return isNil(sequenceø1) ? initialø1 : isVector(sequenceø1) ? hasInitialø1 ? sequenceø1.reduce(f, initialø1) : sequenceø1.reduce(f) : isList(sequenceø1) ? hasInitialø1 ? reduceList(f, initialø1, sequenceø1) : reduceList(f, first(sequenceø1), rest(sequenceø1)) : 'else' ? reduce(f, initialø1, seq(sequenceø1)) : void 0;
    }.call(this);
};
var reduceList = function reduceList(f, initial, sequence) {
    return function loop() {
        var recur = loop;
        var resultø1 = initial;
        var itemsø1 = sequence;
        do {
            recur = isEmpty(itemsø1) ? resultø1 : (loop[0] = f(resultø1, first(itemsø1)), loop[1] = rest(itemsø1), loop);
        } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var count = exports.count = function count(sequence) {
    return isNil(sequence) ? 0 : seq(sequence).length;
};
var isEmpty = exports.isEmpty = function isEmpty(sequence) {
    return count(sequence) === 0;
};
var first = exports.first = function first(sequence) {
    return isNil(sequence) ? void 0 : isList(sequence) ? sequence.head : isVector(sequence) || isString(sequence) ? (sequence || 0)[0] : isLazySeq(sequence) ? first(lazySeqValue(sequence)) : 'else' ? first(seq(sequence)) : void 0;
};
var second = exports.second = function second(sequence) {
    return isNil(sequence) ? void 0 : isList(sequence) ? first(rest(sequence)) : isVector(sequence) || isString(sequence) ? (sequence || 0)[1] : isLazySeq(sequence) ? second(lazySeqValue(sequence)) : 'else' ? first(rest(seq(sequence))) : void 0;
};
var third = exports.third = function third(sequence) {
    return isNil(sequence) ? void 0 : isList(sequence) ? first(rest(rest(sequence))) : isVector(sequence) || isString(sequence) ? (sequence || 0)[2] : isLazySeq(sequence) ? third(lazySeqValue(sequence)) : 'else' ? second(rest(seq(sequence))) : void 0;
};
var rest = exports.rest = function rest(sequence) {
    return isNil(sequence) ? list() : isList(sequence) ? sequence.tail : isVector(sequence) || isString(sequence) ? sequence.slice(1) : isLazySeq(sequence) ? rest(lazySeqValue(sequence)) : 'else' ? rest(seq(sequence)) : void 0;
};
var lastOfList = function lastOfList(list) {
    return function loop() {
        var recur = loop;
        var itemø1 = first(list);
        var itemsø1 = rest(list);
        do {
            recur = isEmpty(itemsø1) ? itemø1 : (loop[0] = first(itemsø1), loop[1] = rest(itemsø1), loop);
        } while (itemø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var last = exports.last = function last(sequence) {
    return isVector(sequence) || isString(sequence) ? (sequence || 0)[dec(count(sequence))] : isList(sequence) ? lastOfList(sequence) : isNil(sequence) ? void 0 : isLazySeq(sequence) ? last(lazySeqValue(sequence)) : 'else' ? last(seq(sequence)) : void 0;
};
var butlast = exports.butlast = function butlast(sequence) {
    return function () {
        var itemsø1 = isNil(sequence) ? void 0 : isString(sequence) ? subs(sequence, 0, dec(count(sequence))) : isVector(sequence) ? sequence.slice(0, dec(count(sequence))) : isList(sequence) ? list.apply(void 0, butlast(vec(sequence))) : isLazySeq(sequence) ? butlast(lazySeqValue(sequence)) : 'else' ? butlast(seq(sequence)) : void 0;
        return !(isNil(itemsø1) || isEmpty(itemsø1)) ? itemsø1 : void 0;
    }.call(this);
};
var take = exports.take = function take(n, sequence) {
    return isNil(sequence) ? list() : isVector(sequence) ? takeFromVector(n, sequence) : isList(sequence) ? takeFromList(n, sequence) : isLazySeq(sequence) ? take(n, lazySeqValue(sequence)) : 'else' ? take(n, seq(sequence)) : void 0;
};
var takeVectorWhile = function takeVectorWhile(predicate, vector) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var tailø1 = vector;
        var headø1 = first(vector);
        do {
            recur = !isEmpty(tailø1) && predicate(headø1) ? (loop[0] = conj(resultø1, headø1), loop[1] = rest(tailø1), loop[2] = first(tailø1), loop) : resultø1;
        } while (resultø1 = loop[0], tailø1 = loop[1], headø1 = loop[2], recur === loop);
        return recur;
    }.call(this);
};
var takeListWhile = function takeListWhile(predicate, items) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var tailø1 = items;
        var headø1 = first(items);
        do {
            recur = !isEmpty(tailø1) && isPredicate(headø1) ? (loop[0] = conj(resultø1, headø1), loop[1] = rest(tailø1), loop[2] = first(tailø1), loop) : list.apply(void 0, resultø1);
        } while (resultø1 = loop[0], tailø1 = loop[1], headø1 = loop[2], recur === loop);
        return recur;
    }.call(this);
};
var takeWhile = exports.takeWhile = function takeWhile(predicate, sequence) {
    return isNil(sequence) ? list() : isVector(sequence) ? takeVectorWhile(predicate, sequence) : isList(sequence) ? takeVectorWhile(predicate, sequence) : 'else' ? takeWhile(predicate, lazySeqValue(sequence)) : void 0;
};
var takeFromVector = function takeFromVector(n, vector) {
    return vector.slice(0, n);
};
var takeFromList = function takeFromList(n, sequence) {
    return function loop() {
        var recur = loop;
        var takenø1 = list();
        var itemsø1 = sequence;
        var nø2 = n;
        do {
            recur = nø2 === 0 || isEmpty(itemsø1) ? reverse(takenø1) : (loop[0] = cons(first(itemsø1), takenø1), loop[1] = rest(itemsø1), loop[2] = dec(nø2), loop);
        } while (takenø1 = loop[0], itemsø1 = loop[1], nø2 = loop[2], recur === loop);
        return recur;
    }.call(this);
};
var dropFromList = function dropFromList(n, sequence) {
    return function loop() {
        var recur = loop;
        var leftø1 = n;
        var itemsø1 = sequence;
        do {
            recur = leftø1 < 1 || isEmpty(itemsø1) ? itemsø1 : (loop[0] = dec(leftø1), loop[1] = rest(itemsø1), loop);
        } while (leftø1 = loop[0], itemsø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var drop = exports.drop = function drop(n, sequence) {
    return n <= 0 ? sequence : isString(sequence) ? sequence.substr(n) : isVector(sequence) ? sequence.slice(n) : isList(sequence) ? dropFromList(n, sequence) : isNil(sequence) ? list() : isLazySeq(sequence) ? drop(n, lazySeqValue(sequence)) : 'else' ? drop(n, seq(sequence)) : void 0;
};
var conjList = function conjList(sequence, items) {
    return reduce(function (result, item) {
        return cons(item, result);
    }, sequence, items);
};
var conj = exports.conj = function conj(sequence) {
    var items = Array.prototype.slice.call(arguments, 1);
    return isVector(sequence) ? sequence.concat(items) : isString(sequence) ? '' + sequence + str.apply(void 0, items) : isNil(sequence) ? list.apply(void 0, reverse(items)) : isList(sequence) || isLazySeq() ? conjList(sequence, items) : isDictionary(sequence) ? merge(sequence, merge.apply(void 0, items)) : 'else' ? (function () {
        throw TypeError('' + 'Type can\'t be conjoined ' + sequence);
    })() : void 0;
};
var assoc = exports.assoc = function assoc(source) {
    var keyValues = Array.prototype.slice.call(arguments, 1);
    return conj(source, dictionary.apply(void 0, keyValues));
};
var concat = exports.concat = function concat() {
    var sequences = Array.prototype.slice.call(arguments, 0);
    return reverse(reduce(function (result, sequence) {
        return reduce(function (result, item) {
            return cons(item, result);
        }, result, seq(sequence));
    }, list(), sequences));
};
var seq = exports.seq = function seq(sequence) {
    return isNil(sequence) ? void 0 : isVector(sequence) || isList(sequence) || isLazySeq(sequence) ? sequence : isString(sequence) ? Array.prototype.slice.call(sequence) : isDictionary(sequence) ? keyValues(sequence) : 'default' ? (function () {
        throw TypeError('' + 'Can not seq ' + sequence);
    })() : void 0;
};
var isSeq = exports.isSeq = function isSeq(sequence) {
    return isList(sequence) || isLazySeq(sequence);
};
var listToVector = function listToVector(source) {
    return function loop() {
        var recur = loop;
        var resultø1 = [];
        var listø1 = source;
        do {
            recur = isEmpty(listø1) ? resultø1 : (loop[0] = (function () {
                resultø1.push(first(listø1));
                return resultø1;
            })(), loop[1] = rest(listø1), loop);
        } while (resultø1 = loop[0], listø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var vec = exports.vec = function vec(sequence) {
    return isNil(sequence) ? [] : isVector(sequence) ? sequence : isList(sequence) ? listToVector(sequence) : 'else' ? vec(seq(sequence)) : void 0;
};
var sort = exports.sort = function sort(f, items) {
    return function () {
        var hasComparatorø1 = isFn(f);
        var itemsø2 = !hasComparatorø1 && isNil(items) ? f : items;
        var compareø1 = hasComparatorø1 ? function (a, b) {
            return f(a, b) ? 0 : 1;
        } : void 0;
        return isNil(itemsø2) ? list() : isVector(itemsø2) ? itemsø2.sort(compareø1) : isList(itemsø2) ? list.apply(void 0, vec(itemsø2).sort(compareø1)) : isDictionary(itemsø2) ? seq(itemsø2).sort(compareø1) : 'else' ? sort(f, seq(itemsø2)) : void 0;
    }.call(this);
};
var repeat = exports.repeat = function repeat(n, x) {
    return function loop() {
        var recur = loop;
        var nø2 = n;
        var resultø1 = [];
        do {
            recur = nø2 <= 0 ? resultø1 : (loop[0] = dec(nø2), loop[1] = conj(resultø1, x), loop);
        } while (nø2 = loop[0], resultø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var isEvery = exports.isEvery = function isEvery(predicate, sequence) {
    return vec(sequence).every(function ($1) {
        return predicate($1);
    });
};
var some = exports.some = function some(predicate, sequence) {
    return function loop() {
        var recur = loop;
        var itemsø1 = sequence;
        do {
            recur = isEmpty(itemsø1) ? false : predicate(first(itemsø1)) ? true : 'else' ? (loop[0] = rest(itemsø1), loop) : void 0;
        } while (itemsø1 = loop[0], recur === loop);
        return recur;
    }.call(this);
};
var partition = exports.partition = function partition() {
    switch (arguments.length) {
    case 2:
        var n = arguments[0];
        var coll = arguments[1];
        return partition(n, n, coll);
    case 3:
        var n = arguments[0];
        var step = arguments[1];
        var coll = arguments[2];
        return partition(n, step, [], coll);
    case 4:
        var n = arguments[0];
        var step = arguments[1];
        var pad = arguments[2];
        var coll = arguments[3];
        return function loop() {
            var recur = loop;
            var resultø1 = [];
            var itemsø1 = seq(coll);
            do {
                recur = function () {
                    var chunkø1 = take(n, itemsø1);
                    var sizeø1 = count(chunkø1);
                    return sizeø1 === n ? (loop[0] = conj(resultø1, chunkø1), loop[1] = drop(step, itemsø1), loop) : 0 === sizeø1 ? resultø1 : n > sizeø1 + count(pad) ? resultø1 : 'else' ? conj(resultø1, take(n, vec(concat(chunkø1, pad)))) : void 0;
                }.call(this);
            } while (resultø1 = loop[0], itemsø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    default:
        throw RangeError('Wrong number of arguments passed');
    }
};
var interleave = exports.interleave = function interleave() {
    switch (arguments.length) {
    case 2:
        var ax = arguments[0];
        var bx = arguments[1];
        return function loop() {
            var recur = loop;
            var cxø1 = [];
            var axø2 = ax;
            var bxø2 = bx;
            do {
                recur = isEmpty(axø2) || isEmpty(bxø2) ? seq(cxø1) : (loop[0] = conj(cxø1, first(axø2), first(bxø2)), loop[1] = rest(axø2), loop[2] = rest(bxø2), loop);
            } while (cxø1 = loop[0], axø2 = loop[1], bxø2 = loop[2], recur === loop);
            return recur;
        }.call(this);
    default:
        var sequences = Array.prototype.slice.call(arguments, 0);
        return function loop() {
            var recur = loop;
            var resultø1 = [];
            var sequencesø2 = sequences;
            do {
                recur = some(isEmpty, sequencesø2) ? resultø1 : (loop[0] = concat(resultø1, map(first, sequencesø2)), loop[1] = map(rest, sequencesø2), loop);
            } while (resultø1 = loop[0], sequencesø2 = loop[1], recur === loop);
            return recur;
        }.call(this);
    }
};
var nth = exports.nth = function nth(sequence, index, notFound) {
    return isNil(sequence) ? notFound : isList(sequence) ? index < count(sequence) ? first(drop(index, sequence)) : notFound : isVector(sequence) || isString(sequence) ? index < count(sequence) ? sequence[index] : notFound : isLazySeq(sequence) ? nth(lazySeqValue(sequence), index, notFound) : 'else' ? (function () {
        throw TypeError('Unsupported type');
    })() : void 0;
};
//# sourceMappingURL=data:application/json;base64,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
