// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var R = require('stream').Readable;
var test = require('tape');
var Buffer = require('buffer').Buffer;

var util = require('util');
var EE = require('events').EventEmitter;

test('stream2 - compatibility', function (t) {

  var ondataCalled = 0;

  function TestReader() {
    R.apply(this);
    this._buffer = new Buffer(100);
    this._buffer.fill('x');

    this.on('data', function() {
      ondataCalled++;
    });
  }

  util.inherits(TestReader, R);

  TestReader.prototype._read = function(n) {
    this.push(this._buffer);
    this._buffer = new Buffer(0);
  };

  var reader = new TestReader();
  t.equal(ondataCalled, 1);
  t.end();
});