{
    var _ns_ = {
            id: 'wisp.backend.javascript.writer',
            doc: 'Compiler backend for for writing JS output'
        };
    var wisp_ast = require('./../../ast');
    var name = wisp_ast.name;
    var namespace = wisp_ast.namespace;
    var symbol = wisp_ast.symbol;
    var isSymbol = wisp_ast.isSymbol;
    var isKeyword = wisp_ast.isKeyword;
    var wisp_sequence = require('./../../sequence');
    var list = wisp_sequence.list;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var isList = wisp_sequence.isList;
    var vec = wisp_sequence.vec;
    var map = wisp_sequence.map;
    var count = wisp_sequence.count;
    var last = wisp_sequence.last;
    var reduce = wisp_sequence.reduce;
    var isEmpty = wisp_sequence.isEmpty;
    var wisp_runtime = require('./../../runtime');
    var isTrue = wisp_runtime.isTrue;
    var isNil = wisp_runtime.isNil;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isVector = wisp_runtime.isVector;
    var isDictionary = wisp_runtime.isDictionary;
    var isBoolean = wisp_runtime.isBoolean;
    var isRePattern = wisp_runtime.isRePattern;
    var reFind = wisp_runtime.reFind;
    var dec = wisp_runtime.dec;
    var subs = wisp_runtime.subs;
    var isEqual = wisp_runtime.isEqual;
    var wisp_string = require('./../../string');
    var replace = wisp_string.replace;
    var join = wisp_string.join;
    var split = wisp_string.split;
    var upperCase = wisp_string.upperCase;
}
var writeReference = exports.writeReference = function writeReference(form) {
        'Translates references from clojure convention to JS:\n\n  **macros**      __macros__\n  list->vector    listToVector\n  set!            set\n  foo_bar         foo_bar\n  number?         isNumber\n  create-server   createServer';
        return function () {
            var idø1 = name(form);
            idø1 = idø1 === '*' ? 'multiply' : idø1 === '/' ? 'divide' : idø1 === '+' ? 'sum' : idø1 === '-' ? 'subtract' : idø1 === '=' ? 'equal?' : idø1 === '==' ? 'strict-equal?' : idø1 === '<=' ? 'not-greater-than' : idø1 === '>=' ? 'not-less-than' : idø1 === '>' ? 'greater-than' : idø1 === '<' ? 'less-than' : idø1 === '->' ? 'thread-first' : 'else' ? idø1 : void 0;
            idø1 = join('_', split(idø1, '*'));
            idø1 = join('-to-', split(idø1, '->'));
            idø1 = join(split(idø1, '!'));
            idø1 = join('$', split(idø1, '%'));
            idø1 = join('-plus-', split(idø1, '+'));
            idø1 = join('-and-', split(idø1, '&'));
            idø1 = last(idø1) === '?' ? '' + 'is-' + subs(idø1, 0, dec(count(idø1))) : idø1;
            idø1 = reduce(function (result, key) {
                return '' + result + (!isEmpty(result) && !isEmpty(key) ? '' + upperCase((key || 0)[0]) + subs(key, 1) : key);
            }, '', split(idø1, '-'));
            return idø1;
        }.call(this);
    };
var writeKeywordReference = exports.writeKeywordReference = function writeKeywordReference(form) {
        return '' + '"' + name(form) + '"';
    };
var writeKeyword = exports.writeKeyword = function writeKeyword(form) {
        return '' + '"' + '\uA789' + name(form) + '"';
    };
var writeSymbol = exports.writeSymbol = function writeSymbol(form) {
        return write(list(symbol(void 0, 'symbol'), namespace(form), name(form)));
    };
var writeNil = exports.writeNil = function writeNil(form) {
        return 'void(0)';
    };
var writeNumber = exports.writeNumber = function writeNumber(form) {
        return form;
    };
var writeBoolean = exports.writeBoolean = function writeBoolean(form) {
        return isTrue(form) ? 'true' : 'false';
    };
var writeString = exports.writeString = function writeString(form) {
        form = replace(form, RegExp('\\\\', 'g'), '\\\\');
        form = replace(form, RegExp('\n', 'g'), '\\n');
        form = replace(form, RegExp('\r', 'g'), '\\r');
        form = replace(form, RegExp('\t', 'g'), '\\t');
        form = replace(form, RegExp('"', 'g'), '\\"');
        return '' + '"' + form + '"';
    };
var writeTemplate = exports.writeTemplate = function writeTemplate() {
        var form = Array.prototype.slice.call(arguments, 0);
        return function () {
            var indentPatternø1 = /\n *$/;
            var lineBreakPatterø1 = RegExp('\n', 'g');
            var getIndentationø1 = function (code) {
                return reFind(indentPatternø1, code) || '\n';
            };
            return function loop() {
                var recur = loop;
                var codeø1 = '';
                var partsø1 = split(first(form), '~{}');
                var valuesø1 = rest(form);
                do {
                    recur = count(partsø1) > 1 ? (loop[0] = '' + codeø1 + first(partsø1) + replace('' + '' + first(valuesø1), lineBreakPatterø1, getIndentationø1(first(partsø1))), loop[1] = rest(partsø1), loop[2] = rest(valuesø1), loop) : '' + codeø1 + first(partsø1);
                } while (codeø1 = loop[0], partsø1 = loop[1], valuesø1 = loop[2], recur === loop);
                return recur;
            }.call(this);
        }.call(this);
    };
var writeGroup = exports.writeGroup = function writeGroup() {
        var forms = Array.prototype.slice.call(arguments, 0);
        return join(', ', forms);
    };
var writeInvoke = exports.writeInvoke = function writeInvoke(callee) {
        var params = Array.prototype.slice.call(arguments, 1);
        return writeTemplate('~{}(~{})', callee, writeGroup.apply(void 0, params));
    };
var writeError = exports.writeError = function writeError(message) {
        return function () {
            return (function () {
                throw Error(message);
            })();
        };
    };
var writeVector = exports.writeVector = writeError('Vectors are not supported');
var writeDictionary = exports.writeDictionary = writeError('Dictionaries are not supported');
var escapePattern = function escapePattern(pattern) {
    pattern = join('/', split(pattern, '\\/'));
    pattern = join('\\/', split(pattern, '/'));
    return pattern;
};
var writeRePattern = exports.writeRePattern = function writeRePattern(form) {
        return function () {
            var flagsø1 = '' + (form.multiline ? 'm' : '') + (form.ignoreCase ? 'i' : '') + (form.sticky ? 'y' : '');
            var patternø1 = form.source;
            return '' + '/' + escapePattern(patternø1) + '/' + flagsø1;
        }.call(this);
    };
var compileComment = exports.compileComment = function compileComment(form) {
        return compileTemplate(list('//~{}\n', first(form)));
    };
var writeDef = exports.writeDef = function writeDef(form) {
        return function () {
            var idø1 = first(form);
            var isExportø1 = (meta(form) || {} || 0)['top'] && !(meta(idø1) || {} || 0)['private'];
            var attributeø1 = symbol(namespace(idø1), '' + '-' + name(idø1));
            return isExportø1 ? compileTemplate(list('var ~{};\n~{}', compile(cons(symbol(void 0, 'set!'), form)), compile(list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, '.')].concat([symbol(void 0, 'exports')], [attributeø1]))], [idø1]))))) : compileTemplate(list('var ~{}', compile(cons(symbol(void 0, 'set!'), form))));
        }.call(this);
    };
var isWriteInstance = exports.isWriteInstance = function isWriteInstance(form) {
        return writeTemplate('~{} instanceof ~{}', write(second(form)), write(first(form)));
    };
var write = exports.write = function write(form) {
        return isNil(form) ? writeNil(form) : isSymbol(form) ? writeReference(form) : isKeyword(form) ? writeKeywordReference(form) : isString(form) ? writeString(form) : isNumber(form) ? writeNumber(form) : isBoolean(form) ? writeBoolean(form) : isRePattern(form) ? writePattern(form) : isVector(form) ? writeVector(form) : isDictionary(form) ? writeDictionary() : isList(form) ? writeInvoke.apply(void 0, map(write, vec(form))) : 'else' ? writeError('Unsupported form') : void 0;
    };
//# sourceMappingURL=data:application/json;base64,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
